/* ttytest - test if process is connected to a terminal and foreground */

/* M.A.Huckvale - May 1987 */

/*--------------------------------------------------------------------------*/
/**MAN
.TH TTYTEST SFS3 UCL SFS
.SH NAME
ttytest - test if process connected to foreground terminal
.SH SYNOPSIS
int   \fBttytest\fR()
.SH DESCRIPTION
.I ttytest()
is a routine to check if it is sensible to report messages to the standard
output.  It returns 1 if the process is connected to a terminal \fIand\fR is
running in the foreground, and 0 otherwise.
.SS
To force detection of a terminal, set the environment variable GFORCE.
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

#ifdef DOS
#include <sys/types.h>
#include <sys/stat.h>
int ttytest()
{
	struct stat st;
	fstat(1,&st);
#ifdef _MSC_VER
	if ((st.st_mode & _S_IFMT)==_S_IFCHR)
#else
	if ((st.st_mode & S_IFMT)==S_IFCHR)
#endif
		return(1);
	else
		return(0);
}
#else

#ifdef MASSCOMP
#include <sys/ioctl.h>
#endif

int ttytest()
{
	int	tgrp;
	char	*p;

	if ((p=getenv("GFORCE"))!=NULL) return(1);

#if defined(MASSCOMP)
	if (ioctl(1,TIOCGPGRP,&tgrp) != 0) 
#else
	if ((tgrp=tcgetpgrp(1)) < 0)
#endif
		return(0);	/* not a terminal */
#if defined(LINUX) || defined(SVR4) || defined(SOLARIS)
	else if (tgrp != getpgrp())
#else
	else if (tgrp != getpgrp(0))
#endif
		return(0);	/* not foreground */
	else
		return(1);	/* ok */
}
#endif

#ifdef IAG
#include <stdio.h>
main()
{
	if (ttytest()==1) printf("OK to write\n");
}
#endif
