/* video -- terminal-independent text enhancement commands */

/*--------------------------------------------------------------------------*/
/**MAN
.TH VIDEO SFS3 UCL SFS
.SH NAME
video - terminal-independent text enhancement routines
.SH SYNOPSIS
.nf

initvideo(flag);
int    flag;

italicon();
italicoff();
boldon();
boldoff();
uparrow();

.fi
.SH DESCRIPTION
.I initvideo()
is an optional routine that may be used to enforce the generation of terminal codes
even if the process is not connected to a terminal.  If 
.I flag
is set then the following routines always produce codes.  Default action is only to send
codes if the process is talking to a terminal, in which case this routine need not be called.
.I italicon()
sends appropriate codes to the terminal to turn italics (or underlining) on.
.I italicoff()
sends appropriate codes to the terminal to turn italics (or underlining) off.
.I boldon()
sends appropriate codes to the terminal to turn bold (or reverse video) on.
.I boldoff()
sends appropriate codes to the terminal to turn bold (or reverse video) off.
.I uparrow()
sends appropriate codes to the terminal to move the cursor up one line.
.SH VERSION/AUTHOR
1.0 - Mark Huvkvale.
.SH SEE ALSO
termcap(3)
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#ifdef DOS
#include <conio.h>
#endif
#include "sfs.h"

#ifdef _MSC_VER
/* to be implemented for Visual C */
#define BLACK 0
#define BLUE 1
#define LIGHTGRAY 7
#define WHITE 15
void textcolor(int col) {}
void textbackground(int col) {}
int wherex() { return(0); }
int wherey() { return(0); }
void gotoxy(int x,int y) {}
#endif

/* text formatting data */
static int	vidinit=0;
#ifdef DOS
static int	fgcol=LIGHTGRAY;
static int	bgcol=BLACK;
static int	cpos=0;
#else
static char	termcap[1024];		/* termcap entry for terminal */
static char	termfunc[1024];		/* terminal function strings */
static char	*so,*se;		/* strings for standout on/standout end */
static char	*us,*ue;		/* strings for underline on/underline off */
static char	*up;			/* string for up cursor */
#endif

void initvideo(flag)
int	flag;		/* 0=std, 1=force output */
{
#ifdef DOS
	if (ttytest()) vidinit=1;
#else
	char	*ptr;
	if (flag || isatty(1)) {
		if (tgetent(termcap,getenv("TERM")) == 1) {
			ptr=termfunc;
			so=ptr;
			tgetstr("so",&ptr);
			se=ptr;
			tgetstr("se",&ptr);
			us=ptr;
			tgetstr("us",&ptr);
			ue=ptr;
			tgetstr("ue",&ptr);
			up=ptr;
			tgetstr("up",&ptr);
			vidinit++;
		}
	}
#endif
}

#ifdef DOS
void boldon()
{
	fgcol=WHITE;
}
void boldoff()
{
	fgcol=LIGHTGRAY;
}
void italicon()
{
	bgcol=BLUE;
}
void italicoff()
{
	bgcol=BLACK;
}
void uparrow()
{
	if (vidinit) gotoxy(wherex(),wherey()-1);
}

#include <stdarg.h>
int videoprint(char *fmt, ...)
{
	va_list	params;
	char	buffer[1024];
	int	i;

	if (vidinit==0) {
		/* print message */
		va_start(params, fmt);
		i = vfprintf(stdout, fmt, params);
		va_end(params);
	}
	else {
		/* display message */
		va_start(params, fmt);
		vsprintf(buffer, fmt, params);
		va_end(params);

		textcolor(fgcol);
		textbackground(bgcol);
		for (i=0;buffer[i];i++) {
			if (buffer[i]=='\t') {
				do {
					putch(' ');
					cpos++;
				} while ((cpos%8)!=0);
			}
			else if (buffer[i]=='\n') {
				textbackground(BLACK);
				putch('\r');
				putch('\n');
				textbackground(bgcol);
				cpos=0;
			}
			else {
				putch(buffer[i]);
				cpos++;
			}
		}
	}
	return(i);
}

#else
static void vidout(c)
char	c;
{
	putchar(c);
}

void boldon()
{
	if (!vidinit) initvideo(0);
	tputs(so,1,vidout);
}
void boldoff()
{
	if (!vidinit) initvideo(0);
	tputs(se,1,vidout);
}
void italicon()
{
	if (!vidinit) initvideo(0);
	tputs(us,1,vidout);
}
void italicoff()
{
	if (!vidinit) initvideo(0);
	tputs(ue,1,vidout);
}
void uparrow()
{
	if (!vidinit) initvideo(0);
	printf("%s",up);
}
#endif

#ifdef IAG
main()
{
	int	i;

	printf("TEST VIDEO ATTRIBUTES\n");

	initvideo(0);
	italicon();
	videoprint("\tItalic\n");
	italicoff();
	boldon();
	videoprint("\tBold\n");
	italicon();
	videoprint("\tItalic Bold\n");
	boldoff();
	italicoff();
	videoprint("\tNormal\n");
	for (i=0;i<5;i++) {
		uparrow();
		boldon();
		videoprint("\tNormal\n");
		boldoff();
		sleep(1);
		uparrow();
		videoprint("\tNormal\n");
		sleep(1);
	}
	exit(0);
}
#endif
