/* itemno -- return item number in file from various information */

/* m.a. huckvale - october 1986 */

/* version 1 */
/* version 1.1 - November 1987
	- SFS version
*/
/*--------------------------------------------------------------------------*/
/**MAN
.TH ITEMNO SFS1 UCL
.SH NAME
itemno - return item number from data file
.SH SYNOPSIS
.B itemno
-i item file
.SH DESCRIPTION
.I itemno
is a program to print item numbers from a supplied item specification string.
If there is no matching item in the file, the datatype number is returned alone.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program and exit.
.TP 11
.BI -i item
Supplied item specification string.
.SH VERSION/AUTHOR
1.1 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#define PROGNAME "itemno"
#define PROGVERS "1.1s"
char	*progname=PROGNAME;

/* global declarations */
#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include <ctype.h>

/* global data */
struct item_header item;

/* search parameters */
int	inpitem=0;		/* item.datatype to be found */
char	*inptype="0"; 		/* item specification */

/* main program */
void main(argc,argv)
int argc;
char *argv[];
{
	/* local variables */
	extern int	optind;
	extern char	*optarg;
	int		errflg=0;
	char		c;
	char		filename[SFSMAXFILENAME];
	int		fid;

	/* decode switches */
	while ( (c = getopt(argc,argv,"Ii:")) != EOF )
		switch (c) {
		case 'I' :	/* Identify */
			fprintf(stderr,"%s: Find SFS item number V%s\n",PROGNAME,PROGVERS);
			exit(0);
			break;
		case 'i' :	/* item spec. */
			if (itspec(optarg,&inpitem,&inptype) != 0)
				error("bad '-i' argument: %s",optarg);
			break;
		case '?' :	/* unknown */
			errflg++;
	}
	if (errflg || (argc<2))
		error("usage: %s (-I) -i item file",PROGNAME);

	/* get filename */
	if (optind < argc)
		strcpy(filename,sfsfile(argv[optind]));
	else
		error("no database file specified",NULL);

	/* open datafile */
	if ((fid=sfsopen(filename,"r",NULL)) < 0)
		error("cannot open %s",filename);

	/* locate item if possible */
	if (sfsitem(fid,inpitem,inptype,&item))
		printf("%d.%02d\n",item.datatype,item.subtype);
	else
		printf("%d\n",inpitem);

	/* that's it */
	exit(0);
}
