function replay(fname,item,arg3,arg4,arg5)
% REPLAY replay an audio signal from an SFS file
%
%   REPLAY(fname,item) replays a SPEECH or LX item specified
%   by the item parameter from the SFS file fname.  Replay 
%   is performed by the WAVPLAY function that waits until
%   audio replay is complete before returning.
%
%   REPLAY(fname) replays the last SPEECH item in the file.
%
%   REPLAY(fname,item,start,stop) replays the item starting
%   at time start and ending at time stop.
%
%   REPLAY(fname,item,start) replays the item starting
%   at time start and ending at the end of the file.
%
%   REPLAY(fname,item,anitem,anstart,anstop) replays the item
%   starting at the time of an annotation called anstart
%   and ending at an annotation anstop.  Annotations are taken
%   from the item anitem in the file.

stime=0;
etime=-1;
if (nargin==5) & ischar(arg3)
    % load annotations to find start & stop times
	[ah,ad]=sfsgetitem(fname,arg3);
    % find start
    s=1;
	for i=1:length(ad)
		if strcmp(ad(i).label,arg4) 
            stime=ad(i).posn*ah.frameduration+ah.offset; 
            s=i;
            break;
        end;
	end;
    % find stop following
	for i=s+1:length(ad)
		if strcmp(ad(i).label,arg5) 
            etime=ad(i).posn*ah.frameduration+ah.offset; 
            break;
        end;
	end;
elseif (nargin==4)
    % start and stop times specified
	stime=arg3;
	etime=arg4;
elseif (nargin==3)
    % start specified
	stime=arg3;
elseif (nargin<2)
    % no item specified
    item='sp'; 
end;
% load signal
[h,d]=sfsgetitem(fname,item);
if (etime==-1) 
    etime=h.numframes*h.frameduration+h.offset; 
end;
% find starting and ending index 
sidx=1+floor((stime-h.offset)/h.frameduration);
sidx=min(max(sidx,1),h.numframes);
eidx=floor((etime-h.offset)/h.frameduration);
eidx=min(max(eidx,1),h.numframes);
% replay
wavplay(d(sidx:eidx),1.0/h.frameduration,'sync');
