function [header,data]=sfsnewitem(datatype,frameduration,offset,framesize,numframes)
% SFSNEWITEM creates an empty SFS data set of a given type and size
%
%   [h,d]=sfsnewitem(datatype,frameduration,offset,framesize,numframes)
%   creates an SFS item header structure in the variable h, and a blank
%   data set in the variable d.  The datatype parameter sets the main
%   data type (1=speech,2=lx,3=tx,4=fx, etc) - see the SFS user manual
%   for a complete list.  The frameduration parameter sets the basic
%   sampling time unit - all internal times are integer multiples of 
%   this time.  The offset parameter sets a single global temporal
%   offset for the whole item.  The framesize parameter sets the number
%   of data items used in each frame of data (not used for vector data).
%   The numframes parameter sets the number of frames required in the
%   blank data set.
%
%   It is recommended that after using SFSNEWITEM to create a new
%   header structure, the history field is initialised with a new
%   and unique string describing the processing performed.  The
%   default history string has the form
%      matlab/<item-type>(script=<value of progname>)
%   where progname is an assumed global variable.
%
%   Refer to SFSGETITEM for the format of data sets for different
%   SFS types.
%
%   See also: SFSFILE(), SFSGETITEM(), SFSNEWITEM(), SFSPUTITEM()

