{ annot.inc -- interface to SFS annotations for SPC 1.0 }

{ annotation record structure }
type
	annotation_record=record
		sample:integer;
		annot:string;
		next:^annotation_record; 
	end;
	annotation_record_ptr=^annotation_record;

{ load annotations }
external function LoadAnnotations(var linklist:annotation_record_ptr;an_samprate:real):boolean;

{ find time of matching annotation }
function FirstAnnotation(base:annotation_record_ptr;an_name:string):integer;
begin
	FirstAnnotation := -1;
	if base <> nil then repeat
		if an_name = base^.annot then begin
			FirstAnnotation := base^.sample;
			base := nil;
		end
		else
			base := base^.next;
	until base = nil;
end;

{ Even simpler interface for SPC course }
var
	annot_base_ptr:annotation_record_ptr;

function AnnotationLoad(rate:real):boolean;
begin
	AnnotationLoad := LoadAnnotations(annot_base_ptr,rate);
end;

function AnnotationFind(an_name:string;var s1,s2:integer):boolean;
var
	base:annotation_record_ptr;
begin
	AnnotationFind := false;
	base := annot_base_ptr;
	if base <> nil then repeat
		if an_name = base^.annot then begin
			s1 := base^.sample;
			if base^.next <> nil then
				s2 := base^.next^.sample - 1
			else
				s2 := s1;
			base := nil;
			AnnotationFind := true;
		end
		else
			base := base^.next;
	until base = nil;
end;

