// complex.h -- definition for complex arithmetic class
//
// (c) 1996 Mark Huckvale University College London

#ifndef _Complex_H
#define _Complex_H

#include <iostream>
#include <math.h>
using namespace std;

// The class Complex stores the real and imaginary parts of a
// complex number and defines a basic set of mathematical
// operations on complex numbers

class Complex {
private:
	double	re;		// real part
	double	im;		// imaginary part
public:
	// access functions
	double	real() const { return re; };
	double	imag() const { return im; };
	// constructors
	Complex() {};
	Complex(const Complex& c) : re(c.real()), im(c.imag()) {};
	Complex(double r, double i=0) : re(r), im(i) {};
	~Complex() {};
	// assignment operator
	Complex& operator= (const Complex& c)
	{
		re = c.real(); im=c.imag();
		return *this;
	};
	// update operators
	Complex& operator+= (const Complex& c);
	Complex& operator-= (const Complex& c);
	Complex& operator*= (const Complex& c);
	Complex& operator/= (const Complex& c);
};

// arithmetic operators
Complex operator + (const Complex& c1,const Complex& c2);
Complex operator - (const Complex& c1,const Complex& c2);
Complex operator * (const Complex& c1,const Complex& c2);
Complex operator / (const Complex& c1,const Complex& c2);

// complex functions
double	mag(const Complex& c);
double	arg(const Complex& c);
Complex	exp(const Complex& c);
Complex	sqrt(const Complex& c);

// iostream functions
std::istream& operator >> (std::istream& ip, Complex& c);
std::ostream& operator << (std::ostream& op, const Complex& c);

#endif
