// ltisysch.h -- LTI System Chain class declaration
//
// C++ (c) 1996 Mark Huckvale University College London

#ifndef _LTISysCh_H
#define _LTISysCh_H

#include "ltisys.h"

class LTISystemChain {
public:	// public for demonstration purposes
	LTISystem	*section;	// array of sections
	int		nsection;	// # sections
public:
	// constructors
	LTISystemChain(int n=1);
	LTISystemChain(const LTISystemChain& lch);
	~LTISystemChain();
	// assignment
	LTISystemChain& operator= (const LTISystemChain& lch);
	LTISystem& operator[] (int idx);
	// clear system
	void clear();
	// run system
	double operator() (double ival);
	// frequency response
	Complex response(double freq) const;
};

#endif
