// spectrum.h -- definition for Spectrum (complex waveform) class
//
// (c) 1996 Mark Huckvale University College London

// The Spectrum class provides a basic set of functions for
// manipulating complex-valued signals for DSP

#ifndef __Spectrum_H
#define __Spectrum_H

#include "wavecomp.h"

class Spectrum : public WaveComplex {
public:
	// constructors + assignment
	Spectrum(int size=1,double srate=20000) : WaveComplex(size,srate,0) {};
	Spectrum(const WaveComplex& isig) : WaveComplex(isig) {};
	Spectrum& operator=(const WaveComplex& isig)
	{
		WaveComplex::operator=(isig);
		return *this;
	}
	// return first half of spectrum
	Spectrum half() const
	{
		return WaveComplex::cut(0,count()/2);
	}
	// specialised functions
	void plot(Graph& gr,int gno,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::magplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Magnitude");
	};
	void plotMag(Graph& gr,int gno=1,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::magplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Magnitude");
	}
	void plotLogMag(Graph& gr,int gno=1,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::dbplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Magnitude (dB)");
	}
	void plotPhase(Graph& gr,int gno=1,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::argplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Phase (radian)");
	}
	void plotReal(Graph& gr,int gno=1,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::realplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Real Amplitude");
	}
	void plotImag(Graph& gr,int gno=1,char *pt=0,char *xt=0,char *yt=0) const
	{
		WaveComplex::imagplot(gr,gno,(pt)?pt:"Spectrum",
			(xt)?xt:"Freq (Hz)",(yt)?yt:"Imag Amplitude");
	}
};
#endif
