// WaveDouble.h -- definition for dynamic floating-point waveform class
//
// (c) 1996 Mark Huckvale University College London

// The class Waveform supports the storage, manipulation, display,
// and replay of double-precision floating-point waveforms.

#ifndef _WaveDouble_H
#define _WaveDouble_H

#include "wave.h"

class WaveDouble : public Wave {
protected:
	double	*buf;		// waveform buffer
public:
	// constructors
	WaveDouble(int length=1,double rate=20000.0,int first=0);
	WaveDouble(const WaveDouble& wv);	// Copy constructor
	~WaveDouble();
	// virtual functions
	void dump(int len=-1,int first=0) const;
	void plot(Graph& gr,int gno,const char *title,const char *xt,const char *yt) const;
	// assignment operator
	WaveDouble& operator= (const WaveDouble& wv);
	// sample access
	double& operator[] (const int idx);
	const double& operator[] (const int idx) const;
	// concatenation
	WaveDouble& operator+= (const double val);
	WaveDouble& operator+= (const WaveDouble& wv);
	WaveDouble operator+ (const WaveDouble& wv);
	// cut function
	WaveDouble cut(int first,int len) const;
	// conversion functions
	WaveShort toWaveShort() const;
	WaveComplex toWaveComplex() const;
};
#endif
