/* mlpw.h -- header file for mlp workbench programs */

/* availability of array processor */
#undef VA_AVAIL

/* global sizes */
int	toplayer;			/* number of layers */
int	totunits;			/* number of units */
long	totcycles;			/* number of cycles */
float	toterror;			/* current normalised error */
int	fullconnect;			/* full interconnections */
int	unlayered;			/* unlayered format */

/* array processor use */
int		useap;			/* request to use AP if possible */

/* linear memory allocation */
float		*mlpmem;		/* base of memory array */
int		mlpmemtop;		/* next cell to be allocated */
int		mlpmemsize;		/* current memory size */
#define MLPMEMCHUNK	1024000		/* unit of memory growth = 4MB */
float		*mlpalloc();

/* network index (1 per layer) */
#define MAXLAYER	5
struct index_rec {
	int	start;			/* index into control */
	int	numunit;		/* number of units in layer */
	int	numbase;		/* basic number of units */
	int	numclone;		/* number of times basic units cloned */
	int	maxdelay;		/* max delay referred to this layer */
} lindex[MAXLAYER];			/* layer index table */

/* network control structure (1 per unit) */
struct control_rec {
	short	first;			/* start of fan-in */
	short	nlink;			/* range of fan-in */
	short	ndelay;			/* # delays on input width */
	short	odelay;			/* # output delays referrred to */
	short	clone;			/* unit is clone of basic unit */
	short	fullconnect;		/* fully connected flag */
	short	linearout;		/* linear output flag */
	float	*weight;		/* input weights */
	float	*change;		/* change to input weights */
	float	*lastchange;		/* previous change to weights (Quickprop) */
	float	*delta;			/* input deltas (old changes) */
	float	*connect;		/* input connections */
	float	*output;		/* bottom-up outputs per delay */
	float	*input;			/* top-down inputs per delay */
	float	error;			/* error value */
} *control;

/* model history */
#define HISTORYLEN	32
#define HISTORYLINELEN	128
char	mlphistory[HISTORYLEN][HISTORYLINELEN];
int	mlphistcnt;

/* global defines */
#define RAD_DEG		57.29578
#ifndef MAXLONG
#define MAXLONG		0x7FFFFFFF
#endif

/* learning control parameters */
#define UPDATEFREQ	(-1)		/* frequency of adaptation/pattern */
#define SAVETIME	30		/* every 30 minutes */
#define MINERROR	0.01		/* minimum normalised error */

/* Standard method */
#define ADAPT_STANDARD	0
#define ETA_STD		0.05
#define ALPHA_STD	0.9

/* Lai-Wan adapted parameters */
#define ADAPT_LAI_WAN	1
#define ETA_ZERO	0.2
#define ETA_MAX		5.0
#define ETA_MIN		0.001
#define LAMBDA_ZERO	0.5

/* Lai-Wan adapted parameters */
#define ADAPT_LAI_WAN2	2
#define ETA_ZERO2	0.2
#define ETA_MAX2	0.75
#define ETA_MIN2	0.01
#define ALPHA_LAI_WAN	0.9

/* Quickprop parameters */
#define ADAPT_QUICKPROP 3
#define ETA_QUICKPROP 	0.55
#define ALPHA_QUICKPROP	0.9
#define MAXFACTOR	1.75
#define MODETHRESHOLD	0.0

/* forward declarations */
float	normerr();
float	adapt_std();
float	adapt_lai();
float	adapt_lai2();
float	adapt_quickprop();
