/* spandrv -- C-SPAN driver */

/* M.A. Huckvale - November 1989 */

/* standard definitions */

/* operators */
#define NUL		-1
#define FIX		0
#define LIN		1
#define LOG		2

/* parameters */
#define PARM_FX		0
#define PARM_F1		3
#define PARM_A1		4
#define PARM_F2		6
#define PARM_A2		7
#define PARM_F3		9
#define PARM_A3		10
#define PARM_F4		12
#define PARM_A4		13
#define PARM_FN		15
#define PARM_AN		16
#define PARM_VR		18

#define NUM_PARM	19

/* routines */
#define AT(t)		_abstime=(t)
#define WAIT(t)		_abstime+=(t)
#define NOW		_abstime
#define SAVE		_push(_abstime)
#define RESTORE		_abstime=_pop()
#define GET(p,t)	_setval(p(-2,NUL),NUL,NUL,t)
#define FX(v,i)		_setval(PARM_FX,v,i,_abstime)
#define F1(v,i)		_setval(PARM_F1,v,i,_abstime)
#define F2(v,i)		_setval(PARM_F2,v,i,_abstime)
#define F3(v,i)		_setval(PARM_F3,v,i,_abstime)
#define F4(v,i)		_setval(PARM_F4,v,i,_abstime)
#define FN(v,i)		_setval(PARM_FN,v,i,_abstime)

#define A1(v,i)		_setval(PARM_A1,v,i,_abstime)
#define A2(v,i)		_setval(PARM_A2,v,i,_abstime)
#define A3(v,i)		_setval(PARM_A3,v,i,_abstime)
#define A4(v,i)		_setval(PARM_A4,v,i,_abstime)
#define AN(v,i)		_setval(PARM_AN,v,i,_abstime)

#define VR(v,i)		_setval(PARM_VR,v,i,_abstime)

#define LENGTH(t)	_maxlength(t)
#define CLEAR		_clearsynth()
#define FLUSH		_spanflush()

/* global parameters */
extern int	_abstime;

/* user program */
extern void SYNTH(char **params);
