/* garc -- draw DIG arc through three points */

#include <stdio.h>
#include <math.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#define LIMIT	1.0

#ifdef __STDC__
void   digarc(int  bundle,float     x1,float  y1,float  x2,float  y2,float  x3,float  y3)
#else
void	digarc(bundle,x1,y1,x2,y2,x3,y3)
int	bundle;
float	x1,y1,x2,y2,x3,y3;
#endif
{
	digarcp(bundle,xpix(x1),ypix(y1),xpix(x2),ypix(y2),xpix(x3),ypix(y3));
}

void	digarcp(bundle,px1,py1,px2,py2,px3,py3)
int	bundle;
int	px1,py1,px2,py2,px3,py3;
{
	double	x1=px1,y1=py1,x2=px2,y2=py2,x3=px3,y3=py3;
	double	x12,y12,x23,y23;	/* line bisectors */
	double	l12,l13,l1c;		/* line lengths */
	double	a21x,a213,a31x;		/* angles */
	double	g12,g23;		/* bisector gradients */
	double	xc,yc;			/* circle centre */
	double	d,e;			/* temp variables */

	/* treat metafile output as special case */
	if (digdata.device=='o') {
		(*digtable[digdata.select].arc)(bundle,px1,py1,px2,py2,px3,py3);
		return;
	}

	/* check if a circle specified */
	if ((x1==x3) && (y1==y3)) {
		/* find centre */
		xc = (x1+x2)/2;
		yc = (y1+y2)/2;
		/* erect a new x3,y3 on perimeter */
		l1c = sqrt((x1-xc)*(x1-xc)+(y1-yc)*(y1-yc));
		l13 = sqrt(2*l1c*l1c);
		a21x = atan2(y2-y1,x2-x1);
		a31x = a21x + atan(1.0);
		x3 = x1 + l13*cos(a31x);
		y3 = y1 + l13*sin(a31x);
		/* plot in quarters */
		digarcent(bundle,(float)x1,(float)y1,(float)x3,(float)y3,(float)xc,(float)yc);
		digarcent(bundle,(float)x3,(float)y3,(float)x2,(float)y2,(float)xc,(float)yc);
		x3 = x2 - l13*cos(a31x);
		y3 = y2 - l13*sin(a31x);
		digarcent(bundle,(float)x2,(float)y2,(float)x3,(float)y3,(float)xc,(float)yc);
		digarcent(bundle,(float)x3,(float)y3,(float)x1,(float)y1,(float)xc,(float)yc);
		return;
	}

	/* check points not in a straight line */
	a31x = atan2(y3-y1,x3-x1);
	a213 = atan2(y2-y1,x2-x1) - a31x;
	l12 = sqrt((x2-x1)*(x2-x1)+(y2-y1)*(y2-y1));
	d = fabs(l12 * sin(a213) * sin(a31x));
	e = fabs(l12 * sin(a213) * cos(a31x));
	if ((d*digdata.yscale < LIMIT) && (e*digdata.xscale < LIMIT)) {
		diglinep(bundle,px1,py1,px2,py2);
		diglinep(bundle,px2,py2,px3,py3);
		return;
	}

	/* determine centre of circle */
	x12 = (x1 + x2) / 2;
	x23 = (x2 + x3) / 2;
	y12 = (y1 + y2) / 2;
	y23 = (y2 + y3) / 2;
	if ((y1==y2) || (y2==y3)) {
		if (y1==y2) 
			xc = x12;
		else
			xc = x23;
	}
	else {
		g12 = -(x2-x1)/(y2-y1);
		g23 = -(x3-x2)/(y3-y2);
		xc = ((y12 - g12 * x12) - (y23 - g23 * x23))/(g23 - g12);
	}
	if (y1 != y2) {
		g12 = -(x2-x1)/(y2-y1);
		yc = g12 * xc + y12 - g12 * x12;
	}
	else if (y2 != y3) {
		g23 = -(x3-x2)/(y3-y2);
		yc = g23 * xc + y23 - g23 * x23;
	}
	else {
/*		fprintf(stderr,"digarc:tried to find infinite centre\n"); */
		return;
	}

	/* draw arc in two pieces using recursion */
	digarcent(bundle,(float)x1,(float)y1,(float)x2,(float)y2,(float)xc,(float)yc);
	digarcent(bundle,(float)x2,(float)y2,(float)x3,(float)y3,(float)xc,(float)yc);
}

/* plot portion of a circle recursively */
#ifdef __STDC__
void   digarcent(int  bundle,float  x1,float  y1,float  x2,float  y2,float  xc,float  yc)
#else
void digarcent(bundle,x1,y1,x2,y2,xc,yc)
int	bundle;
float	x1,y1,x2,y2,xc,yc;	/* these are PIXEL co-ordinates */
				/* x1,y1 and x2,y2 on same semicircle */
#endif
{
	double	x12,y12;
	double	r,l12c;
	double	x3,y3;
	double	d,e;
	int	ang1,ang2,diffang,t;

	/* get radius and angles */
	r = sqrt((x1-xc)*(x1-xc)+(y1-yc)*(y1-yc));
	ang1 = (int)(atan2(y1-yc,x1-xc)/DEG_TO_RADS);
	ang2 = (int)(atan2(y2-yc,x2-xc)/DEG_TO_RADS);
	diffang = ang2-ang1;
	if (diffang < 0) diffang += 360;
	if (diffang > 180) {
		t = ang1;
		ang1 = ang2;
		ang2 = t;
	}

	/* check for special routine for arcs */
	if (digtable[digdata.select].arc)
		/* yes, call it */
		(*digtable[digdata.select].arc)(bundle,(int)(xc+0.5),(int)(yc+0.5),(int)(r+0.5),ang1,ang2);
	else {
		/* construct it from lines */
		x12 = (x1 + x2) / 2;
		y12 = (y1 + y2) / 2;
		l12c = sqrt((x12-xc)*(x12-xc) + (y12-yc)*(y12-yc));
		if (l12c==0) {
			/* attempting semi-circle */
			return;
		}
		x3 = xc + (r / l12c) * (x12 - xc);
		y3 = yc + (r / l12c) * (y12 - yc);

		/* check not in straight line */
		d = fabs(x3-x12);
		e = fabs(y3-y12);
		if ((d*digdata.xscale<LIMIT) && (e*digdata.yscale<LIMIT)) {
			/* near enough two lines */
			diglinep(bundle,(int)(x1+0.5),(int)(yc+(y1-yc)/digdata.aspect+0.5),(int)(x3+0.5),(int)(yc+(y3-yc)/digdata.aspect+0.5));
			diglinep(bundle,(int)(x3+0.5),(int)(yc+(y3-yc)/digdata.aspect+0.5),(int)(x2+0.5),(int)(yc+(y2-yc)/digdata.aspect+0.5));
		}
		else {
			/* needs further work */
			digarcent(bundle,(float)x1,(float)y1,(float)x3,(float)y3,(float)xc,(float)yc);
			digarcent(bundle,(float)x3,(float)y3,(float)x2,(float)y2,(float)xc,(float)yc);
		}
	}
	return;
}

#ifdef EMO
main()
{
	float	x1,y1,x2,y2,x3,y3;
	int	i;

	digstart('\0',NULL,0);
	digscale (21.0,21.0,1);
	digbox(0,0.0,0.0,21.0,21.0);
	digclearscreen();

	for (i=20;i>=2;i--)
		digarc(20+i,2.0,2.0,4.0,2.0,(float)i,(float)i);
	for (i=20;i>=2;i--)
		digarc(20+i,2.0,2.0,2.0,4.0,(float)i,(float)i);

	for (i=5;i>=1;i--)
		digarc(20+i,17.0,5.0-i/2.0,17.0,5.0+i/2.0,17.0,5.0-i/2.0);
	for (i=5;i>=1;i--)
		digarc(i,5.0-i/2.0,17.0,5.0+i/2.0,17.0,5.0-i/2.0,17.0);

	digquit(15);
}
#endif
