/* gtext -- draw hardware text at graphics position */

#include <stdio.h>
#include "SFSCONFG.h"
#include "dig.h"
#include "digdata.h"
#include "digtable.h"

#ifdef __STDC__
void   digtext(int bundle,float xstr,float ystr,char    *word)
#else
void	digtext (bundle,xstr,ystr,word)
float 	xstr,ystr;	/* coords of bottom left corner */
int 	bundle;
char 	*word;
#endif
{
	int	x,y;

	x = xpix(xstr);
	y = ypix(ystr);

	digtextp(bundle,x,y,word);
}

#ifdef __STDC__
void	digtextp(int bundle,int x,int y,char *word)
#else
void	digtextp(bundle,x,y,word)
int 	bundle;
int 	x,y;	/* coords of bottom left corner */
char 	*word;
#endif
{
	int	xmax = x + strlen(word)*digdata.chwidth - 1;
	int	ymax = y + digdata.chheight - 1;
	char	ch[2];

	if ((x >= digdata.clipxmin) && (xmax <= digdata.clipxmax) &&
	    (y >= digdata.clipymin) && (ymax <= digdata.clipymax))
	    	/* hunky dory */
		(*digtable[digdata.select].text)(bundle,x,y,word);
	else if ((xmax < digdata.clipxmin) || (x > digdata.clipxmax) ||
		 (ymax < digdata.clipymin) || (y > digdata.clipymax))
		/* outside clipping region */
		return;
	else if ((y < digdata.clipymin) || (ymax > digdata.clipymax))
		/* can't really clip partially in height */
		return;
	else {
		/* knock characters off front */
		while ((x < digdata.clipxmin) && (*word!='\0')) {
			x += digdata.chwidth;
			word++;
		}
		/* plot what's left */
		while (((x+digdata.chwidth) <= digdata.clipxmax) && (*word!='\0')) {
			ch[0] = *word++;
			ch[1] = '\0';
			(*digtable[digdata.select].text)(bundle,x,y,ch);
			x += digdata.chwidth;
		}
	}
}

#ifdef EMO
main()
{
	float	len;
	float	x;

	digstart('g',NULL,1);
	digscale(2.0,2.0,0);
	digorigin(1.0,1.0);
	digline(20,-0.5,0.0,0.5,0.0);
	digline(20,0.0,-0.5,0.0,0.5);
	digtext(21,0.0,0.0,"HELLO");
	digtext(22,0.25,0.25,"\"quotes\", 'quoth he', \"quotin'im\"....");
	digtext(23,-0.9,-0.7,"a");
	digtext(23,-0.9,-0.8,"ab");
	digtext(23,-0.9,-0.9,"abc");

	digline(20,-0.9,-0.6,-0.7,-0.6);
	digflush();
	digtext(20,-0.85,-0.6-digdata.chheight/(2*digdata.yscale),"StrikeouT");
	digline(20,-0.85,-0.55,-0.85,-0.5);
	len = 9*digdata.chwidth/digdata.xscale;
	digline(20,len-0.85,-0.55,len-0.85,-0.5);

	digline(20,len-0.85,-0.6+digdata.chheight/(2*digdata.yscale),len-0.8,-0.6+digdata.chheight/(2*digdata.yscale));
	digline(20,len-0.85,-0.6-digdata.chheight/(2*digdata.yscale),len-0.8,-0.6-digdata.chheight/(2*digdata.yscale));

	digtext(24,0.25,-0.19,"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	digbox(20,0.3,-0.6,0.6,-0.2);
	digclip(0.3,-0.6,0.6,-0.2);
	digtext(20,0.3,-0.6,"Clipped Text");
	for (x=0.2;x<=0.7;x+=0.05)
		digtext(24,x,-x,"ABCDEFGHIJKLMNOPQRSTUVWXYZ");
	digtext(24,0.7,-0.5,"ABCDEFGHIJKLMNOPQRSTUVWXYZ");

	digquit(1);
}
#endif

