/* digitemDI -- grey level displays */

/* version 1.0 - M.A. Huckvale - November 1987 */

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemDI(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct di_rec *buff,double    start,double   stop,int  flags)
#else
int digitemDI(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
struct di_rec	*buff;
double		start,stop;
int		flags;
#endif
{
	int		i,y,x,ex;
	int	numf,bstart;
	double	dstart,dstop;
	double	t;
	char	*labels=NULL;
	int		ngrey=255;
	int		flog=0;

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;
	yt = yval(digitab.iyt);

#if 0
	/* check timing of data set */
	dstart=item->offset+buff[0].posn*item->frameduration;
	bstart=0;
	while ((dstart < start) && (bstart<(item->numframes-1))) {
		bstart++;
		dstart = item->offset + buff[bstart].posn*item->frameduration;
	}
	if ((item->lxsync!=0)&&(dstart>start)&&(bstart > 0)) {
		bstart--;
		dstart=start;
	}
	dstop=item->offset+(buff[bstart].posn)*item->frameduration;
	numf=0;
	while ((dstop < stop) && ((bstart+numf) < (item->numframes-1))) {
		numf++;
		dstop = item->offset + (buff[bstart+numf].posn)*item->frameduration;
	}
	if (dstop < stop) {
		/* data does not reach to right end */
		xr = (float)(xl + (dstop-start)*digitab.scalex);
	}
	if (dstart > start) {
		/* data does not reach to left end */
		xl += (float)((dstart-start)*digitab.scalex);
	}
#endif

	/* get number of grey levels */
	ngrey=(int)param(item->params,"ngrey",255.0);
	if (params(item->params,"sfsformat",NULL)) ngrey=15;
	if (params(item->params,"logf",NULL)) flog=DIGITEMLOG;

#if 0
	/* display, if anything left */
	if ((numf>0) && (bstart<item->numframes)) {
#endif

		/* get max and min values */
		if (!(flags & DIGITEMFIX)) {
			if ((labels=params(item->params,"labels",NULL))==NULL) {
				digitab.lo = param(item->params,"minf",0.0);
				digitab.hi = param(item->params,"maxf",0.5/item->frameduration);
			}
		}

//error("digitdi: minf=%d maxf=%d flog=%d ngrey=%d\n",(int)digitab.lo,(int)digitab.hi,flog,ngrey);

		/* write y-axis */
		if ((flags & DIGITEMFIX) || (labels==NULL)) {
			digitemfreq(bundles,digitab.iyb,digitab.iyt,digitab.lo,digitab.hi,1|flog);
			/* write axis label */
			y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
			labels=params(item->params,"title","Hz");
			digtextp(digitab.dbun,digitab.ixl+3,digitab.iytitle,labels);
		}
		else
			digitemlabel(bundles,digitab.iyb,digitab.iyt,labels,0,item->framesize-sfsstruct[DI_TYPE]);

#if 0
		/* draw graph */
		if (item->lxsync==0)
			diggreyscale(digitab.gbun,xl,yb,xr,yt,buff[bstart].pixel,numf,item->framesize-sfsstruct[DI_TYPE],ngrey);
		else {
			double t=start;
			int ixl=xpix(xl);
			int ixr=xpix(xr);
			while ((ixl<=ixr) && (numf > 0)) {
				diggreyscalep(digitab.gbun,ixl,ypix(yb),ixl+2,ypix(yt),buff[bstart].pixel,1,item->framesize-sfsstruct[DI_TYPE],ngrey);
				ixl++;
				t += (1.0/digdata.xscale)/digitab.scalex;
				while ((t >= item->offset+(buff[bstart].posn+buff[bstart].size) * item->frameduration)&&(numf>0)) {
					bstart++;
					numf--;
				}

			}
		}
#endif
		digclippush();
		digclip(xl,yb,xr,yt);
		for (i=0;i<item->numframes;i++) {

			/* find time of frame */
			t = item->offset + buff[i].posn * item->frameduration - start;

			/* calculate x-value for display */
			x = (int)(digitab.ixl + digitab.ixoff + t*digitab.scalex*digdata.xscale);

			/* end at last plottable record */
			if (x > digitab.ixr) break;

			/* find last plot position */
			if (i < item->numframes-1)
				ex = (int)(digitab.ixl + digitab.ixoff + (t+(buff[i+1].posn-buff[i].posn)*item->frameduration)*digitab.scalex*digdata.xscale);
			else
				ex = (int)(digitab.ixl + digitab.ixoff + (t+buff[i].size*item->frameduration)*digitab.scalex*digdata.xscale);
			if (ex > digitab.ixr) ex=digitab.ixr;
			if (ex < digitab.ixl)
				/* nothing */;
			else if (x < (digitab.ixl+digitab.ixoff))
				x=digitab.ixl+digitab.ixoff;

			/* check x-value lies within box */
			if ((x >= digitab.ixl+digitab.ixoff) && (x < digitab.ixr)) {

				/* plot the pixels */
#if 0
				while (x < ex) {
					diggreyscalep(digitab.gbun,x,ypix(yb),x+2,ypix(yt),buff[i].pixel,1,item->framesize-sfsstruct[DI_TYPE],ngrey);
					x++;
				}
#endif
				diggreyscalep(digitab.gbun,x,ypix(yb),ex+1,ypix(yt),buff[i].pixel,1,item->framesize-sfsstruct[DI_TYPE],ngrey);

			}
		}
		digclippop();

#if 0
	}
#endif

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemDI";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header item;
	struct di_rec	*buff;
	double	totime;

	digstart('\0',NULL,1);
	getitem(argv[1],DI_TYPE,"0",&item,&buff);

	digscale(10.0,10.0,0);
	digclearscreen();

	totime = (buff[item.numframes-1].posn+buff[item.numframes-1].size)*item.frameduration;
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemDI(20,0.0,7.0,10.0,9.0,&item,buff,0.0,totime,3);

	digitemtime(23,0.0,6.0,10.0,6.5,totime-0.25,totime+0.25,1);
	digitemDI(20,0.0,4.0,10.0,6.0,&item,buff,totime-0.25,totime+0.25,3);

	digitemtime(23,0.0,3.0,10.0,3.5,0.0,0.1,1);
	item.offset=0.05;
	digitemDI(20,0.0,1.0,10.0,3.0,&item,buff,0.0,0.1,3);

	digquit(15);
	exit(0);
}
#endif
