/*  digitemTX ---- speech and TX display  */

/* version 1.1 - November 1987
	-SFS release
*/

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#ifdef __STDC__
int    digitemTX(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,int32  *buff,double  start,double  stop,int  flags)
#else
int digitemTX(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;	/* colours for graph */
float		xl,yb,xr,yt;	/* co-ords of box */
struct item_header *item;	/* data definition */
int32		*buff;		/* data buffer */
double		start,stop;     /* start and stop times	*/
int	 	flags;		/* possible options on display */
#endif
{
	register  int    i;	/* index variable */
	int       x,y;
	int       bmark,tmark;	/* tx marker y-values */
	double    totaltx;	/* tx total */

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,"Tx");

	/* calculate y-coordinates for TX markers */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt;

	/* index data and plot tx marks */
	totaltx = item->offset-start;
	for (i=0;i<item->numframes;i++) {

		/* find time of first marker */
		totaltx += buff[i] * item->frameduration;

		/* calculate x-value for display */
		x = (int)(digitab.ixl + digitab.ixoff + totaltx*digitab.scalex*digdata.xscale);

		/* check x-value lies within box */
		if ((x > (digitab.ixl+digitab.ixoff)) && (x < digitab.ixr))
			diglinep(digitab.gbun,x,bmark,x,tmark);

		/* end at last tx plottable */
		if (x > digitab.ixr) break;
	}

	/* draw title if required */
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef	EMO
char	*progname="digitemTX";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct		item_header item;          /* data definition */
	int		*buff;                     /* data buffer     */

	/* choose between laser printer or terminal, 'k' indicates   */
	/* the laser printer, '\0' indicates a terminal.                */

	if (strcmp(argv[1],"-p") ==0) {
		digstart ('k',NULL,1);
	  	getitem(argv[2],TX_TYPE,"*",&item,&buff);
	}
	else {
		digstart ('\0',NULL,1);
		getitem(argv[1],TX_TYPE,"*",&item,&buff);
	}

	/* set the scale */
	digscale (10.0,10.0,0);

	/* clear the screen for the display */
	digclearscreen();

	/* call digitemtime for the timescale */
	digitemtime(23,0.0,9.0,10.0,9.5,0.0,1.0,1);

	/* call digitemTX for the TX markers */
	digitemTX(20,0.0,7.0,10.0,8.0,&item,buff,0.0,1.0,1);

	digitemTX(20,0.0,5.0,10.0,6.0,&item,buff,0.0,1.0,3);

	item.offset=0.1;
	digitemTX(20,0.0,3.0,10.0,4.0,&item,buff,0.0,1.0,3);

	digend();
	exit(0);
}
#endif


