/* digitemWD -- display word lattice */

/* version 1.0 - M.A. Huckvale - July 1998 */

#define V2

#include <stdio.h>
#include <fcntl.h>
#include "sfs.h"
#include "dig.h"
#include "digdata.h"
#include "digitem.h"

#define MAXWDLEVELS	100

static void drawarc(int lbun,int tbun,int sx,int ex,int yb,char *label)
{
	int	lx,rx;
	int	yt,ym;
	int	slen;

	slen = strlen(label)*digdata.chwidth;
	lx = (sx+ex)/2 - slen/2 - 2;
	rx = (sx+ex)/2 + slen/2 + 2;
	yt = yb + digdata.chheight + 2;
	ym = yb + digdata.chheight/2 + 1;

	/* draw text first */
	digtextp(tbun,lx+2,yb+2,label);
	/* draw box */
	digboxp(lbun,lx,yb,rx,yt);
	/* draw linking lines */
	diglinep(lbun,sx,ym,lx,ym);
	diglinep(lbun,rx,ym,ex,ym);
	/* draw blobs */
	digboxp(lbun,sx-1,ym-1,sx+1,ym+1);
	digboxp(lbun,ex-1,ym-1,ex+1,ym+1);
}

#ifdef __STDC__
int    digitemWD(int32  bundles,float  xl,float  yb,float xr,float  yt,struct  item_header *item,struct wd_rec *buff,double    start,double   stop,int  flags)
#else
int digitemWD(bundles,xl,yb,xr,yt,item,buff,start,stop,flags)
int32		bundles;
float		xl,yb,xr,yt;
struct item_header *item;
struct wd_rec 	*buff;
double		start,stop;
int		flags;
#endif
{
	register int	i;
	int		sx,ex,y;
	int		bmark,tmark;
	double		stime,etime;
	int		height;
#ifdef V2
	struct order_rec {
		int	idx;
		int	height;
	} *order;
	int	j;
	int	overlap;
#else
	int		lastx[MAXWDLEVELS];
	int		level;
	int		jiggle;
#endif

	/* sort out bundles */
	digitbundle(bundles);

	/* init box */
	digitbox(xl,yb,xr,yt,start,stop,flags);
	xl += digitab.ixoff/digdata.xscale;

	/* write axis label */
	y = (digitab.iyt + digitab.iyb - digdata.chheight)/2;
	digtextp(digitab.lbun,digitab.ixl+3,digitab.iytitle,"Score");

	/* calc line positions */
	bmark = digitab.iyb+1;
	tmark = digitab.iyt;

	/* clip to graph area */
	digclippush();
	digclip(xl,yb,xr,yt);

#if 0
// didn't really like the look of these - MAH
	/* draw timing lines */
	i=0;
	stime=i*item->frameduration+item->offset;
	while ((i<item->numframes) && (stime<stop)) {
		sx = (int)(digitab.ixl+digitab.ixoff + (stime-start) * digitab.scalex * digdata.xscale);
		diglinep(digitab.gbun,sx,bmark,sx,tmark);
		i++;
		stime=i*item->frameduration+item->offset;
	}
#endif

#ifdef V2
	/* create list sorted by score */
	order = calloc(item->numframes,sizeof(struct order_rec));
	order[0].idx=0;
	for (i=1;i<item->numframes;i++) {
		j = i;
		while ((j > 0) && (buff[i].score > buff[order[j-1].idx].score)) {
			order[j] = order[j-1];
			j--;
		}
		order[j].idx=i;
	}

	/* assign heights */
	order[0].height = tmark - 3*digdata.chheight;
	for (i=1;i<item->numframes;i++) {
		height = tmark - 3*digdata.chheight;
		overlap=1;
		while ((overlap) && (height >= bmark)) {
			overlap=0;
			for (j=0;j<i;j++) {
				if ((buff[order[i].idx].start >= buff[order[j].idx].start) &&
				    (buff[order[i].idx].start <  buff[order[j].idx].end) &&
				    (height == order[j].height))
					overlap=1;
				if ((buff[order[j].idx].start >= buff[order[i].idx].start) &&
				    (buff[order[j].idx].start <  buff[order[i].idx].end) &&
				    (height == order[j].height))
					overlap=1;
			}
			if (overlap) height -= (3*digdata.chheight)/2;
		}
		order[i].height = height;
	}

	/* draw graph */
	for (i=0;i<item->numframes;i++) {
#if 0
printf("i=%d idx=%d height=%d start=%d end=%d score=%g label=%s\n",
	i,order[i].idx,order[i].height,
	buff[order[i].idx].start,
	buff[order[i].idx].end,
	buff[order[i].idx].score,
	buff[order[i].idx].symbol);
#endif
		stime=buff[order[i].idx].start*item->frameduration+item->offset;
		etime=buff[order[i].idx].end*item->frameduration+item->offset;
		if ((order[i].height >= bmark) && ((etime >= start) || (stime < stop))) {
			sx = (int)(digitab.ixl+digitab.ixoff + (stime-start) * digitab.scalex * digdata.xscale);
			ex = (int)(digitab.ixl+digitab.ixoff + (etime-start) * digitab.scalex * digdata.xscale);

			/* draw an arc */
			drawarc(digitab.lbun,digitab.lbun,sx,ex,order[i].height,buff[order[i].idx].symbol);
		}
	}

	free(order);
#else
	/* draw graph */
	for (level=0;level<MAXWDLEVELS;level++) lastx[level]=0;
	level=0;
	height = (3*digdata.chheight)/2;
	jiggle=0;
	i=0;
	stime=buff[i].start*item->frameduration+item->offset;
	etime=buff[i].end*item->frameduration+item->offset;
	while ((i<item->numframes) && (stime<stop)) {
		if (etime >=start) {
			sx = (int)(digitab.ixl+digitab.ixoff + (stime-start) * digitab.scalex * digdata.xscale);
			ex = (int)(digitab.ixl+digitab.ixoff + (etime-start) * digitab.scalex * digdata.xscale);
			if (sx <= lastx[level]) {
				/* overlap on this level - move text up */
				level++;
				y = bmark + level*height + jiggle;
				/* but not too high */
				if (((y+height) >= tmark) ||
				    (level >= MAXWDLEVELS)) {
				    	/* can't fit, reset everything */
				    	jiggle = jiggle + 3;
				    	if (jiggle >= height) jiggle=0;
					y = bmark + jiggle;
					level=0;
				}
			}
			else {
				/* drop down until hit annotation */
				while ((level > 0) && (sx > lastx[level-1])) level--;
				y = bmark + level*height + jiggle;
			}

			/* draw an arc */
			drawarc(digitab.lbun,digitab.lbun,sx,ex,y,buff[i].symbol);

			if (ex > lastx[level])
				/* this annotation is right-most at this level */
				lastx[level] = ex;
		}
		i++;
		stime=buff[i].start*item->frameduration+item->offset;
		etime=buff[i].end*item->frameduration+item->offset;
	}
#endif

	/* draw title if required */
	digclippop();
	digititle(item,flags);

	/* that's it */
	digflush();
	return(0);
}

#ifdef EMO
char	*progname="digitemWD";
main(argc,argv)
int	argc;
char	*argv[];
{
	struct	item_header wditem;
	struct wd_rec *wd;
	double	t,totime;
	int	i;

	digstart('\0',NULL,1);
	getitem(argv[1],WD_TYPE,"*",&wditem,&wd);

	digscale(10.0,10.0,0);
	digclearscreen();

	totime=0;
	for (i=0;i<wditem.numframes;i++) {
		t = wd[i].end * wditem.frameduration;
		if (t > totime) totime=t;
	}

	digitemtime(242424,0.0,9.0,10.0,9.5,0.0,totime,1);
	digitemWD(242422,0.0,6.0,10.0,9.0,&wditem,wd,0.0,totime,3);

	digitemtime(242424,0.0,5.0,10.0,5.5,(3*totime)/4,totime+0.25,1);
	digitemWD(222224,0.0,2.0,10.0,5.0,&wditem,wd,(3*totime)/4,totime+0.25,9);

	digwait();
	digend();
	exit(0);
}
#endif
