/* autoc - normalised autocorrelation */

#include <stdio.h>
#include <math.h>
#include "autoc.h"

/* autocorrelation */
int autoc(float *sp,int len,float *acoeff,int l1,int l2)
{
	register int	i,j;
	int			num;
	float		sum,sumsq1,sumsq2,norm;
	float		*s1,*s2;
	float		max=-1;
	int			maxidx=0;

	/* zero autocorrelation vector */
	for (i=0;i<=l2;i++) acoeff[i]=(float)0.0;

	/* for zero delay */
	sum=(float)0.0;
	num=len;
	s1 = sp;
	for (j=0;j<num;j++,s1++) sum += *s1 * *s1;
	acoeff[0] = sum/len;

	/* for each delay in expected freq. range */
	for (i=l1;i<=l2;i++) {
		sumsq1=sumsq2=sum=(float)0.0;
		num=len-i;
		s1 = sp;
		s2 = sp + i;
		for (j=0;j<num;j++) {
			sumsq1 += *s1 * *s1;
			sumsq2 += *s2 * *s2;
			sum += *s1++ * *s2++;
		}
		norm = (float)(sqrt(sumsq1)*sqrt(sumsq2)/num);
		acoeff[i] = (sum/num)/norm;
		if (acoeff[i] > max) {
			max=acoeff[i];
			maxidx=i;
		}
	}
	return(maxidx);
}

/* autocorrelation */
int autoc_d(double *sp,int len,double *acoeff,int l1,int l2)
{
	register int	i,j;
	int			num;
	double		sum,sumsq1,sumsq2,norm;
	double		*s1,*s2;
	double		max=-1;
	int			maxidx=l1;

	/* zero autocorrelation vector */
	for (i=0;i<=l2;i++) acoeff[i]=(double)0.0;

	/* for zero delay */
	sum=(float)0.0;
	num=len;
	s1 = sp;
	for (j=0;j<num;j++,s1++) sum += *s1 * *s1;
	acoeff[0] = sum/len;

	/* for each delay in expected freq. range */
	for (i=l1;i<=l2;i++) {
		sumsq1=sumsq2=sum=(double)0.0;
		num=len-i;
		s1 = sp;
		s2 = sp + i;
		for (j=0;j<num;j++) {
			sumsq1 += *s1 * *s1;
			sumsq2 += *s2 * *s2;
			sum += *s1++ * *s2++;
		}
		norm = (double)(sqrt(sumsq1)*sqrt(sumsq2)/num);
		acoeff[i] = (sum/num)/norm;
		if (acoeff[i] > max) {
			max=acoeff[i];
			maxidx=i;
		}
	}
	return(maxidx);
}
