/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"
#include "libic.h"

#define NAME "fftr"

void fftr(data,spect,len)
REAL *data;
COMPLEX *spect;
int len;
/*
	Real fourier transform with len = 2**m

	data[len] -> spect[len/2 + 1]

        data and spect can be the same array if desired
*/
{
    static REAL *temp;
    static int tlen = 0;
    REAL *pdata,*pdatan,*pspect,*ptemp,*qtemp;
    int m;

/* First copy into temporary array */

    if (len < 8) error("%s: length (= %d) must be >= 8",NAME,len);
    if (len > tlen) {
	if (tlen) free(temp);
	temp = (REAL *) malloc(len * sizeof(REAL));
	tlen = len;
	}

    pdata = data;
    ptemp = temp;
    pdatan = data + len;
    while(pdata < pdatan) *ptemp++ =  *pdata++;

/* Now do the transform */

    m = log2ch(len);
    rbitrev(temp,len);
    rsplfft(temp,len,m);

/* now unravel the complex parts */

    ptemp = temp;
    qtemp = temp+len - 1;
    pspect = (REAL *) spect;
    *pspect++ = *ptemp++;
    *pspect++ = 0.0;
    while (ptemp < qtemp) {
	*pspect++ = *ptemp++;
	*pspect++ = *qtemp--;
	}
    *pspect++ = *ptemp;
    *pspect++ = 0.0;
    return;
    }
#ifdef EMO

#include <stdio.h>
#include <math.h>
#define LEN 1024

main ()
{
    REAL data[LEN];
    COMPLEX spect[1 + LEN/2];
    REAL sum,theta;
    int i,nharm;
    REAL camp,samp;
    REAL fact;
    int len;

    printf("Test program for fftr - real fast fourier transform\n\n");
    for (;;) {
	do {
	    printf("\nEnter transform length: ");
	    scanf("%d",&len);
	    } while ((len<2) || (len>LEN));

	for (i=0; i<len; i++) data[i] = 0.0;
	printf("Enter harmonic numbers and amplitude of cos & sin (-ve to end)\n");
	for (;;) {
	    scanf("%d",&nharm);
	    if ((nharm<0) || (nharm>len/2)) break;
	    scanf("%f%f",&camp,&samp);
	    for (i=0; i<len; i++) {
		theta = (TWOPI * i * nharm) / len;
		data[i] = data[i] + camp*cos(theta) + samp*sin(theta);
		}
	    }

	fftr(data,spect,len);

	printf("Harm     Cos     Sin\n\n");
	for (i=0; i<=(len/2); i++) {
	    fact = ((i==0) || (i==len/2)) ? 1.0/len : 2.0/len;
	    spect[i].r *= fact;
	    spect[i].i *= -fact;
	    if ((spect[i].r*spect[i].r + spect[i].i*spect[i].i) > 0.01) {
		printf("%3d %8.2f %8.2f\n",i,spect[i].r,spect[i].i);
		}
	    }
        }
    }
#endif
