/* DSP routines from Mike Brookes, Imperial College London */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "sfs.h"
#include "libic.h"

#define NAME "log2ch"

int log2ch(len)
int len;
{
/*
 Returns log2(len) or else exits with an error message
*/
    static int m = 1, n = 2;

    if (n != len) {		/* calculate m = log(len) */
	n = 2; m = 1;
	while (n < len) { n = n << 1; m++; }
	if (n != len) error("%s: len (= %d) not a power of 2",NAME,len);
	}
    return(m);
    }
#ifdef EMO
main()
{
    int len;

    for (;;) {
	printf("Enter length: ");
	scanf("%d",&len);
	printf("Log2(%d) = %d\n",len,log2ch(len));
	}
    }
#endif
