/* error -- print error message and exit */

/*---------------------------------------------------------------------------*/
/**MAN
.TH ERROR SFS3 UCL SFS
.SH NAME
error - print error message and quit
.SH SYNOPSIS
.nf

extern char *progname;

void    error(format [ ,arg ] ... )
char    *str1;

.fi
.SH DESCRIPTION
.I error
prints a message to to the standard error and then terminates the current process.
The message is prefixed with "sfs:" or the contents of the global variable "progname" if
declared.  The text of the message is made up from
.I str1
and
.I args,
if present, with 
.I str1 
containing the "printf" style format for the message, and
.I str2
the coorresponding arguments.
.PP
.I error
also deletes any temporary files created with 
.I sfschannel
(see SFSLIB(SFS3)).
.SH EXAMPLE
.nf

	#define PROGNAME "yourprog"
	char	*progname=PROGNAME;
	:
	error("cannot open file %s",filename);
	:
	error("process fails");

.fi
.SH VERSION/AUTHOR
1.1 - Mark Huckvale
*/
/*---------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

#ifdef WIN32
#include <windows.h>
#include <stdarg.h>

void error(char *fmt, ...)
{
	char	messg[1024];
	char	buffer[1024];
	va_list	params;
	extern char *progname;
	int	i;

	/* print message */
	va_start(params, fmt);
	wvsprintf(buffer, fmt, params);
	va_end(params);
	wsprintf(messg,"%s: %s", progname,buffer);

	/* show a message box */
	MessageBox(NULL,messg,"SFS fatal error",MB_OK|MB_ICONEXCLAMATION);

	/* delete temporary files */
	for (i=0;i<MAXFILES;i++) if (sfsdata[i]) {
		if (sfsdata[i]->mode==SFSWRITE) {
			close(i);
			unlink(sfsdata[i]->ofilename);
		}
	}

	/* terminate process */
	exit(1);
}

#elif defined(__STDC__)
#include <stdarg.h>

void error(char *fmt, ...)
{
	va_list	params;
	extern char *progname;
	int	i;

	/* print message */
	fprintf( stderr, "%s: ", progname );
	va_start(params, fmt);
	vfprintf( stderr, fmt, params);
	va_end(params);
	fprintf( stderr, "\n" );

	/* delete temporary files */
	for (i=0;i<MAXFILES;i++) if (sfsdata[i]) {
		if (sfsdata[i]->mode==SFSWRITE) {
			close(i);
			unlink(sfsdata[i]->ofilename);
		}
	}

	/* terminate process */
	exit(1);
}

#else

/*VARARGS1*/
void error( fmt, argp )
char *fmt;
{
	extern char *progname;
	int	i;

	/* print message */
	fprintf( stderr, "%s: ", progname );
	_doprnt( fmt, &argp, stderr );
	fprintf( stderr, "\n" );

	/* delete temporary files */
	for (i=0;i<MAXFILES;i++) if (sfsdata[i]) {
		if (sfsdata[i]->mode==SFSWRITE) {
			close(i);
			unlink(sfsdata[i]->ofilename);
		}
	}

	/* terminate process */
	exit(1);
}
#endif
