/* params -- decode string parameter from string */

/* m.e.johnson, from 'param' by m.a. huckvale - november 1986 */

/* Version 1.0 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <ctype.h>
#include "sfs.h"

#define isseparator(c)	((c==' ')||(c==',')||(c==';')||(c=='(')||(c==')'))
#define isnonwhitesep(c) ((c==',')||(c==';')||(c=='(')||(c==')'))

char	*params(str,par,def)
char	*str,*par;
char	*def;
{
	int	i,flag=0;
	char	*endstr,*hold,*term;
	static char *retstring=NULL;
	int	lenpar,count=0;
	double	atof();

	term = str + strlen(str);
	endstr = str + strlen(str) - strlen(par);
	lenpar = strlen(par);
	while (!flag && (str <= endstr)) {
		if (isalpha(*str)) {
			/* beginning of word - check for match */
			flag=1;
			for (i=0;(flag && (i<lenpar));i++) if (str[i] != par[i]) flag=0;
			if (isdigit(str[i]) || isalpha(str[i])) flag=0;
		}
		/* if not found - skip to next word */
		if (!flag) {
			while (!isseparator(*str) && (str <= endstr)) str++;
			while (!isalpha(*str) && (str <= endstr)) str++;
		}
	}
	if (!flag) {
		return(def);
	}
	else {
		str += lenpar;
		if (*str != '=') {
			return(par);
		}
		else {
			hold = ++str;
			while (!isnonwhitesep(*str) && (str++ <= term)) count++;
			str=hold;
			if (retstring) free(retstring);
			if ((retstring = (char *)malloc(count+1)) == NULL)
				return(NULL);
			strncpy(retstring,str,count);
			retstring[count]='\0';
			return(retstring);
		}
	}
}
