/* sfsitem -- locate a data item in a file by history match */

/* M.A. Huckvale */

/* version 1.0 - June 1987 */
/* version 1.1 - August 1989, C M Ayer */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <ctype.h>
#include "sfs.h"
#include "sfsdata.h"

int sfsitem(fid,it,match,item)
int	fid;			/* file id from sfsopen */
int32     it;		     /* item type */
char    *match;		 /* item history match */
struct item_header *item;       /* returned item header */
{
	struct item_header itemp;
	int     ty=0;
	int32    lastfound = -1;
	char	junk[16];

	/* check file opened ok */
	if (!sfsdata[fid] ||
	    (sfsdata[fid]->mode != SFSREAD)) return(0);

	/* init data record for item */
	if (sfsdata[fid]->lfid > 0) {
		sfsclose(sfsdata[fid]->lfid);
		sfsdata[fid]->lfid=0;
	}
	sfsdata[fid]->datastart=0;
	sfsdata[fid]->currpos=0;
	sfsdata[fid]->start=0;
	sfsdata[fid]->numf=0;
	sfsdata[fid]->lfid=0;
	sfsdata[fid]->multiplex=0;
	sfsdata[fid]->swab=0;
	sfsdata[fid]->dcoffset=0;
	sfsdata[fid]->shift=0;

	/* go to end of main header */
	lseek(fid,(long)(sizeof(struct main_header)),0);

	/* check match for number */
	if (isdigit(match[0]) || (match[0]=='-')) {
		ty=atoi(match); 
		match=NULL;
	}

	/* loop through data items */
	if (!item) item = &itemp;
	while (read(fid,item,sizeof(struct item_header)) ==
	    sizeof(struct item_header)) {
#if SFS_SWAP_HEADER
		/* always swap into sun4 format */
		sun4swap((int32 *)item);
#endif
		/* do conversion if required */
		if (item->machine != SFSMACHINE)
			sfsconvi(item);
		/* zero data type = first item */
		if (it==0) {
			sfsdata[fid]->item = *item;
			sfsdata[fid]->datastart=lseek(fid,0L,1);
			sfsdata[fid]->currpos=sfsdata[fid]->datastart;
			return(1);
		}
		/* if right type, do match */
		if (item->datatype == it) {
			if ( (match && (histmatch(match,item->history,junk,junk,junk,junk,junk,junk,junk,junk,junk,junk)==1)) ||
			     (ty==-1) || 
			     (ty==item->subtype) ) {
				sfsdata[fid]->item = *item;
				sfsdata[fid]->datastart=lseek(fid,0L,1);
				sfsdata[fid]->currpos=sfsdata[fid]->datastart;
				return(1);
			}
			else
				lastfound=lseek(fid,0L,1)-sizeof(struct item_header);
		}
		lseek(fid,item->length,1);
	}
	/* type is zero, return last item of given type */
	if (!match && (ty==0) && (lastfound > 0)) {
		lseek(fid,lastfound,0);
		read(fid,item,sizeof(struct item_header));
#if SFS_SWAP_HEADER
		/* always swap into sun4 format */
		sun4swap((int32 *)item);
#endif
		/* do conversion if required */
		if (item->machine != SFSMACHINE)
			sfsconvi(item);
		sfsdata[fid]->item = *item;
		sfsdata[fid]->datastart=lseek(fid,0L,1);
		sfsdata[fid]->currpos=sfsdata[fid]->datastart;
		return(1);
	}
	return(0);
}

#ifdef IAG
main()
{
	char    filename[80];
	struct item_header item;
	int     it,fid,code;
	char    match[80];

	printf("Enter filename : "); fflush(stdout);
	scanf("%s",filename);
	if ((fid=sfsopen(filename,"r",NULL)) < 0) exit(1);

	for (;;) {
		printf("Enter Item type     : ");
		fflush(stdout);
		scanf("%d",&it);
		printf("Enter history match : ");
		fflush(stdout);
		scanf("%s",match);
		code = sfsitem(fid,it,match,&item);
		if (code == 0) 
			printf("item not found\n");
		else {
			printf("item %ld.%02ld history=%s\n",
				item.datatype,
				item.subtype,
				item.history);
		}
	}
}
#endif
