/* sfswritelink -- write a linked item to sfs file */

/* version 1.0 - August 1987 */

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"
#include "sfsdata.h"

int sfswritelink(item,numf,link,filename)
struct item_header *item;
int32		numf;
struct link_header *link;
const char		*filename;
{
	int	fid,ok;

	/* indicate a link */
	item->datapresent=2;

	/* create new item in file */
	if ((fid = sfschannel(filename,item)) < 0)
		return(0);

	/* write link header */
	ok = (write(fid,link,sizeof(struct link_header))==sizeof(struct link_header));

	/* massage sfs internal data */
	sfsdata[fid]->item.numframes=numf;
	sfsdata[fid]->item.length=sizeof(struct link_header);

	/* update */
	return(ok);

}
