#!/bin/csh
# shell script to store SFS manual pages in the right place
# saveman 1 xyz abc 
# will look for xyz.c in the current directory and store its
# manual page in /usr/sfs/man/man1/xyz.1
# options -v = verbose, -f = no queries, -n = noclobber
set DIR=../man NUM=1
unset VER FOR NOC
foreach Y ( $* )
set X=$Y:r
set Z=$X:t
if ("$Y" =~ [1-7]) then
    set NUM=$Y
else if ("$Y" =~ -*) then
    switch ($Y)
    case -v:
	set VER; breaksw
    case -f:
	set FOR; breaksw
    case -n:
	set NOC; breaksw
    endsw
else
    set F=$DIR/man$NUM/$Z.$NUM DOIT
    if ((! $?FOR) && (-e $F)) then
	if ($?NOC) then
	    unset DOIT
	    if ($?VER) echo $F already exists
	else
	    echo -n "Do you want to replace existing $F ? "
	    set ANS=$<
	    if (($ANS !~ y*) && ($ANS !~ Y*)) unset DOIT
	    endif
	endif
    if ($?DOIT) then
	awk '/\/\*\*MAN/,/\*\// {if(($0 != "/**MAN")&&($0 != "*/")) print}' $X.c > $F
	if (-z $F) then
	    if ($?VER) echo Cannot extract manual from $X.c
	    /bin/rm $F
	else
	    echo .SH SOURCE >> $F
	    if ($X =~ /*) then
		echo $X.c >> $F
	    else
		echo $cwd/$X.c >> $F
		endif
            nroff -man < $F | col -b >$DIR/man$NUM/$Z.txt
	    if ($?VER) echo $F
	    endif
	endif
    endif
end
