/* es.h -- header file for Es system */

/* item selection record - filled by -i, -a switches */
struct itemsel_rec {
	int32	it;
	int	ty;
	char	*match;
	int	all;
};

/* item number list */
struct itemno_rec {
	int	datatype;
	int	subtype;
};

/* prototypes */
#ifdef __STDC__
int	estree(char *,struct itemno_rec *,int,int);
void 	esmenu_display(int,char **,char **,int);
void 	esmenu_redisplay(void);
int 	esmenu_check(float,float,int);
int 	esmouse_checkp(int,int,int);
int	escheckfile(char *);
int	escopyitem(char *,int,struct itemno_rec *,int,double,double,char *);
int	eslinkitem(char *,int,struct itemno_rec *,int,double,double,char *);
void breakhandler(int);
int getprompt(char *,char *);
void warning(char *messg);
void clear_top_line(void);
char *logname(void);
void title_display(void);
void displaymeasure(char *);
double findvalue(float);
void dograph(void);
void display(int fid,struct item_header *item,double yb,double yt,double t1,double t2);
void displayFFT(int fid,struct item_header *item,double yb,double yt,double t1,double t2,int narrow);
int esitem(int fid,struct itemsel_rec *itab,int itcnt,struct itemno_rec *itemlist);
int itrequired(struct itemsel_rec *itab,int itcnt,struct item_header *item,char	*hist,int flag);
int onitemlist(struct itemno_rec *list,int cnt,int it,int ty);
void getdata(int fid,struct item_header *item,double t1,double t2,char **buff);
int findspeech(int,int);
int findsp(int);
void repspeech(float,double,double,double,double);
void invbox(float,float,float);
void preloadan(int fid,struct item_header *item);
void sortan(int);
void dispan(float,float,double,double,int);
void addan(char *name,double atime,double stime,double etime);
int selan(double atime,double stime,double etime);
void movan(int entry,double atime,double stime,double etime);
int digitmouse(int bundles,float xl,float yb,float xr,float yt,double *start,double *stop);
int getboxcom(int ch,int button,float x,float y,int curmen);


#else
int	estree();
void 	esmenu_display();
void 	esmenu_redisplay();
int 	esmenu_check();
int 	esmouse_checkp();
int	escheckfile();
int	escopyitem();
int	eslinkitem();
void breakhandler();
int getprompt();
void warning();
void clear_top_line();
char *logname();
void title_display();
void displaymeasure();
double findvalue();
void dograph();
void display();
void displayFFT();
int esitem();
int itrequired();
int onitemlist();
void getdata();
int findspeech();
int findsp();
void repspeech();
void invbox();
void preloadan();
void sortan();
void dispan();
void addan();
int selan();
void movan();
#endif

/* commands in Es */
#define ES_ACTION	-12
#define ES_CURSOR_LEFT	-11
#define ES_CURSOR_RIGHT	-10
#define ES_GOTO		-9
#define ES_PLAY_LEFT	-8
#define ES_PLAY_RIGHT	-7
#define ES_PLAY_ALL	-6
#define ES_ANNOT_RIGHT	-5
#define ES_MAINMENU	-4
#define ES_FILEMENU	-3
#define ES_ANNOT	-2
#define ES_NULL		-1
#define ES_EXTERNAL	0		/* limit for esmouse internal */
#define ES_QUIT		0
#define ES_UP		1
#define ES_DOWN		2
#define ES_LEFT		3
#define ES_RIGHT	4
#define ES_PRINT	5
#define ES_TOP		6
#define ES_REPAINT	7
#define ES_TREE		8
#define ES_COPY		9
#define ES_LINK		10

/* escopy completion codes */
#define ES_OK		0
#define ES_NOEXIST	1
#define ES_NOWRITE	2
#define ES_NOTSFS	3
