/* prolab -- process a users label file for fast access */

/* SFS 1.0 - July 1987 */

/*--------------------------------------------------------------------------*/
/**MAN
.TH PROLAB SFS1 UCL SFS
.SH NAME
prolab - process user sfs labels file for fast access
.SH SYNOPSIS
.B prolab
labelsfile
.SH DESCRIPTION
.I prolab
is a program to process a SFS labels file (see labels(SFS5)) for faster access
using SFS routines such as "itspec", "lab_get", etc.  This routine must
be called to operate on a labels file after each edit, otherwise the SFS
label routines will report "file out of date" errors.
.PP
.I Options
and their meanings are:
.TP 11
.B -I
Identify program name and version number.
.SH VERSION/AUTHOR
1.0 - Mark Huckvale.
.SH SEE ALSO
labels(SFS5)
*/
/*--------------------------------------------------------------------------*/

#define PROGNAME "prolab"
#define PROGVERS "1.0s"
char *progname=PROGNAME;

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>
#include <malloc.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sfs.h"

/* data structures for index */
#define MAXMATCH 500
#define MAXCODE	 500
struct labrec {
	int32	pos;
	char	*str;
} match[MAXMATCH],code[MAXCODE];
int	mcnt=0,ccnt=0;
int	mmax=0,cmax=0;

/* sort label record */
void sort(table,cnt)
struct labrec table[];
int		cnt;
{
	int	i,j,m;
	struct labrec	hold;

	for (i=1;i<cnt;i++) {
		hold = table[i];
		for (j=i;j>0;j--) {
			if (((m=strcmp(hold.str,table[j-1].str)) < 0) ||
			    ((m==0) && (hold.pos < table[j-1].pos)))
				table[j] = table[j-1];
			else
				break;
		}
		table[j] = hold;
	}
}

void main(argc,argv)
int	argc;
char	*argv[];
{
        /* option decoding variables */
        extern int      optind;
        int             errflg=0;
        char            c;
	/* file variables */
	char		filename[SFSMAXFILENAME];
	char		ofilename[SFSMAXFILENAME];
	FILE		*ip,*op=NULL;
	/* processing variables */
	char		line[256],pname[32];
	char		*h,*t,*d;
	int32		hstart,mstart,mend,cstart,cend;
	int		i,len;
	struct stat	st;

	/* decode options */
        while ( (c = getopt(argc,argv,"I")) != EOF) switch (c) {
                case 'I' :      /* Identify */
                        fprintf(stderr,"%s: Process 'labels' file V%s\n",PROGNAME,PROGVERS);
                        exit(0);
                        break;
                case '?' :      /* unknown */
                        errflg++;
        }
        if (errflg || (argc<2))
                error("usage: %s (-I) labelsfile",PROGNAME);

        /* get filename */
        if (optind < argc)
                strcpy(filename,argv[optind]);
        else
                error("no labels file specified",NULL);

	/* open input file */
	if ((ip=fopen(filename,"r"))==NULL)
		error("unable to open %s",filename);

	/* open output file */
	strcpy(ofilename,filename);
	strcat(ofilename,".tmp");
	if ((strcmp(filename,ofilename)==0) ||
		((op=fopen(ofilename,"w"))==NULL))
		error("unable to open temp file %s",ofilename);

	/* write header to output file */
	fprintf(op,"#prolab                                             \n");

	/* copy input to output, keeping record */
	while (fgets(line,256,ip)) if ((line[0]!='\n') && (line[0]!='#')) {
		/* delete final newline */
		len = strlen(line);
		if (line[len-1]=='\n') line[len-1]='\0';
		/* save start of history match */
		hstart = ftell(op);
		/* get history match */
		if ((h = strtok(line,":")) == NULL)
			error("format error: line='%s'",line);
		/* eliminate all but program name */
		len=0;
		while (isalnum(h[len])) {
			pname[len]=h[len];
			len++;
		}
		pname[len]='\0';
		/* save it in structure */
		len = strlen(pname);
		if (len > mmax) mmax = len;
		match[mcnt].str = malloc(len+1);
		strcpy(match[mcnt].str,pname);
		match[mcnt].pos = hstart;
		mcnt++;
		fprintf(op,"%s:",h);
		/* get text description */
		if ((t = strtok(0,":")) == NULL)
			error("format error: line='%s'",line);
		fprintf(op,"%s:",t);
		/* get optional codes */
		while ((d = strtok(0,":")) != NULL) {
			len = strlen(d);
			if (len > cmax) cmax = len;
			code[ccnt].str = malloc(len+1);
			strcpy(code[ccnt].str,d);
			fprintf(op,"%s:",d);
			code[ccnt].pos = hstart;
			ccnt++;
		}
		fprintf(op,"\n");
	}


	/* sort records */
	sort(match,mcnt);
	sort(code,ccnt);

	/* write codes and matches to file */
	fprintf(op,"#prolab----------------------------------------------------\n");
	mstart = ftell(op);
	for (i=0;i<mcnt;i++)
		fprintf(op,"#%-6d#%s#%*s\n",match[i].pos,match[i].str,(int)(mmax-strlen(match[i].str)),"");
	mmax += 10;
	mend = ftell(op);
	fprintf(op,"#prolab----------------------------------------------------\n");
	cstart = ftell(op);
	for (i=0;i<ccnt;i++)
		fprintf(op,"#%-6d#%s#%*s\n",code[i].pos,code[i].str,(int)(cmax-strlen(code[i].str)),"");
	cmax += 10;
	cend = ftell(op);

	/* rewind and write header */
	fflush(op);
	fclose(op);
	stat(filename,&st);
	op=fopen(ofilename,"r+");
	fprintf(op,"#prolab %d %d %d %d %d %d %d",
		(int32)st.st_mtime,mstart,mend,mmax,cstart,cend,cmax);
	fflush(op);

	/* close files */
	fclose(ip);
	fclose(op);

	/* swap files */
	unlink(filename);
	link(ofilename,filename);
	unlink(ofilename);

	/* that's all folks */
	exit(0);
}

