/* smanhtml -- create manual page from source file in HTML */

/* M.A.Huckvale - University College London */

/* version 1.0 - January 1998 */

#define PROGNAME "smanhtml"
#define PROGVERS "1.0"

/*--------------------------------------------------------------------------*/
/**MAN
.TH SMANHTML 1 SFS UTIL
.PM P
.SH NAME
smanhtml - filter out manual page from source file into HTML page
.SH SYNOPSIS
.B smanhtml
(sourcefile(s))
.SH DESCRIPTION
.I smanhtml
reads text from its standard input or the filenames supplied and
reformats into HTML any nroff macros found between the markers /\****MAN
and *\/.
It is used to format manual pages from SFS source files (where authors
are requested to include the manual page in the file).
.SH VERSION/AUTHOR
1.0 - Mark Huckvale
*/
/*--------------------------------------------------------------------------*/

#include "SFSCONFG.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "sfs.h"

/* check a string for reserved characters */
void copystring(char *dst,char *src)
{
	if (!src) {
		*dst='\0';
		return;
	}
	while (*src) {
		if (*src=='<') {
			*dst++ = '&';
			*dst++ = 'l';
			*dst++ = 't';
			*dst++ = ';';
		}
		else if (*src=='>') {
			*dst++ = '&';
			*dst++ = 'g';
			*dst++ = 't';
			*dst++ = ';';
		}
		else if (*src=='&') {
			*dst++ = '&';
			*dst++ = 'a';
			*dst++ = 'm';
			*dst++ = 'p';
			*dst++ = ';';
		}
		else if (*src=='|') {
			*dst++ = '&';
			*dst++ = '#';
			*dst++ = '1';
			*dst++ = '2';
			*dst++ = '4';
			*dst++ = ';';
		}
		else if (*src=='"') {
			*dst++ = '&';
			*dst++ = '#';
			*dst++ = '3';
			*dst++ = '4';
			*dst++ = ';';
		}
		else
			*dst++ = *src;
		src++;
	}
	*dst='\0';
}

char *convertslash(char *str)
{
	static char buff[4096];
	char *dst=buff;
	int	italic=0,bold=0;

	while (str && *str) {
		if (*str=='\\') {
			str++;
			if (*str=='f') {
				str++;
				if (*str=='I') {
					str++;
					*dst++ = '<';
					*dst++ = 'I';
					*dst++ = '>';
					italic=1;
				}
				else if (*str=='B') {
					str++;
					*dst++ = '<';
					*dst++ = 'B';
					*dst++ = '>';
					bold=1;
				}
				else if (*str=='R') {
					str++;
					if (italic) {
						*dst++ = '<';
						*dst++ = '/';
						*dst++ = 'I';
						*dst++ = '>';
						italic=0;
					}
					if (bold) {
						*dst++ = '<';
						*dst++ = '/';
						*dst++ = 'B';
						*dst++ = '>';
						bold=0;
					}
				}
				else if (*str)
					*dst++ = *str++;
			}
			else if (*str)
				*dst++ = *str++;
		}
		else
			*dst++ = *str++;
	}
	if (italic) {
		*dst++ = '<';
		*dst++ = '/';
		*dst++ = 'I';
		*dst++ = '>';
	}
	if (bold) {
		*dst++ = '<';
		*dst++ = '/';
		*dst++ = 'B';
		*dst++ = '>';
	}
	*dst='\0';
	return(buff);
}

int ulnext=0;

void procline(char *str)
{
	char fmt[4096];
	char arg[4096];
	char	*p;

	if (str[0]=='.') {
		copystring(fmt,strtok(str+1," \t\n"));
		copystring(arg,strtok(NULL,"\n"));
	}
	else {
		copystring(fmt,NULL);
		copystring(arg,strtok(str,"\n"));
	}
	if (strcmp(fmt,"B")==0)
		printf("<B>%s</B>\n",arg);
	else if (strcmp(fmt,"I")==0)
		printf("<I>%s</I>\n",arg);
	else if (strcmp(fmt,"BI")==0) {
		printf("<B>%s</B> ",strtok(arg," \t\n"));
		printf("<I>%s</I>\n",strtok(NULL,"\n"));
	}
	else if (strcmp(fmt,"TH")==0)
		printf("<P><H2>%s</H2>\n",strtok(arg," \t\n"));
	else if (strcmp(fmt,"SH")==0)
		printf("<H3>%s</H3>\n",arg);
	else if (strcmp(fmt,"SS")==0)
		printf("<H4>%s</H4>\n",arg);
	else if (strcmp(fmt,"PP")==0)
		printf("<P>");
	else if (strcmp(fmt,"sp")==0)
		printf("<P>");
	else if (strcmp(fmt,"TP")==0)
		printf("<P>");
	else if (strcmp(fmt,"IP")==0) {
		p = strrchr(arg,' ');
		if (p && *p) *p='\0';
		printf("<P><I>%s</I>\n",strtok(arg,"\t\n"));
	}
	else if (strcmp(fmt,"nf")==0)
		printf("<pre>\n");
	else if (strcmp(fmt,"fi")==0)
		printf("</pre>\n");
	else if (strcmp(fmt,"br")==0)
		printf("<BR>");
	else if (*fmt && *arg)
		printf("{%s} %s\n",fmt,arg);
	else if (*fmt) {
		if (strcmp(fmt,"ul")==0) {
			ulnext=1;
		}
		else
			printf("{%s}\n",fmt);
	}
	else if (*arg) {
		if (ulnext) {
			printf("<u>%s</u>\n",convertslash(arg));
			ulnext=0;
		}
		else
			printf("%s\n",convertslash(arg));
	}
	else
		printf("\n");
}

void procfile(FILE *ip,char *title)
{
	char	iline[1024];
	int	start=0;
	time_t	tim;
	char	buf[32];

	tim = time((time_t *)0);
	strcpy(buf,ctime(&tim));
	buf[25]='\0';

	while (fgets(iline,1024,ip)) {
		if (start && (strncmp(iline,"*/",2)==0)) {
			printf("<HR><sub>%s</sub></body></html>\n",buf);
			break;
		}
		if (start) procline(iline);
		if (strncmp(iline,"/**MAN",6)==0) {
			printf("<html><head><title>%s: Manual Page</title></head><body>\n",title);
			start=1;
		}
	}
}

int main(int argc,char **argv)
{
	extern int optind;
	extern char *optarg;
	int	c,errflg=0;
	FILE	*ip;
	char	basename[256],*p;

	while ((c=getopt(argc,argv,"I"))!=EOF) switch (c) {
	case 'I':
		fprintf(stderr,"%s: Get manual page from source in HTML Vs%s\n",PROGNAME,PROGVERS);
		exit(0);
	default:
		errflg=1;
		break;
	}
	if (errflg)
		error("usage: %s (-I) (sourcefiles)",PROGNAME);

	if (optind==argc)
		procfile(stdin,"SFS");
	else for (;optind<argc;optind++) {
		if ((ip=fopen(argv[optind],"r"))==NULL)
			error("could not open '%s'",argv[optind]);
		p = strrchr(argv[optind],'\\');
		if (!p) p = strrchr(argv[optind],'/');
		if (p)
			strcpy(basename,p+1);
		else
			strcpy(basename,argv[optind]);
		p = strrchr(basename,'.');
		if (p) *p='\0';
		procfile(ip,basename);
		fclose(ip);
	}
	exit(0);
}
