/* plot.sml -- demonstration of some simple plotting */

var ydata[1:10]
var xdata[1:10]

init {
	var	i
	string	key

	ydata[1] = 1
	ydata[2] = 10
	ydata[3] = 2
	ydata[4] = 9
	ydata[5] = 3
	ydata[6] = 8
	ydata[7] = 4
	ydata[8] = 7
	ydata[9] = 5
	ydata[10] = 6
	xdata[1] = 1
	xdata[2] = 2
	xdata[3] = 3
	xdata[4] = 4
	xdata[5] = 5
	xdata[6] = 6
	xdata[7] = 7
	xdata[8] = 8
	xdata[9] = 9
	xdata[10] = 10

	plot(stdout,1,ydata,10)
	plotwait(stdout)

	plotclear(stdout)
	plotxdata(xdata,0)
	plot(stdout,1,ydata,10)
	plotwait(stdout)

	plotclear(stdout)
	plotparam("title=This is the graph title")
	plotparam("xtitle=This is the x-axis")
	plotparam("ytitle=This is the y-axis")
	plotparam("yzero=yes")
	plotparam("xzero=yes")
	plotparam("char=*")
	plotxdata(xdata,0)
	plot(stdout,1,ydata,10)
	plotwait(stdout)

	plotclear(stdout)
	plotparam("title=This is the graph title")
	plotparam("xtitle=This is the x-axis")
	plotparam("ytitle=This is the y-axis")
	plotparam("yzero=no")
	plotparam("xzero=no")
	plotparam("xpos=top")
	plotparam("ypos=right")
	plotparam("xlabel=top")
	plotparam("ylabel=right")
	plotparam("ylog=yes")
	plotparam("char=")
	plotxdata(xdata,0)
	plot(stdout,1,ydata,10)
	plotwait(stdout)

	plotclear(stdout)
	plottitle(stdout,"6 Example Graphs")
	plotparam("vertical=2")
	plotparam("horizontal=3")
	plotparam("xtitle=This is the x-axis")
	plotparam("ytitle=This is the y-axis")
	plotparam("xpos=bottom")
	plotparam("ypos=left")
	plotparam("xlabel=bottom")
	plotparam("ylabel=left")
	plotparam("ylog=no")
	plotparam("char=")
	plotxdata(xdata,0)
	for (i=1;i<=6;i=i+1) {
		switch (i) {
		case 1: {
			plotparam("title=          Line          ")
			plotparam("type=line")
			}
		case 2: {
			plotparam("title=         Scatter        ")
			plotparam("type=point")
			plotparam("char=+")
			}
		case 3: {
			plotparam("title=        Histogram       ")
			plotparam("type=hist")
			plotparam("char=")
			}
		case 4: {
			plotparam("title=   Histogram with end   ")
			plotparam("type=histend")
			}
		case 5: {
			plotparam("title=Histogram with divisions")
			plotparam("type=histdiv")
			}
		case 6: {
			plotparam("title=           Bar          ")
			plotparam("type=bar")
			}
		}
		plot(stdout,i,ydata,4+i)		
	}
}
