#include "..\xbase.h"
#include <stdlib.h>
#include "..\time.h"
#include "..\iostream.h"
#include <windows.h>


FILE* ce_fopen(const char* path,const char* mode){

	WCHAR wpath[_MAX_PATH],wmode[10];
	
	wsprintf(wpath,L"%S",path);
	wsprintf(wmode,L"%S",mode);

	return _wfopen(wpath,wmode);
}

int ce_fputc( int c, FILE *stream ){

	if ( fwrite((const void*)&c,1,1,stream) == 1 )
			return c;

	 return EOF;
}

int ce_fgetc( FILE *stream ){
	
	char c;
	if (  fread(&c,1,1,stream) == 1 )
			return c;

	return EOF;
}



ostream& ostream::operator<<(const char *_Val){

	WCHAR buff[1024];
	wsprintf(buff,L"%S",_Val);
	OutputDebugString(buff);
	return *this;
}

ostream& ostream::operator<<(char _Val){

	WCHAR buff[2];
	wsprintf(buff,L"%c",_Val);
	OutputDebugString(buff);
	return *this;
}

ostream& ostream::operator<<(int _Val){
	WCHAR buff[20];
	wsprintf(buff,L"%d",_Val);
	OutputDebugString(buff);
	return *this;
}

ostream& ostream::operator<<(unsigned long _Val){
	return (*this)<<(int)_Val;
}
 
ostream& ostream::operator<<(float _Val){
	WCHAR buff[20];
	wsprintf(buff,L"%f",_Val);
	OutputDebugString(buff);
	return *this;
}


XBDLLEXPORT ostream cout;

extern "C" {

XBDLLEXPORT int errno;

XBDLLEXPORT void rewind(  FILE *stream ){
  fseek( stream, 0L, SEEK_SET );
}

XBDLLEXPORT int remove(const char *path ){
	
	WCHAR wpath[_MAX_PATH];
	wsprintf(wpath,L"%S",path);
	
	if ( DeleteFile(wpath) )
		return 0;

	return 1;
}

XBDLLEXPORT int rename(const char *oldname, const char *newname ){
	WCHAR wold[_MAX_PATH];
	WCHAR wnew[_MAX_PATH];
	wsprintf(wold,L"%S",oldname);
	wsprintf(wnew,L"%S",newname);

	if ( MoveFile(wold,wnew) )
		return 0;

	return 1;
}

XBDLLEXPORT char *   strdup(const char *str){

	int len = strlen(str);

	char* ret = (char*)xheap_Alloc(len+1);

	if ( ret )
		memcpy(ret,str,len+1);

	return ret;
}

XBDLLEXPORT int isdigit( int c ){
	return c >='0' && c <= '9';
}
XBDLLEXPORT int isalpha( int c ){
	return (c>='a' && c <='z') ||
		   (c>='A' && c <='Z');
}
XBDLLEXPORT int islower( int c ){
	return (c>='a' && c <='z') ;
}
XBDLLEXPORT int isupper( int c ){
	return (c>='A' && c <='Z');
}
XBDLLEXPORT int isspace(int c){
	return c==' ';
}

XBDLLEXPORT char *   strrchr(const char *s, int c)
{
  register const char *found, *p;

  c = (unsigned char) c;

  // Since strchr is fast, we use it rather than the obvious loop.
  
  if (c == '\0')
    return strchr(s, '\0');

  found = NULL;
  while ((p = strchr(s, c)) != NULL)
    {
      found = p;
      s = p + 1;
    }

  return (char *) found;

}

inline char i_tolower(char c){
	if ( (c>='A' && c <='Z') ){
		return c | 0x20;
	}
	return c;
}

XBDLLEXPORT int stricmp(const char* s1, const char * s2){
	while( (*s1) && (*s2) ){
		
		if (  i_tolower(*s1++) !=i_tolower(*s2++) )
			return 1;
	}
	return 0;
}



static int maxExponent = 511;	/* Largest possible base 10 exponent.  Any
				 * exponent larger than this will already
				 * produce underflow or overflow, so there's
				 * no need to worry about additional digits.
				 */
static double powersOf10[] = {	/* Table giving binary powers of 10.  Entry */
    10.,			/* is 10^2^i.  Used to convert decimal */
    100.,			/* exponents into floating-point numbers. */
    1.0e4,
    1.0e8,
    1.0e16,
    1.0e32,
    1.0e64,
    1.0e128,
    1.0e256
};

/*
 *----------------------------------------------------------------------
 *
 * strtod --
 *
 *	This procedure converts a floating-point number from an ASCII
 *	decimal representation to internal double-precision format.
 *
 * Results:
 *	The return value is the double-precision floating-point
 *	representation of the characters in string.  If endPtr isn't
 *	NULL, then *endPtr is filled in with the address of the
 *	next character after the last one that was part of the
 *	floating-point number.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

double strtod(const char* string,char** endPtr)
{
    int sign, expSign = FALSE;
    double fraction, dblExp, *d;
    register CONST char *p;
    register int c;
    int exp = 0;		/* Exponent read from "EX" field. */
    int fracExp = 0;		/* Exponent that derives from the fractional
				 * part.  Under normal circumstatnces, it is
				 * the negative of the number of digits in F.
				 * However, if I is very long, the last digits
				 * of I get dropped (otherwise a long I with a
				 * large negative exponent could cause an
				 * unnecessary overflow on I alone).  In this
				 * case, fracExp is incremented one for each
				 * dropped digit. */
    int mantSize;		/* Number of digits in mantissa. */
    int decPt;			/* Number of mantissa digits BEFORE decimal
				 * point. */
    CONST char *pExp;		/* Temporarily holds location of exponent
				 * in string. */

    /*
     * Strip off leading blanks and check for a sign.
     */

    p = string;
    while (isspace(UCHAR(*p))) {
	p += 1;
    }
    if (*p == '-') {
	sign = TRUE;
	p += 1;
    } else {
	if (*p == '+') {
	    p += 1;
	}
	sign = FALSE;
    }

    /*
     * Count the number of digits in the mantissa (including the decimal
     * point), and also locate the decimal point.
     */

    decPt = -1;
    for (mantSize = 0; ; mantSize += 1)
    {
	c = *p;
	if (!isdigit(c)) {
	    if ((c != '.') || (decPt >= 0)) {
		break;
	    }
	    decPt = mantSize;
	}
	p += 1;
    }

    /*
     * Now suck up the digits in the mantissa.  Use two integers to
     * collect 9 digits each (this is faster than using floating-point).
     * If the mantissa has more than 18 digits, ignore the extras, since
     * they can't affect the value anyway.
     */
    
    pExp  = p;
    p -= mantSize;
    if (decPt < 0) {
	decPt = mantSize;
    } else {
	mantSize -= 1;			/* One of the digits was the point. */
    }
    if (mantSize > 18) {
	fracExp = decPt - 18;
	mantSize = 18;
    } else {
	fracExp = decPt - mantSize;
    }
    if (mantSize == 0) {
	fraction = 0.0;
	p = string;
	goto done;
    } else {
	int frac1, frac2;
	frac1 = 0;
	for ( ; mantSize > 9; mantSize -= 1)
	{
	    c = *p;
	    p += 1;
	    if (c == '.') {
		c = *p;
		p += 1;
	    }
	    frac1 = 10*frac1 + (c - '0');
	}
	frac2 = 0;
	for (; mantSize > 0; mantSize -= 1)
	{
	    c = *p;
	    p += 1;
	    if (c == '.') {
		c = *p;
		p += 1;
	    }
	    frac2 = 10*frac2 + (c - '0');
	}
	fraction = (1.0e9 * frac1) + frac2;
    }

    /*
     * Skim off the exponent.
     */

    p = pExp;
    if ((*p == 'E') || (*p == 'e')) {
	p += 1;
	if (*p == '-') {
	    expSign = TRUE;
	    p += 1;
	} else {
	    if (*p == '+') {
		p += 1;
	    }
	    expSign = FALSE;
	}
	if (!isdigit(UCHAR(*p))) {
	    p = pExp;
	    goto done;
	}
	while (isdigit(UCHAR(*p))) {
	    exp = exp * 10 + (*p - '0');
	    p += 1;
	}
    }
    if (expSign) {
	exp = fracExp - exp;
    } else {
	exp = fracExp + exp;
    }

    /*
     * Generate a floating-point number that represents the exponent.
     * Do this by processing the exponent one bit at a time to combine
     * many powers of 2 of 10. Then combine the exponent with the
     * fraction.
     */
    
    if (exp < 0) {
	expSign = TRUE;
	exp = -exp;
    } else {
	expSign = FALSE;
    }
    if (exp > maxExponent) {
	exp = maxExponent;
//	errno = ERANGE;
    }
    dblExp = 1.0;
    for (d = powersOf10; exp != 0; exp >>= 1, d += 1) {
	if (exp & 01) {
	    dblExp *= *d;
	}
    }
    if (expSign) {
	fraction /= dblExp;
    } else {
	fraction *= dblExp;
    }

done:
    if (endPtr != NULL) {
	*endPtr = (char *) p;
    }

    if (sign) {
	return -fraction;
    }
    return fraction;
}


XBDLLEXPORT int  unlink(const char* path){
	return 0;
}



DIR *opendir(const char *name)
{
 DIR *dir = 0;

 if(name && name[0])
 {
     size_t base_length = strlen(name);
     const char *all = /* the root directory is a special case... */
         strchr("/\\", name[base_length - 1]) ? "*" : "/*";

     if((dir = (DIR *) xheap_Alloc(sizeof *dir)) != 0 &&
        (dir->name = (char *) xheap_Alloc(base_length + strlen(all) + 1)) != 0)
     {
         strcat(strcpy(dir->name, name), all);
		 
		 WCHAR path[_MAX_PATH+1];
		 wsprintf(path,L"%S",dir->name);
		 dir->handle = FindFirstFile(path,&dir->fd);
		 dir->first = true;

         if(dir->handle != INVALID_HANDLE_VALUE  )
         {
             dir->result.d_name = 0;
         }
         else /* rollback */
         {
             xheap_Free(dir);
             dir = 0;
         }
     }
     else /* rollback */
     {
         xheap_Free(dir);
         dir   = 0;
         errno = ENOMEM;
     }
 }
 else
 {
     errno = EINVAL;
 }

 return dir;
}

int closedir(DIR *dir)
{
 int result = -1;

 if(dir)
 {
     if(dir->handle != INVALID_HANDLE_VALUE )
     {
          FindClose(dir->handle);
     }

     xheap_Free(dir);
 }

 if(result == -1) /* map all errors to EBADF */
 {
     errno = EBADF;
 }

 return result;
}

struct dirent *readdir(DIR *dir)
{
 struct dirent *result = 0;

 if(dir && dir->handle != INVALID_HANDLE_VALUE)
 {
     if ( ! dir->first )
		 FindNextFile(dir->handle,&dir->fd);

	 dir->first = false;
	 
     result   =  &dir->result;


 }
 else
 {
     errno = EBADF;
 }

 return result;
}
/*
void rewinddir(DIR *dir)
{
 if(dir && dir->handle != -1)
 {
     _findclose(dir->handle);
     dir->handle = _findfirst(dir->name, &dir->info);
     dir->result.d_name = 0;
 }
 else
 {
     errno = EBADF;
 }
}
*/


XBDLLEXPORT int  access(const char* path,int access){
	WCHAR wpath[_MAX_PATH+1];

	wsprintf(wpath,L"%S",wpath);

	DWORD attr = GetFileAttributes(wpath);

	if ( attr == 0xffffffff )
		return -1;

	return 0;
}

XBDLLEXPORT const char* strerror(int){
	return "Unsupported";
}

/*
 * The table below is used to convert from ASCII digits to a
 * numerical equivalent.  It maps from '0' through 'z' to integers
 * (100 for non-digit characters).
 */

static char cvtIn[] = {
    0, 1, 2, 3, 4, 5, 6, 7, 8, 9,		/* '0' - '9' */
    100, 100, 100, 100, 100, 100, 100,		/* punctuation */
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,	/* 'A' - 'Z' */
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35,
    100, 100, 100, 100, 100, 100,		/* punctuation */
    10, 11, 12, 13, 14, 15, 16, 17, 18, 19,	/* 'a' - 'z' */
    20, 21, 22, 23, 24, 25, 26, 27, 28, 29,
    30, 31, 32, 33, 34, 35};

/*
 *----------------------------------------------------------------------
 *
 * strtoul --
 *
 *	Convert an ASCII string into an integer.
 *
 * Results:
 *	The return value is the integer equivalent of string.  If endPtr
 *	is non-NULL, then *endPtr is filled in with the character
 *	after the last one that was part of the integer.  If string
 *	doesn't contain a valid integer value, then zero is returned
 *	and *endPtr is set to string.
 *
 * Side effects:
 *	None.
 *
 *----------------------------------------------------------------------
 */

unsigned long int
strtoul(const char* string,char** endPtr,int base)
    /*CONST char *string;		 String of ASCII digits, possibly
				 * preceded by white space.  For bases
				 * greater than 10, either lower- or
				 * upper-case digits may be used.
				 */
    /* char **endPtr;		Where to store address of terminating
				 * character, or NULL. */
    /*int base;			 Base for conversion.  Must be less
				 * than 37.  If 0, then the base is chosen
				 * from the leading characters of string:
				 * "0x" means hex, "0" means octal, anything
				 * else means decimal.
				 */
{
    register CONST char *p;
    register unsigned long int result = 0;
    register unsigned digit;
    int anyDigits = 0;
    int negative=0;
    int overflow=0;

    /*
     * Skip any leading blanks.
     */

    p = string;
    while (isspace(UCHAR(*p))) {
	p += 1;
    }
    if (*p == '-') {
        negative = 1;
        p += 1;
    } else {
        if (*p == '+') {
            p += 1;
        }
    }

    /*
     * If no base was provided, pick one from the leading characters
     * of the string.
     */
    
    if (base == 0)
    {
	if (*p == '0') {
	    p += 1;
	    if ((*p == 'x') || (*p == 'X')) {
		p += 1;
		base = 16;
	    } else {

		/*
		 * Must set anyDigits here, otherwise "0" produces a
		 * "no digits" error.
		 */

		anyDigits = 1;
		base = 8;
	    }
	}
	else base = 10;
    } else if (base == 16) {

	/*
	 * Skip a leading "0x" from hex numbers.
	 */

	if ((p[0] == '0') && ((p[1] == 'x') || (p[1] == 'X'))) {
	    p += 2;
	}
    }

    /*
     * Sorry this code is so messy, but speed seems important.  Do
     * different things for base 8, 10, 16, and other.
     */

    if (base == 8) {
	unsigned long maxres = ULONG_MAX >> 3;
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > 7) {
		break;
	    }
	    if (result > maxres) { overflow = 1; }
	    result = (result << 3);
	    if (digit > (ULONG_MAX - result)) { overflow = 1; }
	    result += digit;
	    anyDigits = 1;
	}
    } else if (base == 10) {
	unsigned long maxres = ULONG_MAX / 10;
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > 9) {
		break;
	    }
	    if (result > maxres) { overflow = 1; }
	    result *= 10;
	    if (digit > (ULONG_MAX - result)) { overflow = 1; }
	    result += digit;
	    anyDigits = 1;
	}
    } else if (base == 16) {
	unsigned long maxres = ULONG_MAX >> 4;
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > ('z' - '0')) {
		break;
	    }
	    digit = cvtIn[digit];
	    if (digit > 15) {
		break;
	    }
	    if (result > maxres) { overflow = 1; }
	    result = (result << 4);
	    if (digit > (ULONG_MAX - result)) { overflow = 1; }
	    result += digit;
	    anyDigits = 1;
	}
    } else if ( base >= 2 && base <= 36 ) {
	unsigned long maxres = ULONG_MAX / base;
	for ( ; ; p += 1) {
	    digit = *p - '0';
	    if (digit > ('z' - '0')) {
		break;
	    }
	    digit = cvtIn[digit];
	    if (digit >= ( (unsigned) base )) {
		break;
	    }
	    if (result > maxres) { overflow = 1; }
	    result *= base;
	    if (digit > (ULONG_MAX - result)) { overflow = 1; }
	    result += digit;
	    anyDigits = 1;
	}
    }

    /*
     * See if there were any digits at all.
     */

    if (!anyDigits) {
	p = string;
    }

    if (endPtr != 0) {
	/* unsafe, but required by the strtoul prototype */
	*endPtr = (char *) p;
    }

    if (overflow) {
	errno = ERANGE;
	return ULONG_MAX;
    } 
    if (negative) {
	return -result;
    }
    return result;
}


XBDLLEXPORT long int strtol(const char* string,char ** endPtr,int base)
    	/* String of ASCII digits, possibly
				 * preceded by white space.  For bases
				 * greater than 10, either lower- or
				 * upper-case digits may be used.
				 */
    		/* Where to store address of terminating
				 * character, or NULL. */
    			/* Base for conversion.  Must be less
				 * than 37.  If 0, then the base is chosen
				 * from the leading characters of string:
				 * "0x" means hex, "0" means octal, anything
				 * else means decimal.
				 */
{
    register CONST char *p;
    long result;

    /*
     * Skip any leading blanks.
     */

    p = string;
    while (isspace(UCHAR(*p))) {
	p += 1;
    }

    /*
     * Check for a sign.
     */

    if (*p == '-') {
	p += 1;
	result = -(strtoul(p, endPtr, base));
    } else {
	if (*p == '+') {
	    p += 1;
	}
	result = strtoul(p, endPtr, base);
    }
    if ((result == 0) && (endPtr != 0) && (*endPtr == p)) {
	*endPtr = (char *) string;
    }
    return result;
}


}

