/*  Filename: filebuf.cpp

    Supplimentary file for providing buffered file access for the Xbase 
	project that was written by StarTech, Gary A. Kunkel.
  
    This header file provides definitions for providing buffered file access.

    Copyright (C) 2003 Pulse Data International (NZ) Ltd.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact:

		Pulse Data International (NZ) Ltd.,
		P O Box 3044,
		Christchurch,
		New Zealand.

    Email:

		enquiries@pulsedata.com

    See our website at:

        http://www.pulsedata.com/


	KeySoft 5.1 Alpha 1, 15 Aug 2003	- Windows CE Compliancy
	KeySoft 5.1 Alpha 1, 30 Jan 2004	- RAM buffering for speed
	KeySoft 5.1 Alpha 1, 13 Feb 2004	- Fixing memory leaks

*/

#ifndef FILEBUF_H
#define FILEBUF_H

enum fileBuf_OpenMode
{
   ReadOnly,
   ReadWriteNew,
   ReadWrite,
   ReadWriteBinary
};

class XBDLLEXPORT fileBuf_class
{
public:
   fileBuf_class ();

   BOOL     Open (const char* filename, const char* mode);
   size_t   Read (void* buffer, size_t size, size_t count);
   size_t   Write (const void* buffer, size_t size, size_t count);
   int      Close ();
   int      Seek (long offset, int origin);
   int      Rewind () {return Seek (0, SEEK_SET);}
   long     GetPos ();
   int      Putc (int c);
   int      Getc ();
   int      Flush ();
   void*    FileNo ();

   BOOL     IsOpen ();

   void     operator= (fileBuf_class& rhs);

private:
   FILE*    _File;
   int      _Pos;
   HANDLE   _Heap;
   BYTE*    _Buffer;
   int      _BufferCount;
   int      _BufferStart;
   BOOL     _HasChanged;

   BOOL     _LoadFileToMem ();
};

#endif