#pragma once
#include "windows.h"
#include "stdlib.h"
#include "windef.h"

class XBDLLEXPORT ostream{

public:

	ostream& operator<<(const char *_Val);
	ostream& operator<<(float _Val);
	ostream& operator<<(int _Val);
	ostream& operator<<(char _Val);
	ostream& operator<<(unsigned long _Val);
};

extern XBDLLEXPORT ostream cout;
#define endl "\r\n"

extern "C"{

XBDLLEXPORT void rewind(  FILE *stream );
XBDLLEXPORT int remove(const char *path );
XBDLLEXPORT int rename(
   const char *oldname,
   const char *newname 
);

XBDLLEXPORT char *  strdup(const char *);

#if _WIN32_WCE < 400
XBDLLEXPORT int isdigit( int c );
XBDLLEXPORT int isalpha( int c );
XBDLLEXPORT int islower( int c );
XBDLLEXPORT int isupper( int c );
XBDLLEXPORT int isspace( int c );
XBDLLEXPORT char *strrchr( const char *string, int c );
XBDLLEXPORT double strtod(
   const char *nptr,
   char **endptr 
);
#endif

XBDLLEXPORT int stricmp(const char*, const char * );
XBDLLEXPORT long _filelength( int handle );
XBDLLEXPORT int  unlink(const char* path);

#define  R_OK   4 
#define  W_OK   2 
#define  X_OK   1 
#define  F_OK   0 

XBDLLEXPORT int  access(const char* path,int access);

#define EPERM		1	/* Operation not permitted */
#define	ENOFILE		2	/* No such file or directory */
#define	ENOENT		2
#define	ESRCH		3	/* No such process */
#define	EINTR		4	/* Interrupted function call */
#define	EIO			5	/* Input/output error */
#define	ENXIO		6	/* No such device or address */
#define	E2BIG		7	/* Arg list too long */
#define	ENOEXEC		8	/* Exec format error */
#define	EBADF		9	/* Bad file descriptor */
#define	ECHILD		10	/* No child processes */
#define	EAGAIN		11	/* Resource temporarily unavailable */
#define	ENOMEM		12	/* Not enough space */
#define	EACCES		13	/* Permission denied */
#define	EFAULT		14	/* Bad address */
/* 15 - Unknown Error */
#define	EBUSY		16	/* strerror reports "Resource device" */
#define	EEXIST		17	/* File exists */
#define	EXDEV		18	/* Improper link (cross-device link?) */
#define	ENODEV		19	/* No such device */
#define	ENOTDIR		20	/* Not a directory */
#define	EISDIR		21	/* Is a directory */
#define	EINVAL		22	/* Invalid argument */
#define	ENFILE		23	/* Too many open files in system */
#define	EMFILE		24	/* Too many open files */
#define	ENOTTY		25	/* Inappropriate I/O control operation */
/* 26 - Unknown Error */
#define	EFBIG		27	/* File too large */
#define	ENOSPC		28	/* No space left on device */
#define	ESPIPE		29	/* Invalid seek (seek on a pipe?) */
#define	EROFS		30	/* Read-only file system */
#define	EMLINK		31	/* Too many links */
#define	EPIPE		32	/* Broken pipe */
#define	EDOM		33	/* Domain error (math functions) */
#define	ERANGE		34	/* Result too large (possibly too small) */
/* 35 - Unknown Error */
#define	EDEADLOCK	36	/* Resource deadlock avoided (non-Cyg) */
#define	EDEADLK		36
/* 37 - Unknown Error */
#undef ENAMETOOLONG
#define	ENAMETOOLONG	38	/* Filename too long (91 in Cyg?) */
#define	ENOLCK		39	/* No locks available (46 in Cyg?) */
#define	ENOSYS		40	/* Function not implemented (88 in Cyg?) */
#undef ENOTEMPTY
#define	ENOTEMPTY	41	/* Directory not empty (90 in Cyg?) */
#define	EILSEQ		42	/* Illegal byte */

extern XBDLLEXPORT int errno;
XBDLLEXPORT const char* strerror(int);
#if _WIN32_WCE < 400
XBDLLEXPORT long strtol( const char *nptr, char **endptr, int base );
#endif

#ifndef _MAX_PATH
#define _MAX_PATH 260
#endif


struct dirent{
	const char* d_name;
	char  ascii_buff[_MAX_PATH+1];

};

struct DIR
{
 HANDLE              handle; /* -1 for failed rewind */
 WIN32_FIND_DATA	 fd;
 bool				 first;
 struct dirent       result; /* d_name null iff first time */
 char                *name;  /* NTBS */
};


//XBDLLEXPORT void rewinddir(DIR *dir);
XBDLLEXPORT struct dirent *readdir(DIR *dir);
XBDLLEXPORT int closedir(DIR *dir);
XBDLLEXPORT DIR *opendir(const char *name);


#define fopen ce_fopen
#define fputc ce_fputc 
#define fgetc ce_fgetc 
FILE* ce_fopen(const char* path,const char* mode);
int   ce_fputc( int c, FILE *stream );
int		ce_fgetc( FILE *stream );


}

