/*  Filename: xheap.h

    Supplimentary file for providing buffered file access for the Xbase 
	project that was written by StarTech, Gary A. Kunkel.
  
    This file provides a class for providing a secondary heap.

    Copyright (C) 2003 Pulse Data International (NZ) Ltd.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact:

		Pulse Data International (NZ) Ltd.,
		P O Box 3044,
		Christchurch,
		New Zealand.

    Email:

		enquiries@pulsedata.com

    See our website at:

        http://www.pulsedata.com/


	KeySoft 5.1 Alpha 1, 15 Aug 2003	- Windows CE Compliancy
	KeySoft 5.1 Alpha 1, 30 Jan 2004	- RAM buffering for speed
	KeySoft 5.1 Alpha 1, 13 Feb 2004	- Fixing memory leaks

*/

#include <windows.h>

#include "xbase.h"

class xheap_class
{
public:
   xheap_class ();
  ~xheap_class ();
  
   void* Alloc (int size, DWORD flags = 0);
   void* ReAlloc (void* ptr, int size);
   void  Free (void* ptr);
   void  CleanUp ();

private:
   HANDLE _Heap;
};

static xheap_class* xheap = NULL;

class xheap_globals
{
public:
   ~xheap_globals ();
};

xheap_globals xheapGlobals;

xheap_globals::~xheap_globals ()
{
   if (xheap) delete xheap;
}

void* xheap_Alloc (int size)
{
   if (!xheap) xheap = new xheap_class;
   return xheap->Alloc (size);
}

void* xheap_CAlloc (int size)
{
   if (!xheap) xheap = new xheap_class;
   return xheap->Alloc (size, HEAP_ZERO_MEMORY);
}

void* xheap_ReAlloc (void* ptr, int size)
{
   if (!xheap) xheap = new xheap_class;
   return xheap->ReAlloc (ptr, size);
}

void xheap_Free (void* ptr)
{
   if (!xheap) xheap = new xheap_class;
   xheap->Free (ptr);
}

void xheap_CleanUp ()
{
   if (!xheap) xheap = new xheap_class;
   xheap->CleanUp ();
}

xheap_class::xheap_class ()
{
   _Heap = HeapCreate (0, 0, 0);
}

xheap_class::~xheap_class ()
{
   HeapDestroy (_Heap);
}

void* xheap_class::Alloc (int size, DWORD flags)
{
   return HeapAlloc (_Heap, flags, size);
}

void* xheap_class::ReAlloc (void* ptr, int size)
{
   return HeapReAlloc (_Heap, 0, ptr, size);
}

void xheap_class::Free (void* ptr)
{
   HeapFree (_Heap, 0, ptr);
}

void xheap_class::CleanUp ()
{
   HeapDestroy (_Heap);
   _Heap = HeapCreate (0, 0, 0);
}