/*  Filename: xheap.h

    Supplimentary file for providing buffered file access for the Xbase 
	project that was written by StarTech, Gary A. Kunkel.
  
    This file provides definitions for providing a secondary heap.

    Copyright (C) 2003 Pulse Data International (NZ) Ltd.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Contact:

		Pulse Data International (NZ) Ltd.,
		P O Box 3044,
		Christchurch,
		New Zealand.

    Email:

		enquiries@pulsedata.com

    See our website at:

        http://www.pulsedata.com/


	KeySoft 5.1 Alpha 1, 15 Aug 2003	- Windows CE Compliancy
	KeySoft 5.1 Alpha 1, 30 Jan 2004	- RAM buffering for speed
	KeySoft 5.1 Alpha 1, 13 Feb 2004	- Fixing memory leaks

*/

#ifndef XHEAP_H
#define XHEAP_H

XBDLLEXPORT void* xheap_Alloc (int size);
XBDLLEXPORT void* xheap_CAlloc (int size);
XBDLLEXPORT void* xheap_ReAlloc (void* ptr, int size);
XBDLLEXPORT void  xheap_Free (void* ptr);
XBDLLEXPORT void  xheap_CleanUp ();

#endif