/*nfbtrans.c converted from Pascal to C by Randy formenti N8KL*/
/*internet rcf@genrad.com */
/*November 28, 1992*/
#if defined(__TINY__) || defined(__SMALL__) || defined(__MEDIUM__) || defined(__COMPACT__) || defined(__LARGE__)
#define TURBOC     /* turbo C++ 3.0 or later */
#endif
#define LINT_ARGS
#include        <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <conio.h>
#include <sys\types.h>
#include <sys\stat.h>
#include <malloc.h>
#include <memory.h>
#include <process.h>
#include <time.h>

/*global variables*/
char temp[160], *out = temp + 2;
int paramcount;
char **paramstr;
char *options[28] =/* all allowed options */
{"CF", "CO", "DB", "DE", "DS", "FI", "FO", "FS", "FX", "HK", "LM", "LS", "NC", "OW",
  "PA", "PE", "PL", "PO", "PS", "PW", "SO", "ST", "TF", "TM", "TP", "TV", "~~",
NULL};
char *call_prefix[12] =
{"KA", "KB", "KC", "KD", "K", "N", "WA", "WB", "WD", "W", "VE", NULL};
char *token_names[14] = /* used in external format language */
{"D", "T", "L", "SK", "C", "IND", "PAG", "FIE", "O", "ST", "A", "MAT", NULL};
int token_vals[14] =    /* values for tokens above */
{1, 2, 3, 4, 5, 6, 80, 100, 101, 102, 199, 202, 999};



#define 	OWNER		"Randy Formenti"

#define 	VERSION 	"Version November, 1992"

#define 	RELEASE 	"7.11"

#define COPYRIGHT "Copyrighted by The National Federation of the Blind, 1983...93"

#define MAXTAB		1000    /* number of entries in binary table of
                                 * braille rules */

typedef int BOOL;
#define TRUE 1
#define FALSE 0

/*globals for buffered read*/
#define BUFSIZE 2048
char iobuf[BUFSIZE + 1];
int bytes_in_buf;
char *ioptr;
int timer = 0xe00; /* default delay timing value only if linked with
                    * nfbasm.asm */
int emboss_delay = 0;
int hot_key = 0;   /* no hot keys by default */
int ab_flag = 0;   /* abort */
char *stateid[60] =
{"AK\000Alaska", "AL\000Alabama", "AR\000Arkansas",
  "AZ\000Arizona", "AS\000American Samoa", "CA\000California",
  "CO\000Colorado", "CT\000Connecticut", "CZ\000Canal Zone",
  "DC\000District of Columbia", "DE\000Delaware", "FL\000Florida",
  "GA\000Georgia", "GU\000Guam", "HI\000Hawaii",
  "ID\000Idaho", "IL\000Ilinois", "IN\000Indiana",
  "IA\000Iowa",
  "KS\000Kansas", "KY\000Kentucky", "LA\000Lousiana", "ME\000Maine",
  "MD\000Maryland", "MA\000Massachusetts", "MI\000Michigan",
  "MN\000Minnesota", "MS\000Mississippi", "MO\000Missouri",
  "MT\000Montana", "NE\000Nebraska", "NV\000Nevada",
  "NH\000New Hampshire", "NJ\000New Jersey", "NM\000New Mexico",
  "NY\000New York", "NC\000North Carolina", "ND\000North Dakota",
  "CN\000Northern Mariana Is", "OH\000Ohio", "OK\000Oklahoma",
  "OR\000Oregon", "PA\000Pennsylvania", "PR\000Puerto Rico",
  "RI\000Rhode Island", "SC\000South Carolina", "SD\000South Dakota",
  "TN\000Tennessee", "TT\000Trust Territories", "TX\000Texas",
  "UT\000Utah", ",VT\000Vermont", "VA\000Virginia",
  "VI\000Virgin Islands", "WA\000Washington", "WV\000West Virginia",
"Wi\000Wisconsin", "WY\000Wyoming"};

typedef struct
{
  unsigned int lstart;
  unsigned int lend;
  BOOL lflag;
  int fopstart;
  int fopcount, lopcount;
}   loptype;

typedef struct
{
  unsigned char fop;    /* operation */
  int fstart;      /* field start */
  int flen;        /* field length */
  int fappo;       /* pointer to data */
}   foptype;


typedef struct
{                  /* holds binary form of braille rules */
  int start1[256];
  int start2[27][27];
  int typex[MAXTAB + 1];
  char match[MAXTAB + 1][11];
  char replace[MAXTAB + 1][11];
}   t;

int statecount = 58;
BOOL usr_default = FALSE;
int dcopies = 0, pagestart = 0, pageend = -1;
char fiel[256];
char *field = fiel;
int count, copies, lastcopy = 0;
int bpagec;
char token[100][40];
int tcount;
int tcur;
int fopcount, lopcount;
int lineskips = 99, linesperpage = 25;
int maxline = 0, make_sound = 1;
int display_braille = -1;
int display_source = -1;
BOOL printit = TRUE;
int skip_output = 0, over_write = 0;
BOOL no_copyright = FALSE;      /* display copyright by default */
int leftmargin = -1;
int capvec[255], subvec[255];
int trans_mode = -1;
int pause_time = 0;
long total_words, total_dots, total_cells;
BOOL fromfile;
BOOL usetemplate = FALSE;
char filein[49] = {0};
int outext;
FILE *intext = NULL, *lfile;
int infile;
char fileout[49] = {0};
char filetemp[49];
typedef foptype INTER_ARR8[40];
INTER_ARR8 f;
char appdat[40][41];
int appcount, lcount, temperror;
BOOL lopactive = FALSE;
int inpglen = 66;  /* input page length */
char transpath[81] = {0};
char table_file[20] = {"braille.TAB"};
char stat_file[20] = {0};
char config_file[20] = {"NFBTRANS.CNF"};
char format_string[4] = {"^~"};
typedef loptype INTER_ARR10[40];
static INTER_ARR10 l;
typedef unsigned char INTER_ARR11[256];
INTER_ARR11 dottab = {  /* braille dot equivilent for each ascii char, not
                         * currently used */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 15 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 31 */
  0, 46, 16, 60, 43, 41, 47, 4, 55, 62, 33, 44, 32, 36, 40, 12, /* / ascii 47 */
  52, 2, 6, 18, 50, 34, 22, 54, 38, 20, 49, 48, 35, 63, 28, 57, /* ? ascii 63 */
  8, 1, 3, 9, 25, 17, 11, 27, 19, 10, 26, 5, 7, 13, 29, 21,     /* O */
  15, 31, 23, 14, 30, 37, 39, 58, 45, 61, 53, 42, 51, 59, 24, 56,       /* _ */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 111 lowercase
                                                         * not coded */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 127 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 143 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 159 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 175 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 191 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 207 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 223 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,       /* ascii 239 */
0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};        /* ascii 255 */

typedef char INTER_ARR12[10];
INTER_ARR12 bnumber = {"JABCDEFGHI"};
t  *b = NULL;
/*variables for dotranslate*/
BOOL done;
BOOL endfile;
char oldword[256];
char oldline[256];
char oldline6[255];
char tline[256];
char fline[256];
char hline[256];
char bline[256];
char bline6[256];
char lline[256];
char wline[256];
int blinec;
int bpageb;
int bpageh;
int linelength;
int curmax;

char c;
char words[81];
char bword[81];
char bword6[81];
char tabvec[256];

BOOL join;
BOOL group;
BOOL pjoin;
BOOL pgroup;
BOOL hyphen;
BOOL phyphen;
BOOL xjoin;
BOOL xgroup;
BOOL xpjoin;
BOOL xpgroup;
BOOL xhyphen;
BOOL xphyphen;

int xgrade = -1;
#define GRADE0 0
#define GRADE1 1
#define GRADE2 2
#define GRADE3 3
BOOL xcenter;
int xformat;
#define POETRY 1
# define TEXT 2
#define BLOCK 3
#define LISTS 4
BOOL xdouble;
BOOL xtab;
BOOL xacronym;
BOOL xheading;
BOOL xfooting;
BOOL makefoot;
BOOL makehead;
BOOL fillit;

BOOL quoteopen, quoteclose;

int margin, point, firstletter, chardec, lastmatch;
char linein[256];
unsigned int lineinct;
BOOL newline;
int quotecount;
int dopagenum = -1;
BOOL doroman;
BOOL dobook;
unsigned char tabtable[255];
BOOL disablecol;
int setmargin, oldmargin;
BOOL tabmargin;
BOOL pageset;
int woffset;
char addchar[11];
int actualpage;
char *roman[10] =
{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
char *roman10[10] = {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};

/*forward declarations*/
void top_of_form(void);
void backspace_int(int);
void dofillit(void);
void make_roman(void);
void make_arabic(int *);
void make_book(void);
void bpurge(void);
void build_line(void);
void test_purge(void);
void add_dots(char *);
int get_integer(char *);
void get_digit(void);
void do_commands(void);
void do_lop_op(int, int, int, int);
void do_lop(void);
void getline(void);
void check_purge(void);
void get_word(void);
void set_vect(void);
void do_letter(void);
void do_number(void);
void do_punct(void);
void build_word(void);
void check_ham_call(void);
void trans_word(void);
BOOL get_token(void);
void pop_tok(char *);
int check_token(char *);
void do_ops(void);
void do_template(void);
void do_translate(void);
void advance_page(void);
void load_tables(void);
void translate_file(void);
void sound(int);
void nosound(void);
void emboss_file(void);
void get_page_range(void);
void delay(int);
void get_config(void);
void process_options(char *);
void trim(char *);
int strpos(char *, char *);
void insert(char *, char *, int);
void move(char *, char *, int);
void do_pause(void);
void write_string(char *);
void write_char(char);
void no_space(void);
void main(int, char **);

void top_of_form()
{
  int i;
  actualpage++;
  bpagec++;
  if (bpagec > pageend)
  {
    done = TRUE;
    bline[0] = 0;
    bline6[0] = 0;
    bword[0] = 0;
    return;
  }
  if (bpagec > pagestart)
  {                /* page in range */
    if (lineskips < 99)
      for (i = 0; i < lineskips + linesperpage - blinec; i++)
      {            /* i */
        write_string(" ");
        if (display_braille)
          printf("\n");
      }            /* i */
    if (lineskips == 99)
      write_char(12);   /* formfeed */
    if (lineskips == 999)
      write_string("\13");
    if (lineskips == 9999)
    {              /* 9999 */
      write_string("\14");
      printf("\nTo Continue, Press Return\7");
      getch();
    }              /* 9999 */
  }                /* page in range */
  if (dopagenum && ((bpagec > 1) || pageset) && !xheading)
    linelength = curmax - 6 - margin - strlen(addchar);
  else
    linelength = curmax + 1 - margin;

  blinec = 0;
  if (make_sound)
  {
    sound(2000);
    delay(30);
    nosound();
  }
  if (display_braille)
  {                /* display_braille */
    sprintf(wline, "Copy %d of %d   page %d", copies, lastcopy, bpagec);
    while (strlen(wline) < 40)
    {
      if (strlen(wline) & 1)
        strcat(wline, "*");
      else
      {            /* even put * in beginning */
        strcpy(field + 1, wline);
        field[0] = '*';
        strcpy(wline, field);
      }            /* even prefix with * */
    }              /* while */
    printf("%s\n", wline);
  }                /* display_braille */
  else
  if (!skip_output)
    printf("On page %d  Copy %d of %d\n", bpagec, copies, lastcopy);

  if (printit)
    delay(emboss_delay);
}                  /* top_of_form */

void backspace_int(int j)
{                  /* output a packspace so cursor is at first number of
                    * integer */
  do
  {
    j /= 10;
    printf("%c", 8);
  }
  while (j > 0);
}                  /* backspace_int */

void dofillit()
{
  int j;
  fillit = FALSE;
  j = strlen(bline) - 1;
  if (j <= 0)
    return;
  /* find out where last word on bline begins */
  while (bline[j] != ' ' && j > 1)
    j--;
  strcpy(field, bline + j + 1); /* store the last word of bline */
  memset(bline + j, '\42', curmax - j); /* fill with quotes dot 5 */
  bline[j] = ' ';
  j = maxline - margin - strlen(field);
  strcpy(bline + j, field);
  bline[j - 1] = ' ';
}                  /* dofillit */

void make_roman()
{
  if (bpagec >= 100)
    make_arabic(&bpagec);
  else
    sprintf(field, "%s%s", roman10[bpagec / 10], roman[bpagec % 10]);
}                  /* make_roman */

void make_arabic(int *page)
{
  int i;
  sprintf(field, "#%d", *page);
  i = 1;
  while (field[i])
  {
    field[i] = bnumber[(int) (field[i] - (char) 48)];
    i++;
  }                /* while */
  if (page == &bpagec)
    strcat(field, addchar);
}                  /* make_arabec */

void make_book()
{
  field++;         /* make room for possible character at beginning */
  make_arabic(&bpageb);
  field--;         /* put pointer back where it was */
  if (bpagec - bpageh > 1)
    field[0] = (char) ((int) ('A') + bpagec - 2 - bpageh);
  else
    strcpy(field, field + 1);   /* remove first char of field */
}                  /* make_book */

void bpurge()
{
  int i, j;
  blinec++;        /* increment current braille line */

  if (bline[0])
  {                /* bline not empty */
    if (strlen(bline6) > strlen(bline))
      strcpy(bline, bline6);
    bline[curmax] = 0;  /* set bline to <curmax chars long */

    if (margin > 1)
    {              /* insert space before left margin */
      move(bline, bline + margin - 1, curmax + 1 - margin);     /* insert space in front
                                                                 * of lien is necessary */
      memset(bline, 32, margin - 1);    /* fill in left margin with spaces */
    }              /* insert space before left margin */
  }                /* bline not empty */

  if (xcenter)
  {                /* center */
    trim(bline);
    j = (curmax - strlen(bline)) / 2;
    if (j > 0)
    {
      move(bline, bline + j, strlen(bline));
      memset(bline, 32, j);
    }
    if (newline)
      xcenter = FALSE;
  }                /* center */

  if (fillit && newline)
    dofillit();

  if (blinec == 1)
  {                /* first line on this page */
    field[0] = 0;
    if (((bpagec > 1) || pageset || dobook) && dopagenum)
    {              /* store braille page number in field */
      if (doroman)
        make_roman();
      else
      if (dobook)
        make_book();
      else
        make_arabic(&bpagec);
    }              /* store braille page number in field */
    if (xheading)
    {              /* xheading */
      strcpy(hline + strlen(hline) - strlen(field), field);
      if (bpagec >= pagestart)
      {            /* output */
        if (display_braille)
          printf("%s\n", hline);
        write_string(hline);
      }            /* output */
      blinec++;
    }              /* xheading */
    else
    {              /* not xheading */
      j = strlen(bline);
      memset(bline + j, 32, maxline - j);
      strcpy(bline + maxline - strlen(field), field);
    }              /* not xheading */
  }                /* first line on page */

  if (dobook && blinec >= linesperpage)
  {                /* put braille page in lower right corner */
    make_arabic(&bpagec);
    j = strlen(bline);
    memset(bline + j, 32, maxline - j);
    strcpy(bline + maxline - strlen(field), field);
  }                /* put braille page number in lower right corner. */

  if (bpagec >= pagestart)
  {                /* output */
    if (display_braille)
      printf("%s\n", bline);
    if (!bline[0])
      strcpy(bline, " ");
    write_string(bline);
  }                /* output */
  if (xdouble && (bpagec >= pagestart))
  {
    write_string(" ");
    blinec++;
  }

  bline[0] = bline6[0] = 0;
  if (!(xformat == TEXT) || fillit)
    for (i = 0; i < woffset; i++)
      strcat(bline, " ");
  pjoin = FALSE;
  pgroup = FALSE;
  if (xfooting && (blinec >= linesperpage - 1))
  {                /* put footing on bottom of current page */
    if (dobook)
    {              /* adjust footing for braille page in lower right corner */
      make_arabic(&bpagec);
      strcpy(oldline, fline);   /* save fline */
      strcpy(fline, fline + strlen(field) + 1);
      sprintf(fline + strlen(fline), " %s", field);
    }              /* adjust footing for braille page in lower right corner */
    if (bpagec >= pagestart)
    {              /* output */
      write_string(fline);
      if (display_braille)
        printf("%s\n", fline);
    }              /* output */
    if (dobook)
      strcpy(fline, oldline);
    blinec++;
  }                /* put footing on bottom of current page */
  if (blinec >= linesperpage)
    top_of_form();
  else
  if (dobook && (blinec >= linesperpage - 1) && !xfooting)
    linelength = curmax - 6 - margin;
  else
    linelength = curmax + 1 - margin;
  newline = FALSE;
}                  /* bpurge */

void build_line()
{
  int i, j, m, n;
  i = strlen(bline);
  if (xtab)
  {                /* xtab */
    m = n = 0;
    do
    {
      n++;
      if (tabtable[i + n] != 0)
        m = n;
    }
    while (!((m != 0) || (i + n >= linelength)));
    if (!m)
      m = 1;
    for (n = 0; n < m; n++)
    {
      strcat(bline, " ");
      strcat(bline6, " ");
    }
    pjoin = FALSE;
    pgroup = FALSE;
    phyphen = FALSE;
    xtab = FALSE;
  }                /* xtab */

  if (!(phyphen || pjoin || (pgroup && group)))
    i++;
  j = i + strlen(bword6);
  i += strlen(bword);

  if (((i > linelength) || (j > linelength)) ||
      (fillit && ((i > linelength - 6) || (j > linelength - 6))))
    bpurge();

  if (pjoin || (pgroup && group) || (strcmp(bword, "1") == 0)
      || (strlen(bline) == 0) || phyphen)
  {
    sprintf(bline6, "%s%s", bline, bword6);
    strcat(bline, bword);
  }
  else
  if (bline[strlen(bline) - 1] == ' ')
  {
    sprintf(bline6, "%s%s", bline, bword6);
    strcat(bline, bword);
  }
  else
  {
    sprintf(bline6, "%s %s", bline, bword6);
    sprintf(bline + strlen(bline), " %s", bword);
  }

  if (!strcmp(bline, "BE"))
    strcpy(bline, "2"); /* braille for be */
  bword6[0] = 0;
  pgroup = group;
  pjoin = join;
  phyphen = hyphen;
}                  /* build_line */

void test_purge()
{
  int i, j = -1;
  for (i = 0; bline[i] != '\0'; i++)
    if (bline[i] != ' ')
      j = i;
  if (j >= 0)      /* bline contains a nonspace char, so flush it */
    bpurge();
}                  /* test_purge */

int get_integer(char *string)
{                  /* returns integer from string and removes digits. 18hello
                    * becomes hello returning 18 */
  int j = 0, retval = 0;
  while (isdigit(string[j]))
  {
    retval = 10 * retval + (int) string[j] - 48;
    j++;
  }                /* while */
  if (j)
    strcpy(string, string + j); /* remove digits */
  return (retval);
}                  /* get_integer */

void get_digit()
{
  if (hot_key)
  {
    out[1] = 0;
    out[0] = (char) getche();
    if (out[0] <= '\r')
      out[0] = 0;
  }
  else
    cgets(temp);
}                  /* get_digit */

void add_dots(char *string)
{
  int dot, i = 0, j;
  while (string[i])
  {
    dot = dottab[(int) string[i]];
    if (dot)
      total_cells++;
    for (j = 0; j < 6; j++)
    {
      if (dot & 1)
        total_dots++;
      dot = dot >> 1;
    }              /* j */
    i++;
  }                /* while */
}                  /* add_dots */

void do_commands()
{
  int tilpos, i, j;
  char c, *cptr;
  if ((cptr = strpbrk(words, format_string)) == NULL)
    return;        /* no format commands in word */
  newline = TRUE;
  tilpos = 1 + cptr - words;
  if (words[tilpos])    /* theres a character after the tilda */
    do
    {
      c = (char) toupper(words[tilpos]);        /* the character after the ~ */
      if (!strchr("ILZ", c))
        strcpy(words + tilpos - 1, words + tilpos + 1); /* for every char except
                                                         * ILZ */

      switch (c)
      {
      case 'A':   /* Acronym Logic - Betty Desimone */
        xacronym = TRUE;
        newline = FALSE;
        break;
      case 'B':   /* Textbook Break */
        doroman = FALSE;
        dobook = TRUE;
        bpageh = bpagec;        /* set to current page */
        if (blinec < linesperpage)
          bpageh--;
        bpageb = get_integer(words);
        if (!bpageb)
          bpageb = 1;   /* set to 1 if invalid integer */
        test_purge();
        memset(tline, '-', maxline);    /* dots 3/6 */
        i = maxline;
        make_arabic(&bpageb);
        strcpy(tline + maxline - strlen(field), field); /* put page num at end
                                                         * of line */
        if (blinec > 1 && blinec < linesperpage - 1)
        {
          if (bpagec >= pagestart)
          {        /* page in range */
            write_string(tline);
            if (display_braille)
              printf("%s\n", tline);
          }        /* page in range */
          blinec++;
        }
        else
          linelength = curmax - 6 - margin;
        break;
      case 'C':   /* Center */
        newline = TRUE;
        test_purge();
        xcenter = TRUE;
        break;
      case 'D':   /* Double Toggle */
        xdouble ^= xdouble;
        break;
      case 'E':   /* Poetry */
        test_purge();
        xformat = POETRY;
        break;
      case 'F':   /* Fill Line - Index table of contents */
        test_purge();
        fillit = TRUE;
        break;
      case 'G':   /* Set Right Margin */
        i = curmax;
        curmax = get_integer(words);
        if (curmax < 1)
          curmax = 1;
        if (curmax > maxline)
          curmax = maxline;
        linelength = curmax + 1 - margin;
        break;
      case 'H':   /* Heading */
        strcpy(oldline, bline);
        strcpy(oldline6, bline6);
        xheading = TRUE;
        xpgroup = pgroup;
        xpjoin = pjoin;
        xjoin = join;
        xgroup = group;
        xhyphen = hyphen;
        xphyphen = phyphen;
        makehead = TRUE;
        bline[0] = 0;
        bline6[0] = 0;
        pgroup = FALSE;
        group = FALSE;
        join = FALSE;
        pjoin = FALSE;
        break;
      case 'I':   /* Italics */
        words[tilpos] = '_';
        if (tilpos > 1)
        {          /* >=1 char before ~ */
          if (isalpha(words[tilpos - 2]))
            words[tilpos - 1] = '-';
          else
            strcpy(words + tilpos - 1, words + tilpos);
        }
        else
          strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case 'J':   /* Stop Heading */
        xheading = FALSE;
        break;
      case 'K':   /* Stop Footing */
        xfooting = FALSE;
        break;
      case 'L':   /* Letter Sign */
        words[tilpos] = '\\';
        strcpy(words + tilpos - 1, words + tilpos);
        /* newline=FALSE;  */
        break;
      case 'M':   /* Left Margin Set */
        newline = TRUE;
        test_purge();
        i = margin;
        margin = get_integer(words);
        if (margin < 1)
          margin = 1;
        if (margin > 30)
          margin = 30;
        linelength += i - margin;
        setmargin += margin - oldmargin;
        oldmargin = margin;
        break;
      case 'N':   /* Set PageNum */
        addchar[0] = 0;
        dopagenum = TRUE;
        doroman = FALSE;
        bpagec = get_integer(words);
        if (isupper(words[0]))
        {          /* uppercase letter followed number */
          sprintf(addchar, ";%c", words[0]);
          words[0] = 0;
        }          /* uppercase letter followed word */
        if (bpagec == 1)
          pageset = TRUE;
        bpageh = bpagec;
        if (blinec == 0)
          linelength = curmax - 6 - margin - strlen(addchar);
        break;
      case 'O':   /* Offset for Wrap */
        woffset = get_integer(words);
        if (woffset > 30)
          woffset = 0;  /* keep values reasonable */
        break;
      case 'P':   /* New page */
        if (blinec >= linesperpage - 1)
        {
          bpurge();
        }
        else
        {
          test_purge();
          if (dobook)
          {
            /* we have to put page number in lower right corner */
            j = blinec;
            for (i = j; i <= linesperpage; i++)
              bpurge();
          }
          else
            top_of_form();
        }
        if (printit)
          delay(emboss_delay);
        break;
      case 'Q':   /* clear all tabs */
        memset(tabtable, 0, sizeof(tabtable));
        break;
      case 'R':   /* Roman Numerals */
        doroman = TRUE;
        dobook = FALSE;
        break;
      case 'S':   /* Skip a line */
        newline = TRUE;
        test_purge();
        bpurge();
        break;
      case 'T':   /* Text Format */
        xformat = TEXT;
        test_purge();
        for (i = 0; i < woffset; i++)
          strcat(bline, " ");
        strcpy(bline6, bline);
        break;
      case 'U':   /* page Numbering Off */
        addchar[0] = 0;
        dopagenum = FALSE;
        break;
      case 'V':   /* set tab */
        i = get_integer(words);
        if (!i)
          i++;
        tabtable[i] = 1;
        break;
      case 'W':   /* Footing */
        strcpy(oldline, bline);
        strcpy(oldline6, bline6);
        xfooting = TRUE;
        xpgroup = pgroup;
        xpjoin = pjoin;
        xjoin = join;
        xgroup = group;
        xhyphen = hyphen;
        xphyphen = phyphen;
        makefoot = TRUE;
        bline[0] = 0;
        bline6[0] = 0;
        pgroup = FALSE;
        group = FALSE;
        join = FALSE;
        pjoin = FALSE;
        break;
      case 'X':
        xtab = TRUE;
        break;
      case 'Y':
        xformat = LISTS;        /* TABLE Format */
        break;
      case 'Z':   /* Terminator */
        words[tilpos] = '`';
        strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case '\47': /* Apostrophe */
        words[tilpos] = '=';
        strcpy(words + tilpos - 1, words + tilpos);
        newline = FALSE;
        break;
      case '0':   /* Grade 0 */
        newline = FALSE;
        xgrade = GRADE0;
        break;
      case '1':   /* Grade 1 */
        newline = FALSE;
        xgrade = GRADE1;
        break;
      case '2':   /* Grade 2 */
        newline = FALSE;
        xgrade = GRADE2;
        load_tables();
        break;
      case '3':   /* grade 3 */
        newline = FALSE;
        xgrade = GRADE3;
        load_tables();
        break;
      }            /* switch */
      if ((cptr = strpbrk(words, format_string)) == NULL)
        tilpos = 0;
      else
        tilpos = 1 + cptr - words;
    }
    while (tilpos != 0);
  strcat(words, " ");
}                  /* do_commands */

/*****************************/
/*** Execute the Operation ***/
/*****************************/
void do_lop_op(int op, int fstart, int flen, int fapdat)
{
  int i, j;
  if (op < 100)
    switch (op)
    {
    case 1:
      linein[0] = 0;
      break;       /* delete */
    case 2:
      xformat = TEXT;
      break;       /* text */
    case 3:
      xformat = LISTS;
      break;       /* lists */
    case 4:
      strcpy(linein, "~S ");
      linein[0] = format_string[0];
      break;       /* skip line */
    case 5:       /* center */
      while (linein[0] == ' ')
        strcpy(linein, linein + 1);     /* remove leading blanks */
      strcpy(field, linein);
      sprintf(linein, "~C%s", field);
      linein[0] = format_string[0];
      break;
    case 6:       /* indent */
      setmargin = oldmargin + 2;
      break;
    case 80:      /* page */
      inpglen = fstart;
      break;
    }              /* switch */
  else
  if (op < 200)
  {                /* <200 */
    if (!linein[0])
      return;
    tabmargin = TRUE;
    if ((int) strlen(linein) < fstart)
      for (i = (int) strlen(linein) - 1; i < (int) strlen(linein) + flen; i++)
        strcat(linein, " ");
    strcpy(field, linein + fstart - 1);
    field[flen] = 0;
    strcpy(linein + fstart - 1, linein + fstart + flen - 1);
    trim(field);

    switch (op)
    {              /* switch op */
    case 101:
      field[0] = 0;
      break;
    case 102:     /* state */
      if (field[0])
      {            /* field not empty */
        for (i = 0; i < statecount; i++)
        {          /* i */
          j = strpos(field, stateid[i]);
          if (j)
          {        /* found state abbreviation */
            strcpy(field + j - 1, field + j + 1);
            insert(stateid[i] + 3, field, j - 1);
            break;
          }        /* found state abbrevation */
        }          /* i */
      }            /* field not empty */
    }              /* switch */
    if (fapdat > 0)
    {
      sprintf(temp, "%s %s", field, appdat[fapdat]);
      strcpy(field, temp);
    }
    insert(field, linein, fstart - 1);
  }                /* <200 */
  else
  if (op < 255)
  {                /* <255 */
    if (!linein[0])
      return;
    if ((int) strlen(linein) < fstart)
      for (i = (int) strlen(linein); i < (int) strlen(linein) + flen; i++)
        strcat(linein, " ");
    strcpy(field, linein + fstart);
    field[flen] = 0;
    if ((fapdat > 0) && (strpos(field, appdat[fapdat]) > 0))
    {
      disablecol = TRUE;
      switch (op)
      {
      case 201:
        linein[0] = 0;
        break;
      case 202:
        disablecol = TRUE;
        break;
      }            /* switch */
    }
  }
}                  /* do_lop_op */

/**************************************************/
/*** Do Line Operation Processing -- outer loop ***/
/**************************************************/
void do_lop()
{
  int i, j;
  disablecol = FALSE;
  if (!lopcount)   /* no instructions were stored */
    return;
  for (i = 1; i <= lopcount; i++)
    if (l[i].lflag)
      if ((lineinct >= l[i].lstart) && (lineinct <= l[i].lend))
      {            /* line within range */
        j = l[i].fopstart;
        do_lop_op((int) f[j].fop, f[j].fstart, f[j].flen, f[j].fappo);
        if (disablecol)
          for (j = l[i].fopstart + 1; j <= l[i].fopstart + l[i].fopcount - 1; j++)
            do_lop_op((int) f[j].fop, f[j].fstart, f[j].flen, f[j].fappo);
      }            /* line within range */
  if (!disablecol)
    for (i = 1; i <= lopcount; i++)
      if (!l[i].lflag)
        if ((lineinct >= l[i].lstart) && (lineinct <= l[i].lend))
          for (j = l[i].fopstart; j < l[i].fopstart + l[i].fopcount; j++)
            do_lop_op((int) f[j].fop, f[j].fstart, f[j].flen, f[j].fappo);

  if (disablecol)
    tabmargin = FALSE;
}                  /* do_lop */

void getline()
{
  int i = -1;
  for (;;)
  {                /* do until line read, line too long, or eof */
    i++;
    if (!bytes_in_buf)
    {              /* empty buffer so fill it up */
      if ((bytes_in_buf = read(infile, iobuf, BUFSIZE)) <= 0)
      {            /* eof */
        endfile = done = TRUE;
        break;
      }            /* eof */
      ioptr = iobuf;
    }              /* buffer empty so fill it up */
    c = *ioptr & (char) 127;    /* remove b7 if present */
    bytes_in_buf--;
    ioptr++;
    if (c == 31)
      c = '|';
    if (c == (char) 30)
      i--;
    else
      linein[i] = c;
    if (c == '\13' || c == '\14')
      lineinct = 0;
    if (c == ' ' && i > 200)
      break;       /* line too long, end at word */
    if (c == (char) 10)
      break;       /* actual end of line */
    if (c < ' ')
      linein[i] = ' ';  /* remove all control chars */
  }
  linein[i] = linein[i + 1] = 0;
  i--;
  while (i >= 0 && linein[i] == ' ')
    linein[i--] = 0;    /* remove trailing spaces */
  if (lineinct > inpglen && inpglen > 0)
    lineinct = 0;  /* reset lineinct for next input page */
  lineinct++;

  if (lopactive)
    do_lop();

  if (display_source)
    printf("=>%s", linein);
}                  /* getline */

/*************************************/
/*** See if Line should be written ***/
/*************************************/
void check_purge(void)
{
  int i, j;
  BOOL purgit = TRUE;
  /* flush unless the first leftmargin-1 chars contain a nonspace char */
  for (i = 0; i < leftmargin; i++)      /* Determine whether to flush */
    if (linein[i] != ' ' && linein[i] != '\0')  /* when reading a new Line */
      purgit = FALSE;

  if (xformat == LISTS || xformat == BLOCK)
    purgit ^= 1;   /* toggle purgeit */

  if (disablecol)
    purgit = TRUE;

  if (purgit)      /* Check for Indentation */
  {
    newline = TRUE;
    j = -1;
    for (i = 0; bline[i] != 0; i++)
      if (bline[i] != ' ')
        j = i;
    if (j >= 0)
      bpurge();
    bline[0] = 0;
    if (xformat == TEXT)
      for (i = 0; i < woffset; i++)
        strcat(bline, " ");
    strcpy(bline6, bline);
    quotecount = 0;
    if (tabmargin)
      margin = setmargin;
    else
      margin = oldmargin;
    tabmargin = FALSE;
  }
}                  /* check_purge */

/***********************************/
/***   Extract a Word From the	 ***/
/***   Input Text -- check for	 ***/
/***	      commands		 ***/
/***********************************/
void get_word()
{
  char *cptr;
  int l;
  hyphen = FALSE;
  xacronym = FALSE;

  newline = FALSE;
  while (linein[0] == (char) 0 && !done)
  {                /* blank line and not eof */
    l = strlen(bline);
    if (makefoot)
    {
      makefoot = FALSE; /* only do once for each ~w command */
      memset(fline, 32, curmax);
      fline[linelength] = 0;
      if (bline[0])
        move(bline, fline + linelength - l + 1, l - 1);
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }
    if (makehead)
    {
      /* use bline to consstruct header */
      makehead = FALSE; /* only do this once for each ~h command */
      memset(hline, 32, curmax);        /* fill with spaces */
      hline[curmax] = 0;
      if (bline[0])
        move(bline, hline + (linelength - l) / 2, l - 1);
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }
    getline();
    /* newline=TRUE; */
    check_purge();
  }                /* blank line and not eof */

  if (done)
  {
    words[0] = 0;
    return;
  }
  while (linein[0] == ' ')
    strcpy(linein, linein + 1); /* remove leading blanks */
  cptr = strpbrk(linein, " ");
  if (cptr)        /* extract the word */
  {                /* blank found */
    *cptr = 0;
    strncpy(words, linein, sizeof(words));
  }                /* blank found */
  else
    strncpy(words, linein, sizeof(words));
  strcpy(linein, linein + strlen(words) + 1);
  linein[strlen(linein) + 1] = 0;
  if (strpbrk(words, format_string))
    do_commands();
  return;
}                  /* get_word */

/******************************************************/
/*** Set up the Vector for the characters in a Word ***/
/******************************************************/
void set_vect()
{
  int i = 0;
  do
  {
    capvec[i] = subvec[i] = 0;
    if (isupper(words[i]))
      capvec[i] = 2;
    else
    if (islower(words[i]))
      capvec[i] = 1;
    else
    if (words[i] == '|')
    {              /* vertical bar */
      strcpy(words + i, words + i + 1); /* delete | */
      capvec[i] = 9;    /* do not translate character after | */
      words[i] |= 128;  /* set b7 on character not to be trahnslated */
      /* this prevents this char from being a match in do_letter */
    }              /* vertical bar */
    i++;
  }
  while (words[i]);
  if (xgrade)
    strupr(words); /* leave case unchanged if grade 0 */
  capvec[i] = subvec[i] = 0;
}                  /* set_vec */

/***********************************/
/***   Check the extracted word  ***/
/*** against the table of valid  ***/
/*** types:			 ***/
/***	  1-use anywhere	 ***/
/***	  2-must be exact match  ***/
/***	  3-at beginning or all  ***/
/***	  4-only in middle	 ***/
/***	  5-joins with same type ***/
/***	  6-joins next-to,into,by***/
/***	  7-not at beginning	 ***/
/***	  8-the word BE 	 ***/
/***	  9-his,was,were,enough  ***/
/***	 10-only at end 	 ***/
/***********************************/
void do_letter()
{
  int i, j, k, l, matchend, wlength, wstart, casetype;
  BOOL atend, matched;
  char mworks[11], work1[11];
  lastmatch = count;
  wlength = strlen(words);
  wstart = 0;
  while (words[wstart] == '_')
  {
    wlength--;
    wstart++;
  }                /* while */
  wstart = 0;      /* for firstletter */

  join = FALSE;
  group = FALSE;
  matched = FALSE;
  firstletter++;
  subvec[count] = point;
  i = (int) words[count] - 64;
  if (i < 0 || i > 27)
    i = 0;         /* not a letter */
  j = (int) words[count + 1] - 64;
  if (j < 0 || j > 27)
    j = 0;         /* not a letter */
  i = b->start2[i][j];
/*for example the word this i=20 j=8 and start2[i][j] points to where words
* starting with th start*/
  if (i > 0 && xgrade >= GRADE2 && !xacronym)
    do
    {
      strcpy(mworks, b->match[i]);
      l = strlen(mworks);
      matchend = count + l - 1; /* points to last character of proposed match */
      if (strncmp(mworks, words + count, l))
        goto l10;

      k = b->typex[i];
      if (firstletter > wstart && (k == 2 || k == 3 || k == 6 || k == 8))
        goto l10;
      if (firstletter == wstart && (k == 4 || k == 7))
        goto l10;

      j = b->typex[b->start1[(int) words[matchend + 1]]];       /* Next Letter */
      if (j > 0 && j < 11)
        atend = FALSE;  /* next char is a letter */
      else         /* Set end of Word if next char not Letter */
        atend = TRUE;

      if (atend == FALSE && (k == 2 || k == 6 || k == 10))
        goto l10;

      if (atend && ((k == 4) ||
                    ((!strcmp(mworks, "IN")) && (k == 3))))
        /* in [3,4] */
        goto l10;

      if ((k == 5) && (atend) && (firstletter == wstart)
          && (words[wstart] != '\\'))
        group = TRUE;

      if (pjoin && k == 8 && atend)
        goto l10;

      if ((k == 8) && (matchend == wlength - 1)
          && (wlength != l))
        goto l10;

      if ((k == 9) &&   /* was, his, etc. */
          ((l != wlength) ||
           pjoin))
        goto l10;

      if (k == 6)
      {
        if (matchend - wstart + 1 != wlength)
          goto l10;/* to Into by */
        join = TRUE;
      }

      casetype = capvec[count];
      if (casetype == 1)        /* lowercase */
        for (k = 0; mworks[k + 1]; k++)
          if (isupper(mworks[k + 1]))
            if (capvec[count + k + 1] != casetype)
              goto l10;

      subvec[count] = i;
      count = matchend;
      matched = TRUE;

  l10:if (!matched)
        i++;
      strcpy(work1, b->match[i]);
    }              /* while */
    while ((!matched) && work1[1] == mworks[1]);
  /* while (!(matched || (work1[1] != mworks[1]))); */
  quoteopen = FALSE;
  quoteclose = FALSE;
}                  /* do_letter */

/***********************************/
/***	  Convert NumberS	 ***/
/***	       Type 11		 ***/
/***********************************/
void do_number()
{
  if (xgrade == GRADE0)
    return;        /* check for minus - make in (9) sign */
  firstletter = -1;
  subvec[count] = point;
  capvec[count] = 3;
  quoteopen = FALSE;
  quoteclose = FALSE;
}                  /* do_number */

/***********************************/
/***  Convert THE PUNCTUATION	 ***/
/***  Type 21 - Simple Replace	 ***/
/***	   22 - .		 ***/
/***	   24 - '                ***/
/***	   25 - "                ***/
/***	   27 - -		 ***/
/***********************************/
void do_punct()
{
  int i, k;
  BOOL matched;
  BOOL apostrophe;
  point--;
  do
  {
    point++;
  }
  while (strncmp(b->match[point], words + count, strlen(b->match[point])));

  if (count > 0)   /* Check for capital mark requirement */
    if (lastmatch >= 0)
    {
      k = b->typex[abs(subvec[lastmatch])];
      if (k == 6 || k == 8 || k == 9)
        subvec[lastmatch] = -abs(subvec[lastmatch]);
    }

  matched = FALSE;

  join = FALSE;
  group = FALSE;
  pgroup = FALSE;
  apostrophe = FALSE;
  k = b->typex[point];

  if (k == 24)
  {
    if ((isupper(words[count - 1]) || isdigit(words[count - 1])) &&
        (isupper(words[count + 1]) || isdigit(words[count + 1])))
      apostrophe = TRUE;
    if ((isupper(words[count - 1]) || isdigit(words[count - 1])) && quotecount == 0)
      apostrophe = TRUE;
    if (count - 1 == (int) strlen(words) && (words[count - 1] == 'S' || words[count - 1] == 'N'))
      ;            /* Maybe an apostrophe */
  }
  if (apostrophe == FALSE && (k == 24 || k == 25))
  {                /* Handle quotes */
    c = words[count - 1];
    if (quoteopen || ((count > 0) &&
            !(c == '(' || c == '-' || c == '"' || c == '\47' || c == '[') &&
                      !quoteclose))
    {              /* Ending quote */
      if (quotecount & 1)
        subvec[count] = b->start1[(int) '>'];
      else
        subvec[count] = b->start1[(int) '}'];
      quotecount--;
      quoteopen = TRUE;
    }              /* ending quote */
    else
    {              /* Beginning quote */
      if (pjoin)
      {
        pjoin = FALSE;
        strcpy(bline, bline6);  /* reset for to into by */
      }
      quotecount++;
      if (quotecount & 1)
        subvec[count] = b->start1[(int) '<'];
      else
        subvec[count] = b->start1[(int) '{'];
      quoteclose = TRUE;
    }              /* beginning quote */
    return;
  }                /* handle quote */

  do
  {                /* Find replacement */
    i = count + strlen(b->match[point]) - 1;
    if (!strncmp(b->match[point], words + count, strlen(b->match[point])))
    {
      matched = TRUE;
      subvec[count] = point;
      count = i;
    }
    else
      point++;
  }
  while (!matched);

  if (b->typex[point] != 27)
    firstletter = -1;
  quoteopen = FALSE;
  quoteclose = FALSE;
}                  /* do_punct */

/***********************************/
/***   Build the Word From the	 ***/
/***   Information kept in the	 ***/
/***	 contraction vector	 ***/
/***********************************/
void build_word()
{
  BOOL nolow, num = FALSE, allcaps = FALSE;
  int i, i1, j, k;
  bword[0] = 0;    /* start with no word */
  bword[70] = 0;   /* tells if word gets too long */
  bword6[0] = 0;

  strcpy(oldword, words);
  for (i = 0; words[i]; i++)
  {
    if (bword[70])
      break;       /* quit before bword overflows */
    if (capvec[i] == 9)
    {              /* do not translate this char */
      j = strlen(bword);
      bword[j] = words[i] & (char) 127;
      bword[j + 1] = 0; /* only 1 character was added to bword */
    }              /* do not translate this char */
    else
    if (subvec[i])
    {
      if (subvec[i] < 0)
      {
        nolow = TRUE;
        subvec[i] = -subvec[i];
      }
      else
        nolow = FALSE;

      i1 = subvec[i];
      k = b->typex[i1];
      if ((!num) && ((k == 11)
                     || ((k == 22) && (b->typex[subvec[i + 1]] == 11))))
      {
        strcat(bword, "#");
        num = TRUE;
        allcaps = FALSE;
        join = FALSE;
        group = FALSE;
        pgroup = FALSE;
      }

      if (k == 11 || k == 21 || k == 23 || k == 24 || k == 25 || k == 27)
        strcat(bword, b->replace[i1]);

      if (k == 22) /* period */
        if (b->typex[subvec[i + 1]] == 11)      /* numeric follows period */
          strcat(bword, ".");   /* decimal point */
        else
          strcat(bword, b->replace[i1]);

      if (num && k == 26)       /* Percent */
      {
        j = strpos(bword, "#");
        if (!j)
          j++;
        insert(b->replace[i1], bword, j - 1);
      }

      if (k > 0 && k < 11)
      {
        if (num && strcmp(b->match[i1], "-"))
        {
          num = FALSE;
          if (words[i] == 'S' && words[i - 1] != '\47')
            strcat(bword, "'");
          if ((capvec[i] == 1) && (words[i] < 'K') &&
              (!isupper(words[i + 1])))
/*
                   or
                   (((CapVec[I]=1) and (Word[I]='P')) and
                    ((CapVec[I+1]=1) and (Word[I+1]='M')))
*/
            strcat(bword, ";");
        }
        if (allcaps == FALSE && capvec[i] == 2)
        {
          pgroup = FALSE;
          strcat(bword, ",");
          if (capvec[i + 1] == 2)
          {
            strcat(bword, ",");
            allcaps = TRUE;
          }
        }
        if (k == 6)
        {
          sprintf(bword6, "%s%s", bword, b->match[subvec[i]]);
          if (!strcmp(bword6, "INTO"))
            strcpy(bword6, "9TO");
        }

        if (nolow)
          strcat(bword, b->match[i1]);
        else
          strcat(bword, b->replace[i1]);
      }
    }
    if (!strcmp(words, "$"))
    {
      strcpy(bword, "4#");
      strcpy(bword6, bword);
    }
  }                /* i */
  bword[curmax] = 0;
}                  /* build_word */

void check_ham_call()
{
  int i = 0, l = strlen(words), l1;
  if (l > 6)
    return;
  strcpy(out, words);
  strupr(out);
  if (strcmp(out, words))
    return;
  while (call_prefix[i])
  {
    l1 = strlen(call_prefix[i]);
    if (!strncmp(out, call_prefix[i], l1))
    {              /* match */
      if (!isdigit(out[l1]))
        return;
      xacronym = TRUE;
      strlwr(words + l1 + 1);
      break;
    }              /* match */
    i++;
  }                /* while */
}                  /* check_ham_call */

/***********************************/
/***   Determine Letter Type	 ***/
/***********************************/
void trans_word()
{
  int k;
  quoteopen = FALSE;
  quoteclose = FALSE;
  lastmatch = 0;
  firstletter = -1;
  count = -1;
  do
  {
    count++;
    if (capvec[count] != 9)
    {              /* not | */
      chardec = (int) words[count];
      point = b->start1[chardec];
      k = b->typex[point];
      if (k > 0 && k < 11)
        do_letter();
      if (k == 11)
        do_number();
      if (k > 20)
        do_punct();
    }              /* not | */
  }
  while (words[count + 1]);
}                  /* trans_word */

BOOL get_token()
{
  char delim = ' ';
  char *cptr;
  while ((lline[0]) && lline[0] == ' ')
    strcpy(lline, lline + 1);
  if (!lline[0])
    return (FALSE);
  if (lline[0] == (char) 39 || lline[0] == (char) 34)
  {                /* ' or " */
    delim = lline[0];
    strcpy(lline, lline + 1);
  }
  if (!lline[0])
    return (FALSE);

  tcount++;
  cptr = strchr(lline, delim);
  if (cptr == NULL)
  {
    strcpy(token[tcount], lline);
    lline[0] = 0;
    return (FALSE);
  }
  *cptr = 0;
  strcpy(token[tcount], lline);
  strcpy(lline, cptr + 1);
  return (TRUE);
}                  /* get_token */

void pop_tok(char *string)
{
  string[0] = 0;
  if (tcur >= tcount)
    return;
  tcur++;
  strcpy(string, token[tcur]);
}                  /* pop_tok */

int check_token(char *string)
{
  int i;
  if (!string[0])
    return (999);
  if (atol(string) > 0)
    return (888);  /* number */
  strupr(string);
  i = -1;
  do
  {
    i++;
    if (!strncmp(string, token_names[i], strlen(token_names[i])))
      break;
  }
  while (token_names[i] != NULL);
  if (token_vals[i] == 999)
  {                /* unknown token */
    fprintf(stderr, "Unknown token %s in line %d\n", field, lcount);
    exit(1);
  }                /* unknown token */
  return (token_vals[i]);
}                  /* check_token */

void do_ops()
{
  int i;
  tcur = 0;
  pop_tok(field);
  strupr(field);
  if (strcmp(field, "LINE"))
  {
    fprintf(stderr, "Invalid first Operation - must be LINE in line %d", lcount);
    fprintf(stderr, "%\n%s\n", lline);
    temperror = 100;
    return;
  }

  pop_tok(field);
  if (check_token(field) != 888)
  {                /* not a number */
    fprintf(stderr, "No line numbers specified in line %d\n%s\n", lcount, lline);
    temperror = 110;
    return;
  }                /* not a number */

  lopcount++;
  l[lopcount].lstart = atoi(field);     /* starting line */
  l[lopcount].lend = l[lopcount].lstart;        /* in case there isn't a
                                                 * second line number */
  l[lopcount].fopstart = fopcount + 1;
  pop_tok(field);
  if (check_token(field) == 888)
  {                /* ending line number specified */
    l[lopcount].lend = atoi(field);
    if (l[lopcount].lend < l[lopcount].lstart)
    {              /* bad line range */
      fprintf(stderr, "Ending line less than starting line in line %d\n", lcount);
      exit(1);
    }              /* bad line range */
    pop_tok(field);
  }                /* ending line number specified */

  while (check_token(field) < 100)
  {
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fop = (unsigned char) check_token(field);
    pop_tok(field);
    if (f[fopcount].fop == 80)
    {              /* page */
      f[fopcount].fstart = atoi(field);
      pop_tok(field);
    }              /* page */
  }                /* while */

  if (check_token(field) == 202)
  {                /* match */
    pop_tok(field);
    if (check_token(field) != 888)
    {              /* not a number */
      fprintf(stderr, "No Match column numbers specified in line %d\n%s\n",
              lcount, lline);
      temperror = 210;
    }              /* not a number */
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fstart = atoi(field);
    f[fopcount].flen = 1;
    l[lopcount].lflag = TRUE;
    pop_tok(field);
    if (check_token(field) == 888)
    {              /* got a number */
      i = atoi(field);
      if (i > f[fopcount].fstart)
        f[fopcount].flen = i - f[fopcount].fstart + 1;
      pop_tok(field);
    }              /* got a number */

    f[fopcount].fop = (unsigned char) 202;
    appcount++;
    f[fopcount].fappo = appcount;
    strcpy(appdat[appcount], field);
    pop_tok(field);
    if (check_token(field) == 1)        /* delete */
      f[fopcount].fop = (unsigned char) 201;
  }                /* match */

  while (check_token(field) == 100)
  {                /* field */
    pop_tok(field);
    if (check_token(field) != 888)
    {              /* no field number specified */
      fprintf(stderr, "No field numbers specified in line %d\n%s\n",
              lcount, lline);
      temperror = 210;
    }              /* no field number specified */
    fopcount++;
    l[lopcount].fopcount++;
    f[fopcount].fstart = atoi(field);
    f[fopcount].flen = 1;

    pop_tok(field);
    if (check_token(field) == 888)
    {
      i = atoi(field);
      if (i > f[fopcount].fstart)
        f[fopcount].flen = i - f[fopcount].fstart + 1;
      pop_tok(field);
    }              /* while */

    if (check_token(field) > 100 && check_token(field) < 199)
    {
      f[fopcount].fop = (unsigned char) check_token(field);
      pop_tok(field);
    }

    if (check_token(field) == 199)
    {              /* append */
      if (f[fopcount].fop == (unsigned char) 0)
        f[fopcount].fop = (unsigned char) 199;
      appcount++;
      f[fopcount].fappo = appcount;
      pop_tok(appdat[appcount]);
      pop_tok(field);
    }              /* append */
  }                /* while */
}                  /* do_op */

void do_template()
{
  temperror = 0;
  lcount = 0;
  lopcount = 0;
  fopcount = 0;
  appcount = 0;
  memset(f, 0, sizeof(foptype));
  memset(l, 0, sizeof(loptype));
  memset(appdat, 0, sizeof(appdat));
  lfile = fopen(filetemp, "rt");
  if (lfile == NULL)
  {                /* not found */
    fprintf(stderr, "*** External Format File %s not found ... ***\7", filetemp);
    exit(1);
  }                /* not found */

  printf("External Format File %s\n", filetemp);
  while (fgets(lline, 200, lfile))
  {                /* while there are lines to read */
    lline[strlen(lline) - 1] = 0;       /* get rid of lf */
    lcount++;
    if (lline[0] == ';')
      continue;    /* skip comment */
    tcount = 0;    /* tokens found on this line */
    while (get_token());        /* store tokens from entire line */
    if (tcount > 0)
      do_ops();    /* tokens were found */
  }                /* while */
  if (lopcount)
    printf("External Format Processing Complete\n");
  else
    fprintf(stderr, "No external format lines were processed\n");
  lopactive = TRUE;
  fclose(lfile);
}                  /* do_template */

void do_translate()
{
  int i;
  memset(tabvec, 0, sizeof(tabvec));
  memset(tabtable, 0, sizeof(tabtable));

  pgroup = FALSE;
  pjoin = FALSE;
  join = FALSE;
  group = FALSE;
  hyphen = FALSE;
  phyphen = FALSE;
  if (xgrade < 0)
    xgrade = GRADE2;
  xacronym = TRUE;
  xcenter = FALSE;
  xformat = TEXT;
  xtab = FALSE;
  dobook = FALSE;
  xdouble = FALSE;
  xheading = FALSE;
  xfooting = FALSE;
  makefoot = FALSE;
  makehead = FALSE;
  if (dopagenum < 0)
    dopagenum = TRUE;
  pageset = FALSE;
  doroman = FALSE;
  disablecol = FALSE;
  fillit = FALSE;
  quotecount = 0;
  margin = 1;
  setmargin = 1;
  oldmargin = 1;
  tabmargin = FALSE;
  bpageb = 0;
  bpagec = 0;
  blinec = 0;
  actualpage = 0;
  woffset = 2;
  lineinct = 0;
  inpglen = 0;
  total_words = total_dots = total_cells = 0l;
  field[0] = 0;
  addchar[0] = 0;
  curmax = maxline;
  linelength = maxline + 1 - margin;
  copies++;

  lseek(infile, 0l, 0); /* start from beginning for each copy */
  bytes_in_buf = 0;/* no bytes in iobuf */

  top_of_form();
  endfile = FALSE;
  done = FALSE;
  do
  {
    get_word();
    i = strlen(words);
    if (i > 1 && words[i - 1] == '-' && words[i - 2] != '-')
    {
      strcpy(oldword, words);
      get_word();
      sprintf(temp, "%s%s", oldword, words);
      temp[maxline] = 0;
      strcpy(words, temp);
    }
    if (words[0])
    {              /* word not empty */
      total_words++;
      if (xgrade)
      {
        check_ham_call();
        set_vect();
        trans_word();
        build_word();
      }
      else
      {            /* grade 0 no translation */
        strcpy(bword, words);
        strcpy(bword6, words);
      }            /* grade 0 no translation */
      build_line();
    }              /* word not empty */
    if (kbhit())
      if (getch() == 27)
      {
        done = TRUE;    /* abort */
        ab_flag = 1;
        return;
      }
  }                /* while */
  while (!done);
  bpurge();

  if (xfooting && blinec > 0)
  {
    for (i = blinec + 2; i <= linesperpage; i++)
      if (bpagec > pagestart)
      {
        write_string(" ");
        if (display_braille)
          printf("\n");
      }
    if (bpagec > pagestart)
    {
      write_string(fline);
      if (display_braille)
        printf("%s\n", fline);
    }
    blinec = linesperpage;
  }

  if (blinec > 0)
  {                /* advance to top of next page */
    advance_page();
    if (printit)
      delay(emboss_delay);
    actualpage++;
  }                /* advance to top of next page */

  if (!(actualpage & 1))
  {
    if (lineskips)
      advance_page();
    if (printit)
      delay(emboss_delay);
  }
  flushall();
}                  /* do_translate */

void advance_page()
{
  int i;
  if (lineskips < 99)
    for (i = blinec; i < linesperpage + lineskips; i++)
      write_string(" ");        /* do it with linefeeds */
  if (lineskips == 99)
    write_char(12);/* do it with a formfeed */
  if (lineskips == 999)
    write_char(11);/* vertical tab no lf */
  if (lineskips == 9999)
  {
    write_string("\14");        /* formfeed with linefeed */
    printf("\nTo Continue, Press Return\n");
    getch();
  }
}                  /* advance_page */

void load_tables()
{
  int i = 0, j, k, error = 0, current_line = 0;
  char work[40], work1[40], work2[40];
  int lenmat, lenrep, typex;
  FILE *btable;
  char *ver_bar, *c;
  sprintf(temp, "%s%s", transpath, table_file);
  if ((btable = fopen(temp, "rt")) == NULL)
  {                /* error */
    fprintf(stderr, "Cannot find %s\n", temp);
    exit(1);
  }                /* error */
  if (b == NULL)   /* only allocate once */
    if ((b = malloc(sizeof(t))) == NULL)
    {              /* error */
      fprintf(stderr, "Cannot allocate memory for table\n");
      exit(1);
    }              /* error */
  memset(b, 0, sizeof(t));      /* fill in structure with zeros */
  strcpy(work2, "  ");  /* forces mismatch between work1 and work2 on first
                         * line */
  while (fgets(temp, 80, btable))
  {                /* while there are lines to read */
    current_line++;
    trim(temp);
    /* skip blank lines and comments starting with ; or # */
    if (temp[0] == '\n' || temp[0] == ';' || bline[0] == '#')
      continue;
    strupr(temp);
    if (!strcmp(temp, "$DONE$"))
      break;
    if ((ver_bar = strpbrk(temp, "|")) == NULL)
    {              /* error */
  no_ver_bar:error++;
      fprintf(stderr, "Improper placement of | error in line %d\n", current_line);
      break;
    }              /* error */
    *ver_bar = (char) 0;
    strcpy(work, temp);
    *ver_bar = '|';/* restore bline */
    c = ver_bar + 1;    /* beginning of part 2 */
    if ((ver_bar = strpbrk(ver_bar + 1, "|")) == NULL)
      goto no_ver_bar;
    *ver_bar = (char) 0;
    lenmat = strlen(c);
    if (lenmat > 10)
    {              /* too long */
      fprintf(stderr, "Error - match too long in line %d\n%s\n", current_line, bline);
      error++;
      break;
    }              /* too long */
    strcpy(work1, c);
    *ver_bar = '|';
    c = strpbrk(ver_bar, " ");
    if (c)
      *c = '\0';
    lenrep = strlen(ver_bar + 1);
    if (lenrep > 10)
    {
      fprintf(stderr, "Error - Replace too long in line %d\n%s\n", current_line, bline);
      error++;
      break;
    }
    if (i >= MAXTAB)
    {              /* too many entries */
      fprintf(stderr, "More then %d entries in table not allowed\n", MAXTAB);
      fprintf(stderr, "Remaining entries will be ignored.\n");
      break;       /* quit reading the table not fatal */
    }              /* too many entries */
    typex = atoi(work);
    if (typex <= -32 || typex >= 64)
    {              /* bad type */
      fprintf(stderr, "Invalid type in line %d\n", current_line);
      error++;
      break;
    }              /* type error */
    if (xgrade == GRADE3)
    {              /* grade 3 */
      if (typex < 0)
        continue;  /* skip unwanted g2 entry */
      typex &= 31;
    }              /* grade 3 */
    else
    if (typex > 32)
      continue;    /* skip g3 entry */
    i++;           /* we found a valid line, store results */
    b->typex[i] = abs(typex);
    strcpy(b->match[i], work1);
    strcpy(b->replace[i], ver_bar + 1);
    if (i > 1)     /* store previous match in work2 */
      strcpy(work2, b->match[i - 1]);
    j = (int) (work1[0] - '@');
    if (j < 0 || j > 26)
      j = 0;
    if (work1[0] != work2[0])
    {              /* first characters differ */
      b->start1[(int) (work1[0])] = i;
      b->start2[j][0] = i;
    }              /* first characters differ */
    else
    if ((work1[1] != work2[1]))
    {              /* second element of match and previous match differ */
      k = (int) (work1[1] - '@');
      if (k < 0 || k > 26)
        k = 0;
      b->start2[j][k] = i;
    }              /* second elements differ */
  }                /* while */
  fclose(btable);
  if (error)
  {                /* fatal error occurred */
    fprintf(stderr, "Correct error in %s and restart program.\n", table_file);
    exit(1);
  }                /* fatal error occurred */
}                  /* load_tables */

void get_config()
{
  int i = 0;
  char *c = getenv("NFBTRANS");
  char *cptr;
  while (i < 2)
  {                /* try current directory first, then use nfbtrans
                    * environment variable */
    if (i)
      if (c)
      {            /* nfbtrans defined */
        strcpy(transpath, c);
        if (transpath[strlen(transpath) - 1] != '\\')
          strcat(transpath, "\\");
      }            /* nfbtrans defined */
    if (intext != NULL)
      break;       /* store environment in transpath even if config file is
                    * in current directory */
    sprintf(temp, "%s%s", transpath, config_file);      /* try this file first */
read_config:
    if ((intext = fopen(temp, "rt")) != NULL)
    {              /* read config file */
      while (fgets(temp, 80, intext))
      {            /* while there are lines to read */
        strupr(temp);
        trim(temp);
        if (temp[0] == '\n' || temp[0] == ';' || temp[0] == '#')
          continue;/* skip */
        if ((cptr = strpbrk(temp, " ")) != NULL)
          *cptr = 0;    /* allows comments */
        process_options(temp);
      }            /* while */
      fclose(intext);
    }              /* read config file */
    i++;
  }                /* while */
  for (i = 1; i <= paramcount; i++)
  {
    strupr(paramstr[i]);
    if (paramstr[i][2] == '=')
    {              /* xx= */
      process_options(paramstr[i]);
      if (!paramcount)
        goto read_config;       /* cf=newfile was found */
    }              /* xx= */
    else
    {              /* not xx= */
      strcpy(filein, paramstr[1]);
      usr_default = TRUE;
      display_source = FALSE;
      printf("Processing file - %s\n", filein);
      lastcopy = atoi(paramstr[2] + 3);
      if (lastcopy <= 0)
        i--;
      if (lastcopy <= 0)
        lastcopy = 1;
      pagestart = 1;
      pageend = 9999;   /* print all pages */
      i++;
    }              /* not xx= */
  }                /* i */
}                  /* get_config */

void process_options(char *string)
{
  int j;
  char *cptr = string + 3;
  for (j = 0; options[j] != NULL; j++)
  {
    if (!strncmp(string, options[j], 2))
    {              /* option matched */
      if (*cptr <= ' ')
        j = -1;    /* error since nothing follows xx= */
      switch (j)
      {
      case 0:     /* cf */
        strcpy(config_file, cptr);
        paramcount = 0;
        break;
      case 1:     /* co */
        lastcopy = atoi(cptr);
        break;
      case 2:     /* db */
        display_braille = atoi(cptr);
        break;
      case 3:     /* de */
        emboss_delay = atoi(cptr);
        break;
      case 4:     /* ds */
        display_source = atoi(cptr);
        break;
      case 5:     /* fi */
        strcpy(filein, cptr);
        break;
      case 6:     /* FO */
      case 17:    /* po */
        strcpy(fileout, cptr);
        if (j == 5)
          printit = FALSE;
        break;
      case 7:     /* format string */
        strcpy(lline, cptr);
        tcount = 0;
        get_token();
        strcpy(format_string, token[1]);
        break;
      case 8:     /* fx */
        strcpy(filetemp, cptr);
        if (*cptr >= 'A')
          usetemplate = TRUE;
        break;
      case 9:     /* hk */
        hot_key = atoi(cptr);
        break;
      case 10:    /* lm */
        leftmargin = atoi(cptr);
        break;
      case 11:    /* ls */
        lineskips = atoi(cptr);
        break;
      case 12:    /* nc */
        no_copyright = TRUE;
        break;
      case 13:    /* ow */
        over_write = atoi(cptr);
        break;
      case 14:    /* pa */
        pause_time = atoi(cptr);
        display_braille = display_source = FALSE;
        break;
      case 15:    /* pe */
        pageend = atoi(cptr);
        break;
      case 16:    /* pl */
        linesperpage = atoi(cptr);
        break;
      case 18:    /* ps */
        pagestart = atoi(cptr);
        break;
      case 19:    /* pw */
        maxline = atoi(cptr);
        break;
      case 20:    /* so */
        make_sound = atoi(cptr);
        break;
      case 21:    /* st */
        strncpy(stat_file, cptr, sizeof(stat_file));
        break;
      case 22:    /* tf */
        strcpy(table_file, cptr);
        break;
      case 23:    /* tm */
        trans_mode = atoi(cptr);
        break;
      case 24:    /* tp */
        strcpy(transpath, cptr);
        break;
      case 25:
        timer = atoi(cptr);
        break;
      case 26:
        strcpy(words, cptr);
        do_commands();
        break;
      default:
        fprintf(stderr, "\7Improper option format,%s nothing follows =.\n", string);
        exit(1);
      }            /* switch */
      break;
    }              /* option matched */
  }                /* j */
  if (options[j] == NULL)
  {                /* invalid */
    fprintf(stderr, "\7Invalid option %s\n", string);
    exit(1);
  }                /* invalid */
}                  /* process_options */

void trim(char *string)
{
  int i, l = strlen(string);
/*remove trailing cr lf and spaces*/
  for (i = l - 1; i >= 0; i--)
  {
    switch (string[i])
    {
    case ' ':
    case '\12':   /* lf */
    case '\15':   /* cr */
      break;
    default:
      string[i + 1] = 0;
      i = 0;
      while (string[i] == ' ')
        i++;
      if (i)
        strcpy(string, string + i);
      return;
    }
  }                /* i */
}                  /* trim */

int strpos(char *string, char *substring)
{
  int i = 0, j, stringlen, sublen;
  stringlen = strlen(string);
  sublen = strlen(substring);
  if ((!stringlen) || (!sublen) || (sublen > stringlen))
    return (0);
  do
  {
    for (j = 0; j < sublen; j++)
      if (string[i + j] != substring[j])
        goto retry;
    return (i + 1);
retry:;
  }
  while (++i < stringlen);
  return (0);
}                  /* strpos */

void insert(char *ins, char *string, int ins_point)
{
  char buf[256];
  memcpy(buf, string, ins_point);       /* save beginning of string */
  strcpy(buf + ins_point, ins);
  strcat(buf, string + ins_point);
  strcpy(string, buf);
}                  /* insert */

void move(char *string1, char *string2, int bytes)
{
  while (bytes >= 0)
  {
    string2[bytes] = string1[bytes];
    bytes--;
  }                /* while */
}                  /* move */

/***********************************/
/***      Translate A File       ***/
/***********************************/

void translate_file()
{
  int i;
  long time1, time2, in_length, out_length;
  temp[0] = 48;
  if (filein[0] == '\0')
    do
    {
      printf("Enter source File name <RETURN> to exit? ");
      cgets(temp);
      printf("\n");
      if (!out[0])
        exit(0);
    }
    while (!out[0]);
  if (!filein[0])
    strcpy(filein, out);
  infile = open(filein, O_BINARY | O_RDONLY);
  if (infile < 0)
  {                /* error */
    fprintf(stderr, "\7*** %s not found .... ***\n", filein);
    exit(1);
  }                /* error */
  fromfile = TRUE;
  if (leftmargin < 0)
  {                /* get left margin */
    leftmargin = 1;
    printf("Enter Number of spaces before Left Margin of source File \n");
    printf("     (usually 1)? %d", leftmargin);
    backspace_int(leftmargin);
    temp[0] = 3;
    cgets(temp);
    printf("\n");
    leftmargin = atoi(out);
    if (leftmargin <= 0)
      leftmargin = 1;
  }                /* get left margin */
  if (maxline <= 0)
  {                /* get maxline */
    maxline = 40;
    printf("Enter Number of braille cells to emboss\n");
    printf("  on a Line (usually 40)? %d", maxline);
    backspace_int(maxline);
    cgets(temp);
    maxline = atoi(out);
    if (maxline <= 0)
      maxline = 40;
  }                /* get maxline */
  get_page_range();
  if (display_source < 0)
  {                /* display source? */
    printf("\nDisplay Source Text (Y/N)? N\010");
    get_digit();
    if (out[0] == 'y' || out[0] == 'Y')
      display_source = TRUE;
    else
      display_source = FALSE;
  }                /* display source? */
  if (display_braille < 0)
  {                /* display braille? */
    printf("\nDisplay Translated Text (Y/N)? Y\010");
    get_digit();
    if (out[0] == 'n' || out[0] == 'N')
      display_braille = FALSE;
  }                /* display braille? */
  if (linesperpage <= 0)
  {
    linesperpage = 25;
    printf("\nNumber of Lines per Page? %d", linesperpage);
    backspace_int(linesperpage);
    cgets(temp);
    if (out[0])
      linesperpage = atoi(out);
    if (linesperpage <= 0)
      linesperpage = 25;
    printf("\n");
  }
  if (lineskips < 0)
  {
    lineskips = 99;
    printf("Line Skips between Pages (99-FF, 999-VT)? %d", lineskips);
    backspace_int(lineskips);
    cgets(temp);
    if (out[0])
      lineskips = atoi(out);
    if (lineskips < 0)
      lineskips = 99;
  }
  printit = TRUE;
  if (trans_mode < 10)
  {                /* get secondary translation mode */
    printf("\n\nPlease select ");
    printf("\n  1 to Translate and store in a File or");
    printf("\n  2 Translate and emboss immediately.");
    printf("\n  Choice? 2\010");
    do
    {
      get_digit();
      if (!out[0])
        i = 2;
      else
        i = atoi(out);
    }
    while (i < 1 || i > 2);
  }                /* get secondary translation mode */
  else
    i = trans_mode / 10;
  if (i == 1)
  {                /* translate and store */
    printit = FALSE;
    if (!fileout[0])
    {
      printf("\nEnter name of File to create? ");
      temp[0] = 48;
      cgets(temp);
      strcpy(fileout, out);
    }
  }                /* translate and store */
  if (!filetemp[0])
  {
    printf("\nName of External Format File (RETURN for none)? ");
    cgets(temp);
    printf("\n");
    strcpy(filetemp, out);
  }
  if ((filetemp[0]) && filetemp[0] != '/')
    usetemplate = TRUE;
  if ((printit && !(usr_default)))
  {
    if (pagestart <= 0)
    {
      printf("Enter First Page to Emboss? %d\010", pagestart);
      temp[0] = 5;
      cgets(temp);
      pagestart = atoi(out);
    }
    if (pageend <= 0)
    {
      printf("\n Enter Last Page to Emboss? %d\010", pageend);
      cgets(temp);
      if (out[0])
        pageend = atoi(out);
      if (pagestart <= 0)
        pagestart = 1;
    }
  }
  if (lastcopy <= 0)
  {
    lastcopy = 1;
    printf("\nEnter Number of Copies? %d\010", lastcopy);
    cgets(temp);
    lastcopy = atoi(out);
  }
  if (lastcopy <= 0)
    lastcopy = 1;
  printf("\n\n");
  if (usetemplate)
    do_template();
  if (!printit)
  {
    if (access(fileout, 0) == 0 && over_write == 0)
    {              /* file already exists */
      printf("File %s exists - Overwrite (Y/N)? Y\007", fileout);
      if (make_sound)
      {
        sound(220);
        delay(500);
        nosound();
      }
      cgets(temp);
      if (out[0] == 'n' || out[0] == 'N')
        return;
    }              /* file already exist */
    printf("Writing to file - %s\n", fileout);
  }
  else
    do_pause();
  if (ab_flag)
    return;
  time(&time1);
  outext = open(fileout, O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
  do
  {
    do_translate();
  }
  while (copies < lastcopy);
  in_length = filelength(infile);
  out_length = filelength(outext);
  close(infile);
  close(outext);
  if (stat_file[0])
    if ((intext = fopen(stat_file, "wt")) != NULL)
    {              /* open */
      time(&time2);
      time2 -= time1;
      fprintf(intext, "%ld minutes %ld seconds\n", time2 / 60l, time2 % 60l);
      fprintf(intext, "%ld Words, %d Pages\n", total_words, bpagec);
      fprintf(intext, "Total cells %ld\n", total_cells);
      fprintf(intext, "%ld dots\n", total_dots);
      fprintf(intext, "Input file length: %ld\n", in_length);
      fprintf(intext, "Output file length: %ld\n", out_length);
      if (!ab_flag)
        fprintf(intext, "Output is %ld%% of input\n", 100l * out_length / in_length);
      fclose(intext);
    }              /* open */
}                  /* translate_file */


/********************************/
/*** Emboss a translated File ***/
/********************************/

void emboss_file()
{
  char ch, *cptr;
  if (!filein[0])
  {                /* get filename */
    temp[0] = 48;
    printf("Enter the name of the already Translated File <RETURN> to exit: ");
    cgets(temp);
    if (!out[0])
      exit(0);
    strcpy(filein, out);
    printf("\n");
  }                /* get filename */
  if ((intext = fopen(filein, "rt")) == NULL)
  {                /* error */
    fprintf(stderr, "\7%s does not exist\n", filein);
    exit(1);
  }                /* error */
  if (lastcopy <= 0)
  {
    temp[0] = 3;
    lastcopy = 1;
    printf("\nNumber of Copies? %d\010", lastcopy);
    cgets(temp);
    lastcopy = atoi(out);
    if (lastcopy <= 0)
      lastcopy = 1;
    dcopies = 1;
    printf("\n");
  }
  get_page_range();
  usr_default = FALSE;
  printit = TRUE;
  do_pause();
  outext = open(fileout, O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
  do
  {                /* while there are copies to emboss */
    copies++;
    actualpage = 0;
    bpagec = 1;    /* current braille page */
    lineinct = 0;
    rewind(intext);/* start from beginning of file for this copy */
    while ((fgets(field, 80, intext)) && bpagec <= pageend)
    {              /* while there are lines to read and not passed ending
                    * page */
      if (kbhit())
        if (getch() == 27)
        {          /* escape */
          ab_flag = 1;
          break;
        }          /* escape */
      lineinct++;
      lcount = strlen(field);
      field[lcount - 1] = 0;    /* remove \n */
      if ((cptr = strpbrk(field, "\013\014")) != NULL || lineinct > linesperpage)
      {            /* new page */
        bpagec++;  /* ff or vt */
        lineinct = 1;   /* first line on new page */
        if (bpagec > pageend)
          break;   /* done */
        if ((display_braille && (bpagec > pagestart)))
        {          /* display braille */
          printf("%s\n", field);
          if (strlen(field) > 20)
            printf("       Copy %d of %d\n", copies, lastcopy);
        }          /* display_braille */
      }            /* new page */
      if (bpagec >= pagestart)
      {            /* process page */
        if (cptr)
        {          /* vt or ff */
          ch = *cptr;
          if (!pause_time)
            printf("%s\n", field);
          strcpy(field, cptr + 1);
          if (actualpage)
            write_char(ch);
          actualpage++;
          delay(emboss_delay);
          if (field[0])
            write_string(field);
        }          /* ff or vt */
        else
        {          /* no ff or vt */
          write_string(field);
          if (!pause_time)
            printf("%s\n", field);
        }          /* no f or vt */
      }            /* process page */
    }              /* while */
  }
  while (copies < lastcopy);
  fclose(intext);
  close(outext);
}                  /* emboss_file */

void get_page_range()
{
  if (pagestart <= 0)
  {                /* get starting page */
    temp[0] = 5;
    pagestart = 1;
    printf("Start at Page? 1\010");
    cgets(temp);
    pagestart = atoi(out);
    if (pagestart <= 0)
      pagestart = 1;
    printf("\n");
  }                /* get starting page */
  if (pageend < pagestart)
  {                /* pageend */
    temp[0] = 5;
    pageend = 9999;
    printf("Stop at Page (RETURN for end)? %d", pageend);
    backspace_int(pageend);
    cgets(temp);
    pageend = atoi(out);
    if (!out[0])
      pageend = 9999;
    printf("\n");
    if (pageend < 1)
      pageend = 9999;
  }                /* pageend */
}                  /* get_page_range */

void do_pause()
{
  int i;
  if (printit)
    strcpy(fileout, "PRN");
  if (pause_time)
  {                /* pause */
    for (i = 0; i < pause_time; i++)
    {
      if (make_sound)
        sound(440);
      delay(80);
      nosound();
      delay(800);
      if (kbhit())
      {
        if (getch() == 27)
        {
          ab_flag = 1;
          return;
        }
        getch();
      }
    }              /* i */
    skip_output = 1;
  }                /* pause */
}                  /* do_pause */

void write_string(char *string)
{
  int l;
  l = sprintf(temp, "%s\r\n", string);
  if (write(outext, temp, l) < l)
    no_space();
  if (stat_file[0])
    add_dots(string);
}                  /* write_string */

void write_char(char ch)
{
  if (write(outext, &ch, 1) <= 0)
    no_space();
}                  /* write_char */

void no_space()
{
  int i;
  if (!printit)
    fprintf(stderr, "\nInsufficient disk space\n");
  if (make_sound)
    for (i = 0; i < 5; i++)
    {
      sound(1000);
      delay(500);
      sound(1500);
      delay(500);
    }
  nosound();
  exit(1);
}                  /* no_space */

void main(int argc, char *argv[])
{
  int i;
  paramcount = argc - 1;
  paramstr = argv;
  get_config();
  if (no_copyright == FALSE)
  {                /* display message */
    printf("\nGrade Two Braille Translator - Release %s\n", RELEASE);
    printf("%s\n", COPYRIGHT);
    printf("%s\n\n", VERSION);
    printf("\n%s is the Registered Owner\n", OWNER);
  }                /* display message */
  memset(l, 0, sizeof(l));
  load_tables();
  do
  {
    skip_output = 0;
    if (usr_default == FALSE && pagestart <= 1 && trans_mode <= 0)
    {              /* choose mode */
      printf("\nPlease select\n");
      printf("  1 to Translate a Text File or");
      printf("\n  2 to emboss a File that has already been Translated.");
      while (trans_mode % 10 < 1 || trans_mode % 10 > 2)
      {
        printf("\nChoice? 1\010");
        if (make_sound)
        {
          sound(440);
          delay(20);
          sound(1760);
          delay(20);
          nosound();
        }
        temp[0] = 2;
        get_digit();
        if (!out[0])
          strcpy(out, "1");
        trans_mode = atoi(out);
      }            /* while */
    }              /* choose mode */
    if ((trans_mode % 10) == 1 || usr_default == TRUE)
      translate_file();
    else
      emboss_file();
    if (skip_output)
    {
      do_pause();
      getch();
    }
    if (ab_flag)
      break;
    if (!usr_default)
    {
      if (make_sound)
        for (i = 22; i <= 9990; i++)
          sound(i);
      nosound();
      printf("\nDo another Y/N? ");
      get_digit();
    }
  }
  while (usr_default || (out[0] == 'y' || out[0] == 'Y'));
  if (!no_copyright)
    printf("\nReturning to Operating System...");
  exit(0);
}                  /* main */
