                page

title   name

;
;
;       Copyright 1986 by Dana Nowell - All rights reserved
;
; HISTORY:
;     Version     Date         Name            Description
;       1.0     08/22/86        dn      first cut
;
;

;------------------------------------------------------------------------------
;
;       MACRO   SECTION
;
;------------------------------------------------------------------------------

Version_msg     macro
                jmp     copyright_end

copyright_msg   db      CR, LF, 'Copyright 1986 - Dana Nowell  '
                db      'Version 1.0', CR, LF
                db      '    Released into the public domain', CR, LF, '$'
copyright_end:
                Msg     copyright_msg
                endm


Msg     macro   ptr

        push    dx
        push    ax

        lea     dx, ptr
        mov     ah, 09h
        int     21h

        pop     ax
        pop     dx

        endm


        NULL            equ     00h
        CR              equ     0dh             ; carriage return
        LF              equ     0ah             ; line feed
        F_FEED          equ     0ch             ; form feed
        TAB             equ     09h             ; tab character
        EOF             equ     1ah             ; ctrl z ( end of file )
        SPACE           equ     ' '             ; ascii space character
        QUOTE           equ     '"'


DOS_FUNCTION    equ     21h
DOS_TERMINATE   equ     20h
DOS_RENAME      equ     17h
DISP_STRING     equ      9h



;
;       ALL SWITCHES MUST BE IN UPPER CASE !!
;

SWITCH_CHAR     equ     '-'


SYSTEM_CHAR     equ     'S'
HIDDEN_CHAR     equ     'H'
VOLUME_CHAR     equ     'V'


FILESIZE        equ     11h             ; max length of filename / vol label

DEFAULT_ATTR    equ     31h             ; attribute byte for subdir, archive,
                                        ; and ( by default ) read-only

VOLUME_MASK     equ      8h             ; volume attribute mask
SYSTEM_MASK     equ      4h             ; system attribute mask
HIDDEN_MASK     equ      2h             ; hidden attribute mask






com     segment
        assume cs:com, ds:com, es:com

        org     5ch

fcb1            label   byte
drive1          db      ?
name1           db      11 dup(?)

        org     6ch

fcb2            label   byte
drive2          db      ?
name2           db      11 dup(?)

        org     80h

param_len       db      ?       ; length of parameter string ( excludes CR )
parameters      db      127 dup(?) ; parameters

        org     100h

prog    proc

        Version_msg             ; display copyright message

        test    al, al
        jz      drive_ok
        Msg     invdr$       ; point to error msg
        jmp     error

drive_ok:
        call    check_parms

        call    valid_name

        call    move_fcb

        cmp     test_label, 0           ; was file / volume syntax mixed?
        je      do_rename               ; no ok to do rename

        Msg     invvolm$                ; display mixed syntax message
        jmp     error


do_rename:
        lea     dx, xfcb                ; point dx to extended fcb
        mov     ah, DOS_RENAME          ; function 17 = rename
        int     DOS_FUNCTION

        test    al, al                  ; test for errors
        jz      exit                    ; ok

        Msg     invnam$
        jmp     error


exit:
        Msg     invok$
        int     DOS_TERMINATE

prog    endp


valid_name      proc    near

        cmp     name1, SPACE            ; does name exist ?
        jne     got_name1

        call    vol_quote               ; patch for quoted vol labels

        cmp     name1, SWITCH_CHAR      ; is it a switch ?
        je      bad_name

got_name1:
        cmp     name2, SPACE            ; does name exist ?
        je      bad_name

        cmp     name2, SWITCH_CHAR      ; is it a switch ?
        je      bad_name

got_name2:
        ret

bad_name:

        jmp     invalid_param   ; invalid parameter error msg

valid_name      endp





vol_quote       proc    near

;
;       if it is volume labels both MUST be quoted strings
;


;
;       this section does old volume label
;

        lea     di, parameters

        xor     test_label, 1           ; set / reset volume request flag

        call    find_quote
        jcxz    got_no_quote

got_quote1:
        mov     si, di                  ; already moved past the opening quote
        lea     di, name1
        call    move_til_quote
        inc     si                      ; skip end quote


;
;       this sections does new volume label
;


        mov     di, si
        call    find_quote

        jcxz    got_no_quote

        mov     si, di                  ; already moved past the opening quote
        lea     di, name2
        call    move_til_quote

        ret

got_no_quote:

        jmp     invalid_param   ; invalid parameter error msg

vol_quote       endp






find_quote      proc    near

        xor     cx, cx
        mov     cl, param_len
        inc     cx              ; count the CR at end of params

        mov     al, QUOTE
        repne   scasb           ; scan until a quote is found or 256 bytes

        ret

find_quote      endp


move_til_quote  proc    near

        push    ax
        push    cx
        push    di              ; save destination address on stack

        mov     di, si
        xor     cx, cx
        mov     cl, param_len
        inc     cx              ; count the CR at end of params

        mov     al, QUOTE
        repne   scasb           ; scan until a quote is found

        jcxz    no_quote

        sub     di, si          ; end of string - start = length
        mov     cx, di          ; put lenth of string to be moved into cx

        dec     cx              ; do NOT move the ending quote mark

        cmp     cx, FILESIZE    ; trap for entries larger than max size
        jbe     size_ok

        Msg     invsize$
        jmp     error

size_ok:
        pop     di              ; get destination back
        rep     movsb           ; move string bytes

        pop     cx
        pop     ax

        ret

no_quote:
        Msg     invquote$
        jmp     error           ; no end quote so error out

move_til_quote  endp



move_fcb        proc    near

        lea     si, fcb1                ; point to name1 fcb
        lea     di, old_name            ; point to old name field
        mov     cx, 0ch
        repz    movsb                   ; move name1 to extended fcb

        lea     si, name2               ; point to name2 not drive
        lea     di, new_name            ; point to new name field
        mov     cx, 0bh
        rep     movsb

        ret

move_fcb        endp





check_parms     proc    near

        xor     cx, cx                  ; clear length
        lea     di, parameters          ; begin at start of cmd_line
        mov     cl, param_len           ; for length of cmd line
        cmp     cl, 0                   ; check for NO parameters case
        je      end_check

next_switch:
        call    find_switch     ; scan cmd_line for switch char
                                ; al = switch char -> found

        cmp     al, SWITCH_CHAR
        jne     end_check       ; no switch present

process_switch:
        inc     di              ; skip already processed

;
;       CONVERT TO  UPPERCASE  FOR COMPARES
;
; NOTE : this routine is case specific ( alpha only ) dup at own risk
;
;

        cmp     [di], byte ptr 60h       ; check for lower case ( 'a' = 61h )
        jbe     upper
        sub     [di], byte ptr 20h       ; make uppercase

;
;       now we have uppercase so test against possible switches
;

upper:
        cmp     [di], byte ptr CR        ; check for carriage return at end
        je      end_check                ; if end of line all done

        cmp     [di], byte ptr SPACE     ; check for space separator
        je      next_switch              ; if end of switch check for more

        cmp     [di], byte ptr SYSTEM_CHAR
        je      sys_char                 ; if system character process it

        cmp     [di], byte ptr HIDDEN_CHAR
        je      hide_char                ; if hidden character process it

        cmp     [di], byte ptr VOLUME_CHAR
        je      volm_char                ; if volume character process it

;
;       if we haven't identified it by now it's an error
;

        Msg     invswitch$    ; bad switch message
        jmp     error



sys_char:
        lea     si, attr
        or      [si], byte ptr SYSTEM_MASK
        jmp     short process_switch



hide_char:
        lea     si, attr
        or      [si], byte ptr HIDDEN_MASK
        jmp     short process_switch



volm_char:
        lea     si, attr
        or      [si], byte ptr VOLUME_MASK

        xor     test_label, 1           ; set / reset volume request flag
        jmp     short process_switch



end_check:
        ret

check_parms     endp





find_switch     proc    near

check_char:
        cmp     [di], byte ptr SWITCH_CHAR
        je      found_switch
        inc     di
        loop    check_char

;
;       we didn't find the switch character so set flag and go home
;

        mov     al, NULL        ; no switch
        jmp     short   gone



found_switch:
        mov     al, SWITCH_CHAR         ; set the gotcha flag

gone:
        ret

find_switch     endp





invalid_param   proc    near

        Msg     invpar$      ; invalid parameter error msg
        jmp     short error

invalid_param   endp



error   proc    near

        int     DOS_TERMINATE           ; terminate

error   endp






;-------------------------------------------------------------------------;
;                                                                         ;
;                                                                         ;
;                       DATA AREA BEGINS HERE                             ;
;                                                                         ;
;                                                                         ;
;-------------------------------------------------------------------------;

test_label      dw      0

invpar$         db      CR, LF
                db      CR, LF
                db      '    This program renames files or directories.  '
                db      'Files that are READ-ONLY,'
                db      CR, LF
                db      'ARCHIVE, or DIRECTORIES '
                db      'may be renamed regardless of switch settings'
                db      CR, LF
                db      'The switches allow you to rename HIDDEN (-h) '
                db      'or SYSTEM (-s) files '
                db      CR, LF
                db      'and directories.  All attribute types are additive '
                db      '  - i.e. you may change '
                db      CR, LF
                db      'a HIDDEN, READ-ONLY file.  '
                db      'This utility accepts the standard DOS wildcards '
                db      CR, LF
                db      '( ? and * ) - be EXTREMELY CAREFUL '
                db      'using wildcards with hidden or system files.  '
                db      CR, LF
                db      CR, LF
                db      'ARGUMENTS :     [d:]oldname newname [-hs]'
                db      CR, LF
                db      CR, LF
                db      '    This program will also change ( DOS 2.0 ) volume '
                db      'labels.  All labels '
                db      CR, LF
                db      'MUST be enclosed in quotes and the -v switch '
                db      'must be set.  Only the label '
                db      CR, LF
                db      'of the CURRENT drive may the be '
                db      'changed ( root must be the current directory ).'
                db      CR, LF
                db      CR, LF
                db      'ARGUMENTS :     "oldlabel" "newlabel" -v'
                db      CR, LF
                db      CR, LF
                db      CR, LF, '$'

invvolm$        db      CR, LF, '    You have mixed the command SYNTAX for '
                db      'renaming volume labels with '
                db      CR, LF
                db      'that for renaming files.  Entering the program '
                db      'name without any arguments '
                db      CR, LF
                db      'will supply instructions for proper use.'
                db      CR, LF, '$'

invnam$         db      CR, LF, 'File ( or label ) NOT FOUND or '
                db      'ALREADY EXISTS', CR, LF, '$'

invsize$        db      CR, LF, 'Name is TOO LARGE', CR, LF, '$'

invswitch$      db      CR, LF, 'INVALID command line SWITCH', CR, LF, '$'

invquote$       db      CR, LF, 'IMPROPER number of QUOTES', CR, LF, '$'

invdr$          db      CR, LF, 'DISK DRIVE NOT FOUND', CR, LF, '$'

invok$          db      CR, LF, 'Rename SUCESSFULLY completed', CR, LF, '$'


;
;       file control block junk is stored here
;




;------------------------------------------------------------------------------
;
; Note on standard fcb structure :
;
;       The standard FCB is larger than the size reserved in the PSP if you
; intend to use to FCB data from the PSP move it to a different location.
;
;
;               STANDARD STRUCTURE OF A FILE CONTROL BLOCK
;
;
;    extension :
;            offset  length             description
;              -7       1       extension active flag ( 0ffh = active )
;              -6       5       normally unused should be zeros
;              -1       1       file attribute when extension is active
;                                      1  . . . . . . . 1   read-only
;                                      2  . . . . . . 1 .   hidden
;                                      4  . . . . . 1 . .   system
;                                      8  . . . . 1 . . .   volume label
;                                     16  . . . 1 . . . .   subdirectory
;                                     32  . . 1 . . . . .   archive
;                                     64  . 1 . . . . . .   unused
;                                    128  1 . . . . . . .   unused
;
;    fcb :
;            offset  length             description
;               0       1       special drive number ( 1 byte )
;                               0 = default
;                               1 = a:
;                               2 = b:       etc
;               1       8       filename or device name
;               9       3       filename extension
;              12       2       current block number
;              14       2       record size
;              16       4       file size in bytes ( dos dir entry at open )
;              20       2       file date ( bit coded as in dir )
;              22      10       dos work area
;              32       1       current record number ( 0 - 127 )
;              33       4       random record number
;
;------------------------------------------------------------------------------

xfcb            db      0ffh            ; extended fcb id byte
fcb1_ext        db      5 dup(0)        ; fcb # 1 extension
attr            db      DEFAULT_ATTR    ; allowable attribute settings go here


old_name       db      11h dup(0)      ; old name goes here
new_name       db      11h dup(0)      ; new name goes here



com     ends
        end     prog

