'
'   PROGRAM:    CHKMODEM.EXE
'
'   DATE:       09-01-1991
'
'   PROGRAMMER: Gary G. Hendershot
'               7218 Reservoir Road
'               Springfield, VA  22150
'               Voice:  703/569-6874
'               Fax:    703/569-1081
'               Data:   703/569-1419
'
'
'   PURPOSE:    CHECKMODEM is a utility that checks either internal
'               SERIAL Ports 1-4 or a DESIGNATE Port Address and
'               Interupt for the existance and response of a MODEM
'
'               The program is quite useful in determining which
'               serial port the modem is attached to and whether
'               or not it responds as required to Carrier Detect
'               and Data Terminal Ready changes.
'
'               The program can also determine the MINIMUM and
'               MAXIMUM baud rates at which the MODEM will respond
'               to commands.
'
'   REQUIRED:   This program was written to be compiled with the
'               Microsoft BASIC PDS Ver 7.0/7.1
'
'               It has been compiled under Microsoft Quick BASIC Ver 4.5
'               successfully with no modification.
'
'               NUMEROUS SUB-PROGRAMs are "CALLed" by this program that
'               are contained in third party library code.  The libraries
'               employed are as follows.
'
'               *******************************************************
'
'               ProBas Professional Basic Programming Library Ver 4.01
'               Hammerly Computer Services, Inc.
'               9309 Jasmine Court
'               Laurel, MD  20707
'               301/953-2191
'
'               This library provides the file handling and string print
'               routines.
'
'               *******************************************************
'
'               QBSerial Serial Communications Library
'               Jeff Sumberg
'               Sysop(2) - SailBoard BBS
'               Wayne, NJ, 201-831-8152
'                      [ or ]
'               Box 212
'               Ringwood, NJ, 07456
'
'               This library provides the Serial Communications routines
'
'               *******************************************************
'
'   COMMAND:    The program is executed with the command "CHKMODEM".
'               In its default state the program will check serial
'               ports 1-4 with these specifications ...
'
'                               COM1        COM2        COM3        COM4
'
'                   Address     3F8H        2F8H        3E8H        2E8H
'                   Interrupt   4           3           4           3
'                   Hand Shake  NONE        NONE        NONE        NONE
'
'               Each port will be sent an initialization string and a
'               response of "OK" will be considered a confirmation ...
'
'               A CONFIG file can be named on the command line.  The
'               command "CHKMODEM @MODEM.DAT" will cause the program
'               to look for a file named MODEM.DAT in the current
'               DRIVE:\SUBDIR ...  the CONFIG file must have the following
'               layout to be accepted ...
'
'               HEX ADDRS; SEND COMMAND; EXPECTED RESULT; HAND SHAKING;
'
'               Note that the parameters are seperated by a SEMI-COLON ...
'               The SEMI-COLON is used as a DELIMITER and must be used.
'
'               If MODEM.DAT contains the following data ...
'
'                    2F8;3;AT;OK;NONE;
'                    2F8;3;AT;OK;XON/XOFF;
'                    2F8;3;AT;OK;CTS;
'                    2F8;3;AT;OK;CTS/XON/XOFF;
'
'               the port at 2F8 Hex and interrupt 3 will be sent the message
'               "AT" with the expectation of getting back an "OK response
'               with "NONE" hand shaking, "XON/XOFF" hand shaking, "CTS"
'               hand shaking and "CTS/XON/XOFF" handshaking ...
'
'               Each time the serial port is checked, the program tries to
'               get a response from the modem at 300, 1200, 2400, 4800,
'               9600, 19200, 38400 and 57600 Baud ...  the slowest and
'               fastest baud rates the modem accepted a command are
'               reported ...
'
'               The modem is also checked with Carrier Detect and Data
'               Terminal Ready lines enabled and disabled ...
'
'
    DEFINT A-Z
'   $DYNAMIC
'
    DECLARE SUB OpenComm CDECL ALIAS "_open_comm" (BYVAL Port%, BYVAL IRQ%, BYVAL Wlen%, BYVAL Parity%, BYVAL Baud&, BYVAL HS%)
    DECLARE SUB CloseComm CDECL ALIAS "_close_comm" ()
    DECLARE FUNCTION WriteChar% CDECL (BYVAL Ascii%)
    DECLARE FUNCTION ReadChar% CDECL ()
    DECLARE SUB Transmit CDECL ALIAS "_transmit_string" (addr$)
    DECLARE FUNCTION DataWaiting% CDECL ALIAS "_data_waiting" ()
    DECLARE SUB ClearInputBuffer CDECL ALIAS "_clear_input_buffer" ()
    DECLARE SUB CarrierDetect CDECL ALIAS "_carrier_detect_flag" (BYVAL OnOff%)
    DECLARE FUNCTION CarrierLost% CDECL ALIAS "_carrier_state" ()
    DECLARE FUNCTION DriverCopyright% CDECL ()
    DECLARE SUB DTRcontrol CDECL ALIAS "_dtr" (BYVAL OnOff%)
'
1:
    CRLF$ = CHR$(13) + CHR$(10)
'
    CLS
    CALL DMPRINT("CHKMODEM Ver 2.0 - Modem Diagnostic Utility" + CRLF$)
    CALL DMPRINT("Copyright (C) 1991, Soft Sale Limited" + CRLF$)
    CALL DMPRINT(CRLF$ + "Soft Sale Limited"+ CRLF$)
    CALL DMPRINT("7218 Reservoir Road" + CRLF$)
    CALL DMPRINT("Springfield, VA  22150" + CRLF$)
    CALL DMPRINT("Voice:  703/569-6874" + CRLF$)
    CALL DMPRINT("Fax:    703/569-1081" + CRLF$)
    CALL DMPRINT("Data:   703/569-1419" + CRLF$ + CRLF$)
2:
'
    LOCATE 11, 1, 1
    OROW% = CSRLIN                              ' current cursor line
    OCOL% = POS(0)                              ' current cursor column
'
    REDIM PORTADDR%(16)
    REDIM VECTOR%(16)
    REDIM MINBAUD&(16)
    REDIM MAXBAUD&(16)
    REDIM DTRCMDON%(16)
    REDIM CDCMDON%(16)
    REDIM DTRCMDOFF%(16)
    REDIM CDCMDOFF%(16)
    REDIM HANDSHAKE$(16)
'
    IF INSTR(COMMAND$, "@") > 0 THEN
        CONFIG$ = MID$(COMMAND$, INSTR(COMMAND$, "@") + 1, LEN(COMMAND$))
        CALL STRIPBLANKS(CONFIG$, 3, SLEN%)
        CONFIG$ = LEFT$(CONFIG$, SLEN%)
        CALL EXIST(CONFIG$, FOUND%)
3:
        IF FOUND% THEN
            CALL DMPRINT("Reading CONFIG file " + CONFIG$ + CRLF$)
            CALL FOPEN(CONFIG$, 0, 0, HANDLE%, ECODE%)
4:
            IF ECODE% = 0 THEN
                Start% = 0
                DO
                    ST$ = SPACE$(128)
5:
                    CALL SFREAD2(HANDLE%, ST$, BYTES%, ECODE%)
                    ST$ = LEFT$(ST$, BYTES%)
                    IF ECODE% = 0 THEN
6:
                        REDIM ParseArray$(10)
                        CALL PARSEDELIMITED(ST$, ";",ParseArray$(), COUNT%, 3)
                        ADDRS%      = VAL("&H" + ParseArray$(1))
                        INTER%      = VAL(ParseArray$(2))
                        Send$       = ParseArray$(3)
                        Respond$    = ParseArray$(4)
7:
                        IF INSTR(ParseArray$(5), "NO") > 0 THEN
                            HandShake% = 0
                        ELSEIF INSTR(ParseArray$(5), "ON") > 1 AND INSTR(ParseArray$(5), "CT") > 1 THEN
                            HandShake% = 3
                        ELSEIF INSTR(ParseArray$(5), "ON") > 1 THEN
                            HandShake% = 1
                        ELSEIF INSTR(ParseArray$(5), "CT") > 1 THEN
                            HandShake% = 2
                        ELSE
                            HandShake% = 0
                        END IF
8:
                        Start% = Start% + 1
                        HandShake$(Start%) = " HandShake " + ParseArray$(5)
                        IF INTER% <> 0 THEN
                            OKROW% = CSRLIN
                            OKCOL% = POS(0)
                            LOCATE 10 + Start%, 1, 1
                            Status$ = "Scan Request #" + STR$(Start%) + " at ADDRESS " + HEX$(ADDRS%) + " Hex - on INTERUPT" + STR$(INTER%) + HandShake$(Start%)
                            GOSUB ReportIT
                            LOCATE 15 + START%, 1, 1
                            GOSUB SCANIT
                            LOCATE OKROW%, OKCOL%, 1
10:
                        ELSE
                            ECODE% = -255
                        END IF
                    END IF
                LOOP UNTIL ECODE% <> 0
11:
                CALL FCLOSE(HANDLE%)
            END IF
        ELSE
            ECODE% = 2
        END IF
    ELSE
        FOR START% = 1 TO 4
            SELECT CASE START%
            CASE 1
                DEF SEG=&h40
                ADDRS%=PEEK(0)+PEEK(1)*256
                DEF SEG
            CASE 2
                DEF SEG=&h40
                ADDRS%=PEEK(2)+PEEK(3)*256
                DEF SEG
            CASE 3
                DEF SEG=&h40
                ADDRS=PEEK(4)+PEEK(5)*256
                DEF SEG
            CASE 4
                DEF SEG=&h40
                ADDRS%=PEEK(6)+PEEK(7)*256
                DEF SEG
            CASE ELSE
            END SELECT
15:
            IF ADDRS% = 0 THEN
                OKROW% = CSRLIN
                OKCOL% = POS(0)
                LOCATE 10 + START%, 1, 1
                Status$ = "There is no SERIAL PORT" + STR$(START%)
                GOSUB ReportIT
                LOCATE OKROW%, OKCOL%, 1
16:
            ELSE
                OKROW% = CSRLIN
                OKCOL% = POS(0)
                LOCATE 10 + START%, 1, 1
                Status$ = "Checking SERIAL PORT" + STR$(START%) + " at BASE ADDRESS " + HEX$(ADDRS%) + " Hex"
                GOSUB ReportIT
17:
                IF (START% = 1) OR (START% = 3) THEN
                    INTER% = 4
                ELSE
                    INTER% = 3
                END IF
18:
                SEND$ = "AT E1 V1"
                RESPOND$ = "OK"
                HandShake% = 0
                HandShake$(Start%) = " HandShake = NONE"
19:
                LOCATE 15 + START%, 1, 1
                GOSUB SCANIT
                LOCATE OKROW%, OKCOL%, 1
20:
            END IF
        NEXT START%
    END IF
'
    IF (ECODE% <> 0) AND (ECODE% <> -1) THEN
        CALL DMPRINT("ERROR:" + STR$(ECODE%) + " reading config file!" + CRLF$)
        IF ECODE% = 2 THEN
            CALL DMPRINT("Config file not found!" + CRLF$)
        ELSE
            CALL DMPRINT("Bad Config file format!" + CRLF$)
        END IF
        SYSTEM
    ELSE
        ECODE% = 0
    END IF
'
QuitPlace:
'
    RROW% = CSRLIN
    RCOL% = POS(0)
    CALL QPRINT("Press any key to exit!", 23, 1, 0, 0)
    A$ = ""
    WHILE A$ = ""
        A$ = INKEY$
    WEND
    CLS
    LOCATE 1, 1, 0
    Status$ = ""
    GOSUB ReportIT
    GOSUB ReportIT
    FOR Start% = 1 TO 16
        IF PORTADDR%(Start%) > 0 THEN
            Status$ = "Modem Found on SCAN#" + STR$(Start%) + " @ ADDR = " + HEX$(PORTADDR%(Start%)) + " INT =" + STR$(VECTOR%(Start%)) + " MinBaud =" + STR$(MINBAUD&(Start%)) + " MaxBaud =" + STR$(MAXBAUD&(Start%))
            GOSUB ReportIt
            Status$ = "Responds with "
            IF CDCMDOFF%(Start%)  THEN Status$  = Status$ + " - CD LOW"
            IF CDCMDON%(Start%)   THEN Status$  = Status$ + " - CD HIGH"
            IF DTRCMDOFF%(Start%) THEN Status$  = Status$ + " - DTR LOW"
            IF DTRCMDON%(Start%)  THEN Status$  = Status$ + " - DTR HIGH"
            Status$ = Status$ + " -" + HandShake$(Start%)
            GOSUB ReportIT
            Status$ = ""
            GOSUB ReportIT
            GOSUB ReportIT
        END IF
    NEXT Start%
'
    LOCATE 23, 1, 1
'
    END
'
ScanIt:

50:
    FOR Z% = 1 TO 8
        WORD% = 8
        PARITY% = 0
'
51:
        SELECT CASE Z%
        CASE 1
            Baud& = 300
        CASE 2
            Baud& = 1200
        CASE 3
            Baud& = 2400
        CASE 4
            Baud& = 4800
        CASE 5
            Baud& = 9600
        CASE 6
            Baud& = 19200
        CASE 7
            Baud& = 38400
        CASE 8
            Baud& = 57600
        CASE ELSE
        END SELECT
'
53:
        CALL OPENCOMM(ADDRS%, INTER%, WORD%, PARITY%, Baud&, HANDSHAKE%)
'
        GOSUB CheckModem
'
54:
        CALL CLOSECOMM
'
    NEXT Z%
'
    RETURN
'
CheckModem:
'
    CARRIERDETECT 0                     ' turn CD off
    DTRCONTROL 0                        ' turn DTR off
    SLEEP 1
    GOTBACK$ = ""
    FOUND% = 0
    ClearInputBuffer
    TIMEOUT! = TIMER + 1
    TRANSMIT SEND$ + CHR$(13)
    WHILE (FOUND% = 0) AND (TIMER < TIMEOUT!)
        WHILE DataWaiting%
            C% = ReadChar%
            GOTBACK$ = GOTBACK$ + CHR$(C%)
        WEND
        FOUND% = INSTR(GOTBACK$, RESPOND$)
        GOSUB GetSCANNER
    WEND
'
    IF FOUND% > 0 THEN
        PORTADDR%(Start%) = ADDRS%
        VECTOR%(Start%) = INTER%
        IF MINBAUD&(START%) = 0 THEN MINBAUD&(START%) = Baud&
        IF MAXBAUD&(Start%) < Baud& THEN MAXBAUD&(Start%) = Baud&
        IF CDCMDOFF%(Start%) = 0 THEN CDCMDOFF%(Start%) = -1
        IF DTRCMDOFF%(Start%) = 0 THEN DTRCMDOFF%(Start%) = -1
    END IF
'
    CARRIERDETECT 0                     ' turn CD off
    DTRCONTROL 1                        ' turn DTR on
    SLEEP 1
    GOTBACK$ = ""
    FOUND% = 0
    ClearInputBuffer
    TIMEOUT! = TIMER + 1
    TRANSMIT SEND$ + CHR$(13)
    WHILE (FOUND% = 0) AND (TIMER < TIMEOUT!)
        WHILE DataWaiting%
            C% = ReadChar%
            GOTBACK$ = GOTBACK$ + CHR$(C%)
        WEND
        FOUND% = INSTR(GOTBACK$, RESPOND$)
        GOSUB GetSCANNER
    WEND
'
    IF FOUND% > 0 THEN
        PORTADDR%(Start%) = ADDRS%
        VECTOR%(Start%) = INTER%
        IF MINBAUD&(START%) = 0 THEN MINBAUD&(START%) = Baud&
        IF MAXBAUD&(Start%) < Baud& THEN MAXBAUD&(Start%) = Baud&
        IF CDCMDOFF%(Start%) = 0 THEN CDCMDOFF%(Start%) = -1
        IF DTRCMDON%(Start%) = 0 THEN DTRCMDON%(Start%) = -1
    END IF
'
    CARRIERDETECT 1                     ' turn CD on
    DTRCONTROL 0                        ' turn DTR off
    SLEEP 1
    GOTBACK$ = ""
    FOUND% = 0
    ClearInputBuffer
    TIMEOUT! = TIMER + 1
    TRANSMIT SEND$ + CHR$(13)
    WHILE (FOUND% = 0) AND (TIMER < TIMEOUT!)
        WHILE DataWaiting%
            C% = ReadChar%
            GOTBACK$ = GOTBACK$ + CHR$(C%)
        WEND
        FOUND% = INSTR(GOTBACK$, RESPOND$)
        GOSUB GetSCANNER
    WEND
'
    IF FOUND% > 0 THEN
        PORTADDR%(Start%) = ADDRS%
        VECTOR%(Start%) = INTER%
        IF MINBAUD&(START%) = 0 THEN MINBAUD&(START%) = Baud&
        IF MAXBAUD&(Start%) < Baud& THEN MAXBAUD&(Start%) = Baud&
        IF CDCMDON%(Start%) = 0 THEN CDCMDON%(Start%) = -1
        IF DTRCMDOFF%(Start%) = 0 THEN DTRCMDOFF%(Start%) = -1
    END IF
'
    CARRIERDETECT 1                     ' turn CD on
    DTRCONTROL 1                        ' turn DTR on
    SLEEP 1
    GOTBACK$ = ""
    FOUND% = 0
    ClearInputBuffer
    TIMEOUT! = TIMER + 1
    TRANSMIT SEND$ + CHR$(13)
    WHILE (FOUND% = 0) AND (TIMER < TIMEOUT!)
        WHILE DataWaiting%
            C% = ReadChar%
            GOTBACK$ = GOTBACK$ + CHR$(C%)
        WEND
        FOUND% = INSTR(GOTBACK$, RESPOND$)
        GOSUB GetSCANNER
    WEND
    IF FOUND% > 0 THEN
        PORTADDR%(Start%) = ADDRS%
        VECTOR%(Start%) = INTER%
        IF MINBAUD&(START%) = 0 THEN MINBAUD&(START%) = Baud&
        IF MAXBAUD&(Start%) < Baud& THEN MAXBAUD&(Start%) = Baud&
        IF CDCMDON%(Start%) = 0 THEN CDCMDON%(Start%) = -1
        IF DTRCMDON%(Start%) = 0 THEN DTRCMDON%(Start%) = -1
    END IF
'
    RETURN
'
GetSCANNER:
'
    SELECT CASE SCANCOUNT%
    CASE 0
        SCANCOUNT% = 1
        SCANNER$ = "|"
    CASE 1
        SCANCOUNT% = 2
        SCANNER$ = "/"
    CASE 2
        SCANCOUNT% = 3
        SCANNER$ = "-"
    CASE 3
        SCANCOUNT% = 0
        SCANNER$ = "\"
    CASE ELSE
    END SELECT
'
    ONROW% = CSRLIN                              ' current cursor line
    ONCOL% = POS(0)                              ' current cursor column
    LOCATE ONROW%, ONCOL%, 0
    Status$ = "Want ->" + RESPOND$ + "<- from ADDRESS " + HEX$(ADDRS%) + " at " + STR$(Baud&) + " Baud!"
    Status$ = LEFT$(Status$ + SPACE$(50), 50) + SCANNER$
    IF FOUND% <> 0 THEN
        Status$ = Status$ + SPACE$(4) + "MODEM FOUND!"
    ELSE
        Status$ = Status$ + SPACE$(4) + "MODEM NOT FOUND!"
    END IF
    Status$ = LEFT$(Status$ + SPACE$(78), 78)
    RROW% = CSRLIN
    RCOL% = POS(0)
    CALL QPRINT(Status$, RROW%, RCOL%, 0, 0)
'
    RETURN
'
ReportIt:
'
    Status$ = LEFT$(Status$ + SPACE$(78), 78)
    CALL DMPRINT(Status$ + CRLF$)
    RETURN
'
