/*nfbtrans.c converted from Pascal to C by Randy formenti N8KL*/
/*Ammended to by Brian Buhrow in order to use under the Unix operating
system*/
#ifndef unix
#define LINT_ARGS
#define DOS
#else
#define UNIX_PATH "/usr/local/lib"
#endif		   /* unix */
#ifndef lint
#endif		   /* lint */
#include	<stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#ifdef DOS
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <fcntl.h>
#include <conio.h>
#include <dos.h>
#include <memory.h>
#include <process.h>
#else
#include <string.h>
#include <fcntl.h>
#endif		   /* DOS */
#include <time.h>
#include <signal.h>
#include <errno.h>

#ifdef unix
#define CONFIG_FILE "nfbtrans.cnf"      /* For us Unix types who hate
					 * uppercase */
#define MAXPATHLEN 1023 /* For the longest possible pathname */
#define O_BINARY 0 /* We don't need it here */
/*Definition of mode bits for open*/
#ifndef S_ISUID    /* If we've seen this before, no redefinition */
#define S_ISUID 04000	/* set User id on execution */
#define S_ISGID 02000	/* set Group id on execution */
#define S_ISVTX 01000	/* save text image after termination */
#define S_IREAD 00400	/* read by owner */
#define S_IWRITE 00200	/* write by owner */
#define S_IEXEC 00100	/* execute by owner */
#endif		   /* The following are not usually defined */
#define STD_OPEN 00777	/* rwxrwxrwx */
#define delay(a) delay_unix(a)
#define FOPEN_READ "r"
#define FOPEN_WRITE "w"
#else		   /* DOS */
#define CONFIG_FILE "NFBTRANS.CNF"      /* For those DOS heades */
#define STD_OPEN S_IWRITE	/* Standard DOs open */
#define MAXPATHLEN 127	/* for the longest possible path name in DOS */
#define FOPEN_READ "rt"
#define FOPEN_WRITE "wt"
#endif		   /* unix */

#ifdef _S_IFCHR
#define IFCHR _S_IFCHR
#elif defined(S_IFCHR)
#define IFCHR S_IFCHR
#else
#define IFCHR _IFCHR
#endif

/*defines and defaults*/
#define 	VERSION 	"Version 7.38, \nApril 21, 1995"
#define COPYRIGHT "Written by the National Federation of the Blind and Randy \
Formenti"
#define MAX_MATCH 20
#define MAX_REP 10
#define MAXTAB		1300	/* number of entries in binary table of
				 * braille rules */
#define TABLENAME "braille.tab" /* for DOS or Unix */
#define MAX_FILES 50	/* max # of files stored using wildcard spec in dos */
#define MAX_EXTENSIONS 40	/* # of extensions for auto format */
#define MAX_INIT 45/* max length of pre_init & post_init strings */
#define MAX_TOKENS 40	/* max # of token on a line of .efl file */
#define MAXWORDLEN 132
#define MAX_TOC_ENTRY 250
#define MAX_EFL_DATA 40
#define MAX_EFL_DATA_LEN 40
#define MAX_COL_WIDTH 20	/* in table definition */
#define MAX_DIC_LEN 40	/* max length of word in hyphenation dictionary */
#define TRUE 1
#define FALSE 0
#define BUFSIZE 4096
#define GRADE0 0
#define GRADE1 1
#define GRADE2 2
#define GRADE3 3
#define POETRY 1
# define TEXT 2
#define BLOCK 3
#define LISTS 4
#define BLOCK_PARA 5
#define AUTO_FORMAT 6
#define UPPER 2
#define LOWER 1
#define NUMERIC 4
#define NOTRANS 8

/*global variables*/
char temp[160];
int paramcount;
char **paramstr;
char *options[82] =/* all allowed options alphabetically */
{"BE", "BM", "CA", "CL", "CO", "CS", "DB", "DE", "DM", "DS", "EF", "ET", "EX",
  "FC", "FP", "FS", "GD", "GM", "HD", "HE", "HK", "HM", "HT", "HV", "I0", "I1",
  "I2", "I3", "I4", "I5", "I6", "I7", "I8", "I9", "IA", "IB", "IC", "ID", "IE",
  "IF", "IP", "IT", "KC", "L0", "L1", "L2", "LE", "LF", "LI", "LM", "LS", "MA",
  "MM", "MS", "MT", "NC", "OC", "OW", "PA", "PD", "PE", "PF", "PL", "PN", "PS",
  "PW", "QM", "RW", "S0", "SI", "SO", "SP", "ST", "TC", "TD", "TF", "TM",
"TN", "TP", "TV", "VC", NULL};
char *main_menu[3] = {
  "  1 - Translate a Text File\n",
  "  2 - Emboss a File that has already been Translated\n",
"  3 - Back Translate a Grade Two file\n"};
char *call_prefix[13] =
{"KA", "KB", "KC", "KD", "KE", "K", "N", "WA", "WB", "WD", "W", "VE", NULL};
char single_dot[5] = {"@,'\042"};
char prn[13] = {"prn"};
char stdin_name[13] = {"stdin"};
char *progress[2] = {"Skipping", "On"};
char *token_names[19] = /* used in external format language */
{"D", "T", "L", "SK", "C", "IND", "PAG", "FIE", "O", "ST", "A", "MAT",
"REPL", "REPS*", "REPS", "REPW*", "REPW", NULL};
short token_vals[19] =	/* values for tokens above */
{1, 2, 3, 4, 5, 6, 80, 100, 101, 102, 199, 202, 301, 305, 306, 310, 311, 999};
char *stateid[60] =
{"AK\000Alaska", "AL\000Alabama", "AR\000Arkansas",
  "AZ\000Arizona", "AS\000American Samoa", "CA\000California",
  "CO\000Colorado", "CT\000Connecticut", "CZ\000Canal Zone",
  "DC\000District of Columbia", "DE\000Delaware", "FL\000Florida",
  "GA\000Georgia", "GU\000Guam", "HI\000Hawaii",
  "ID\000Idaho", "IL\000Ilinois", "IN\000Indiana",
  "IA\000Iowa",
  "KS\000Kansas", "KY\000Kentucky", "LA\000Lousiana", "ME\000Maine",
  "MD\000Maryland", "MA\000Massachusetts", "MI\000Michigan",
  "MN\000Minnesota", "MS\000Mississippi", "MO\000Missouri",
  "MT\000Montana", "NE\000Nebraska", "NV\000Nevada",
  "NH\000New Hampshire", "NJ\000New Jersey", "NM\000New Mexico",
  "NY\000New York", "NC\000North Carolina", "ND\000North Dakota",
  "CN\000Northern Mariana Is", "OH\000Ohio", "OK\000Oklahoma",
  "OR\000Oregon", "PA\000Pennsylvania", "PR\000Puerto Rico",
  "RI\000Rhode Island", "SC\000South Carolina", "SD\000South Dakota",
  "TN\000Tennessee", "TT\000Trust Territories", "TX\000Texas",
  "UT\000Utah", ",VT\000Vermont", "VA\000Virginia",
  "VI\000Virgin Islands", "WA\000Washington", "WV\000West Virginia",
"Wi\000Wisconsin", "WY\000Wyoming", NULL};

typedef short BOOL;

/*globals for buffered read*/
char iobuf[BUFSIZE + 1];
unsigned int bytes_in_buf;
char *ioptr, *eolptr;
short timer = 0xe00;	/* default delay timing value only if linked with
			 * nfbasm.asm */
short emboss_delay = 0;
short hot_key = 0; /* no hot keys by default */
short max_menu = 2;/* 2 options printed on main menu */
short ab_flag = 0; /* abort */
short output_case = 1;	/* output uppercase by default */
short it_flag = 0, math_flag = 0;
short stdin_tty = 0, stdout_tty = 0;	/* is stdin or stdout 1 keyboard or 0
					 * file */
short print_date = 0, print_file = 0;	/* prints date and file on first page
					 * if true */
short current_pass, toc_word;
short spool = 0, charspersec = 40;
short keep_together = 0, keep_together_save = 0;
short prog_init;
short file_count, current_file, total_files = 0, total_equasions = 0;
struct tm *tm;

typedef struct
{
  unsigned short startline, endline;
  BOOL lflag;
  short fopstart, fopend, dummy;
}   loptype;

typedef struct
{
  short fop;	   /* operation */
  short fstart;    /* field start */
  short flen;	   /* field length */
  short fappo;	   /* pointer to data */
}   foptype;

typedef struct
{		   /* holds binary form of braille rules */
  short typex[MAXTAB + 1];
  short start1[256];
  short start2[27][27];
  char match[MAXTAB + 1][MAX_MATCH + 1];
  char replace[MAXTAB + 1][MAX_REP + 1];
}   tablet;

typedef struct
{
  short braille, print;
}   toctype;

toctype toc_pages[MAX_TOC_ENTRY], toc_page;

typedef struct
{
  char ext[10];
  short init_val;
}   extension_t;

typedef struct
{
  short total;
  extension_t prog_ext[MAX_EXTENSIONS];
}   prog_ext_t;
prog_ext_t prog_extension;

typedef struct
{
  char pre_init[MAX_INIT + 1], post_init[MAX_INIT + 1], format[3];
}   init_t;
init_t init[15];   /* for i0 - i9 */

typedef char columnt[MAX_COL_WIDTH + 1];

BOOL usr_default = FALSE;
short pagestart = 0, pagestart_save, pageend = -1, pageend_save;
char field_[256];
char *field = field_;
short count, copies, lastcopy = 0, rejoin, quiet_mode = 0, book_mode = 3;
short bpagec, pagenumlen, read_hyphen_file, hyphen_searches, hyphen_matches, hyphen_mode = 0;
short hyphens_used, hyp_dic_tested = 0, split_word = 0;
char token[MAX_TOKENS][40];
short token_count, token_char;
short current_token;
short fopcount, lopcount;
short lineskips = 99, linesperpage = 25;
short maxline = 0, make_sound = 1;
short display_braille = -1;
short display_source = -1;
BOOL printit = TRUE;
short skip_output = 0, over_write = 0, input_file_arg = 0, start_arg = 1;
short graphics_mode = 0;	/* skip chars with b7 set */
short guide_dots = 2;
short keep_control = 0, expand_tab = 0;
short table_entries;
BOOL no_copyright = FALSE;	/* display copyright by default */
short leftmargin = -1;
short capvec[256], subvec[256];
short trans_mode = -1, trans_default = 21;
short pause_time = 0, inf_path_len = 0;
unsigned long total_words, total_dots[8], total_cells, total_lines, emboss_time, config_lines;
time_t time1, time2;
time_t hyp_date_verify[5] = {0, 0, 0, 0, 0};
char hyp_name_verify[5][13];
long in_length, out_length, total = 0l, total_rejoins;
unsigned int hyphen_line_count;
typedef struct
{
  long pos;
  unsigned int line;
}   dictype;
dictype hyphen_dic_start[191];
short efl_mode = FALSE;
BOOL reload_table = TRUE;
char inf_name[MAXPATHLEN] = {0};
char inf_name_ext[10];
char file_name[MAX_FILES][13];
char hyphen_file[40], hyphen_extension[5] = {".hyp"};
char hyphen_dic_name[64] = {0};
char hyphen_dic_line[MAX_DIC_LEN + 1];
char part1[MAX_DIC_LEN + 1], part2[MAX_DIC_LEN + 1];
int outf_des = 0;
FILE *intext = NULL, *lfile, *hyp_ptr, *conf_ptr, *hyp_dic_ptr = NULL, *dic_out_ptr = NULL;
int inf_des, inf_des_save = 0;
char outf_name[49] = {0};
char efl_file[49];
foptype f[40];
char efl_data[MAX_EFL_DATA][MAX_EFL_DATA_LEN + 1];
short appcount, linecount;
BOOL lopactive = FALSE;
unsigned short inpglen = 66;	/* input page length */
char transpath[MAXPATHLEN + 1] = {0};
char table_file[20], active_table[20];
char math_table[20] = {"math.tab"};
char math_symbols[30] = {"=<>"};
char stat_file[MAXPATHLEN + 1] = {0};
char config_file[MAXPATHLEN] = {CONFIG_FILE};
char indent[30] = {"  "};
char format_string[4] = {"~"};
char ignore_format[20] = {0};
char date_string[20];
char *dayofweek[7] = {"sun", "mon", "tue", "wed", "thu", "fri", "sat"};
char s0_init[20] = {0};
char l0[4] = {0};
char l1[4] = {0};
char *l2[10] = {"DE\000\000\000", "HET\000\000", "EEN\000\000", ""};
char vowels[40] = {"AEIOUY\201\202\203\205\210\211\212\213\214\220\223\225\226\227\232\240\241\242\243"};
char consonants[40] = {"BCDFGHJKLMNPQRSTVWXZ\200\207"};
char *t1[6] = {",TITLE\0\0\0\0", ",PR9T\0\0\0\0\0", ",BRL\0\0\0\0\0\0",
"\0\0\0\0\0\0\0\0\0\0", ",PAGE\0\0\0\0\0", ",PAGE\0\0\0\0\0"};
char table_definition[40] = {0}, table_sscan[25] = {"%s %s %s %s %s %s %s %s"};
char italics[4] = {"_"};
char cap_single[4] = {","};
char cap_all[4] = {",,"};
char quotes[4] = {"\042\047"};
short field_width[8];
short cols_in_table, cols_in_line, chars_in_table, chars_in_line;
loptype l[40];
unsigned char dot_table[128] = {	/* braille dot equivilent for each
					 * ascii char, used in statistics
					 * file */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* ascii 0-15 b0 = dot
							 * 1, b1 = dot 2 ... */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* ascii 16-31 */
  0, 46, 16, 60, 43, 41, 47, 4, 55, 62, 33, 44, 32, 36, 40, 12, /* / ascii 32-47 */
  52, 2, 6, 18, 50, 34, 22, 54, 38, 20, 49, 48, 35, 63, 28, 57, /* ? ascii 48-63 */
  8, 65, 67, 73, 89, 81, 75, 91, 83, 74, 90, 69, 71, 77, 93, 75,	/* @-O */
  79, 95, 87, 78, 94, 101, 103, 122, 109, 125, 117, 42, 51, 59, 24, 56, /* _ */
  0, 1, 3, 9, 25, 17, 11, 27, 19, 10, 26, 5, 7, 13, 29, 21,	/* 96-o */
  15, 31, 23, 14, 30, 37, 39, 58, 45, 61, 53, 0, 0, 0, 0, 0,	/* p-127 */
};

unsigned char graph_tab[170] = {
  /* converts ascii representation of braille to ibm graphic characters */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* ascii 0-15 */
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,	/* ascii 16-31 */
  32, 221, 189, 163, 196, 211, 219, 0, 224, 208, 220, 201, 190, 173, 251, 175,	/* 32-47 ' */
  162, 172, 0, 186, 174, 206, 161, 0, 191, 170, 215, 223, 0, 198, 193, 212,	/* 63 27< */
  0, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, /* 64-79 @ */
  240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 188, 197, 252, 253	/* 80-95 */
};

columnt *column = (columnt *) & graph_tab[0];	/* graph_tab unused for now */
char bnumber[] = {"jabcdefghi"};        /* lowercase for 8 dot braille */
tablet *b;
/*variables for do_translate*/
BOOL done;
char oldword[200];
char oldline[256], oldline6[256];
char tline[256];
char fline[256];
char hline[256];
char bline[256];
char bline6[256];
char wline[256];
short blinec, bpageb, bpageh, linelength, fill_length = 6;
short center_length = 30;
short first_page = FALSE;
short curmax;

unsigned char c;
char words[200];
char bword[200];
char bword6[200];

BOOL join, pjoin, rjoin;
BOOL group;
BOOL pgroup;
BOOL xjoin;
BOOL xgroup;
BOOL xpjoin;
BOOL xpgroup;

short xgrade = -1, grade_mod = 0;
BOOL xcenter, find_toc_pages, got_toc_page, last_toc_word = FALSE;
short xformat = -1, xformat_save;
short blank_lines, djoin;
BOOL xdouble, xtab, xacronym, xheading, xfooting, makefoot, makehead, fillit;

BOOL quoteopen, quoteclose;

short margin, point, firstletter, chardec, lastmatch;
char linein[256], *plinein, line_end[4] = {0};
unsigned short lineinct;
BOOL newline;
short quotecount;
BOOL dopagenum = -1;
BOOL doroman, dobook, book_toc, braille_page_nums;
unsigned char tabtable[256];
BOOL disablecol;
short setmargin, oldmargin;
BOOL tabmargin;
BOOL pageset;
char addchar[11], fill_char = '\042';
short actualpage;
short interpoint = FALSE;
char *roman[10] =
{"", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"};
char *roman10[10] = {"", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC"};
struct stat infilestat, outfilestat, hypfilestat;

#ifdef DOS
struct find_t fileinfo; /* wildcard support for dos */
#endif		   /* DOS */

/*function prototypes*/
void top_of_form(void);
void page_beep(void);
void backspace_int(short);
void dofillit(void);
void make_roman(void);
void make_arabic(short *, char *);
void make_book(void);
void bpurge(void);
void format_first_line(void);
void build_line(void);
short split_hyphen_word(short);
void remove_dashes(char *);
void flush_if_not_blank(void);
void add_case(void);
void add_dots(char *);
short get_integer(char *);
short is_equasion(void);
void get_digit(void);
void get_date(void);
void do_commands(void);
void do_lop_op(foptype);
void do_lop(void);
void getline(void);
void get_input(char *, short);
void get_paragraph_type(void);
void check_purge(void);
void get_word(void);
void set_vect(char *);
void do_letter(short, char *);
void do_number(void);
void do_punct(char *);
void build_word(char *, char *);
void check_ham_call(void);
void trans_word(char *);
BOOL store_next_token(void);
void pop_token(char *);
short check_token(void);
void store_commands(void);
void add_efl_data(char *);
void test_range(char *);
void load_template(void);
void do_translate(void);
void translate_word(char *, char *);
void write_stat_file(void);
void advance_page(void);
FILE *open_option_file(char *);
void load_tables(char *);
short search_hyphen_dictionary(char *);
void test_hyphen_dictionary(int);
void translate_file(void);
int open_input_file(void);
void report_open_error(char *);
short test_file_exist(void);
void backtranslate_file(void);
short test_extension(char *);
short search_extensions(char *);
#ifndef __TURBOC__
void delay(int);
void sound(int);
void nosound(void);
#endif
void emboss_file(void);
void spool_file(void);
void get_copies(void);
void get_page_range(void);
void get_config(void);
FILE *open_config_file(int);
void rewrite_config(void);
void write_hv(FILE *);
void process_options(char *);
void open_hyp_dictionary(char *);
void process_table_definition(void);
void trim(char *);
short strpos(char *, char *);
void insert(char *, char *);
void move(char *, char *, short);
void do_pause(void);
void get_printer_file_name(void);
void pause_program(void);
short check_keyboard(short);
void write_toc_header(void);
void write_string(char *, short);
void write_char(char);
void no_space(void);
void sort_names(void);
void copy_string(char *, char *, short);
void delete(char *, int);
void cleanup(int);
void exit_program(int);
void print_error(char *,...);
int ISalpha(char);
int Isdigit(char);
void main(int, char **);
#ifdef unix
extern char *strlwr(char *string);
extern char *strupr(char *string);
extern short getch(void);
extern short getche(void);
extern long filelength(int descriptor);
extern short beep(int count);
extern short kbhit(void);
#endif		   /* unix */

void top_of_form()
{
  short i;
  BOOL dopagesave = dopagenum;
  if (bpagec >= pageend)
  {
    done = TRUE;
    bline[0] = bline6[0] = bword[0] = 0;
    return;
  }
  actualpage++;
  bpagec++;
  if (bpagec > pagestart)
  {		   /* page in range */
    if (lineskips < 99)
      for (i = 0; i < lineskips + linesperpage - blinec; i++)
	write_string(" ", 1);
    else
    {
      if (lineskips == 99)
	write_char(12); /* formfeed */
      else
      {
	if (lineskips == 999)
	  write_string("\13", 0);
	else
	if (lineskips == 9999)
	{	   /* 9999 */
	  write_string("\14", 0);
	  fprintf(stderr, "\nPress Any Key to Continue\7");
	  getch();
	}	   /* 9999 */
      }
    }
  }		   /* page in range */
  blinec = 0;
  keep_together = keep_together_save;
  if (done == FALSE || xfooting == TRUE)
  {		   /* next page */
    pagenumlen = 0;
/*if interpoint mode do not print even page numbers*/
    if (interpoint && (bpagec & 1) == 0)
      dopagenum = FALSE;
    if (dopagenum && ((bpagec > 1 - (first_page > 0)) || pageset) && !xheading)
    {		   /* adjust for page number */
      pagenumlen = (short) (4 + (bpagec > 9) + (bpagec > 99));
      linelength = curmax - pagenumlen - margin - (short) (strlen(addchar) + 1);
    }		   /* adjust for page number */
    else
      linelength = curmax + 1 - margin;
    if (xcenter)
      linelength = center_length;
    dopagenum = dopagesave;
    page_beep();
    if (display_braille)
    {		   /* display_braille */
      sprintf(wline, "Copy %d of %d   page %d", copies, lastcopy, bpagec);
      strcpy(temp, wline);
      i = ((short) strlen(wline) - maxline) >> 1;
      if (i > 0)
      {
	memset(field, 32, maxline);
	strnset(field, '*', i);
	field[i] = 0;
	sprintf(wline, "%s%s%s", field, temp, field);
      }
      if (!skip_output)
	fprintf(stderr, "%s\n", wline);
    }		   /* display_braille */
    else
    if (skip_output + quiet_mode == 0)
    {		   /* report progress */
      sprintf(temp, "%s page %d", progress[(bpagec >= pagestart)], bpagec);
      if (lastcopy > 1)
	sprintf(temp + strlen(temp), " Copy %d of %d", copies,
		lastcopy);
      fprintf(stderr, "%s\n", temp);
    }		   /* report progress */

    if (printit)
      delay(emboss_delay);
  }		   /* next page */
  else
    bpagec--;
}		   /* top_of_form */

void page_beep()
{
  if (make_sound)
  {
#ifndef unix
    sound(2000);
    delay(3);
    nosound();
#else
    beep(1);	   /* Beep terminal */
#endif		   /* unix */
  }
}		   /* page_beep */

void backspace_int(short j)
{		   /* output a packspace so cursor is at first number of
		    * integer */
  do
  {
    j /= 10;
    fprintf(stderr, "%c", 8);
  }
  while (j > 0);
}		   /* backspace_int */

void dofillit()
{
  int i, j;
  fillit = FALSE;
  i = strlen(bline) - 1;
  if (got_toc_page)
  {		   /* add page number to bline */
    bline[curmax] = 0;
    if (book_toc && (book_mode & 4))
    {		   /* store print and braille page numbers */
      make_arabic(&toc_page.print, temp);
      make_arabic(&toc_page.braille, temp + 10);
      sprintf(field, "%5s %5s", temp, temp + 10);
    }		   /* store print and braille page numbers */
    else
      make_arabic(&toc_page.braille, field);
    i += 2;	   /* indexes first character of page number */
    sprintf(bline + i - 1, " %s", field);
  }		   /* add page number to bline */
  else
  {		   /* process last word on line */
    if (i <= 0)
      return;
    /* find out where last word on bline begins */
    while (bline[i] != ' ' && i > 0)
      i--;
    if (bline[i] == ' ')
      i++;
    strcpy(field, bline + i);	/* store the last word of bline */
    if ((short) strlen(field) >= fill_length)
      print_error("\007Last word %s of TOC longer than %d characters in line %ld\n",
		  field, fill_length - 1, total_lines);
  }		   /* process last word on line */
  memset(bline + i, fill_char, maxline - i);	/* fill with quotes dot 5 */
  j = maxline - i - strlen(field) - 1;
  if (j < guide_dots)
    memset(bline + i, ' ', j);  /* remove guide dots */
  i = maxline - strlen(field);
  strcpy(bline + i, field);
  bline[i - 1] = ' ';   /* put blank before last word */
}		   /* dofillit */

void make_roman()
{
  if (bpagec >= 100)
    make_arabic(&bpagec, field);
  else
    sprintf(field, ";%s%s", roman10[bpagec / 10], roman[bpagec % 10]);
  if (!braille_page_nums)
    delete(field, 1);
}		   /* make_roman */

void make_arabic(short *page, char *string)
{
  short i;
  sprintf(string, "#%d", *page);
  if (braille_page_nums)
  {
    i = 1;
    while (string[i])
    {
      string[i] = bnumber[(short) (string[i] - (char) 48)];
      i++;
    }		   /* while */
  }
  else
    delete(string, 1);
  if (page == &bpagec)
    strcat(string, addchar);
}		   /* make_arabec */

void make_book()
{
  make_arabic(&bpageb, field + 1);
  if (bpagec - bpageh > 1)
    field[0] = (char) ((int) ('A') + bpagec - 2 - bpageh);
  else
    delete(field, 1);	/* remove first char of field */
}		   /* make_book */

void bpurge()
{
  short j, guide_line = 0;
  BOOL dopagesave = dopagenum;
  char ch;
  blinec++;	   /* increment current braille line */
  if (bline[0])
  {		   /* bline not empty */
    if (strlen(bline6) > strlen(bline))
      strcpy(bline, bline6);
    ch = bline[curmax];
    bline[curmax] = 0;	/* set bline to <curmax chars long */

    if (margin > 1)
    {		   /* insert space before left margin */
      move(bline, bline + margin - 1, curmax + 1 - margin);
      /* insert space in front of line if necessary */
      memset(bline, 32, margin - 1);	/* fill in left margin with spaces */
    }		   /* insert space before left margin */
  }		   /* bline not empty */

  if (xcenter)
  {		   /* center */
    trim(bline);
    j = (curmax - (short) strlen(bline)) >> 1;
    if (j > 0)
    {
      move(bline, bline + j, (short) strlen(bline));
      memset(bline, 32, j);
    }
    if (newline)
      xcenter = FALSE;
  }		   /* center */

  if (fillit && newline)
  {
    bline[curmax] = ch;
    dofillit();
    guide_line = 1;/* line of toc with dot 5 guidemarks */
  }

  if (blinec == 1)
  {		   /* first line on this page */
    field[0] = 0;
    if (interpoint && (bpagec & 1) == 0)
      dopagenum = FALSE;	/* no even page numbers for interpoint */
    if (((bpagec > 1 - (first_page > 0)) || pageset || dobook) && dopagenum)
    {		   /* store braille page number in field */
      if (doroman)
	make_roman();
      else
      if (dobook && (book_mode & 2))
	make_book();
      else
	make_arabic(&bpagec, field);
      if (guide_line || (fillit && toc_word) || (table_definition[0] && chars_in_table + pagenumlen > curmax))
      { 	   /* cannot have this line on a line with a page number */
	strcpy(bline6, bline);
	bline[0] = 0;
	format_first_line();
	if (bpagec >= pagestart)
	  write_string(bline, 1);
	strcpy(bline, bline6);
	blinec++;
	if (toc_word)
	  write_toc_header();
	field[0] = 0;
      } 	   /* cannot have this line on a page number line */
    }		   /* store braille page number in field */
    else
    if (toc_word)
      write_toc_header();
    dopagenum = dopagesave;
    if (xheading)
    {		   /* xheading */
      printf("xheading = %d\n", xheading);
      getch();
      strcpy(hline + strlen(hline) - strlen(field), field);
      if (bpagec >= pagestart)
	write_string(hline, 1);
      blinec++;
    }		   /* xheading */
    else
      format_first_line();
  }		   /* first line on page */
  else
  if (keep_together)
  {		   /* conditional skip & not first line */
    /* find out if bline has only spaces */
    strcpy(field, bline);
    trim(field);
    if (!field[0] && blinec + keep_together > linesperpage)
    {		   /* skip rest of page */
      blinec--;
      top_of_form();
      return;
    }		   /* skip rest of page */
  }		   /* conditional skip & not first line */

  if (dobook && blinec >= linesperpage && (book_mode & 2))
  {		   /* put braille page in lower right corner */
    make_arabic(&bpagec, field);
    j = (short) strlen(bline);
    memset(bline + j, 32, maxline - j);
    strcpy(bline + maxline - strlen(field), field);
  }		   /* put braille page number in lower right corner. */

  if (bpagec >= pagestart)
  {		   /* output */
    write_string(bline, 1);
    if (xdouble)
      write_string(" ", 1);
  }		   /* output */
  if (xdouble)
    blinec++;

  bline[0] = bline6[0] = 0;
  if (!(xformat == TEXT) || fillit)
    strcpy(bline, indent);
  if (xformat == BLOCK || xformat == BLOCK_PARA)
    bline[0] = '\0';
  strcpy(bline6, bline);
  pjoin = FALSE;
  pgroup = FALSE;
  if (xfooting && (blinec >= linesperpage - 1))
  {		   /* put footing on bottom of current page */
    if (dobook)
    {		   /* adjust footing for braille page in lower right corner */
      make_arabic(&bpagec, field);
      strcpy(oldline, fline);	/* save fline */
      delete(fline, strlen(field) + 1);
      sprintf(fline + strlen(fline), " %s", field);
    }		   /* adjust footing for braille page in lower right corner */
    if (bpagec >= pagestart)
      write_string(fline, 1);
    if (dobook)
      strcpy(fline, oldline);
    blinec++;
  }		   /* put footing on bottom of current page */
  if (blinec >= linesperpage)
    top_of_form();
  else
  if (dobook && (blinec >= linesperpage - 1) && !xfooting)
    linelength = (short) (curmax - pagenumlen - margin + 1);
  else
    linelength = curmax + 1 - margin;
  if (xcenter)
    linelength = center_length;
  newline = FALSE;
}		   /* bpurge */

void format_first_line()
{
  short j;
  j = (short) strlen(bline);
  memset(bline + j, 32, maxline - j);
  strcpy(bline + maxline - strlen(field), field);
}		   /* format_first_line */

void build_line()
{
  short i, j, l, r, build_bpurge = 0, bword_len, dash_pos, bline_len;
  char c;
  i = bline_len = (short) strlen(bline);
  if (xtab)
  {		   /* xtab */
    j = r = 0;
    do
    {
      r++;
      if (tabtable[i + r] != 0)
	j = r;	   /* found tab */
    }
    while (j == 0 && (i + r < linelength));

    if (!j)
      j = 1;
    for (r = 1; r < j; r++)
    {
      strcat(bline, " ");
      strcat(bline6, " ");
    }
    pjoin = pgroup = xtab = FALSE;
  }		   /* xtab */

  if (l1[0] && strcmp(words, l1) == 0)
    pjoin = TRUE;
  if (djoin)
  {		   /* dutch braille l2 */
    djoin++;
    if (djoin == 3)
    {
      djoin = 0;
      for (j = 0; l2[j][0]; j++)
	if (!strcmp(words, l2[j]))
	  pjoin = TRUE;
    }
  }		   /* dutch braille l2 */

  if (!(pjoin || (pgroup && group)))
    i++;	   /* account for space */
  j = i + (short) strlen(bword6);
  bword_len = (short) strlen(bword);
  i += bword_len;

  if (i > linelength || j > linelength)
    build_bpurge++;
  if (l0[0])
    if (strchr(l0, words[strlen(words + 1)]))
      join = TRUE;

  if (rjoin)
  {
    join = TRUE;
    rjoin = FALSE;
  }

  if (fillit)
  {		   /* fillit */
    if (!toc_word)
      write_toc_header();
    toc_word++;
    if (i > linelength -
	fill_length || j > linelength - fill_length)
      build_bpurge++;	/* flush output unless last_toc_word */
    if (last_toc_word)
      build_bpurge = FALSE;	/* do not flush output line, must be
				 * processed by dofillit */
  }		   /* fillit */
  if (build_bpurge)
    if (bline[0] && strcmp(bline, indent))
    {		   /* line not empty or blank */
      if (xgrade && hyp_dic_ptr && fillit == FALSE && bword_len > 3 &&
	  i - bword_len < maxline - 1)
      { 	   /* search hyphenation dictionary */
	dash_pos = search_hyphen_dictionary(words);
	if (dash_pos)
	{	   /* found dictionary word */
	  hyphen_matches++;
	  /* restore original case of word */
	  r = 0;
	  for (j = 0; hyphen_dic_line[j]; j++)
	  {
	    if (hyphen_dic_line[j] == '-' || hyphen_dic_line[j] == '|')
	      continue;
	    if (capvec[r] == LOWER)
	      hyphen_dic_line[j] = (char) tolower(hyphen_dic_line[j]);
	    r++;
	  }	   /* j */
	  do
	  {
	    dash_pos = split_hyphen_word(dash_pos);
	    if (dash_pos)
	    {	   /* test split word */
	      split_word = 1;
	      translate_word(part1, temp);
	      if (i - bword_len + (short) strlen(temp) > linelength)
		continue;	/* split word still too long */
	      hyphens_used++;
	      sprintf(bline + bline_len, " %s", temp);
	      /* remove space if word should join previous word */
	      if (pjoin)
		delete(bline + bline_len, 1);
	      c = format_string[0];
	      format_string[0] = '~';
	      split_word = 2;
	      translate_word(part2, bword);
	      format_string[0] = c;
	      if (hyphen_mode & 8)
		if (fprintf(dic_out_ptr, "%s page %d\n", words, bpagec) < 0)
		  no_space();
	      if (hyphen_mode & 16 && dic_out_ptr == stderr)
		getch();
	      break;
	    }	   /* test split word */
	  }
	  while (dash_pos);
	  split_word = 0;
	}	   /* found dictionary word */
	else
	if (hyphen_mode & 32)
	{	   /* word not found */
	  if (fprintf(dic_out_ptr, "%s page %d not found\n", words, bpagec) <= 0)
	    no_space();
	  if (dic_out_ptr == stderr)
	    getch();
	}	   /* word not found */
      } 	   /* search hyphenation dictionary */
      bpurge();
    }		   /* line not empty or blank */

  if (pjoin || (pgroup && group) || (strcmp(bword, "1") == 0 && xgrade > 0)
      || (bline[0] == '\0'))
  {
    sprintf(bline6, "%s%s", bline, bword6);
    strcat(bline, bword);
  }
  else
  {
    r = (short) strlen(bline);
    if (bline[r - 1] == ' ')
    {
      sprintf(bline6, "%s%s", bline, bword6);
      strcat(bline, bword);
    }
    else
    {
      sprintf(bline6, "%s %s", bline, bword6);
      sprintf(bline + r, " %s", bword);
    }
  }

  if (last_toc_word)
  {		   /* output toc line */
    last_toc_word = FALSE;
    newline = TRUE;
    bpurge();
  }		   /* output toc line */

  if (table_definition[0] && plinein >= eolptr)
  {		   /* table defined & last word on line */
    sscanf(bline, table_sscan, column[0], column[1],
	   column[2], column[3], column[4], column[5], column[6], column[7]);
    for (i = 0; i < cols_in_table; i++)
    {
      if ((short) strlen(column[i]) > field_width[i])
	print_error("\007Field %d > %d characters in line %ld\n", i + 1,
		    field_width[i], total_lines);
      if (column[i][0] == '`' && column[i][1] == '\0')
	column[i][0] = 0;	/* have a column with blanks */
    }		   /* i */
    sprintf(bline, table_definition, column[0], column[1], column[2],
	    column[3], column[4], column[5], column[6], column[7]);
    bpurge();
  }		   /* table defined & last word on line */

  if (!strcmp(bline, "BE"))
    if (xgrade > 1)
      strcpy(bline, "2");       /* braille for be */
  bword6[0] = '\0';
  pgroup = group;
  pjoin = join;
  r = (short) strlen(bline);
  l = curmax - (blinec == 0) * pagenumlen;
  if (r > l)
  {		   /* line too long */
    /* look for repeating characters */
    j = 0;
    c = bline[0];
    for (i = 1; bline[i]; i++)
      if (bline[i] == c)
	j++;
      else
      { 	   /* no repeat */
	j = 0;
	c = bline[i];
      } 	   /* no repeat */
    if (r - j < l)
    {		   /* truncate repeats */
  truncate:
      if (bline[0] == ' ')
	delete(bline, strlen(indent));
      bline[l] = '\0';
      bpurge();
      return;
    }		   /* truncate repeats */
    else
    {		   /* line still too long */
      /* look for double repeats */
      i = (short) (r - 3);
      while (i >= 0)
	if (bline[i] == bline[r - 1] && bline[i - 1] == bline[r - 2])
	  i -= 2;
	else
	  break;
      if (i + 3 < l)
	goto truncate;
      /* no double repeate so continue on next line */
      strcpy(bword, bline + l);
      bline[l] = bword6[0] = '\0';
      build_line();
    }		   /* word still too long */
  }		   /* line too long */
}		   /* build_line */

short split_hyphen_word(short dash_pos)
{
  for (;;)
  {
    dash_pos--;
    if (!dash_pos)
      break;
    if (hyphen_dic_line[dash_pos] == '-')
    {		   /* found rightmost dash */
      strcpy(part2, hyphen_dic_line + dash_pos + 1);
      strlwr(part2);
      strcpy(part1, hyphen_dic_line);
      part1[dash_pos + 1] = 0;
      remove_dashes(part1);
      remove_dashes(part2);
      break;
    }		   /* found rightmost dash */
  }
  return (dash_pos);
}		   /* split_hyphen_word */

void remove_dashes(char *string)
{		   /* remove dashes except if last char of string */
  int i, j = 0;
  for (i = 0; string[i]; i++)
    if (string[i] != '-')
      string[j++] = string[i];
    else
    if (!string[i + 1])
      string[j++] = '-';
  string[j] = 0;
}		   /* remove_dashes */

void flush_if_not_blank()
{
  short i;
  for (i = 0; bline[i]; i++)
    if (bline[i] != ' ')
    {		   /* line contains a nonblank character */
      bpurge();
      break;
    }		   /* line contains a nonblank character */
}		   /* flush_if_not_blank */

short get_integer(char *string)
{		   /* returns integer from string and removes digits. 18hello
		    * becomes hello returning 18 */
  short j = 0, retval = 0, minusflag = 0;
  if (string[0] == '-')
  {
    minusflag = 1;
    j++;
  }
  while (Isdigit(string[j]))
  {
    retval = 10 * retval + (short) (string[j] - (char) 48);
    j++;
  }		   /* while */
  if (j - minusflag)
    delete(string, j);	/* remove digits */
  if (minusflag)
    retval = -retval;
  return (retval);
}		   /* get_integer */

short is_equasion()
{		   /* returns TRUE if word is a mathimatical equasion,
		    * otherwise FALSE */
  if (!strpbrk(words, math_symbols))
    return (FALSE);
  if (strpbrk(words, "0123456789<>"))
  {
    total_equasions++;
    if (math_flag == 2)
      fprintf(stderr, "%ld - %s\n", total_words, words);
    return (1);
  }
  return (0);
}		   /* is_equasion */

void get_digit()
{
  if (hot_key)
  {
    temp[1] = 0;
    temp[0] = (char) getche();
    if (temp[0] <= '\r')
      temp[0] = 0;
    if (temp[0] == (char) 27)
    {		   /* escape */
      fprintf(stderr, "\n");
      exit_program(0);
    }		   /* escape */
  }
  else
    get_input(temp, 80);
}		   /* get_digit */

void get_date()
{		   /* stores date in date_string */
  time(&time1);
  tm = localtime(&time1);
  sprintf(date_string, "%s %02d/%02d/%02d %02d:%02d",
	  dayofweek[tm->tm_wday], tm->tm_mon + 1, tm->tm_mday, tm->tm_year,
	  tm->tm_hour, tm->tm_min);
}		   /* get_date */

void add_dots(char *string)
{
  int dot, i = 0, j;
  while (string[i])
  {
    dot = dot_table[(int) string[i]];
    if (xgrade)
      dot &= 63;   /* remove dot 7 unless we're doing computer braille */
    total_cells++;
    for (j = 0; j < 7; j++)
    {
      if (dot & 1)
	total_dots[j]++;
      dot = dot >> 1;
    }		   /* j */
    i++;
  }		   /* while */
}		   /* add_dots */
void add_case()
{
  short i, j = 0, k;
  BOOL show_caps = TRUE, show_lower = FALSE;
  for (i = 0; words[i]; i++)
  {
    if (isupper(words[i]) && show_caps)
    {		   /* add comma */
      bword[j++] = ',';
      if (isupper(words[i + 1]))
      { 	   /* add another comma */
	bword[j++] = ',';
	show_caps = FALSE;
	show_lower = TRUE;
      } 	   /* add another comma */
    }		   /* add a comma */
    if (islower(words[i]) && show_lower)
    {
      bword[j++] = ';';
      show_lower = FALSE;
      show_caps = TRUE;
    }
    if (words[i] < ' ')
    {
      k = b->start1[(int) words[i]];
      strcpy(bword + j, b->replace[k]);
      j += (short) (strlen(b->replace[k]));
      continue;
    }
    bword[j++] = words[i];
  }		   /* i */
  bword[j] = 0;
}		   /* add_case */

void do_commands()
{
  short tilpos, i, j, k, l, grade_modified = 0;
  unsigned long it_word = 0l;
  char c, *cptr;
  if ((cptr = strpbrk(words, format_string)) == NULL)
    return;	   /* no format commands in word */
  /* assume command will be forced to a new braille line */
  newline = TRUE;

  tilpos = 1 + (short) (cptr - words);
  if (words[tilpos])	/* theres a character after the tilda */
    do
    {
      c = (char) toupper(words[tilpos]);	/* the character after the ~ */
      cptr = words + tilpos - 1;
      if (!strchr("ILZ[", c))
	delete(cptr, 2);	/* for every char except ILZ[ */
      if (strchr("CEFMSTY[_", c))
	flush_if_not_blank();

      switch (c)
      {
      case 'A':   /* Acronym Logic - Betty Desimone */
	xacronym = TRUE;
	newline = FALSE;
	break;
      case 'B':   /* Textbook Break */
	doroman = FALSE;
	dobook = TRUE;
	bpageh = bpagec;	/* set to current page */
	/* blinec is 0 if first line has not been written to page */
	if (blinec < linesperpage)
	  bpageh--;
	bpageb = get_integer(cptr);
	if (!bpageb)
	  bpageb = 1;	/* set to 1 if invalid integer */
	if (book_mode & 1)
	{	   /* mark with dashes */
	  flush_if_not_blank();
	  memset(tline, '-', maxline);  /* dots 3/6 */
	  i = maxline;
	  make_arabic(&bpageb, field);
	  strcpy(tline + maxline - strlen(field), field);	/* put page num at end
								 * of line */
	  if (blinec > 1 && blinec < linesperpage - 1)
	  {	   /* not at top 2 or bottom 2 lines of page */
	    if (bpagec >= pagestart)
	      write_string(tline, 1);
	    blinec++;
	  }	   /* not at top 2 or bottom 2 lines of page */
	  else
	    linelength = (short) (curmax - pagenumlen - margin + 1);
	}	   /* mark with dashes */
	break;
      case 'C':   /* Center */
	xcenter = TRUE;
	if (center_length > (short) (curmax - 6))
	  center_length = (short) (curmax - 6);
	linelength = center_length;
	break;
      case 'D':   /* Double Toggle */
	xdouble ^= xdouble;
	break;
      case 'E':   /* Poetry */
	xformat = POETRY;
	break;
      case 'F':   /* Fill Line - Index table of contents */
	fillit = TRUE;
	/* assume a normal ~f not followed by digit */
	got_toc_page = FALSE;
	fill_length = 6;
	if (Isdigit(*cptr))
	{	   /* process toc mark */
	  i = get_integer(cptr);
	  if (i > MAX_TOC_ENTRY)
	    print_error("\007More than %d TOC entries not allowed\n", MAX_TOC_ENTRY);
	  j = (short) (i - 1);
	  if (current_pass == 1)
	  {	   /* first pass */
	    if (!i)
	    {	   /* one pass required before embossing */
	      if (find_toc_pages)
		goto duplicate;
	      /*
	       * set starting and ending page so program translates entire
	       * file but never writes to disk during first pass
	       */
	      pagestart = pageend = 32767;
	      find_toc_pages = TRUE;
	      fillit = FALSE;
	      break;
	    }	   /* one pass required before embossing */
	    /* in first pass with i in range */
	    if (!find_toc_pages)
	      print_error("\007~f0 not found before ~F%d on line %ld\n",
			  i + 1, total_lines);
	    if (toc_pages[j].braille > 0)
	  duplicate:
	      print_error("\007Duplicate ~f%d entry on line %ld\n", i, total_lines);
	    if (!toc_pages[j].braille)
	    {	   /* toc entry on first pass */
	      toc_pages[j].braille = -1;	/* found first toc mark */
	      got_toc_page = TRUE;	/* page is correct only on second
					 * pass */
	    }	   /* toc entry on first pass */
	    else
	    {	   /* found second toc mark first pass */
	      toc_pages[j].braille = bpagec;
	      toc_pages[j].print = bpageb;
	      if (dobook && (book_mode & 4))
		book_toc = TRUE;
	      fillit = FALSE;	/* title, not actual toc entry */
	    }	   /* second toc entry first pass */
	  }	   /* first pass */
	  else
	  {	   /* second pass */
	    if (!i)
	    {	   /* ~f0 second pass */
	      fillit = FALSE;
	      break;
	    }	   /* ~f0 second pass */
	    if (toc_pages[j].braille)
	    {	   /* first toc entry second pass */
	      toc_page = toc_pages[j];
	      toc_pages[j].braille = 0; /* indicates this contents/title pair
					 * has been processed */
	      got_toc_page = TRUE;
	      if (book_toc)
		fill_length = 12;
	    }	   /* first toc entry second pass */
	    else
	      fillit = FALSE;	/* title entry second pass */
	  }	   /* second pass */
	}	   /* process toc entry */
	else
	if (*cptr == ':')
	{	   /* colen */
	  delete(cptr, 1);
	  fill_length = get_integer(cptr);
	}	   /* colen */
	break;
      case 'G':   /* Set Right Margin */
	i = curmax;
	curmax = get_integer(cptr);
	if (curmax < 1)
	  curmax = 1;
	if (curmax > maxline)
	  curmax = maxline;
	linelength = curmax + 1 - margin;
	break;

      case 'H':   /* Heading */
	strcpy(oldline, bline);
	strcpy(oldline6, bline6);
	xheading = TRUE;
	xpgroup = pgroup;
	xpjoin = pjoin;
	xjoin = join;
	xgroup = group;
	makehead = TRUE;
	bline[0] = 0;
	bline6[0] = 0;
	pgroup = FALSE;
	group = FALSE;
	join = FALSE;
	pjoin = FALSE;
	break;
      case 'I':   /* Italics */
	newline = FALSE;
	words[tilpos] = italics[0];
	if (words[tilpos + 1] == '\\')
	{
	  it_flag += 1;
	  delete(words + tilpos + 1, 1);	/* remove backslash */
	  delete(words + tilpos - 1, 2);
	  if (it_word == total_words)
	  {
	    delete(words, 1);
	    break;
	  }
	  it_word = total_words;
	  for (i = 0; i <= (it_flag & 1); i++)
	    insert(italics, words);
	  if (it_flag == 2)
	    it_flag = 0;
	  break;
	}
	else
	  it_flag = 0;
	if (tilpos > 1)
	{	   /* >=1 char before ~ */
	  if (isalpha(words[tilpos - 2]))
	    words[tilpos - 1] = '-';
	  else
	    delete(words + tilpos - 1, 1);
	}
	else
	{
	  words[tilpos - 1] = italics[0];
	  delete(words + tilpos - 1, 1);
	}
	break;
      case 'J':   /* Stop Heading */
	xheading = FALSE;
	break;
      case 'K':   /* Stop Footing */
	xfooting = FALSE;
	break;
      case 'L':   /* Letter Sign */
	words[tilpos - 1] = '|';        /* don't translate next character */
	words[tilpos] = ';';
	/* newline=FALSE;  */
	break;
      case 'M':   /* Left Margin Set */
	i = margin;
	margin = get_integer(cptr);
	if (margin < 1)
	  margin = 1;
	if (margin > 30)
	  margin = 30;
	linelength += i - margin;
	setmargin += margin - oldmargin;
	oldmargin = margin;
	break;

      case 'N':   /* Set PageNum */
	addchar[0] = 0;
	dopagenum = TRUE;
	doroman = FALSE;
	bpagec = get_integer(cptr);
	if (isupper(words[0]))
	{	   /* uppercase letter followed number */
	  sprintf(addchar, ";%c", words[0]);
	  words[0] = 0;
	}	   /* uppercase letter followed word */
	if (bpagec == 1)
	  pageset = TRUE;
	bpageh = bpagec;
	if (blinec == 0)
	  linelength = curmax - pagenumlen - margin - (short) (strlen(addchar) + 1);
	break;
      case 'O':   /* Offset for Wrap */
	i = get_integer(cptr);
	if (i >= 30)
	  i = 2;   /* keep values reasonable */
	memset(indent, 32, i);
	indent[i] = '\0';
	break;
      case 'P':   /* page */
	if (*cptr == '+' || *cptr == '-')
	{
	  braille_page_nums = FALSE;
	  if (*cptr == '+')
	    braille_page_nums = TRUE;
	  delete(cptr, 1);
	  break;
	}
	if (!Isdigit(cptr[0]))
	{	   /* always skip page */
	  k = 1;
	  if (cptr[0] == ':')
	  {	   /* colon */
	    delete(cptr, 1);
	    i = get_integer(cptr);
	    strcpy(field, bline);
	    trim(field);
	    if (field[0])
	      i++;
	    if (blinec + i < linesperpage)
	      k = -1;	/* no page break */
	  }	   /* colon */

	  if (cptr[0] && isalpha(cptr[0]))
	  {	   /* letter */
	    /* skip to next odd page if interpoint right facing page is odd */
	    if (interpoint && (bpagec & 1))
	      k++;
	    delete(cptr, 1);
	  }	   /* letter */
	  for (l = 0; l < k; l++)
	  {
	    if (blinec >= linesperpage - 1)
	      bpurge(); /* last line on page */
	    else
	    {	   /* not last line on page */
	      flush_if_not_blank();
	      if (dobook)
	      {
		/* we have to put page number in lower right corner */
		j = blinec;
		for (i = j; i < linesperpage; i++)
		  bpurge();
	      }
	      else
		top_of_form();
	    }	   /* not last line on page */
	  }	   /* l */
	}	   /* always skip page */
	else
	{	   /* conditional skip */
	  keep_together = get_integer(cptr);
	  if (keep_together > linesperpage / 2)
	    keep_together = (short) (linesperpage / 2);
	  keep_together_save = keep_together;
	}	   /* conditional skip */
	break;
      case 'Q':   /* clear all tabs */
	memset(tabtable, 0, sizeof(tabtable));
	break;
      case 'R':   /* Roman Numerals */
	doroman = TRUE;
	dobook = FALSE;
	break;
      case 'S':   /* Skip a line */
	bpurge();
	break;
      case 'T':   /* Text Format */
	xformat = TEXT;
	strcat(bline, indent);
	strcpy(bline6, bline);
	line_end[0] = '\0';
	break;
      case 'U':   /* page Numbering Off */
	addchar[0] = 0;
	dopagenum = FALSE;
	break;
      case 'V':   /* set tab */
	i = (short) get_integer(words);
	if (!i)
	  i = 1;
	if (i >= linelength)
	  print_error("\007Tab set beyond line length in line %d\n",
		      lineinct);
	tabtable[i] = 1;
	break;
      case 'W':   /* Footing */
	strcpy(oldline, bline);
	strcpy(oldline6, bline6);
	xfooting = TRUE;
	xpgroup = pgroup;
	xpjoin = pjoin;
	xjoin = join;
	xgroup = group;
	makefoot = TRUE;
	bline[0] = 0;
	bline6[0] = 0;
	pgroup = FALSE;
	group = FALSE;
	join = FALSE;
	pjoin = FALSE;
	break;
      case 'X':
	xtab = TRUE;
	j = get_integer(cptr);
	if (j)
	{
	  for (i = 0; i < j; i++)
	    if ((short) strlen(bline) < linelength)
	      strcat(bline, " ");
	}
	else
	  xtab = TRUE;
	break;
      case 'Y':
	xformat = LISTS;	/* TABLE Format */
	break;
      case 'Z':   /* Terminator */
	words[tilpos] = '`';
	delete(words + tilpos - 1, 1);
	newline = FALSE;
	break;
      case '\47': /* Apostrophe */
	words[tilpos] = '=';
	delete(words + tilpos - 1, 1);
	newline = FALSE;
	break;
      case '_':
	break;
      case '0':   /* Grade 0 */
      case '1':   /* grade 1 */
      case '2':   /* grade 2 */
      case '3':   /* grade 3 */
	if (grade_modified++)
	  print_error(
		      "\007Two grade modifiers in word not allowed in line %ld", total_lines);
	newline = FALSE;
	group = pjoin = FALSE;
	i = xgrade;
	cptr = strchr(ignore_format, c);
	xgrade = (short) (c - '0');
	if (xgrade == 3 && cptr == NULL)
	  reload_table = TRUE;
	if (xgrade >= 2 && cptr == NULL)
	  load_tables(table_file);
	if (xgrade == 3 && cptr == NULL)
	  reload_table = TRUE;
	if (xgrade == 0 || xgrade == 3)
	{	   /* test mod */
	  if (!cptr)
	    grade_mod = 0;
	  if (Isdigit(words[tilpos - 1]))
	  {
	    if (!cptr)
	      grade_mod = (short) (words[tilpos - 1] - (char) 48);
	    delete(words + tilpos - 1, 1);
	  }
	}	   /* test mod */
	if (cptr)
	  xgrade = i;
	break;
      case '4':   /* block */
	newline = FALSE;
	xformat = BLOCK;
	break;
      case '5':   /* blockparagraphs */
	newline = FALSE;
	xformat = BLOCK_PARA;
	break;
      case '6':   /* auto format */
	newline = FALSE;
	xformat = AUTO_FORMAT;
	break;
      case '[':   /* escape */
	i = (short) (tilpos - 1);
	words[i] = (char) 27;	/* escape character */
	delete(words + tilpos, 1);	/* remove the [ */
	do
	{	   /* write escape sequence directly to printer or file */
	  write_char(words[i]);
	  i++;
	}
	while (words[i] != '\0' && words[i] != '~');
	strcpy(words + tilpos - 1, words + i);
	break;
      case '-':   /* process as command line option */
	j = tilpos;
	while (words[j] && words[j] != '~')
	  j++;
	strcpy(temp, words + tilpos - 1);
	strcpy(words + tilpos - 1, words + j);
	temp[j - tilpos + 1] = '\0';
	strupr(temp);
	/* if quoted string, the first quote starts in char 4 xx= */
	if ((temp[3] == '\042' || temp[3] == '\047') &&
	    (strchr(temp + 4, temp[3]) == NULL))
	  while (plinein < eolptr)
	  {
	    get_word();
	    sprintf(temp + strlen(temp), " %s", words);
	    if (strchr(temp + 4, temp[3]))
	    {
	      words[0] = '\0';
	      break;
	    }
	  }	   /* while */
	process_options(temp);
	break;
      case '.':
	j = test_extension(words + tilpos - 1);
	if (j < 0)
	  print_error("\7Excluded extension in line %ld", total_lines);
	strcpy(words, init[j].pre_init);
	break;
      case '~':
	format_string[0] = 0;
	break;
      default:
    bad_format:
	fprintf(stderr, "\007Format error in ");
	if (total_lines)	/* error occurred in input file */
	  print_error("line %ld\n%s", total_lines, linein);
	print_error("i%d=%s|%s\n", prog_init,
		    init[prog_init].pre_init, init[prog_init].post_init);
      } 	   /* switch */
      if (strchr("AL", c) && words[0] == '\0')
	goto bad_format;
      if ((cptr = strpbrk(words, format_string)) != NULL)
	tilpos = 1 + (short) (cptr - words);
    }
    while (cptr != NULL);
}		   /* do_commands */

/*** Execute the Operation ***/
void do_lop_op(foptype fop)
{
  short i, j, k, l;
  if (fop.fop < 100)
  {		   /* not field match or replace */
    switch (fop.fop)
    {
    case 1:	  /* delete */
      linein[0] = 1;
      linein[1] = 0;	/* delete but don't count as blank */
      break;
    case 2:	  /* text */
      xformat = TEXT;
      break;
    case 3:	  /* list */
      xformat = LISTS;
      break;
    case 4:	  /* skip line */
      strcpy(linein, "~S ");
      linein[0] = format_string[0];
      break;
    case 5:	  /* center */
      trim(linein);
      strcpy(field, linein);
      sprintf(linein, "~C%s", field);
      linein[0] = format_string[0];
      break;
    case 6:	  /* indent */
      setmargin = (short) (oldmargin + 2);
      break;
    case 80:	  /* page */
      inpglen = (unsigned short) fop.fstart;
      break;
    }		   /* switch */
    return;
  }		   /* not field match or replace */
  if (!linein[0])
    return;	   /* nothing to do on empty line */
  if (fop.fop < 300)
  {		   /* field or match */
    j = (short) strlen(linein);
    if (j < fop.fstart + 1)
      for (i = j; i <= fop.fstart; i++)
	strcat(linein, " ");    /* fill in line so field isn't garbage */
    strcpy(field, linein + fop.fstart);
    field[fop.flen] = 0;

    if (fop.fop < 200)
    {		   /* field state omit append */
      tabmargin = TRUE;
      delete(linein + fop.fstart, fop.flen);	/* remove field from linein */
      trim(field);

      switch (fop.fop)
      { 	   /* switch op */
      case 101:   /* omit */
	field[0] = 0;
	break;
      case 102:   /* state */
	if (field[0])
	{	   /* field not empty */
	  for (i = 0; stateid[i]; i++)
	  {	   /* i */
	    j = strpos(field, stateid[i]);
	    if (j)
	    {	   /* found state abbreviation */
	      delete(field + j - 1, 2);
	      insert(stateid[i] + 3, field + j - 1);
	      break;
	    }	   /* found state abbreviation */
	  }	   /* i */
	}	   /* field not empty */
      } 	   /* switch */
      if (fop.fappo > 0)
	strcat(field, efl_data[fop.fappo - 1]);
      insert(field, linein + fop.fstart);
      return;
    }		   /* <200 */

/*process match operations which are the only ones left*/
    if ((fop.fappo > 0) && (strpos(field, efl_data[fop.fappo - 1]) > 0))
    {		   /* match string is not empty */
      disablecol = TRUE;
      switch (fop.fop)
      {
      case 201:   /* delete */
	linein[0] = 0;
	break;
      case 202:   /* match */
	disablecol = TRUE;
	break;
      } 	   /* switch */
    }		   /* match string is not empty */
  }		   /* field or match */
  if (fop.fop > 300 && fop.fop < 312)
  {		   /* replace */
    k = 1;
    if (fop.fop == 305 || fop.fop == 310)
    {
      k = 40;
      fop.fop++;
    }
    for (l = 0; l < k; l++)
    {
      strcpy(temp, linein);
      strupr(temp);
      strcpy(field, efl_data[fop.fappo - 1]);
      j = strpos(temp, field);
      if (!j)
	return;
      j--;	   /* relative to zero */
      switch (fop.fop)
      {
      case 301:   /* replace line */
	strcpy(linein, efl_data[fop.fappo]);
	break;
      case 306:   /* replace substring */
	delete(linein + j, strlen(field));	/* remove substring */
	insert(efl_data[fop.fappo], linein + j);
	break;
      case 311:   /* replace word */
	while (linein[j] != ' ' && j > 0)
	  j--;
	if (linein[j] == ' ')
	  j++;
	/* j points to first character of word */
	i = (short) (j + 1);
	while (linein[i] != ' ' && linein[i] != '\0')
	  i++;
	strcpy(linein + j, linein + i); /* remove the word */
	insert(efl_data[fop.fappo], linein + j);
	break;
      } 	   /* switch */
    }		   /* replace */
  }		   /* l */
}		   /* do_lop_op */

/*** Do Line Operation Processing -- outer loop ***/
void do_lop()
{
  short i, j;
  disablecol = FALSE;
  for (i = 0; i < lopcount; i++)
    if (l[i].lflag)/* match active */
      if ((lineinct >= l[i].startline) && (lineinct <= l[i].endline))
      { 	   /* line within range */
	j = l[i].fopstart;
	do_lop_op(f[j]);
	if (disablecol)
	  for (j = (short) (l[i].fopstart + 1); j < l[i].fopend; j++)
	    do_lop_op(f[j]);
      } 	   /* line within range */
  if (!disablecol)
    for (i = 0; i < lopcount; i++)
      if (!l[i].lflag)
	if ((lineinct >= l[i].startline) && (lineinct <= l[i].endline))
	  for (j = l[i].fopstart; j < l[i].fopend; j++)
	    do_lop_op(f[j]);

  if (disablecol)
    tabmargin = FALSE;
}		   /* do_lop */

void getline()
{
  short i = -1, j;
  for (;;)
  {		   /* do until line read, line too long, or eof */
    i++;
    if (!bytes_in_buf)
    {		   /* empty buffer so fill it up */
      bytes_in_buf = read(inf_des, iobuf, (unsigned int) BUFSIZE);
      if (bytes_in_buf <= 0)
      { 	   /* eof */
	done = TRUE;
	if (i > 0 && c != '\n')
	  done = FALSE; /* file ended without crlf */
	break;
      } 	   /* eof */
      ioptr = iobuf;
    }		   /* buffer empty so fill it up */
    c = (char) *ioptr;
    bytes_in_buf--;
    ioptr++;
    if (c >= (unsigned char) 128)
    {		   /* b7 */
      if (!graphics_mode)
	goto skip_char;
      if (graphics_mode == 1)
	c &= 127;  /* remove b7 */
    }		   /* b7 */
    if (c == 31)
      c = '|';
    if (c == '\10' && i > 0)
    {		   /* backspace */
      i -= 2;
      continue;
    }		   /* backspace */
    if (c == (char) 30)
    {
  skip_char:
      i--;
      continue;
    }
    else
      linein[i] = c;
    if (c == '\13' || c == '\14')
      lineinct = 0;
    if (c == '\n')
      break;	   /* actual eol */
    if (c == '\t' && lopactive > 0 && expand_tab > 0)
    {
      c = ' ';
      for (j = 0; j < expand_tab; j++)
	linein[i++] = ' ';
      i--;
    }
    if (i > 170)
    {		   /* look for word break */
      if (c == ' ' || i > 250)
      {
	total_lines--;
	break;	   /* line too long, end at word */
      }
    }		   /* look for word break */
    if (c == '\15')
      goto space;
    if (c < ' ' && keep_control == 0)
  space:linein[i] = ' ';
    /* remove all control chars */
  }		   /* for */
  linein[i] = linein[i + 1] = '\0';
  i--;
  while (i >= 0 && linein[i] == ' ')
    linein[i--] = 0;	/* remove trailing spaces */
  eolptr = linein + i + 1;
  plinein = &linein[0];
  if (inpglen > 0 && lineinct > inpglen)
    lineinct = 0;  /* reset lineinct for next input page. Used by .efl files */
  lineinct++;
  total_lines++;

  if (lopactive)
    do_lop();

  if (display_source)
    printf("=>%s\n", linein);
}		   /* getline */

void get_input(char *string, short length)
{		   /* gets a line of input from stdin up to length bytes */
  short l;
  fgets(string, length, stdin);
  l = (short) (strlen(string) - 1);
  if (string[l] == '\n' && l >= 0)
    string[l] = 0;
}		   /* get_input */

void get_paragraph_type()
{
  short indents = 0, blanks = 0;
  char prev_char = '\1';
  short save_disp = display_source;
  xformat = TEXT;
  if (stdin_tty == 0 || (infilestat.st_mode & IFCHR))
    return;
  display_source = 0, done = FALSE, bytes_in_buf = 0;
  total_lines = 0;
  do
  {
    getline();
    if (linein[0])
    {		   /* line not empty */
      if (prev_char == '\0')
	blanks++;
      if (!strncmp(linein, "    ", 4))
	indents++;
    }		   /* line not empty */
    prev_char = linein[0];
  }
  while (done == FALSE && total_lines < 1000);
  display_source = save_disp;
  if (blanks > indents)
    xformat = BLOCK_PARA;
  linein[0] = '\0';
}		   /* get_paragraph_type */

void check_purge(void)
{		   /* see if line should be written */
  short i, j;
  BOOL purgit = TRUE;
  /* flush unless the first leftmargin-1 chars contain a nonspace char */
  for (i = 0; i < leftmargin; i++)
    /* Determine whether to flush */
    if (linein[i] != ' ' && linein[i] != '\0')  /* when reading a new Line */
      purgit = FALSE;

  if (xformat == LISTS || xformat == BLOCK)
    purgit ^= 1;   /* toggle purgit */
  if (xformat == BLOCK_PARA)
    if (!linein[0])
    {		   /* blank */
      if (!blank_lines++)
	purgit = TRUE;	/* indent since this line is blank */
      else
	purgit = FALSE;
      if (!bline[0])
	purgit = FALSE;
    }		   /* blank */
    else
    {		   /* not blank */
      purgit = FALSE;
      blank_lines = 0;
    }		   /* not blank */

  if (disablecol)
    purgit = TRUE;

  if (purgit)	   /* Check for Indentation */
  {
    newline = TRUE;
    j = -1;
    for (i = 0; bline[i]; i++)
      if (bline[i] != ' ')
	j = i;
    if (j >= 0 || xformat == BLOCK_PARA)
      bpurge();
    bline[0] = 0;
    if (xformat == TEXT || xformat == BLOCK_PARA)
      strcat(bline, indent);
    strcpy(bline6, bline);
    quotecount = 0;
    if (tabmargin)
      margin = setmargin;
    else
      margin = oldmargin;
    tabmargin = FALSE;
  }
}		   /* check_purge */

/***   Extract a Word From the	 ***/
/***   Input Text -- check for	 ***/
/***	      commands		 ***/
void get_word()
{
  char *cptr;
  int l;
  xacronym = FALSE;

  newline = FALSE;
  while (*plinein == '\0' && !done)
  {		   /* blank line and not eof */
    /*
     * line could also be blank because all words were removed from read
     * buffer
     */
    l = strlen(bline);	/* length of pending braille line */
    if (makefoot)
    {		   /* foot */
      makefoot = FALSE; /* only do once for each ~w command */
      memset(fline, 32, curmax);
      fline[linelength] = 0;
      if (bline[0])
	move(bline, fline + linelength - l + 1, (short) (l - 1));
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }		   /* foot */
    if (makehead)
    {		   /* head */
      /* use bline to consstruct header */
      makehead = FALSE; /* only do this once for each ~h command */
      memset(hline, 32, curmax);	/* fill with spaces */
      hline[curmax] = 0;
      if (bline[0])
	move(bline, hline + (linelength - l) / 2, (short) (l - 1));
      strcpy(bline, oldline);
      strcpy(bline6, oldline6);
      pgroup = xpgroup;
      pjoin = xpjoin;
      join = xjoin;
      group = xgroup;
    }		   /* head */
    getline();
    check_purge();
  }		   /* blank line and not eof */

  if (done)
  {
    words[0] = 0;
    return;
  }
  while (*plinein == ' ')
    plinein++;	   /* skip leading blanks */
  cptr = strchr(plinein, ' ');
  if (cptr)
  {		   /* space found */
    *cptr = 0;	   /* put null at end of word */
    strncpy(words, plinein, sizeof(words));
    *cptr = ' ';   /* restore linein */
    plinein = cptr + 1; /* where to search for next word */
  }		   /* space found */
  else
  {		   /* word at end of line */
    strncpy(words, plinein, sizeof(words));
    plinein += strlen(words);	/* we are done with this line */
  }		   /* word at end of line */
  if (strpbrk(words, format_string))
    do_commands();
  words[MAXWORDLEN] = '\0';     /* words shouldn't be longer than that anyway */
  /* change words containing string of _ to -, looks better in braille */
  if (words[0] == '_')
  {		   /* _ */
    l = 0;
    while (words[++l] == '_');
    if (l > 2 && words[l] == '\0')
      strnset(words, '-', l);
  }		   /* _ */
  return;
}		   /* get_word */

void set_vect(char *wordstring)
{		   /* set up the vector for the characters in a word */
  char *wptr = &wordstring[0];
  short *cap_ptr = &capvec[0], *sub_ptr = &subvec[0];
  short i;
  do
  {
    *cap_ptr = *sub_ptr = 0;
    if (*wptr >= '\0')
    {		   /* not graphics character */
      if (isupper(*wptr))
	*cap_ptr = UPPER;
      else
      { 	   /* not uppercase */
	if (islower(*wptr))
	  *cap_ptr = LOWER;
	else
	  if (*wptr == '|' && format_string[0] != '\0' && wptr[1] != '\0' &&
	      isdigit(b->replace[b->start1[48]][0]) == 0)
	{	   /* vertical bar */
	  delete(wptr, 1);	/* delete | */
	  *cap_ptr = NOTRANS;	/* do not translate character after | */
	  *wptr |= 128; /* set b7 on character not to be translated */
	  /* this prevents this char from being a match in do_letter */
	}	   /* vertical bar */
      } 	   /* is not uppercase */
    }		   /* not graphics character */
    else
    {		   /* graphics character */
      *cap_ptr = LOWER;
      i = b->typex[b->start1[(short) (unsigned char) *wptr]];
      if (i == 29)
	*cap_ptr = UPPER;
    }		   /* graphics character */
    wptr++;
    cap_ptr++;
    sub_ptr++;
  }
  while (*wptr);
  strupr(wordstring);
  *cap_ptr = *sub_ptr = 0;
}		   /* set_vect */

/*   Check the extracted word  */
/* against the table of valid  */
/* types:		       */
/*	1-use anywhere	       */
/*	2-must be exact match  */
/*	3-at beginning or all  */
/*	4-only in middle       */
/*	5-joins with same type */
/*	6-joins next-to,into,by*/
/*	7-not at beginning     */
/*	8-the word BE	       */
/*	9-his,was,were,enough  */
/*     10-only at end	       */
void do_letter(short wlength, char *wordstring)
{
  short i, j, k, l, matchend, wstart, casetype;
  BOOL matched;
  char current_match[MAX_MATCH + 1], *next_match;
  lastmatch = count;
  wstart = 0;
  join = group = FALSE;
  matched = FALSE;
  firstletter++;
  subvec[count] = point;	/* subvec indexes single letter in case
				 * there's no match */
  i = (short) (unsigned char) (wordstring[count] - 64);
  if (i <= 0 || i > 26)
    i = point;	   /* graphics or control character */
  else
  {		   /* letter */
    j = (short) (unsigned char) (wordstring[count + 1] - 64);
    if (j <= 0 || j > 26)
    {		   /* not letter */
      i = (short) (point + 1);
      if (b->match[point][0] != b->match[point + 1][0])
	i--;
    }		   /* not letter */
    else
      i = b->start2[i][j];
  }		   /* letter */
/*for example the word this i=20 j=8 and start2[i][j] points to where words
* starting with th start*/
  if (i > 0 && xgrade >= GRADE2 && !xacronym)
    do
    {
      strcpy(current_match, b->match[i]);
      l = (short) strlen(current_match);
      matchend = (short) (count + l - 1);	/* points to last character
						 * of proposed match */

      if (strncmp(current_match, wordstring + count, l))
	goto try_next_match;	/* not a match */

      k = b->typex[i];
      if (firstletter > wstart && (k == 2 || k == 3 || k == 6 || k == 8 ||
				   k == 11 || k == 12))
	goto try_next_match;	/* not a match because not at beginning of
				 * word */
      if (firstletter == wstart)
      { 	   /* at beginning of word */
	if (split_word)
	{	   /* split word */
	  if (k == 2 && strcmp(current_match, b->replace[i]))
	    goto try_next_match;
	  if (k == 7 && split_word == 2)
	    k = 1;
	}	   /* split word */
	if (k == 4 || k == 7 || k == 15)
	  goto try_next_match;	/* these types cannot be at beginning of word */
      } 	   /* at beginning of word */
      j = b->typex[b->start1[(short) wordstring[matchend + 1]]];	/* Next Letter */
      if (j > 0 && j < 19)
      { 	   /* not at end next char is a letter */
	if (k == 2 || k == 6 || k == 10 || k == 12)
	  goto try_next_match;
	if ((k == 13 || k == 15) && strchr(vowels, wordstring[matchend + 1]) == NULL)
	  goto try_next_match;
	if (k == 14 && strchr(consonants, wordstring[matchend + 1]) == NULL)
	  goto try_next_match;
	if (k == 15 && strchr(vowels, wordstring[count - 1]) == NULL)
	  goto try_next_match;
      } 	   /* not at end */
      else	   /* Set end of Word if next char not Letter */
      { 	   /* at end */
	if (k == 4 || (k == 3 && strcmp(current_match, "IN") == 0))
	  /* in [3,4] */
	  goto try_next_match;
	if (k == 11 || k > 12)
	  goto try_next_match;	/* at beginning not all, or French types */

	if (k == 5 && firstletter == wstart && wordstring[wstart] != '\\')
	  group = TRUE; /* join with same type */
	if (pjoin && k == 8)
	  goto try_next_match;
	if (k == 2 && strcmp(current_match, "US") == 0 &&
	    capvec[firstletter] == UPPER && capvec[firstletter + 1] == UPPER)
	  goto try_next_match;
      } 	   /* at end */

      if ((k == 8) && (matchend == wlength - 1)
	  && (wlength != l))
	goto try_next_match;

      if ((k == 9) &&	/* was, his, etc. */
	  ((l != wlength) ||
	   pjoin))
	goto try_next_match;

      if (k == 6)
      {
	if (matchend - wstart + 1 != wlength)
	  goto try_next_match;	/* to Into by */
	join = TRUE;
      }
      if (k == 12)
	djoin = 1;

      casetype = capvec[count];
      if (casetype == LOWER)	/* lowercase */
	for (k = 0; current_match[k + 1]; k++)
	  if (isupper(current_match[k + 1]))
	    if (capvec[count + k + 1] != casetype)
	      goto try_next_match;

      subvec[count] = i;
      count = matchend;
      matched = TRUE;
      break;

  try_next_match:i++;
      next_match = b->match[i];
      if (wordstring[count] < 0 || wordstring[count + 1] < 0)
      {
	if (current_match[0] == next_match[0])
	  current_match[1] = next_match[1];
      }
    }		   /* while */
    while ((!matched) && next_match[1] == current_match[1]);
  quoteopen = quoteclose = FALSE;
}		   /* do_letter */

/***	  Convert NumberS	 ***/
/***	       Type 19		 ***/
void do_number()
{
  if (xgrade == GRADE0)
    return;	   /* check for minus - make in (9) sign */
  firstletter = -1;
  subvec[count] = point;
  capvec[count] = NUMERIC;
  quoteopen = quoteclose = FALSE;
}		   /* do_number */

/*  Convert THE PUNCTUATION    */
/*  Type 21 - Simple Replace   */
/*	 22 - . 	       */
/*	 24 - '                */
/*	 25 - "                */
/*	 27 - - 	       */
void do_punct(char *wordstring)
{
  short i, k;
  BOOL matched;
  char ch = b->match[point][0];
  BOOL apostrophe;

  while (strncmp(b->match[point], wordstring + count, strlen(b->match[point])))
  {
    point++;
    if (b->match[point][0] != ch)
      print_error("\7Unable to match punctuation in line %ld\n", total_lines);
  }		   /* while */

  if (count > 0)   /* Check for capital mark requirement */
    if (lastmatch >= 0)
    {
      k = b->typex[abs(subvec[lastmatch])];
      if (k == 6 || k == 8 || k == 9)
	subvec[lastmatch] = (short) -abs(subvec[lastmatch]);
    }

  matched = FALSE;

  join = group = pgroup = apostrophe = FALSE;
  k = b->typex[point];

  if (k == 24)
  {		   /* apostrophe */
    if ((isupper(wordstring[count - 1]) || isdigit(wordstring[count - 1])) &&
	(isupper(wordstring[count + 1]) || isdigit(wordstring[count + 1])))
      apostrophe = TRUE;
    if ((isupper(wordstring[count - 1]) || isdigit(wordstring[count - 1])) && quotecount == 0)
      apostrophe = TRUE;
    /*
     * if (count - 1 == (int) strlen(words) && (words[count - 1] == 'S' ||
     * words[count - 1] == 'N')) Maybe an apostrophe
     */
  }		   /* apostrophe */
  if (apostrophe == FALSE && (k == 24 || k == 25))
  {		   /* Handle quotes */
    c = wordstring[count - 1];
    if (quoteopen || ((count > 0) &&
	    !(c == '(' || c == '-' || c == '"' || c == '\47' || c == '[') &&
		      !quoteclose))
    {		   /* Ending quote */
      if (quotecount & 1)
	subvec[count] = (short) (b->start1[34] + 1);
      else
	subvec[count] = (short) (b->start1[34] + 3);
      quotecount--;
      quoteopen = TRUE;
    }		   /* ending quote */
    else
    {		   /* Beginning quote */
      if (pjoin)
      {
	pjoin = FALSE;
	strcpy(bline, bline6);	/* reset for to into by */
      }
      quotecount++;
      if (quotecount & 1)
	subvec[count] = b->start1[34];
      else
	subvec[count] = (short) (b->start1[34] + 2);
      quoteclose = TRUE;
    }		   /* beginning quote */
    return;
  }		   /* handle quote */

  do
  {		   /* Find replacement */
    i = (short) (count + strlen(b->match[point]) - 1);
    if (!strncmp(b->match[point], wordstring + count, strlen(b->match[point])))
    {
      matched = TRUE;
      subvec[count] = point;
      count = i;
    }
    else
      point++;
  }
  while (!matched);

  if (b->typex[point] != 27)
    firstletter = -1;
  quoteopen = FALSE;
  quoteclose = FALSE;
}		   /* do_punct */

/***   Build the Word From the	 ***/
/***   Information kept in the	 ***/
/***	 contraction vector	 ***/
void build_word(char *wordstring, char *bwordstring)
{
  BOOL nolow, num = FALSE, allcaps = FALSE;
  short i, i1, j, k;
  bwordstring[0] = bword6[0] = '\0';    /* start with no word */
  bwordstring[MAXWORDLEN] = '\0';       /* tells if word gets too long */

  strcpy(oldword, wordstring);
  for (i = 0; wordstring[i]; i++)
  {
    if (bwordstring[MAXWORDLEN])
      break;	   /* quit before bword overflows */
    if (capvec[i] == NOTRANS)
    {		   /* do not translate this char */
      j = (short) strlen(bwordstring);
      bwordstring[j] = (char) (wordstring[i] & 127);
      bwordstring[j] = (char) toupper(bwordstring[j]);
      bwordstring[j + 1] = 0;	/* only 1 character was added to bword */
    }		   /* do not translate this char */
    else
    if (subvec[i])
    {
      if (subvec[i] < 0)
      {
	nolow = TRUE;
	subvec[i] = -subvec[i];
      }
      else
	nolow = FALSE;

      i1 = subvec[i];
      k = b->typex[i1];
      if ((!num) && ((k == 19)
		     || ((k == 22) && (b->typex[subvec[i + 1]] == 19))))
      {
	if (!isdigit(b->replace[i1][0]))
	  strcat(bwordstring, "#");
	num = TRUE;
	allcaps = FALSE;
	join = FALSE;
	group = FALSE;
	pgroup = FALSE;
      }

      if (k == 19 || k == 21 || k == 23 || k == 24 || k == 25 || k == 27 || k == 28)
	strcat(bwordstring, b->replace[i1]);

      if (k == 22) /* period */
	if (b->typex[subvec[i + 1]] == 19)	/* numeric follows period */
	  strcat(bwordstring, ".");     /* decimal point */
	else
	  strcat(bwordstring, b->replace[i1]);

      if (k == 26)
	/* Percent */
	if (num)
	{
	  j = strpos(bwordstring, "#");
	  if (!j)
	    j++;
	  insert(b->replace[i1], bwordstring + (short) (j - 1));
	}
	else
	  strcat(bwordstring, b->replace[i1]);

      if ((k > 0 && k < 19) || k == 29)
      {
	if (num && strcmp(b->match[i1], "-"))
	{
	  num = FALSE;
	  if (wordstring[i] == 'S' && wordstring[i - 1] != '\47')
	    strcat(bwordstring, "'");
	  if (capvec[i] == LOWER && (wordstring[i] < 'K') &&
	      (!isupper(wordstring[i + 1])))
	    strcat(bwordstring, ";");
	}
	if (allcaps == FALSE && capvec[i] == UPPER)
	{
	  pgroup = FALSE;
	  j = (short) strlen(bwordstring);
	  strcat(bwordstring, cap_single);
	  if (capvec[i + 1] == UPPER)
	  {
	    strcpy(bwordstring + j, cap_all);
	    allcaps = TRUE;
	  }
	}
	if (k == 6)
	{	   /* to into by */
	  sprintf(bword6, "%s%s", bword, b->match[subvec[i]]);
	  if (!strcmp(bword6, "INTO"))
	    strcpy(bword6, "9TO");
	}	   /* to into by */

	if (nolow)
	  strcat(bwordstring, b->match[i1]);
	else
	  strcat(bwordstring, b->replace[i1]);
      }
    }
    if (!strcmp(wordstring, "$"))
    {
      strcpy(bwordstring, "4#");
      strcpy(bword6, bwordstring);
    }
  }		   /* i */
}		   /* build_word */

void check_ham_call()
{
  short i = 0, l = (short) strlen(words), l1;
  if (l > 6)
    return;
  strcpy(temp, words);
  strupr(temp);
  if (strcmp(temp, words))
    return;	   /* not uppercase */
  while (call_prefix[i])
  {
    l1 = (short) strlen(call_prefix[i]);
    if (!strncmp(temp, call_prefix[i], l1))
    {		   /* match */
      if (!isdigit(temp[l1]))
	return;
      xacronym = TRUE;
      strlwr(words + l1 + 1);
      break;
    }		   /* match */
    i++;
  }		   /* while */
}		   /* check_ham_call */

void trans_word(char *wordstring)
{
  short k, l;
  quoteopen = quoteclose = FALSE;
  lastmatch = 0;
  firstletter = count = -1;
  l = (short) strlen(wordstring);
  do
  {
    count++;
    if (capvec[count] != NOTRANS)
    {		   /* not | */
      chardec = (short) (unsigned char) wordstring[count];
      point = b->start1[chardec];	/* = first table entry for this
					 * character */
      k = b->typex[point];
      if (!k)
	print_error("\007Character \042%c\042 decimal %d not in %s line %ld\n",
		    wordstring[count], chardec, active_table, total_lines);
      if ((k == 28 || k == 29) && xgrade > 1)
	if (b->match[point][0] == b->match[point + 1][0])
	{
	  point++;
	  k = b->typex[point];
	}
      if (k <= 15)
	do_letter(l, wordstring);
      else
      { 	   /* not a letter */
	if (k == 19)
	  do_number();
	else
	  do_punct(wordstring);
      } 	   /* not letter */
    }		   /* not | */
  }
  while (wordstring[count + 1]);
}		   /* trans_word */

BOOL store_next_token()
{		   /* removes next token from temp storing it in token[]
		    * increment token_count */
  short retval = FALSE;
  char delim = ' ';
  char *cptr;
  while (temp[0] == ' ')
    delete(temp, 1);	/* remove leading spaces */
  if (temp[0] == (char) 39 || temp[0] == (char) 34)
  {		   /* ' or " */
    delim = temp[0];
    delete(temp, 1);	/* remove delim */
  }
  if (!temp[0])
    return (FALSE);/* empty line */
  if (token_count >= MAX_TOKENS)
    print_error("More than %d tokens on line %d\n", MAX_TOKENS,
		linecount);

  cptr = strchr(temp, delim);
  if (cptr == NULL)
  {		   /* last token on line */
    strcpy(token[token_count], temp);
    temp[0] = 0;
  }		   /* last token */
  else
  {		   /* found matching delim */
    *cptr = 0;
    strcpy(token[token_count], temp);
    strcpy(temp, cptr + 1);
    retval = TRUE;
  }		   /* found delim match */
  token_count++;
  return (retval);
}		   /* store_next_token */

void pop_token(char *string)
{
  string[0] = 0;
  if (current_token >= token_count)
    return;	   /* no more stored tokens */
  strcpy(string, token[current_token]);
  current_token++;
}		   /* pop_token */

short check_token()
{
  int i;
  if (!field[0])
    token_char = 199;
  else
  {		   /* not empty */
    if (atol(field) > 0)
      token_char = 888;
    else
    {		   /* word */
      strupr(field);
      i = -1;
      do
      {
	i++;
	if (!strncmp(field, token_names[i], strlen(token_names[i])))
	  break;
      }
      while (token_names[i] != NULL);
      if (token_vals[i] == 999)
	print_error("Unknown token %s in line %d\n", field, linecount);
      token_char = token_vals[i];
    }		   /* word */
  }		   /* not empty */
  return (token_char);
}		   /* check_token */

void add_efl_data(char *string)
{
  if (appcount >= MAX_EFL_DATA)
    print_error("\007More than %d emf_data entries\n");
  if (strlen(string) > MAX_EFL_DATA_LEN)
    print_error("\007efl_string > %d characters in line %d\n",
		MAX_EFL_DATA_LEN, linecount);
  strcpy(efl_data[appcount], string);
  appcount++;
}		   /* add_efl_data */

void store_commands()
{
  current_token = 0;	/* start from beginning of token list */
  pop_token(field);/* get first token */
  strupr(field);
  if (strcmp(field, "LINE"))
    print_error("Invalid first Operation - must be LINE in line %d\n",
		linecount);

  pop_token(field);
  if (check_token() != 888)
    print_error("No line numbers specified in line %d\n", linecount);

  l[lopcount].startline = (short) atoi(field);	/* starting line */
  l[lopcount].endline = l[lopcount].startline;	/* in case there isn't a
						 * second line number */
  l[lopcount].fopstart = (short) fopcount;	/* where commands start for
						 * this line */
  pop_token(field);
  if (check_token() == 888)
  {		   /* ending line number specified */
    l[lopcount].endline = (short) atoi(field);
    if (l[lopcount].endline < l[lopcount].startline)
      print_error("Ending line less than starting line in line %d\n",
		  linecount);
    pop_token(field);
  }		   /* ending line number specified */

  while (check_token() < 100)
  {		   /* delete skip center indent list text page */
    if (format_string[0] == '\0' && (token_char == 4 || token_char == 5))
      print_error("\007Cannot skip or center lines: formatting is disabled in line %d\n",
		  linecount);
    f[fopcount].fop = token_char;
    pop_token(field);
    if (token_char == 80)
    {		   /* page */
      f[fopcount].fstart = (short) atoi(field);
      pop_token(field);
    }		   /* page */
    fopcount++;
  }		   /* while */

  if (check_token() == 202)
  {		   /* match */
    test_range("match");
    l[lopcount].lflag = TRUE;	/* match subcommand is active */
    f[fopcount].fop = 202;	/* match operation */
    add_efl_data(field);
    f[fopcount].fappo = appcount;	/* index to match data -1 */
    pop_token(field);
    if (check_token() == 1)	/* delete */
      f[fopcount].fop = 201;	/* delete if match */
    fopcount++;
  }		   /* match */

  while (check_token() == 100)
  {		   /* field */
    f[fopcount].fop = 100;	/* indicate a field operation */
    test_range("field");
    f[fopcount].fop = 0;

    if (check_token() > 100 && token_char < 199)
    {		   /* state or omit token */
      f[fopcount].fop = token_char;
      pop_token(field);
    }		   /* state or omit */

    if (check_token() == 199)
    {		   /* append */
      pop_token(field);
      add_efl_data(field);
      f[fopcount].fappo = appcount;
      pop_token(field);
      if (!f[fopcount].fop)
	/* there was no previous state or omit */
	f[fopcount].fop = 199;	/* indicate append operation */
    }		   /* append */
    if (f[fopcount].fop)
      fopcount++;  /* valid field op was found */
  }		   /* while */

  if (token_char >= 301 && token_char <= 311)
  {		   /* replace */
    pop_token(field);
    strupr(field); /* make case insensitive */
    add_efl_data(field);
    if (!field[0])
      print_error("\007No string to replace in line %d\n", linecount);
    f[fopcount].fappo = appcount;
    pop_token(field);
    add_efl_data(field);
    f[fopcount].fop = token_char;
    fopcount++;
  }		   /* replace */
  l[lopcount].fopend = fopcount;
  lopcount++;
}		   /* store_commands */

void test_range(char *string)
{		   /* used in store_commands to test range of match or field
		    * entry */
  int i, fieldpos = 160, op;
  pop_token(field);
  if (check_token() != 888)
  {		   /* no number specified */
    print_error("\007No %s numbers specified in line %d\n", string, linecount);
  }		   /* no number specified */
  f[fopcount].fstart = (short) (abs(atoi(field)) - 1);
  f[fopcount].flen = 1;
  pop_token(field);
  if (check_token() == 888)
  {		   /* got a number */
    i = abs(atoi(field)) - 1;
    f[fopcount].flen = (short) (i - f[fopcount].fstart + 1);
    if (f[fopcount].flen < 1)
      print_error("\007Invalid %s range in line %d\n", string, linecount);
    pop_token(field);
  }		   /* got number */
  if (f[fopcount].fstart + f[fopcount].flen > 160)
    print_error("\007%s specification > 160 in line %d\n", string, linecount);
  for (i = l[lopcount].fopstart; i <= fopcount; i++)
  {
    op = f[i].fop;
    if (op >= 100 && op < 200)
    {		   /* field operation */
      if (f[i].fstart + f[i].flen - 1 >= fieldpos)
	print_error("\007Fields out of order in line %d\n", linecount);
      fieldpos = f[i].fstart;
    }		   /* field operation */
  }		   /* i */
}		   /* test_range */

void load_template()
{
  lfile = fopen(efl_file, FOPEN_READ);
  if (lfile == NULL)
  {		   /* not found */
    if (efl_mode & 1)
      return;	   /* ignore error, translate without .efl file */
    print_error("\007External Format File %s not found ...\n", efl_file);
  }		   /* not found */

  if (efl_mode & 4)
    fprintf(stderr, "External Format File %s\n", efl_file);

  linecount = lopcount = fopcount = appcount = 0;
  /* initialize structures */
  memset(f, 0, sizeof(foptype));
  memset(l, 0, sizeof(loptype));
  memset(efl_data, 0, sizeof(efl_data));
  while (fgets(temp, 100, lfile))
  {		   /* while there are lines to read */
    temp[strlen(temp) - 1] = 0; /* get rid of lf */
    linecount++;
    if (temp[0] == ';' || temp[0] == '#')
      continue;    /* skip comment */
    token_count = 0;	/* tokens found on this line */
    while (store_next_token()); /* store tokens from entire line */
    if (token_count)
      store_commands(); /* tokens were found */
  }		   /* while */
  if (lopcount)
  {
    lopactive = TRUE;
    if (efl_mode & 4)
      fprintf(stderr, "%d External Format lines were Processed\n", linecount);
  }
  else
    fprintf(stderr, "No external format lines were processed\n");
  fclose(lfile);
}		   /* load_template */

void do_translate()
{
  short i, subtotal_eq = 0, grade_save = xgrade;;

  copies++;
  current_pass = 1;
  xformat_save = xformat;
get_next_pass:
  /* initialize variables before translation */
  memset(tabtable, 0, sizeof(tabtable));
  pgroup = pjoin = join = rjoin = group = FALSE;
  xacronym = braille_page_nums = TRUE;
  xcenter = FALSE;
  blank_lines = djoin = 0;
  xtab = dobook = xdouble = xheading = xfooting = FALSE;
  if (current_pass == 1)
    book_toc = FALSE;
  makefoot = makehead = FALSE;
  pageset = FALSE;
  doroman = FALSE;
  pagenumlen = (short) (4 * (dopagenum == TRUE));
  disablecol = FALSE;
  fillit = FALSE;
  quotecount = 0;
  margin = setmargin = oldmargin = 1;
  tabmargin = FALSE;
  bpageb = bpagec = blinec = actualpage = lineinct = inpglen = it_flag = 0;
  total_equasions = toc_word = hyphen_searches = hyphen_matches = 0;
  hyphens_used = 0;
  total_words = total_cells = total_rejoins = total_lines = 0l;
  memset(total_dots, 0, 28);
  field[0] = 0;
  addchar[0] = 0;
  curmax = maxline;
  linelength = maxline + 1 - margin;
  plinein = &linein[0];
  fill_length = 6;
  done = FALSE;
  top_of_form();
  bline[0] = '\0';
  if (!total_words)
  {
    if (print_file)
    {		   /* file */
      strcpy(bline, inf_name + (print_file > 1) * inf_path_len);
      if (!print_date)
	bline[curmax - 4] = '\0';
      else
	bline[20 + 12 * (print_date > 1)] = '\0';       /* leave room for date */
#ifdef DOS
      strlwr(bline);
#endif
    }		   /* file */
    if (print_date)
    {		   /* date */
      if (bline[0])
	strcat(bline, " ");
      if (print_date > 1)
	date_string[12] = '\0';
      strcat(bline, date_string);
      date_string[12] = ' ';
    }		   /* date */
    if (bline[0] && pagestart == 1)
      bpurge();
    bline[0] = 0;
  }

  if (inf_des)
    lseek(inf_des, 0l, 0);	/* start from beginning for each copy */
  bytes_in_buf = 0;/* no bytes in iobuf */
  if (rejoin & 6)
    if (hyp_ptr)
      fseek(hyp_ptr, 0l, 0);	/* only if file is open */
  do
  {
    get_word();
    if (math_flag && (xgrade > 0))
    {		   /* math */
      if (is_equasion())
      { 	   /* equasion */
	subtotal_eq++;
	if (subtotal_eq == 1)
	{
	  reload_table = TRUE;
	  load_tables(math_table);
	}
      } 	   /* equasion */
      else
      if (subtotal_eq)
      {
	subtotal_eq = 0;
	reload_table = TRUE;
	load_tables(table_file);
      }
    }		   /* math */
    if (plinein >= eolptr)
    {		   /* last word on line */
      if (got_toc_page == 0 && (words[0] == '$' || words[0] == '`'))
      { 	   /* last toc word */
	if (words[0] == '`')
	  delete(words, 1);
	last_toc_word = TRUE;
      } 	   /* last toc word */
      if (rejoin)
      {
	i = (short) strlen(words);
	if (i > 1 && words[i - 1] == '-' && ISalpha(words[i - 2]) &&
	    strpbrk(words, "*+/%()") == NULL)
	{	   /* proposed hyphenated word */
	  strcpy(oldword, words);
	  get_word();
	  if (ISalpha(words[0]) && ISalpha(words[1]) &&
	      strchr(words, '-') == NULL)
	  {	   /* join */
	    if (rejoin & 6)
	    {	   /* output to file or stderr */
	      sprintf(temp, "%s %s line %ld page %d\n", oldword, words,
		      total_lines, bpagec);
	      if (rejoin & 4)
	      {    /* read or write hyphen file */
		if (!read_hyphen_file)
		{  /* write */
		  if (!total_rejoins)
		  {
		    hyp_ptr = fopen(hyphen_file, "w");
		    if (!hyp_ptr)
		      print_error("\007Unable to open %s\n", hyphen_file);
		  }
		  if (fprintf(hyp_ptr, temp) < 0)
		    no_space();
		}  /* write */
		else
		{  /* read */
		  fgets(field, 80, hyp_ptr);
		  if (strcmp(temp, field))
		  {
		    rjoin = TRUE;
		    goto no_rejoin;
		  }
		}  /* read */
	      }    /* read or write hyphen file */
	      if (rejoin & 2)
		fprintf(stderr, temp);
	    }	   /* output to file or stderr */

	    strncpy(oldword + i - 1, words, sizeof(words) - i);
	    strcpy(words, oldword);
	    total_rejoins++;
	  }	   /* join */
	  else
	  {	   /* doesn't begin with a letter so don't join */
	no_rejoin:
	    plinein = &linein[0];	/* unget the word */
	    strcpy(words, oldword);
	  }	   /* word doesn't begin with letter so don't join */
	}	   /* proposed hyphenated word */
      }
    }		   /* last word on line */
    if (words[0])
    {		   /* word not empty */
      total_words++;
      if (xgrade)
      { 	   /* grade 1-3 */
	check_ham_call();
	translate_word(words, bword);
      } 	   /* grade 1-3 */
      else
      { 	   /* computer braille */
	if (!grade_mod)
	{	   /* grade 0 no translation */
	  strcpy(bword, words);
	  strcpy(bword6, words);
	}	   /* grade 0 no translation */
	else
	  add_case();
      } 	   /* computer braille */
      if (plinein >= eolptr && line_end[0])
	strcat(bword, line_end);
      build_line();
    }		   /* word not empty */
    if (stdin_tty)
      check_keyboard(1);
  }		   /* while */
  while (!done);
  if (inf_des_save != inf_des)
    close(inf_des);/* close linked file */
  inf_des = inf_des_save;
  if (ab_flag)
    return;
  if (find_toc_pages && current_pass < 2)
  {
    /* look for toc entry without corresponding title */
    for (i = 0; i < MAX_TOC_ENTRY; i++)
    {
      if (toc_pages[i].braille < 0)
	print_error("\007Cannot find matching ~F%d\n", i + 1);
      if (dobook && (book_mode & 4) &&
	  toc_pages[i].braille > 0 && toc_pages[i].print == 0)
	print_error("\7Ink-print page undefined for ~f%d\n", i + 1);
    }		   /* i */
    if (dobook && (book_mode & 4))

      if (bpagec < pagestart_save)
	goto delete;
    current_pass++;
    pagestart = pagestart_save;
    pageend = pageend_save;
    xformat = xformat_save;
    xgrade = grade_save;
    goto get_next_pass;
  }
  if (bpagec < pagestart)
  {
    if (strcmp(outf_name, prn))
    {
  delete:close(outf_des);
      unlink(outf_name);
    }
    return;
  }
  if (strcmp(bline, indent))
  {
    bpurge();
    if (xfooting && blinec > 0)
    {		   /* put footing on last page */
      for (i = (short) (blinec + 2); i <= linesperpage; i++)
	if (bpagec > pagestart)
	  write_string(" ", 1);
      if (bpagec > pagestart)
	write_string(fline, 1);
      blinec = linesperpage;
    }		   /* put footing on last page */
  }

  if (blinec > 0)
  {		   /* advance to top of next page */
    advance_page();
    /* we are at the top of bpagec+1 */
    actualpage++;
  }		   /* advance to top of next page */

  if (interpoint)
  {
    if (!(actualpage & 1))
    {		   /* skip interpoint even page */
      blinec = 0;  /* skip whole page */
      advance_page();
    }		   /* skip interpoint even page */
    if (interpoint > 1)
      for (i = 0; i < 2; i++)
	advance_page();
  }		   /* interpoint */
}		   /* do_translate */

void translate_word(char *wordstring, char *bwordstring)
{
  set_vect(wordstring);
  trans_word(wordstring);
  build_word(wordstring, bwordstring);
}		   /* translate_word */

void write_stat_file()
{
  int i;
  if (bpagec < pagestart)
    return;	   /* no output */
  if (stat_file[0] && intext == NULL)
    intext = fopen(stat_file, "a");
  if (intext != NULL)
  {		   /* open */
    time(&time2);
    time2 -= time1;
    fprintf(intext, "%s\n", date_string);
    if (inf_name[0])
      fprintf(intext, "Input File: %s\n", inf_name);
    fprintf(intext, "Translation time: %ld minutes %ld seconds\n", time2 / 60l, time2 % 60l);
    fprintf(intext, "LinesPerPage: %d\n", linesperpage);
    fprintf(intext, "LineLength: %d\n", curmax);
    fprintf(intext, "Words: %ld\n", total_words);
    fprintf(intext, "Pages: %d\n", bpagec);
    fprintf(intext, "Words per Page: %ld\n", total_words / (long) bpagec);
    if (time2)
    {
      fprintf(intext, "Words per Second: %ld\n", total_words / time2);
      fprintf(intext, "Characters per Second: %ld\n", total_cells / time2);
    }
    if (current_pass == 2)
      fprintf(intext, "Passes: 2\n");
    fprintf(intext, "Estimated Embossing Time: %ld Minutes\n", emboss_time);
    if (total_rejoins)
      fprintf(intext, "Rejoined words: %ld\n", total_rejoins);
    if (hyphen_searches)
      fprintf(intext, "Hyphen Searches: %d\n", hyphen_searches);
    if (hyphen_matches)
      fprintf(intext, "Hyphen Matches: %d\n", hyphen_matches);
    if (hyphens_used)
      fprintf(intext, "Hyphens Used: %d\n", hyphens_used);
    if (total_equasions)
      fprintf(intext, "Equasions: %d\n", total_equasions);
    fprintf(intext, "Total Cells: %ld\n", total_cells);
    total = 0l;
    for (i = 0; i <= 5; i++)
      total += total_dots[i];
    fprintf(intext, "Total Dots: %ld\n", total);
    if (total)
      for (i = 0; i <= 5; i++)
	fprintf(intext, "Dot%d: %6ld = %ld%%\n", i + 1, total_dots[i],
		total_dots[i] * 100l / total);
    if (total_dots[6])
      fprintf(intext, "Dot 7: %6ld\n", total_dots[6]);
    if (in_length)
      fprintf(intext, "Input file length: %ld\n", in_length);
    fprintf(intext, "Output file length: %ld\n", out_length);
    if (!ab_flag)
      if (in_length != 0l && ab_flag == 0 && out_length != 0)
	fprintf(intext, "Output is %ld%% of input\n", 100l * out_length / in_length);
    if (ab_flag)
      fprintf(intext, "Aborted\n");
    fprintf(intext, "Entries in table: %d\n\n", table_entries);
  }		   /* open */
}		   /* write_stat_file */

void advance_page()
{
  short i;
  if (lineskips < 99)
    for (i = blinec; i < linesperpage + lineskips; i++)
    {
      write_string(" ", 1);     /* do it with linefeeds */
    }
  if (lineskips == 99)
    write_char(12);/* do it with a formfeed */
  if (lineskips == 999)
    write_char(11);/* vertical tab no lf */
  if (lineskips == 9999)
  {
    write_string("\14", 0);     /* formfeed with linefeed */
    printf("\nTo Continue, Press Return\n");
    getch();
  }
}		   /* advance_page */

FILE *open_option_file(char *name)
{		   /* store file name in temp and attempt to open for reading */
  char *f = field + 10;
  FILE *fptr;
  strcpy(f, name);
  if (name[0] == '/' || name[1] == ':')
    strcpy(temp, f);	/* path already specified */
  else
    sprintf(temp, "%s%s", transpath, f);
  if ((fptr = fopen(temp, FOPEN_READ)) == NULL)
    report_open_error(temp);
  return (fptr);
}		   /* open_option_file */

void load_tables(char *table_name)
{
  short j, k, error = 0, current_line = 0;
  char match[20], prev_match[20];
  short lenmat, lenrep, typex;
  FILE *btable;
  char *ver_bar, *c, *bracket;
  if (!reload_table)
    return;
  reload_table = FALSE;
  btable = open_option_file(table_name);
  strcpy(active_table, table_name);
  table_entries = 0;
  memset(b, 0, sizeof(tablet)); /* fill in structure with zeros */
  prev_match[0] = '\0'; /* forces mismatch between match and prev_match on
			 * first line */
  while (fgets(temp, 80, btable))
  {		   /* while there are lines to read */
    current_line++;
    trim(temp);
    /* skip blank lines and comments starting with ; or # */
    if (temp[0] < ' ' || temp[0] == ';' || temp[0] == '#')
      continue;
    strupr(temp);
    if (isalpha(temp[0]) && temp[2] == '=')
    {
      process_options(temp);
      continue;
    }
    if ((ver_bar = strchr(temp, '|')) == NULL)
    {		   /* error */
  no_ver_bar:error++;
      fprintf(stderr, "\7Improper placement of | error in line %d\n",
	      current_line);
      break;
    }		   /* error */
    *ver_bar = (char) 0;
    typex = (short) atoi(temp);
    *ver_bar = '|';/* restore temp */
    c = ver_bar + 1;	/* beginning of match */
    if ((ver_bar = strchr(ver_bar + 1, '|')) == NULL)
      goto no_ver_bar;
    *ver_bar = (char) 0;
    do
    {
      bracket = strchr(c, '[');
      if (bracket && bracket[1] >= '0' && bracket[1] <= '9')
      {
	if (!strchr(bracket, ']'))
	  print_error("\7Unmatched bracket in line %d\n", current_line);
	bracket[0] = (unsigned char) get_integer(bracket + 1);
	delete(bracket + 1, 1);
      }
      else
	bracket = NULL;
    }
    while (bracket);
    lenmat = (short) strlen(c);
    if (lenmat > MAX_MATCH)
    {		   /* too long */
      fprintf(stderr, "\7Match more than %d characters in line %d\n%s\n",
	      MAX_MATCH, current_line, temp);
      error++;
      break;
    }		   /* too long */
    if (*c >= '0' && *c <= '9' && c[1] >= '0' && c[1] <= '9')
    {
      match[0] = (char) atoi(c);
      match[1] = '\0';
      lenmat = 1;
    }
    else
      strcpy(match, c);
    *ver_bar = '|';/* restore temp */
    c = strchr(ver_bar, ' ');
    if (c)
      *c = '\0';   /* remove extra comment words after table entry */
    lenrep = (short) strlen(ver_bar + 1);
    if (lenrep > MAX_REP)
    {		   /* replace too long */
      fprintf(stderr, "\7Replace more than %d characters in line %d\n%s\n",
	      MAX_REP, current_line, temp);
      error++;
      break;
    }		   /* replace too long */
    if (table_entries >= MAXTAB)
    {		   /* too many entries */
      fprintf(stderr, "\7More than %d entries in table not allowed\n", MAXTAB);
      error++;
      break;
    }		   /* too many entries */
    if (typex <= -32 || typex >= 64)
    {		   /* bad type */
  bad_type:fprintf(stderr, "\7Invalid type %d in line %d\n", typex, current_line);
      error++;
      break;
    }		   /* type error */
    if (xgrade == GRADE3)
    {		   /* grade 3 */
      if (grade_mod == 0 && typex < 0)
	continue;  /* skip unwanted g2 entry */
      typex = (short) abs(typex);
      if (typex > 32 && grade_mod > 0)
      { 	   /* grade_mod nonstandard grade 3 */
	/* skip entries other than dot 4 5 45 and 456 contractions */
	if (!strpbrk(ver_bar + 1, "@\042^_"))
	  continue;
	temp[1] = '\0';
	temp[0] = ver_bar[2];
	if ((grade_mod & 1) && (isupper(temp[0])))
	  goto keep_entry;
	if ((grade_mod & 2) && (Isdigit(temp[0])))
	  goto keep_entry;
	if ((grade_mod & 4) && (strpbrk(temp, single_dot) == NULL)
	    && (grade_mod & 3) == 0)
	  goto keep_entry;
	if ((grade_mod & 8) && strpbrk(temp, single_dot))
	  goto keep_entry;
	continue;
      } 	   /* grade_mod */

  keep_entry:
      typex &= 31;
    }		   /* grade 3 */
    else
    if (typex > 32)
      continue;    /* skip g3 entry */
    if (typex > 29 || (typex > 15 && typex < 19))
      goto bad_type;
    if (table_entries > 0)	/* store previous match in prev_match */
      strcpy(prev_match, b->match[table_entries]);
    table_entries++;	/* we found a valid line, store results */
    b->typex[table_entries] = (short) abs(typex);
    strcpy(b->match[table_entries], match);
    strcpy(b->replace[table_entries], ver_bar + 1);
    j = (short) (match[0] - '@');
    if (j < 0 || j > 27)
      j = 0;
    if (strcmp(prev_match, match) >= 0)
      if (strncmp(prev_match, match, lenmat))
      {
	fprintf(stderr, "\007Sorting error in line %d\n", current_line);
	error++;
	break;
      }
    if (match[0] != prev_match[0])
    {		   /* first characters differ */
      if (lenmat != 1 && match[0] >= 'A' && match[0] <= 'Z')
      { 	   /* error */
	fprintf(stderr, "\007Match should be a single character in line %d %s\n"
		,current_line, temp);
	error++;
	break;
      } 	   /* error */
      b->start1[(short) (unsigned char) (match[0])] = table_entries;
      b->start2[j][0] = table_entries;
    }		   /* first characters differ */
    else
    if ((match[1] != prev_match[1]))
    {		   /* second element of match and previous match differ */
      k = (short) (match[1] - '@');
      if (k < 0 || k > 27)
	k = 0;
      b->start2[j][k] = table_entries;
    }		   /* second elements differ */
  }		   /* while */
  fclose(btable);
  if (error)
    print_error("Correct error in %s and restart program.\n", table_name);
}		   /* load_tables */

short search_hyphen_dictionary(char *string)
{		   /* returns length of word if in dictionary otherwise 0 */
  int k, l, index, string_len;
  char *cptr, *h;
  char hword[MAX_DIC_LEN + 1], prev = 'A';
  if (!(hyphen_mode & 1))
    return (0);    /* not active */
  if (hyphen_mode & 4)
  {		   /* test for dash */
    cptr = strchr(string, '-');
    if (cptr)
    {		   /* found dash */
      cptr--;
      if (isalpha(cptr[0]) && isalpha(cptr[2]))
      { 	   /* - between letters */
	string[MAX_DIC_LEN] = '\0';
	strcpy(hyphen_dic_line, string);
	hyphen_searches++;
	hyphen_line_count = 0;
	string_len = strlen(string);
	if (string[string_len - 1] == '-')
	  string_len--;
	return ((short) string_len);
      } 	   /* - between letters */
    }		   /* found dash */
  }		   /* test for dash */
  if (hyphen_mode & 2)
  {		   /* test for punctuation */
    string_len = (int) (strlen(string) - 1);
    cptr = strpbrk(string + 1, ".!?,:");
    if (cptr)
    {		   /* ends in punctuation */
      strcpy(temp, cptr);
      *cptr = '\0';
    }		   /* ends in punctuation */
  }		   /* test for punctuation */
  index = (int) (unsigned char) string[0] - 65;
  if (index < 0 || index > 191)
    return (0);    /* search word doesn't begin with a letter */
  hyphen_searches++;	/* for statistics file */
  /*
   * seek to where word with this letter starts otherwise where previous
   * letter starts
   */
  while (index > 0 && hyphen_dic_start[index].pos == 0l)
    index--;
  fseek(hyp_dic_ptr, hyphen_dic_start[index].pos, 0);
  hyphen_line_count = hyphen_dic_start[index].line;
  while (fgets(hyphen_dic_line, MAX_DIC_LEN, hyp_dic_ptr))
  {
    hyphen_line_count++;
    l = strlen(hyphen_dic_line);
    hyphen_dic_line[l - 1] = 0; /* remove lf */
    if (prev != hyphen_dic_line[0])
    {		   /* first word starting with this letter */
      index = (int) (unsigned char) hyphen_dic_line[0] - 65;
      if (index < 1 || index > 191)
      {
	fprintf(stderr,
		"\7Line %s in %s must begin with letters or extended \n",
		hyphen_dic_line, hyphen_dic_name);
	print_error("graphics characters\n");
      }
      if (!hyphen_dic_start[index].pos)
      { 	   /* store word position */
	hyphen_dic_start[index].pos = ftell(hyp_dic_ptr) - (long) (l + 1);
#ifdef unix
	hyphen_dic_start[index].pos++;	/* no cr in unix */
#endif
	hyphen_dic_start[index].line = hyphen_line_count - 1;
      } 	   /* store word position */
      prev = hyphen_dic_line[0];
    }		   /* first word starting with this letter */
    /* build hword by removing all dashes & | from the line */
    k = 0;
    h = hyphen_dic_line;
    for (; *h; h++)
      if (*h != '-' && *h != '|')
	hword[k++] = *h;
    hword[k] = 0;
    k = strcmp(hword, string);
    if (k < 0)
      continue;
    if (k > 0)
      return (FALSE);
    if (cptr)
    {		   /* restore punctuation */
      strcpy(cptr, temp);
      strcat(hyphen_dic_line, temp);
    }		   /* restore punctuation */
    return (short) (l - 2);
  }		   /* while */
  return (FALSE);
}		   /* search_hyphen_dictionary */

void test_hyphen_dictionary(int mode)
{
  int i, l;
  unsigned k, total = 0, dash_line = 0, long_line = 0, max_len = 0, max_dash = 0;
  char hword[MAX_DIC_LEN + 1], prevword[MAX_DIC_LEN + 1];
  if (mode == 1)
    fprintf(stderr, "Checking consistency of %s Please Wait...\n", hyphen_dic_name);
  hyp_dic_tested = TRUE;
  prevword[0] = 0;
  fseek(hyp_dic_ptr, 0l, 0);
  while (fgets(temp, 80, hyp_dic_ptr))
  {
    total++;
/*test for uppercase*/
    strcpy(field, temp);
    strupr(field);
    if (strcmp(field, temp))
      print_error("\7Line %u must be uppercase\n", total);
    if (!strchr(temp, '-'))
      print_error("\7- not found in line %u\n", total);
    k = strlen(temp);
    if (temp[k - 2] == '-')
      print_error("\7Word ends with - line %u\n", total);
    if (k > max_len)
    {
      max_len = k;
      long_line = total;
      if (k > MAX_DIC_LEN)
	print_error("\7Word > %d characters in line %u\n", MAX_DIC_LEN, total);
    }
    /* build hword by removing all dashes from temp */
    k = l = 0;
    for (i = 0; temp[i]; i++)
      if (temp[i] != '-' && temp[i] != '|')
	hword[l++] = temp[i];
      else
	k++;
    if (k > max_dash)
    {
      max_dash = k;
      dash_line = total;
    }
    hword[l] = 0;
    l = strcmp(hword, prevword);
    if (l < 0)
      print_error("\7Sorting error in line %u\n", total);
    strcpy(prevword, hword);
  }		   /* while */
  if (!mode)
  {
    fprintf(stderr, "Longest word is %u characters in line %u\n", max_len, long_line);
    fprintf(stderr, "Maximum hyphens %u in line %u\n", max_dash, dash_line);
  }
}		   /* test_hyphen_dictionary */

void get_config()
{
  short i;
  char *c, *cptr;
  if (!total_files)
  {		   /* first time called */
    if (paramcount > 0)
    {		   /* test for cf= */
      strcpy(temp, paramstr[1]);
      strupr(temp);
      if (!strncmp(temp, "CF=", 3))
      { 	   /* new config file */
	strcpy(config_file, paramstr[1] + 3);
	start_arg++;
      } 	   /* new config file */
    }		   /* test for cf= */
    /*
     * use nfbtrans environment variable, current directory, and then program
     * or unix path
     */
    c = (char *) getenv("NFBTRANS");
    if (c)
    {		   /* nfbtrans defined */
      strcpy(transpath, c);
#ifdef DOS
      strcat(transpath, "\\");
#else
      strcat(transpath, "/");
#endif
    }		   /* nfbtrans defined */
    if (!open_config_file(0))
    {		   /* not in environment */
      transpath[0] = '\0';
      if (!open_config_file(0))
      { 	   /* not in environment or current directory */
#ifdef DOS
	strcpy(transpath, paramstr[0]);
	c = strrchr(transpath, '\\');
	if (c)
	  c[1] = 0;/* we have program path */
	else
	  transpath[0] = '\0';
#else
	strcpy(transpath, UNIX_PATH);
#endif
	open_config_file(1);
      } 	   /* not in current dir or environment */
    }		   /* not in environment */
  }		   /* first time called */
  else
    fseek(conf_ptr, 0l, 0);
  config_lines = 0l;
  while (fgets(temp, 150, conf_ptr))
  {		   /* while there are lines to read */
    config_lines++;
    if (strlen(temp) > 145)
      print_error("\7Line too long in %s%s\n", transpath,
		  config_file);

    strupr(temp);
    trim(temp);
    if (temp[0] == '\n' || temp[0] == ';' || temp[0] == '#')
      continue;    /* skip */
    cptr = strchr(temp, ' ');
    if (cptr)
      if (!strchr(quotes, temp[3]))
	*cptr = 0; /* allows comments starting with second word */
    process_options(temp);
  }		   /* while */
  if (hyp_dic_ptr && hyp_dic_tested)
    rewrite_config();
  config_lines = 0l;
  if (!total_files)
    for (i = start_arg; i <= paramcount; i++)
    {
      if (paramstr[i][2] == '=')
      { 	   /* xx= */
	strupr(paramstr[i]);
	process_options(paramstr[i]);
      } 	   /* xx= */
      else
      { 	   /* not xx= */
	usr_default = TRUE;
	/*
	 * if input is from keyboard assume arguments are input files. Else
	 * ignore
	 */
	if (stdin_tty)
	  input_file_arg = i;
	break;
      } 	   /* not xx= */
    }		   /* i */
  if (!stdin_tty)
  {
    inf_des = 0;
    usr_default = TRUE;
  }
  if (!stdout_tty)
  {
    outf_des = 1;
#ifdef DOS
    setmode(1, O_BINARY);
#endif
    trans_mode = 11;
  }
  if (usr_default)
  {
    display_source = FALSE;
    lastcopy = 1;
    if (pagestart <= 0)
      pagestart = 1;
    if (pageend < pagestart)
      pageend = 9999;	/* print entire document */
    if (leftmargin < 1)
      leftmargin = 1;
    if (maxline <= 1)
      maxline = 40;
    if (linesperpage <= 0)
      linesperpage = 25;
    if (lineskips < 0)
      lineskips = 99;
    if (trans_mode <= 0)
      trans_mode = 21;
    display_braille = 0;
  }
}		   /* get_config */

FILE *open_config_file(int mode)
{
  sprintf(temp, "%s%s", transpath, config_file);
  conf_ptr = fopen(temp, FOPEN_READ);
  if (mode && conf_ptr == NULL)
    print_error("\007%s not found\n", config_file);
  return (conf_ptr);
}		   /* open_config_file */

void rewrite_config()
{
  int h_v = 0;
  FILE *f;
  rewind(conf_ptr);
  sprintf(field, "%snfb%d", transpath, getpid());
  f = fopen(field, "w");
  if (!f)
    print_error("\7Cannot open %s\n", field);

  while (fgets(temp, 100, conf_ptr))
  {		   /* while there are lines to read */
    strcpy(iobuf, temp);
    strupr(temp);
    trim(temp);
    if (!strncmp(temp, "HV=", 3))
      continue;
    if (!strncmp(temp, "HD=", 3))
    {		   /* write hp= option */
      h_v++;
      write_hv(f);
    }		   /* write hp= option */
    if (fprintf(f, "%s", iobuf) < 0)
      no_space();
  }		   /* while */
  if (!h_v)
    write_hv(f);
  fclose(f);
  fclose(conf_ptr);
  sprintf(temp, "%s%s", transpath, config_file);
  unlink(temp);
  rename(field, temp);
  open_config_file(1);
}		   /* rewrite_config */

void write_hv(FILE * f)
{		   /* write hv= option into nfbtrans.cnf */
  int j;
  strcpy(temp, "hv=");
  for (j = 0; j < 5; j++)
    sprintf(temp + strlen(temp), "%s=%ld|", hyp_name_verify[j], hyp_date_verify[j]);
  temp[strlen(temp) - 1] = '\0';
  fprintf(f, "%s\n", temp);
}		   /* write_hv */

void process_options(char *string)
{
  short j, x;
  char *cptr = string + 3, *vptr, *eptr, delim;
  for (j = 0; options[j] != NULL; j++)
  {
    if (!strncmp(string, options[j], 2))
    {		   /* option matched */
      if (*cptr <= ' ')
	j = -1;    /* error since nothing follows xx= */
      vptr = strchr(quotes, cptr[0]);
      if (vptr)
      { 	   /* quoted string */
	delim = *cptr;
	delete(cptr, 1);
	vptr = strchr(cptr, delim);
	if (vptr == NULL)
	{
	  if (config_lines)
	    total_lines = config_lines;
	  print_error("\007Unmatched quoted string in line %ld",
		      total_lines);
	}
	vptr[0] = 0;
      } 	   /* quoted string */
      x = (short) atoi(cptr);	/* saves multiple calls to atoi */
      switch (j)
      {
      case 0:	  /* be */
#ifdef DOS
	sound(x);
	get_integer(cptr);
	x = 0;
	if (cptr[0])
	  x = get_integer(cptr + 1);
	if (!x)
	  x = 500;
	delay(x);
	nosound();
#endif
	break;
      case 1:	  /* bm */
	book_mode = x;
	if (book_mode & 8)
	  book_mode |= 4;	/* make sure book TOC bit is set */
	break;
      case 2:	  /* ca */
	vptr = strchr(cptr, '|');
	if (!vptr)
	  goto no_ver_bar;
	*vptr = '\0';
	strncpy(cap_single, cptr, sizeof(cap_single));
	strncpy(cap_all, vptr + 1, sizeof(cap_all));
	break;
      case 3:	  /* cl */
	center_length = x;
	break;
      case 4:	  /* co */
	lastcopy = x;
	break;
      case 5:	  /* cs */
	charspersec = x;
	break;
      case 6:	  /* db */
	display_braille = x;
	break;
      case 7:	  /* de */
	emboss_delay = x;
	break;
      case 8:	  /* dm */
	fprintf(stderr, "%s\n", cptr);
	break;
      case 9:	  /* ds */
	display_source = x;
	break;
      case 10:	  /* ef */
	efl_mode = x;
	break;
      case 11:	  /* et */
	expand_tab = x;
	break;
      case 12:	  /* ex */
	if (total_lines)
	  print_error("\007ex option allowed only in nfbtrans.cnf or on command line\n");
	if (total_files)
	  break;   /* only get once from nfbtrans.cnf */
	for (;;)
	{
	  if (prog_extension.total >= MAX_EXTENSIONS)
	    print_error(
	      "\007Too many extensions.  only the first %d can be stored\n",
			MAX_EXTENSIONS);
	  vptr = strchr(cptr, '=');
	  if (vptr == NULL)
	    break; /* no more extensions */
	  *vptr = 0;	/* terminate extension */
	  if (strlen(cptr) > 8)
	    goto invalid;
	  strcpy(prog_extension.prog_ext[prog_extension.total].ext, cptr);
	  *vptr = ' ';  /* in case theres an error */
	  x = (short) (vptr[1] - 48);
	  if (vptr[1] == '-')
	    vptr[1] = '0';
	  if (x > 9)
	    x -= 7;
	  if (x > 14 || isxdigit(vptr[1]) == 0)
	    goto invalid;
	  prog_extension.prog_ext[prog_extension.total].init_val = x;
	  cptr = vptr + 2;
	  prog_extension.total++;
	}
	break;
      case 13:	  /* fc */
	fill_char = *cptr;
	break;
      case 14:	  /* fp */
	first_page = x;
	break;
      case 15:	  /* fs */
	copy_string(format_string, cptr, 3);
	break;
      case 16:	  /* gd */
	guide_dots = x;
	break;
      case 17:	  /* gm */
	graphics_mode = x;
	break;
      case 18:	  /* hd */
	open_hyp_dictionary(cptr);
	break;
      case 19:	  /* he */
	strncpy(hyphen_extension, cptr, 4);
	break;
      case 20:	  /* hk */
	hot_key = x;
	break;
      case 21:	  /* hm */
	hyphen_mode = get_integer(cptr);
	if (*cptr && dic_out_ptr == NULL)
	  dic_out_ptr = fopen(cptr, "a");
	if (!dic_out_ptr)
	  dic_out_ptr = stderr;
	break;
      case 22:	  /* ht */
	hyp_dic_ptr = open_option_file(cptr);
	memset(hyphen_dic_start, 0, sizeof(hyphen_dic_start));
	test_hyphen_dictionary(0);
	for (;;)
	{
	  fprintf(stderr, "enter word <RETURN> to exit: ");
	  gets(field);
	  if (strlen(field) < 2)
	    break;
	  strupr(field);
	  if (search_hyphen_dictionary(field))
	    fprintf(stderr, "%s was found on line %u\n", field, hyphen_line_count);
	  else
	    fprintf(stderr, "\7%s not found line %u\n", field, hyphen_line_count);
	}
	exit_program(0);
	break;
      case 23:	  /* hv */
	j = 0;
	do
	{
	  vptr = strchr(cptr, '|');
	  eptr = strchr(cptr, '=');
	  if (eptr)
	  {	   /* found = */
	    *eptr = '\0';
	    if (strcmp(cptr, hyphen_dic_name))
	    {
	      strcpy(hyp_name_verify[j], cptr);
	      hyp_date_verify[j] = (time_t) atol(eptr + 1);
	    }
	    j++;
	  }	   /* found = */
	  if (vptr)
	    cptr = vptr + 1;
	}
	while (vptr);
	break;
      case 24:	  /* i0 */
      case 25:	  /* i1 */
      case 26:	  /* i2 */
      case 27:	  /* i3 */
      case 28:	  /* i4 */
      case 29:	  /* i5 */
      case 30:	  /* i6 */
      case 31:	  /* i7 */
      case 32:	  /* i8 */
      case 33:	  /* i9 */
      case 34:	  /* ia */
      case 35:	  /* ib */
      case 36:	  /* ic */
      case 37:	  /* id */
      case 38:	  /* ie */
	if (total_lines)
	  print_error("\007Initialization option not allowed in file\n");
	if (total_files)
	  break;
	x = (short) (string[1] - 48);
	if (x > 9)
	  x -= 7;
	vptr = strchr(cptr, '|');
	if (!vptr)
      no_ver_bar:print_error("\007Missing | in %s\n", string);
	*vptr = 0;
	if (strlen(cptr) > MAX_INIT)
	{
      init_err:
	  print_error("\007Initialization string > %d characters %s\n",
		      MAX_INIT, string);
	}
	copy_string(init[x].pre_init, cptr, MAX_INIT);
	cptr = vptr + 1;
	vptr = strchr(cptr, '|');
	if (!vptr)
	  goto no_ver_bar;
	*vptr = 0;
	if (strlen(cptr) > MAX_INIT)
	  goto init_err;
	copy_string(init[x].post_init, cptr, MAX_INIT);
	copy_string(init[x].format, vptr + 1, 3);
	break;
      case 39:	  /* IF */
	strncpy(ignore_format, cptr, sizeof(ignore_format));
	break;
      case 40:	  /* interpoint */
	interpoint = x;
	break;
      case 41:	  /* it */
	italics[0] = *cptr;
	break;
      case 42:	  /* kc */
	keep_control = x;
	break;
      case 43:	  /* l0 */
	strncpy(l0, cptr, sizeof(l0));
	break;
      case 44:	  /* l1 */
	strncpy(l1, cptr, sizeof(l1));
	break;
      case 45:	  /* l2 */
	j = 0;
	do
	{
	  vptr = strchr(cptr, '|');
	  if (vptr)
	    *vptr = '\0';
	  strcpy(l2[j], cptr);
	  cptr = vptr + 1;
	  j++;
	}
	while (vptr != NULL && j < 9);
	l2[j] = '\0';
	break;
      case 46:	  /* le */
	if (lopactive)
	  print_error("\7EFL file already loaded\n");
	strncpy(efl_file, cptr, sizeof(efl_file));
	load_template();
	break;
      case 47:	  /* lf */
	if (total_lines == 0 || stdin_tty == 0)
	  print_error(
	      "\7lf option not allowed until translation is in progress\n");
	if (inf_des_save != inf_des)
	  close(inf_des);
	strcpy(inf_name + inf_path_len, cptr);
	inf_des = open_input_file();
	bytes_in_buf = 0;
	linein[0] = 0;
	break;
      case 48:	  /* li */
	strncpy(line_end, cptr, sizeof(line_end));
	break;
      case 49:	  /* lm */
	leftmargin = x;
	break;
      case 50:	  /* ls */
	lineskips = x;
	break;
      case 51:	  /* ma */
	math_flag = 0;
	if (!Isdigit(cptr[0]))
	{	   /* not a digit */
	  reload_table = TRUE;
	  if (*cptr == '+')
	    load_tables(math_table);
	  else
	    load_tables(table_file);
	}	   /* not a digit */
	else
	  math_flag = x;
	break;
      case 52:	  /* mm */
	max_menu = x != 3 ? (short) 2 : (short) 3;
	break;
      case 53:	  /* ms */
	strncpy(math_symbols, cptr, sizeof(math_symbols));
	break;
      case 54:	  /* mt */
	strncpy(math_table, cptr, sizeof(math_table));
	break;
      case 55:	  /* nc */
	no_copyright = x;
	break;
      case 56:	  /* oc */
	output_case = x;
	break;
      case 57:	  /* ow */
	over_write = x;
	break;
      case 58:	  /* pa */
	pause_time = x;
	spool = 0;
	display_braille = display_source = FALSE;
	break;
      case 59:	  /* pd */
	print_date = x;
	break;
      case 60:	  /* pe */
	pageend = x;
	break;
      case 61:	  /* pf */
	print_file = x;
	break;
      case 62:	  /* pl */
	linesperpage = x;
	break;
      case 63:	  /* pn */
	strncpy(prn, cptr, sizeof(prn));
	break;
      case 64:	  /* ps */
	pagestart = x;
	break;
      case 65:	  /* pw */
	maxline = curmax = x;
	break;
      case 66:	  /* qm */
	quiet_mode = x;
	break;
      case 67:	  /* rw */
	rejoin = x;
	break;
      case 68:	  /* s0 */
	strncpy(s0_init, cptr, sizeof(s0_init));
	break;
      case 69:	  /* si */
	strncpy(stdin_name, cptr, sizeof(stdin_name));
	break;
      case 70:	  /* so */
	make_sound = x;
	break;
      case 71:	  /* sp */
	spool = x;
	pause_time = 0;
	break;
      case 72:	  /* st */
	strncpy(stat_file, cptr, sizeof(stat_file));
#ifdef unix
	strlwr(stat_file);
#endif
	break;
      case 73:	  /* tc */
	j = 0;
	do
	{
	  vptr = strchr(cptr, '|');
	  if (vptr)
	    *vptr = '\0';
	  strcpy(t1[j], cptr);
	  cptr = vptr + 1;
	  j++;
	}
	while (vptr != NULL && j < 6);
	break;
      case 74:	  /* td */
	strncpy(table_definition, cptr, 40);
	process_table_definition();
	break;
      case 75:	  /* tf */
	strcpy(table_file, cptr);
	reload_table = TRUE;
	load_tables(table_file);
	break;
      case 76:	  /* tm */
	trans_mode = x;
	break;
      case 77:	  /* tn */
	trans_default = x;
	break;
      case 78:	  /* tp */
	strcpy(transpath, cptr);
	break;
      case 79:	  /* tv */
	timer = x;
	break;
      case 80:	  /* vc */
	vptr = strchr(cptr, '|');
	if (!vptr)
	  goto no_ver_bar;
	*vptr = '\0';
	strncpy(vowels, cptr, sizeof(vowels));
	strncpy(consonants, vptr + 1, sizeof(consonants));
	break;
      default:
	print_error("\7Improper option format: %s nothing follows =.\n", string);
      } 	   /* switch */
      break;
    }		   /* option matched */
  }		   /* j */
  if (options[j] == NULL)
  {		   /* invalid */
invalid:
    fprintf(stderr, "\7Invalid option %s", string);
    if (total_lines)
      fprintf(stderr, " in line %ld", total_lines);
    print_error("\n");
  }		   /* invalid */
}		   /* process_options */

void open_hyp_dictionary(char *string)
{
  int i, j = 0;
  if (!strcmp(hyphen_dic_name, string))
    return;	   /* don't close & reopen unless names are different */
  strncpy(hyphen_dic_name, string, sizeof(hyphen_dic_name));
  if (hyp_dic_ptr)
  {		   /* close hyphen dictionary */
    fclose(hyp_dic_ptr);
    hyp_dic_ptr = NULL;
  }		   /* close hyphen dictionary */
  if (string[0])
  {		   /* open hyphen dictionary */
    hyp_dic_ptr = open_option_file(string);
    memset(hyphen_dic_start, 0, sizeof(hyphen_dic_start));
    hyphen_mode |= 1;
    hyp_dic_tested = 0;
    stat(temp, &hypfilestat);
    if (hyphen_mode >= 0)
    {		   /* do consistency check */
      for (i = 0; i < 5; i++)
      {
	if (!hyp_name_verify[i][0])
	{	   /* empty entry with no prior match */
	  strcpy(hyp_name_verify[i], hyphen_dic_name);
	  hyp_date_verify[i] = hypfilestat.st_ctime;
	  break;
	}	   /* empty entry with no prior match */
	if (!strcmp(hyphen_dic_name, hyp_name_verify[i]))
	{	   /* match */
	  if (hypfilestat.st_ctime == hyp_date_verify[i])
	    j++;
	  else
	    hyp_date_verify[i] = hypfilestat.st_ctime;
	  break;
	}	   /* match */
      } 	   /* i */
      if (!j)
      { 	   /* check consistency */
	test_hyphen_dictionary(1);
	if (!config_lines)
	  rewrite_config();
      } 	   /* test consistency */
    }		   /* do consistency check */
  }		   /* open hyphen dictionary */
  else
    hyp_dic_ptr = NULL;
}		   /* open_hyp_dictionary */

void process_table_definition()
{
  int j;
  if (!total_lines)
    print_error("\007td option not allowed on command line or nfbtrans.cnf\n");
  if (!table_definition[0])
    return;
  strlwr(table_definition);
  cols_in_table = chars_in_table = 0;
  strcpy(temp, table_definition);
  for (j = 0; temp[j]; j++)
  {
    if (temp[j] == '%')
    {		   /* percent */
      if ((isdigit(temp[j + 1]) || ((temp[j + 1] == '-') &&
				    isdigit(temp[j + 2]))))
      { 	   /* field spec */
	if (cols_in_table >= 8)
	  print_error("\007> 8 columns in line %ld\n",
		      total_lines);
	j++;	   /* index digit */
	field_width[cols_in_table] = get_integer(temp + j);
	if (field_width[cols_in_table] > MAX_COL_WIDTH)
	  print_error("\007> %d characters in field %d of table definition in line %ld\n",
		      MAX_COL_WIDTH, cols_in_table + 1, total_lines);
	chars_in_table += field_width[cols_in_table];
	if (temp[j] != 's')
	  print_error("\007Invalid field specifier in %s\n",
		      table_definition);
	cols_in_table++;
	continue;
      } 	   /* field spec */
      if (temp[j + 1] == '*')
	print_error("%s\n", "\007%* not allowed in table definition");
    }		   /* percent */
    chars_in_table++;
  }		   /* j */
  if (chars_in_table > curmax + margin - 1)
    print_error("\007Table definition > %d characters in line %ld\n",
		curmax + margin - 1, total_lines);
  flush_if_not_blank();
}		   /* process_table_definition */

void trim(char *string)
{
  int i, l = strlen(string);
/*remove trailing cr lf and spaces*/
  for (i = l - 1; i >= 0; i--)
  {
    switch (string[i])
    {
    case ' ':
    case '\12':   /* lf */
    case '\15':   /* cr */
      break;
    default:
      string[i + 1] = 0;
      i = 0;
      while (string[i] == ' ')
	i++;
      if (i)
	delete(string, i);
      return;
    }
  }		   /* i */
}		   /* trim */

short strpos(char *string, char *substring)
{
  int i = 0, j, stringlen, sublen;
  stringlen = strlen(string);
  sublen = strlen(substring);
  if ((!stringlen) || (!sublen) || (sublen > stringlen))
    return (0);
  do
  {
    for (j = 0; j < sublen; j++)
      if (string[i + j] != substring[j])
	goto retry;
    return (short) (i + 1);
retry:;
  }
  while (++i < stringlen);
  return (0);
}		   /* strpos */

void insert(char *ins, char *string)
{
  char buf[256];
  strcpy(buf, ins);
  strcat(buf, string);
  strcpy(string, buf);
}		   /* insert */

void delete(char *string, int bytes)
{
  strcpy(string, string + bytes);
}		   /* delete */

void move(char *string1, char *string2, short bytes)
{
  while (bytes >= 0)
  {
    string2[bytes] = string1[bytes];
    bytes--;
  }		   /* while */
}		   /* move */

#ifdef DOS
void sort_names()
{		   /* sorts names in file_names */
  short i, j;
  if (file_count < 2)
    return;	   /* nothing to sort */
  for (i = 0; i < file_count; i++)
    for (j = (short) (i + 1); j < file_count; j++)
      if (strcmp(file_name[i], file_name[j]) > 0)
      { 	   /* out of order */
	strcpy(temp, file_name[i]);
	strcpy(file_name[i], file_name[j]);
	strcpy(file_name[j], temp);
      } 	   /* out of order */
}		   /* sort_names */

#endif		   /* DOS */

/***	  Translate A File	 ***/

void translate_file()
{
  short i, input_mode = 0, startfile;
  char *cptr;
  FILE *indirect_ptr = NULL;
  intext = NULL;   /* for statistics file */
  do
  {
    if (!stdin_tty)
      strcpy(inf_name, stdin_name);
    else
    {		   /* input filename required */
      if (!input_file_arg)
      { 	   /* no file args */
	fprintf(stderr, "\nEnter source File name <RETURN> to exit? ");
	get_input(temp, 80);
	if (!temp[0])
	  exit_program(0);
	strcpy(inf_name, temp);
	input_file_arg = (short) paramcount;
      } 	   /* no file args */
      else
      if (!indirect_ptr)
	strcpy(inf_name, paramstr[input_file_arg]);
      input_mode = 1;
      if (inf_name[0] == '@' && indirect_ptr == NULL)
      { 	   /* indirect mode */
	delete(inf_name, 1);	/* remove @ */
	indirect_ptr = fopen(inf_name, "r");
	if (!indirect_ptr)
	  report_open_error(inf_name);
	pagestart = 1;
      } 	   /* indirect mode */

      if (indirect_ptr)
	if (fgets(inf_name, 128, indirect_ptr))
	{	   /* not eof */
	  i = (short) (strlen(inf_name) - 1);
	  if (i >= 0 && inf_name[i] == '\n')
	    inf_name[i] = '\0';
	  if (!i)
	    continue;	/* skip blank lines */
	}	   /* not eof */
	else
	{	   /* eof */
	  fclose(indirect_ptr);
	  indirect_ptr = NULL;
	  input_file_arg++;
	  continue;
	}	   /* eof */

      /* get length of path component of name */
      inf_path_len = 0;
      for (i = 0; inf_name[i]; i++)
	if (inf_name[i] == '\\' || inf_name[i] == '/' || inf_name[i] == ':')
	  inf_path_len = (short) (i + 1);
      file_count = current_file = 0;
      startfile = 1;
#ifdef DOS
      if (strpbrk(inf_name, "?*"))
      { 	   /* wildcard chars */
	input_mode = 2; /* wildcard chars specified */
	pagestart = 1;
	cptr = strpbrk(inf_name, ",;");
	if (cptr)
	{	   /* find startfile */
	  *cptr = '\0'; /* remove startfile from filename */
	  startfile = (short) atoi(cptr + 1);
	  if (startfile < 1)
	    startfile = 1;
	}	   /* find startfile */
      } 	   /* wildcard chars */
      if (!_dos_findfirst(inf_name, 0, &fileinfo))
	do
	{	   /* store and sort matching file names */
	  if (test_extension(fileinfo.name) < 0)
	    continue;	/* extension was excluded */
	  strcpy(file_name[file_count++], fileinfo.name);
	  if (file_count >= MAX_FILES)
	    break; /* don't store any more */
	}
	while (!_dos_findnext(&fileinfo));
      if (!file_count)
/*no file was found in search but store name anyway*/
	strcpy(file_name[file_count++], inf_name + inf_path_len);
      sort_names();
      current_file = (short) (startfile - 1);
      if (current_file > file_count)
	break;
  get_next_file:
      strcpy(inf_name + inf_path_len, file_name[current_file++]);
#endif
    }		   /* input filename required */
    total_lines = 0l;
    if (total_files)
    {
      lopactive = FALSE;
      l0[0] = l1[0] = '\0';
      ignore_format[0] = '\0';
      get_config();
    }
    prog_init = test_extension(inf_name);
    if (prog_init < 0)
      print_error("\7%s: Excluded by ex= option\n", inf_name);
    hyp_ptr = NULL;
    if (stdin_tty)
    {		   /* input filename required */
      inf_des = open_input_file();
      inf_des_save = inf_des;	/* in case the lf option is encountered */
      strncpy(hyphen_file, inf_name + inf_path_len, sizeof(hyphen_file));
      cptr = strpbrk(hyphen_file, ".");
      if (!cptr)
	cptr = hyphen_file + strlen(hyphen_file);
      strcpy(cptr, hyphen_extension);
      hyp_ptr = fopen(hyphen_file, "r");
      read_hyphen_file = (short) (hyp_ptr != (FILE *) NULL);
      if (spool > 1 && total_files > 0 && stdout_tty > 0)
	pause_program();
      if (ab_flag)
	break;
      if (skip_output == 0 && (indirect_ptr != NULL || input_mode == 2
			       || total_files > 0))
	fprintf(stderr, "Translating %s\n", inf_name);
      total_files++;
      fstat(inf_des, &infilestat);
      if (efl_mode && (infilestat.st_mode & IFCHR) == 0 && lopactive == FALSE)
      { 	   /* process .efl file */
	strcpy(efl_file, inf_name);
	cptr = strchr(efl_file, '.');
	if (!cptr)
	  cptr = efl_file + strlen(efl_file);
	strlwr(cptr);
	if (strcmp(cptr, ".efl"))
	{	   /* load */
	  strcpy(cptr, ".EFL");
	  strcpy(format_string, init[prog_init].format);
	  load_template();
	}	   /* load */
      } 	   /* process .efl file */
    }		   /* input file required */
    get_date();    /* put date in date_string */
    if (leftmargin < 0)
    {		   /* get left margin */
      leftmargin = 1;
      fprintf(stderr, "Enter Number of spaces before Left Margin of source File \n");
      fprintf(stderr, "     (usually 1)? %d", leftmargin);
      backspace_int(leftmargin);
      get_input(temp, 4);
      leftmargin = (short) atoi(temp);
      if (leftmargin <= 0)
	leftmargin = 1;
    }		   /* get left margin */
    if (maxline <= 0)
    {		   /* get maxline */
      maxline = 40;
      fprintf(stderr, "Enter Number of braille cells to emboss\n");
      fprintf(stderr, "  on a Line (usually 40)? %d", maxline);
      backspace_int(maxline);
      get_input(temp, 3);
      maxline = (short) atoi(temp);
      if (maxline <= 0)
	maxline = 40;
    }		   /* get maxline */
    get_page_range();
    if (display_source < 0)
    {		   /* display source? */
      fprintf(stderr, "\nDisplay Source Text (Y/N)? N\010");
      get_digit();
      if (temp[0] == 'y' || temp[0] == 'Y')
	display_source = TRUE;
      else
	display_source = FALSE;
    }		   /* display source? */
    if (display_braille < 0)
    {		   /* display braille? */
      fprintf(stderr, "\nDisplay Translated Text (Y/N)? Y\010");
      get_digit();
      if (temp[0] == 'n' || temp[0] == 'N')
	display_braille = FALSE;
    }		   /* display braille? */
    if (linesperpage <= 0)
    {
      linesperpage = 25;
      fprintf(stderr, "\nNumber of Lines per Page? %d", linesperpage);
      backspace_int(linesperpage);
      get_input(temp, 5);
      if (temp[0])
	linesperpage = (short) atoi(temp);
      if (linesperpage <= 0)
	linesperpage = 25;
    }
    if (lineskips < 0)
    {
      lineskips = 99;
      fprintf(stderr, "Line Skips between Pages (99-FF, 999-VT)? %d", lineskips);
      backspace_int(lineskips);
      get_input(temp, 5);
      if (temp[0])
	lineskips = (short) atoi(temp);
      if (lineskips < 0)
	lineskips = 99;
    }
    if (current_file < 2)
      printit = TRUE;
    if (trans_mode < 10)
    {		   /* get secondary translation mode */
      i = (short) (trans_default / 10);
      fprintf(stderr, "\nPlease select ");
      fprintf(stderr, "\n  1 to Translate and store in a File or");
      fprintf(stderr, "\n  2 Translate and emboss immediately.\n  Choice? %d",
	      i);
      backspace_int(i);
      do
      {
	get_digit();
	if (!temp[0])
	  i = (short) (trans_default / 10);
	else
	  i = (short) atoi(temp);
      }
      while (i < 1 || i > 2);
    }		   /* get secondary translation mode */
    else
      i = (short) (trans_mode / 10);
    trans_mode = (short) ((10 * i) + 1);
    if (i == 1)
    {		   /* translate and store */
      printit = FALSE;
      if (!outf_name[0] && stdout_tty != 0)
      { 	   /* output file required */
	fprintf(stderr, "\nEnter name of File to create? ");
	get_input(outf_name, 48);
	if (!outf_name[0])
	  exit_program(0);
      } 	   /* output file required */
    }		   /* translate and store */
    if (!rejoin)
      rejoin = TRUE;
    xgrade = GRADE2;
    xformat = TEXT;
    find_toc_pages = FALSE;
    memset(toc_pages, 0, sizeof(toctype));
    current_pass = 1;
    if (spool > 0 && file_count >= 9 && printit)
      spool++;	   /* pause between files so queue won't overflow */
    if ((printit && !(usr_default)))
      get_page_range();
    get_copies();
    if (printit == FALSE && stdout_tty != 0)
    {		   /* disk file */
      if (test_file_exist())
	return;
      if (stdout_tty)
	printf("Writing to file - %s\n", outf_name);
    }		   /* disk file */
    else
    {
      get_printer_file_name();
      if (total_files == 1)
	do_pause();
    }
    if (ab_flag)
      return;
    time(&time1);
    if (outf_name[0] && outf_des == 0)
      outf_des = open(outf_name, (int) (O_BINARY | O_CREAT | O_TRUNC | O_WRONLY), STD_OPEN);
    fstat(outf_des, &outfilestat);
    keep_control = 0;
    keep_together = keep_together_save = 0;
    total_lines = 0l;
    dopagenum = TRUE;
    strcpy(format_string, "~");
    strcpy(words, init[prog_init].pre_init);
    do_commands();
    strcpy(format_string, init[prog_init].format);
    if (xformat == AUTO_FORMAT)
      get_paragraph_type();
    if (printit && spool)
    {		   /* printer ignore formfeed */
      strcpy(format_string, "~");
      strcpy(words, s0_init);
      do_commands();
      strcpy(format_string, init[prog_init].format);
    }		   /* printer ignore formfeed */
#ifdef unix
    unbuf_stdin(); /* so we can check for esc */
#endif

    do
    {
      do_translate();
    }
    while (copies < lastcopy && ab_flag == 0);
    strcpy(format_string, "~");
    strcpy(words, init[prog_init].post_init);
    do_commands();
    in_length = filelength(inf_des);
    if (infilestat.st_mode & IFCHR)
      in_length = 0l;
    out_length = filelength(outf_des);
    close(inf_des);
    emboss_time = total_cells / (60l * (long) charspersec);
    write_stat_file();
    if (hyp_ptr)
      fclose(hyp_ptr);
    if (read_hyphen_file)
      unlink(hyphen_file);
#ifdef DOS
    if (printit && spool && ab_flag == 0)
    {		   /* spool */
      if (stdout_tty)
      { 	   /* output not redirected */
	if (emboss_time > 1l)
	  printf("Estimated embossing time: %ld minutes\n",
		 emboss_time);
      } 	   /* output not redirected */
      close(outf_des);
      outf_des = 0;
      spool_file();
    }		   /* spool */
    if (ab_flag)
      break;
    if (input_mode)
    {
      copies = 0;
      if (current_file < file_count)
	goto get_next_file;
    }
#endif		   /* DOS */
    if (input_mode == 2)
    {		   /* wildcards */
      input_mode = 1;
    }		   /* wildcards */
    if (indirect_ptr)
      continue;
    input_file_arg++;
  }
  while (input_file_arg <= (short) paramcount);
  if (outf_des > 1)
    close(outf_des);
  if (intext)
    fclose(intext);
  fclose(conf_ptr);
}		   /* translate_file */

int open_input_file()
{
  int h;
  h = open(inf_name, O_BINARY | O_RDONLY);
  if (h < 0)
    report_open_error(inf_name);
  return (h);
}		   /* open_input_file */

short test_file_exist()
{
  short retval = 0;
  if (access(outf_name, 0) == 0 && over_write == 0)
  {		   /* file already exists */
    printf("\007File %s exists - Overwrite (Y/N)? Y\010", outf_name);
    get_digit();
    if (temp[0] == 'n' || temp[0] == 'N')
      retval = 1;
  }		   /* file already exist */
  return (retval);
}		   /* test_file_exist */

void report_open_error(char *string)
{
  if (errno == EACCES)
    print_error("\007%s is a directory\n", string);
  else
    print_error("\7%s not found.\n", string);
}		   /* report_open_error */

void backtranslate_file()
{
  if (stdin_tty)
  {
    fprintf(stderr, "Enter file to back translate: ");
    get_input(temp, 80);
    if (!temp[0])
      exit_program(0);
    strcpy(inf_name, temp);
    inf_des = open(inf_name, O_BINARY | O_RDONLY);
    if (inf_des < 0)
      report_open_error(inf_name);
  }
  else
    inf_des = 0;
  if (stdout_tty)
  {
    fprintf(stderr, "Enter file to Create: ");
    get_input(temp, 48);
    if (!temp[0])
      exit_program(0);
    strcpy(outf_name, temp);
    if (test_file_exist())
      return;
  }
  if (outf_name[0] && outf_des == 0)
    outf_des = open(outf_name, (int) (O_BINARY | O_CREAT | O_TRUNC | O_WRONLY), STD_OPEN);
  do
  {
    get_word();
    strupr(words);
  }
  while (!done);
}		   /* backtranslate_file */

void spool_file()
{
  sprintf(temp, "print %s", outf_name);
  if (system(temp))
    print_error("\007Could not execute %s\n", temp);
}		   /* spool_file */

short test_extension(char *string)
{
  short i, j = 0;
  char *cptr;
  /* get file extension */
  cptr = strchr(string, '.');
  if (cptr == NULL)
  {		   /* no extension */
    for (i = 0; string[i]; i++)
      if (string[i] == ':' || string[i] == '\\' || string[i] == '/')
	j = (short) (i + 1);
    /* copy the filename without path component */
    strncpy(inf_name_ext, string + j, 8);
    j = search_extensions(inf_name_ext);
    if (j)
      goto done_test;
    cptr = string + strlen(string) - 1;
  }		   /* no extension */
  strcpy(inf_name_ext, cptr + 1);
  /* find out if extension is in an ex= option */
  j = search_extensions(inf_name_ext);
done_test:
  if (j)
    return (prog_extension.prog_ext[j - 1].init_val);
  return (0);	   /* for extensions not in ex= */
}		   /* test_extension */

short search_extensions(char *string)
{
  short i, j = 0;
  strupr(string);
  for (i = 0; i < prog_extension.total; i++)
    if (!strcmp(string, prog_extension.prog_ext[i].ext))
      j = (short) (i + 1);	/* extension was in list */
  return (j);
}		   /* search_extensions */

/*** Emboss a translated File ***/

void emboss_file()
{
  char ch, *cptr;
  if (!inf_name[0])
  {		   /* get filename */
    printf("\nEnter the name of the already Translated File <RETURN> to exit: ");
    get_input(temp, 48);
    if (!temp[0])
      exit_program(0);
    strcpy(inf_name, temp);
  }		   /* get filename */
  if ((intext = fopen(inf_name, FOPEN_READ)) == NULL)
    print_error("\7%s does not exist\n", inf_name);
  get_copies();
  get_page_range();
  usr_default = FALSE;
  printit = TRUE;
  get_date();
  get_printer_file_name();
  do_pause();
  if (ab_flag)
    return;
  outf_des = open(outf_name, O_BINARY | O_CREAT | O_TRUNC | O_WRONLY, S_IWRITE);
  do
  {		   /* while there are copies to emboss */
    copies++;
    actualpage = 0;
    bpagec = 1;    /* current braille page */
    lineinct = 0;
    rewind(intext);/* start from beginning of file for this copy */
    while ((fgets(field, 80, intext)) && bpagec <= pageend)
    {		   /* while there are lines to read and not passed ending
		    * page */
      if (check_keyboard(0) < 0)
	break;
      lineinct++;
      linecount = (short) strlen(field);
      field[linecount - 1] = 0; /* remove \n */
      if ((cptr = strpbrk(field, "\013\014")) != NULL ||
	  (short) lineinct > linesperpage)
      { 	   /* new page */
	bpagec++;  /* ff or vt */
	page_beep();
	if (!skip_output)
	  fprintf(stderr, "Embossing page %d\n", bpagec);
	lineinct = 1;	/* first line on new page */
	if (bpagec > pageend)
	  break;   /* done */
	if (display_braille > 0 && bpagec > pagestart && skip_output == 0)
	{	   /* display braille */
	  fprintf(stderr, "%s\n", field);
	  if (linecount >= 20)
	    fprintf(stderr, "       Copy %d of %d\n", copies, lastcopy);
	}	   /* display_braille */
      } 	   /* new page */
      if (bpagec >= pagestart)
      { 	   /* process page */
	if (cptr)
	{	   /* vt or ff */
	  ch = *cptr;
	  if (!skip_output)
	    fprintf(stderr, "%s\n", field);
	  strcpy(field, cptr + 1);
	  if (actualpage)
	    write_char(ch);
	  actualpage++;
	  delay(emboss_delay);
	  if (field[0])
	    write_string(field, 0);
	}	   /* ff or vt */
	else
	{	   /* no ff or vt */
	  write_string(field, 1);
	}	   /* no f or vt */
      } 	   /* process page */
    }		   /* while */
  }
  while (copies < lastcopy);
  fclose(intext);
  close(outf_des);
  if (spool)
    spool_file();
}		   /* emboss_file */

void get_page_range()
{
  char *cptr;
  if (pagestart <= 0)
  {		   /* get starting page */
    pagestart = 1;
    fprintf(stderr, "Start at Page? 1\010");
    get_input(temp, 80);
    pagestart = (short) atoi(temp);
    cptr = strpbrk(temp, "-, ");
    if (cptr)
      pageend = (short) atoi(cptr + 1);
    if (pagestart <= 0)
      pagestart = 1;
  }		   /* get starting page */
  /* if interpoint then pagestart should be odd */
  if (interpoint && (pagestart & 1) == 0)
    pagestart--;
  if (pageend < pagestart)
  {		   /* pageend */
    pageend = 9999;
    fprintf(stderr, "Stop at Page (RETURN for end)? %d", pageend);
    backspace_int(pageend);
    get_input(temp, 5);
    pageend = (short) atoi(temp);
    if (!temp[0])
      pageend = 9999;
    if (pageend < 1)
      pageend = 9999;
  }		   /* pageend */
  if (interpoint && (pageend & 1))
    pageend++;
  pagestart_save = pagestart;
  pageend_save = pageend;
}		   /* get_page_range */

void get_copies()
{
  if (lastcopy <= 0)
  {
    lastcopy = 1;
    printf("\nNumber of Copies? %d\010", lastcopy);
    get_input(temp, 80);
    lastcopy = (short) atoi(temp);
    if (lastcopy <= 0)
      lastcopy = 1;
  }
}		   /* get_copies */

void get_printer_file_name()
{
  int tries = 0;
  char *cptr;
  if (printit)
    if (stdout_tty)
    {		   /* stdout is tty */
      if (!spool)
	strcpy(outf_name, prn);
      else
      { 	   /* spool */
	/* get location of temp file */
	cptr = (char *) getenv("TMP");
	if (cptr)
	  strcpy(temp, cptr);
	else
	  temp[0] = 0;
	do
	{
	  tries++;
	  sprintf(outf_name, "%s%02d%02d%02d", temp, tm->tm_hour, tm->tm_min,
		  tm->tm_sec);
	  if (!access(outf_name, 0))
	    tm->tm_sec++;	/* file exists so use a different name */
	  else
	    break;
	}
	while (tries < 10);

	if (interpoint > 1)
	  interpoint = 1;	/* don't eject blank page */
	printf("Creating %s\n", outf_name);
      } 	   /* spool */
    }		   /* stdout is tty */
}		   /* get_printer_file_name */

void do_pause()
{
  short i;
  if (pause_time && printit)
  {		   /* pause */
    for (i = 0; i < pause_time; i++)
    {
      if (make_sound)
#ifdef DOS
	sound(440);
      delay(80);
      nosound();
#else		   /* unix */
	beep(1);
#endif		   /* DOS */
      delay(800);
      if (stdin_tty)
	if (check_keyboard(0) > 0)
	  getch();
    }		   /* i */
    skip_output = TRUE;
  }		   /* pause */
}		   /* do_pause */

void pause_program()
{
  if (emboss_time)
  {		   /* pause */
    printf("Press any key to continue or wait %ld minutes for embossing\n",
	   emboss_time);
    time1 = (long) time(NULL);
    do
    {
      if (check_keyboard(0))
	break;
    }
    while ((long) time(NULL) - time1 < emboss_time * 60l);
  }		   /* pause */
}		   /* pause_program */

short check_keyboard(short toggle)
{		   /* returns -1 for esc 0 for no key and 1 otherwise */
  short i, retval = 0;
  if (kbhit())
  {		   /* get key */
    i = (short) getch();
    if (i == 32 && toggle > 0)
      make_sound ^= TRUE;
    if (i == 27)
    {		   /* escape */
      done = TRUE; /* abort */
      ab_flag = 1;
      retval = -1;
    }		   /* escape */
    retval = 1;
  }		   /* get key */
  return (retval);
}		   /* check_keyboard */

void write_string(char *string, short display)
{
  int l;
#ifdef DOS
  l = sprintf(temp, "%s\r\n", string);
#else
#ifdef sysv
  l = sprintf(temp, "%s\n", string);
#else		   /* not sysv */
  sprintf(temp, "%s\n", string);
  l = strlen(temp);
#endif		   /* sysv */
#endif		   /* DOS */
  if (!output_case)
    strlwr(temp);
  if (write(outf_des, temp, l) < 0)
    no_space();
  if (printit)
    delay(emboss_delay);
  if (display)
    if (display_braille && skip_output == FALSE)
      fprintf(stderr, "%s", temp);
  if (stat_file[0])
    add_dots(string);
}		   /* write_string */

void write_toc_header()
{
  char string[16];
  if (book_toc == 0 || got_toc_page == 0 || (book_mode & 8) == 0)
    return;
  blinec += (short) (2 + (toc_word == 0));
  if (blinec >= linesperpage)
    print_error("\7TOC header on two pages line %ld\n", total_lines);
  sprintf(string, "%%-%ds%%5s %%5s", curmax - fill_length + 1);
  sprintf(field, string, t1[0], t1[1], t1[2]);
  write_string(field, 0);
  sprintf(field, string, t1[3], t1[4], t1[5]);
  write_string(field, 0);
  if (!toc_word)
    write_string(" ", 0);
  field[0] = 0;
}		   /* write_toc_header */

void write_char(char ch)
{
  if (write(outf_des, &ch, 1) <= 0)
    no_space();
}		   /* write_char */

void no_space()
{
  short i;
  fprintf(stderr, "Error with output file: ");
  perror("Error");
  if (make_sound)
    for (i = 0; i < 5; i++)
    {
#ifdef DOS
      sound(750);
      delay(100);
      sound(1500);
      delay(100);
#else		   /* unix */
      beep(2);
#endif		   /* DOS */
    }
#ifdef DOS
  nosound();
#endif		   /* DOS */
  exit_program(1);
}		   /* no_space */

void copy_string(char *string1, char *string2, short maxlen)
{		   /* copies at most length bytes of string2 into string1
		    * accounting for escaped characters */
  short i, j = 0, k;
  for (i = 0; (string2[i] != '\0' && j < maxlen); i++)
    if (string2[i] != '\\')
      string1[j++] = string2[i];
    else
    {		   /* escape */
      i++;	   /* skip \ */
      if (isdigit(string2[i]))
      { 	   /* digit */
	k = (short) atoi(string2 + i);
	if (k > 9)
	  i++;
	if (k > 99)
	  i++;
	string1[j++] = (char) k;
      } 	   /* digit */
    }		   /* escape */
  string1[j] = '\0';
}		   /* copy_string */

void cleanup(int x)
{
#ifdef DOS
  setmode(1, O_TEXT);
#else		   /* unix */
  restore_stdin();
#endif
  if (x == SIGINT)
    exit(0);
}		   /* cleanup */

void exit_program(int x)
{
  cleanup(-1);
  exit(x);
}		   /* exit_program */

void print_error(char *message,...)
{		   /* prints message to stderr and exit program */
  long *ip = (long *) &message;
  fprintf(stderr, message, ip[1], ip[2], ip[3], ip[4], ip[5], ip[6]);
  exit_program(1);
}		   /* print_error */

int ISalpha(char c)
{
  if (c < '\0')
  {
    if (rejoin & 8)
      return (1);
    return (0);
  }
  return (isalpha(c));
}		   /* ISalpha */

int Isdigit(char c)
{
  if (c <= '\0')
    return (0);
  return (isdigit(c));
}		   /* Isdigit */

void main(int argc, char *argv[])
{
  short i, j;
  paramcount = argc - 1;
  paramstr = argv;
  /* initialize structures */
  b = (tablet *) malloc(sizeof(tablet));
  if (!b)
    print_error("\7Unable to allocate memory for table\n");
  memset(init, 0, sizeof(init_t));
  memset(&prog_extension.total, 0, sizeof(prog_ext_t));
  memset(hyp_name_verify, 0, sizeof(hyp_name_verify));
  stdin_tty = (short) isatty(0);
  stdout_tty = (short) isatty(1);
#ifdef unix
  save_stdin();
  if (stdout_tty)
    setbuf(stdout, NULL);	/* so printf always prints */
#endif		   /* unix */
  strcpy(table_file, TABLENAME);
  get_config();
  signal(SIGINT, cleanup);
  if (no_copyright == FALSE)
  {		   /* display message */
    fprintf(stderr, "\nNFBTRANS Grade Two Braille Translator - Release %s\n", VERSION);
    fprintf(stderr, "%s\012\012", COPYRIGHT);
  }		   /* display message */
  load_tables(table_file);

  copies = 0;
  if (usr_default == FALSE && pagestart <= 1 && trans_mode <= 0)
  {		   /* choose mode */
    j = (short) (trans_default % 10);
    fprintf(stderr, "\nPlease select\n");
    for (i = 0; i < max_menu; i++)
      fprintf(stderr, main_menu[i]);
    while (trans_mode % 10 < 1 || trans_mode % 10 > max_menu)
    {
      fprintf(stderr, "\nChoice? %d", j);
      backspace_int(j);
#ifdef DOS
      if (make_sound)
      {
	sound(440);
	delay(20);
	sound(1760);
	delay(20);
	nosound();
      }
#endif		   /* DOS */
      get_digit();
      if (!temp[0])
	trans_mode = j;
      else
	trans_mode = (short) atoi(temp);
    }		   /* while */
  }		   /* choose mode */
  if ((trans_mode % 10) == 1 || usr_default == TRUE)
    translate_file();
  else
  {
    if ((trans_mode % 10) == 2)
      emboss_file();
    else
      backtranslate_file();
  }
  if (ab_flag)
    fprintf(
	    stderr, "Program aborted\n");
  if (skip_output == TRUE && stdout_tty == TRUE)
  {
    do_pause();
    getch();
  }
  exit_program(0);
}		   /* main */
