
PAGE	60,132
TITLE	KEYLIB  -  C INTERFACE ROUTINES FOR DKEY

COMMENT !

	ret = dk_reset();		clear entire macro table
	ret = dk_disable();		disable translation
	ret = dk_enable();		enable translation
	ret = dk_set(keycode,def);	install or alter key definition
	ret = dk_get(keycode,def);	retrieve definition by keycode
	kc = dk_gnum(num,def);		retrieve definition by sequence #
	bytes = dk_size();		retrieve size of macro table

	int ret;		return value.	 0 = success
						-1 = DK not resident
						 1 = other failure

	int keycode;		BIOS keycode.  Key scan code in upper 8 bits
	char *def;		string for definition.  Length of destination
				  NOT checked for dk_get() and dk_gnum()
	int kc;			keycode returned from dk_gnum()
					-1 = DK not resident
					-2 = requested definition not found
					otherwise is BIOS keycode
	unsigned num;		sequence number for definition.  0 = lowest
	unsigned bytes;		length of macro table.
                                        65535 = DK not resident

    The assembly language routines in DKEY are 'allowed' to (but might not)
    trash the the following registers:
    
    		AX,BX,CX,DX,DI,SI,ES

!

INCLUDE DOS.MAC
INCLUDE STRUCT.MAC

DKEY	MACRO	func
	MOV	AH,&0func&H
	INT	16H
	ENDM

	PSEG



	PROCEDURE DK_RESET

	CALL	DK_RESIDENT
	JNZ	END1
	DKEY	80
END1:	RET

DK_RESET	ENDP



	PROCEDURE DK_DISABLE
	
	CALL	DK_RESIDENT
	JNZ	END4
	DKEY	81
END4:	RET

DK_DISABLE	ENDP



	PROCEDURE DK_ENABLE
	
	CALL	DK_RESIDENT
	JNZ	END5
	DKEY	82
END5:	RET

DK_ENABLE	ENDP



	PROCEDURE DK_SET
	
	ENTER
	PASSW	KEYCODE
	PASSA	DEF
	
	CALL	DK_RESIDENT
	JNZ	END6
	PUSH	DS
	MOV	CX,KEYCODE
	IF LDATA
	LES	DI,DEF
	ELSE
	MOV	DI,DS
	MOV	ES,DI
	MOV	DI,DEF
	ENDIF
	DKEY	83
	POP	DS
END6:	RETURN

DK_SET	ENDP



	PROCEDURE DK_GET
	
	ENTER
	PASSW	KEYCODE
	PASSA	DEF
	
	CALL	DK_RESIDENT
	JNZ	END7
	PUSH	DS
	MOV	CX,KEYCODE
	IF LDATA
	LES	DI,DEF
	ELSE
	MOV	DI,DS
	MOV	ES,DI
	MOV	DI,DEF
	ENDIF
	DKEY	84
	POP	DS
END7:	RETURN

DK_GET	ENDP



	PROCEDURE DK_GNUM
	
	ENTER
	PASSW	NUM
	PASSA	DEF
	
	CALL	DK_RESIDENT
	JNZ	END8
	PUSH	DS
	MOV	CX,NUM
	IF LDATA
	LES	DI,DEF
	ELSE
	MOV	DI,DS
	MOV	ES,DI
	MOV	DI,DEF
	ENDIF
	DKEY	85
	POP	DS
END8:	RETURN

DK_GNUM	ENDP



	PROCEDURE DK_SIZE
	
	CALL	DK_RESIDENT
	JNZ	END9
	DKEY	86
END9:	RET

DK_SIZE	ENDP



PUBLIC	DK_RESIDENT
DK_RESIDENT	PROC

        DKEY    87
        CMP     AX,'JW'                 ;ZERO SET IF DKEY RESIDENT
        MOV     AX,0FFFFH               ;JUST IN CASE
        RET

DK_RESIDENT	ENDP

	ENDPS
	END
