	Name trunc
	Title
	page	,132
comment /

	This program is a filter that reads a file and truncates each
	line at the character on the parmline or the eol char <CR>.
	If there is not parameter lines will be truncated at the first
	space (which includes leading spaces as well.)

/
;===================================================================
code	segment	public
;===================================================================
;
;	command line is at 80h of psp - first byte is length
;
	org	80h
parmsize	db	?
parm		db	7fh dup (?)
;
; .com starts at 100h - but must jump around any data area
;
	org	100h			; com file starts here
	assume	cs:code,ds:code,es:code
trunc:
	jmp	clear
;===================================================================
;
; data area for .com programs
; Uncomment (**) statements and comment (&&) statements
; if you need two different buffers.
;
inchar  	db	?
;
;===================================================================
clear:
;
; start of actual code is here (clear)
;
;
; Read a character.  If it compares to the current character of the
; parmline, loop through the end of the line (CR/LF).
;
; Check parameter line for a character.  If none, insert a space.
;
	cmp	parmsize,2h	; if no characters, insert a space.
	jge	parmok
	mov	parm+1,' '	; tack on the space

; These two i/o parameters are constants.
;
parmok:
	lea	dx,inchar	; offset of inchar
	mov	cx,1h		; get 1 character
again:
;
; read a character
;
	xor	bx,bx		; zero is handle of standard input
	lea	dx,inchar	; offset of inchar
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
; compare character against parmline.
;
	mov	al,parm+1	; load character
	cmp	al,inchar
	jne	output		; if characters don't match, output
;
; Character matched - now read characters until <cr> is seen.
;
skip:
	xor	bx,bx		; zero is handle of standard input
	mov	cx,1h		; get 1 character
	mov	ah,3fh		; read a file/device function
	int	21h		; invoke the function
;
; if carry set of ax=0 exit
;
	jc	oops		; i/o error
	and	ax,ax		; set flags
	jz	oops		; eof
;
; look for <cr>
;
	cmp	inchar,0dh	; if inchar is <cr>, start i/o again.
	jne	skip		; otherwise skip it.
output:
	mov	bx,1h		; standard output handle
	mov	ah,40h		; dx still points at inchar
	int	21h		; call dos output function
	jmp	again		; repeat cycle
oops:
	int	20h		; return to dos
code	ends
	end	trunc
