unit NFBCODE;
(***************************************************************)
(*** Copyright (c) 1991 The National Federation of the Blind ***)
(*** This code may be not be distributed in this source code ***)
(*** format.  Any programs derived from or using this code   ***)
(*** may not be sold or released without permission from the ***)
(*** National Federation of the Blind.  Licensed owners of   ***)
(*** NFBTRANS may freely use and modify this program code    ***)
(*** except as stated above.                                 ***)
(***************************************************************)
interface
uses crt,
     nfbvar;

procedure DoTranslate;

implementation
(* Variables used throughout the program *)
var
  Done       : boolean;
  EndFile    : boolean;
  OldWord    : string[255];
  OldLine    : string[255];
  OldLine6   : string[255];
  TLine      : string[255];
  FLine      : string[255];
  HLine      : string[255];
  BLine      : string[255];
  BLine6     : string[255];
  WLine      : string[255];
  BLineC     : integer;
  BPageB     : integer;
  BPageH     : integer;
  LineLength : integer;
  CurMax     : integer;

  C          : char;
  Words      : string[80];
  BWord      : string[80];
  BWord6     : string[80];
  Work1      : string[20];
  Work2      : string[20];
  TabVec     : string[255];

  Join       : boolean;
  Group      : boolean;
  PJoin      : boolean;
  PGroup     : boolean;
  Hyphen     : boolean;
  PHyphen    : boolean;
  XJoin      : boolean;
  XGroup     : boolean;
  XPJoin     : boolean;
  XPGroup    : boolean;
  XHyphen    : boolean;
  XPHyphen   : boolean;

  XGrade     : (Grade0,Grade1,Grade2);
  XCenter    : boolean;
  XFormat    : (Poetry,Text,Block,Lists);
  XDouble    : boolean;
  XTab       : boolean;
  XAcronym   : boolean;
  XHeading   : boolean;
  XFooting   : boolean;
  MakeFoot   : boolean;
  MakeHead   : boolean;
  FillIt     : boolean;

  QuoteOpen  : boolean;
  QuoteClose : boolean;

  Margin     : integer;
  Point      : integer;
  FirstLetter: integer;
  CharDec    : integer;
  LastMatch  : integer;
  LineIn     : string[255];
  LineInCt   : integer;
  NewLine    : boolean;
  QuoteCount : integer;
  DoPageNum  : boolean;
  DoRoman    : boolean;
  DoBook     : boolean;
  TabTable   : array[1..255] of byte;
  DisableCol : boolean;
  SetMargin  : integer;
  OldMargin  : integer;
  TabMargin  : boolean;
  PageSet    : boolean;
  WOffset    : integer;
  AddChar    : string[10];
  ActualPage : integer;

(***********************************)
(*** This procedure causes an    ***)
(*** advance to TOP OF FORM...   ***)
(***********************************)
procedure BTopofForm;
var I:Integer;
begin
  inc(ActualPage);
  inc(BPageC);
  if BPagec>PageEnd then
    begin
      Done:=true;
      BLine:='';
      BLine6:='';
      BWord:='';
      exit;
    end;
  if BPageC>PageStart then
    begin
      if LineSkips<99 then
        for I:=1 to LineSkips+LinesPerPage-BLineC do
          begin
            writeln(Outext,' ');
            if DispBraille then
              writeln;
          end;
       if LineSkips=99 then
         write(Outext,#12);
       if LineSkips=999 then
         writeln(Outext,#11);
       if LineSkips=9999 then
         begin
           writeln(Outext,#12);
           writeln;
           write('To Continue, Press Return'+#7);
           readln;
         end;
     end;
  if DoPageNum and ((BPageC>1) or Pageset) and not XHeading then
    LineLength:=CurMax-6-Margin-length(AddChar)
  else
    LineLength:=CurMax+1-Margin;

  BLineC:=0;
  sound(2000);
  if DispBraille then
    begin
      str(Copies,Field);
      WLine:='Copy '+Field+' of ';
      str(LastCopy,Field);
      Wline:=WLine+Field+'   Page ';
      Str(BPageC,Field);
      WLine:=WLine+Field;
      while length(WLine)<40 do
        if odd(length(Wline)) then
          WLine:=WLine+'*'
        else
          WLine:='*'+WLine;
      writeln(WLine);
    end
  else
    writeln('On page ',BPagec,'  Copy ',Copies,' of ',LastCopy);
  nosound;

  if PrintIt then
    delay(B.Delay);
end;

(*************************************)
(*** Fill a Table of Contents Line ***)
(*************************************)
procedure DoFillit;
var I,J : integer;
begin
  FillIt:=false;
  I:=LineLength+Margin-1;
  J:=I+1;
  repeat
    J:=J-1;
    if J<1 then
     exit;
  until BLine[J]<>' ';
  repeat
    BLine[I]:=BLine[J];
    BLine[J]:=' ';
    J:=J-1;
    I:=I-1;
  until (BLine[J]=' ') or (J<3);
  I:=I-1;
  repeat
    BLine[I]:='"';        (* dot 5 *)
    I:=I-1;
  until (BLine[I-1]<>' ') or (I<3+Margin-1);
end;

procedure MakeRoman;
var I,J : integer;
begin
  J:=BPageC;
  Field:='';
  while J>=10 do
    begin
      J:=J div 10;
      Field:=Field+'X';
    end;
  J:=BPageC mod 10;
  case J of
    1 : Field:=Field+'I';
    2 : Field:=Field+'II';
    3 : Field:=Field+'III';
    4 : Field:=Field+'IV';
    5 : Field:=Field+'V';
    6 : Field:=Field+'VI';
    7 : Field:=Field+'VII';
    8 : Field:=Field+'VIII';
    9 : Field:=Field+'IX';
  end;
end;

procedure MakeArabic;
var I,J : integer;
begin
  J:=BPageC;
  I:=CurMax;
  Field:='';
  repeat
    Field:=BNumber[J mod 10]+Field;
    J:=J div 10;
    I:=I-1;
  until J=0;
  Field:='#'+Field+AddChar;
end;

procedure MakeBook;
var J : integer;
begin
  J:=BPageB;
  Field:='';
  repeat
    Field:=BNumber[J mod 10]+Field;
    J:=J div 10;
  until J=0;
  Field:='#'+Field;

  if (BPageC-BPageH)>1 then
    Field:=chr(ord('A')+BPageC-2-BPageH)+Field;
end;

(***********************************)
(***    Flush the Line buffer    ***)
(*** if top of Page, put on the  ***)
(***         Page Number         ***)
(***********************************)
procedure BPurge;
var I,J:Integer;
begin
  BLineC:=BLineC+1;

  if length(BLINE)>0 then
    begin
      if length(BLine6)>length(BLine) then
        BLine:=BLine6;
      BLine[0]:=chr(CurMax);

      move(BLine[1],BLine[Margin],CurMax+1-Margin);
      fillchar(BLine[1],Margin-1,' ');
    end;

  if XCenter then
    begin
      J:=CurMax;
      while BLine[J]=' ' do
        J:=J-1;
      J:=(CurMax-J) div 2;

      move(BLine[1],BLine[J+1],CurMax-J);
      fillchar(BLine[1],J,' ');
      if NewLine then
        XCenter:=false;
    end;

  if FillIt and NewLine then
    DoFillIt;

  Field:='';
  if (BLineC=1) then
    begin
      if ((BPagec>1) or PageSet or DoBook) and DoPageNum then
        begin
          if DoRoman then
            MakeRoman
          else
            if DoBook then
              MakeBook
            else
              MakeArabic;
        end;
      if XHeading then
        begin
          for I:=1 to length(Field) do
            HLine[length(HLine)-length(Field)+I]:=Field[I];
          if BPageC>=PageStart then
            begin
              if DispBraille then
                writeln(HLine);
              writeln(Outext,HLine);
            end;
          Blinec:=BLinec+1;
        end
     else
        begin
          BLine[0]:=chr(MaxLine);
          move(Field[1],Bline[MaxLine-length(Field)+1],length(Field));
        end;
    end;

  if DoBook and (BlineC>=LinesPerPage) then
    begin
      BLine[0]:=chr(MaxLine);
      MakeArabic;
      move(Field[1],Bline[MaxLine-length(Field)+1],length(Field));
    end;

  if BPageC>=PageStart then
    begin
      if DispBraille then
        writeln(BLine);
      if (length(BLine)=0) then
        BLine:=BLine+' ';
      writeln(Outext,BLine);
    end;
  if XDouble and (BPageC>=PageStart) then
    begin
      writeln(Outext,' ');
      BLineC:=BLineC+1;
    end;

  fillchar(BLine[1],CurMax,' ');
  fillchar(BLine6[1],CurMax,' ');
  BLine:='';
  if not (XFormat=Text) or Fillit then
    for I:=1 to WOffset do
      BLine:=BLine+' ';
  if XFormat=Block then
    BLine:='';
  BLine6:=BLine;
  PJoin:=false;
  PGroup:=false;
  if XFooting and (BLineC>=LineSperPage-1) then
    begin
      if DoBook then
        begin
          MakeArabic;
          FLine[0]:=chr(CurMax);
          for I:=1 to length(Field) do
            FLine[length(FLine)-length(Field)+I]:=Field[I];
        end;
      if BPageC>=PageStart then
        begin
          writeln(Outext,FLine);
          if DispBraille then
            writeln(FLine);
        end;
      BLinec:=BLinec+1;
    end;
  if BLineC>=LineSperPage then
    BTopofForm
  else if DoBook and (BlineC>=LinesPerPage-1) and not XFooting then
    LineLength:=CurMax-6-Margin
  else
    LineLength:=CurMax+1-Margin;
  NewLine:=false;
end;

(***********************************)
(***   Add A Word to the end of  ***)
(*** the Line -- Check to be sure***)
(*** lower cell Words not at end ***)
(***********************************)
procedure BuildLine;
var I,J:Integer;
    N,M:integer;
begin
  I:=length(BLine);
  if XTab then
    begin
      N:=0;
      M:=0;
      repeat
        inc(N);
        if TabTable[I+N]<>0 then
          M:=N;
      until (M<>0) or (I+N>=linelength);
      if M=0 then
        M:=1;
      for N:=1 to M do
        begin
          BLine:=BLine+' ';
          BLine6:=BLine6+' ';
        end;
      PJoin:=false;
      PGroup:=false;
      PHyphen:=false;
      XTab:=false;
    end;

  if not (PHyphen or PJoin or (PGroup and Group)) then
    I:=I+1;
  J:=I+length(BWord6);
  I:=I+length(BWord);

  if ((I>LineLength) or (J>LineLength)) or
     (Fillit and ((I>LineLength-6) or (J>LineLength-6)))  then
    BPurge;

  if PJoin or (PGroup and Group) or (BWord='1')
    or (length(BLine)=0) or PHyphen then
    begin
      BLine6:=BLine+BWord6;
      BLine:=BLine+BWord;
    end
  else
    if BLine[length(BLine)]=' ' then
      begin
        BLine6:=BLine+BWord6;
        BLine:=BLine+BWord;
      end
    else
      begin
        BLine6:=BLine+' '+BWord6;
        BLine:=BLine+' '+BWord;
      end;

  if (length(BLine)=2) and
     (BLine='BE') then
    BLine:='2';
  BWord6:='';
  PGroup:=Group;
  PJoin:=Join;
  PHyphen:=Hyphen;
end;

(***********************************)
(***   Input Text -- check for   ***)
(***          commands           ***)
(***********************************)
procedure DoCommands;
var TilPos,I,J:integer;
     C      : char;
begin
  NewLine:=true;
  TilPos:=pos('~',Words);
  if (length(Words)>TilPos) then
  repeat
    C:=Words[TilPos+1];
    if C in ['a'..'z'] then
      C:=upcase(C);

    case C of
      'A':begin          (* Acronym Logic - Betty Desimone *)
            XAcronym:=true;
            delete(Words,TilPos,2);
            NewLine:=false;
          end;
      'B':begin          (* Textbook Break *)
            DoRoman:=false;
            DoBook:=true;
            NewLine:=true;
            delete(Words,TilPos,2);
            BPageH:=BPageC;
            if BLineC<LinesPerPage then
              BPageH:=BPageH-1;
            BPageB:=0;
            while (length(Words)>0) and
              (Words[1] in ['0','1','2','3','4','5','6','7','8','9']) do
              begin
                BPageB:=10*BPageB+(ord(Words[1])-ord('0'));
                delete(Words,1,1);
              end;
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            TLine[0]:=chr(MaxLine);
            fillchar(Tline[1],MaxLine,'-');  (* dots 3/6 *)
            I:=MaxLine;
            Field:='';
            J:=BPageB;
            repeat
              TLine[I]:=BNumber[J mod 10];
              J:=J div 10;
              I:=I-1;
            until J=0;
            TLine[I]:='#';
            if (BLineC>1) and (BLineC<LinesPerPage-1) then
              begin
                if BPageC>=PageStart then
                  begin
                    writeln(Outext,TLine);
                    if DispBraille then
                      writeln(TLine);
                  end;
                BLinec:=BLinec+1;
              end
            else
              LineLength:=CurMax-6-Margin;
          end;
      'C':begin       (* Center *)
            NewLine:=true;
            delete(Words,TilPos,2);
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            XCenter:=true;
          end;
      'D':begin          (* Double Toggle *)
            if not XDouble then
              XDouble:=true
            else
              XDouble:=false;
            delete(Words,TilPos,2);
          end;
      'E':begin           (* Poetry *)
            delete(Words,TilPos,2);
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            XFormat:=Poetry;
          end;
      'F':begin           (* Fill Line - Index *)
            NewLine:=true;
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            FillIt:=true;
            delete(Words,TilPos,2);
          end;
      'G':begin                 (* Set Right Margin *)
            I:=CurMax;
            CurMax:=ord(Words[3])-ord('0');
            if (length(Words)>=4) then
            if Words[4] in ['0','1','2','3','4','5','6','7','8','9']
              then CurMax:=10*CurMax+(ord(Words[4])-ord('0'));
            if CurMax<1 then CurMax:=1;
            if CurMax>MaxLine then CurMax:=MaxLine;
            delete(Words,3,length(Words)-2);
            LineLength:=CurMax+1-Margin;
            delete(Words,TilPos,2);
          end;
      'H':begin         (* Heading *)
            OldLine:=BLine;
            OldLine6:=Bline6;
            XHeading:=true;
            XPgroup:=PGroup;
            XPjoin:=PJoin;
            XJoin:=Join;
            XGroup:=Group;
            XHyphen:=Hyphen;
            XPHyphen:=PHyphen;
            MakeHead:=true;
            BLine:='';
            BLine6:='';
            PGroup:=false;
            Group:=false;
            Join:=false;
            PJoin:=false;
            delete(Words,TilPos,2);
          end;
      'I':begin         (* Italics *)
            Words[TilPos+1]:='_';
            if TilPos>1 then
              begin
                if Words[TilPos-1] in ['a'..'z','A'..'Z'] then
                  Words[TilPos]:='-'
                else
                  delete(Words,TilPos,1);
              end
            else
              delete(Words,TilPos,1);
            NewLine:=false;
          end;
      'J':begin             (* Stop Heading *)
            XHeading:=false;
            delete(Words,TilPos,2);
          end;
      'K':begin             (* Stop Footing *)
            XFooting:=false;
            delete(Words,TilPos,2);
          end;
      'L':begin         (*Letter Sign*)
            Words[TilPos+1]:='\';
            delete(Words,TilPos,1);
          (*  NewLine:=false;  *)
          end;
      'M':begin         (* Left Margin Set *)
            NewLine:=true;
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            I:=Margin;
            Margin:=ord(Words[3])-ord('0');
            if (length(Words)>=4) then
            if Words[4] in ['0','1','2','3','4','5','6','7','8','9']
              then Margin:=10*Margin+(ord(Words[4])-ord('0'));
            if Margin<1 then Margin:=1;
            if Margin>30 then Margin:=30;
            delete(Words,3,length(Words)-2);
            LineLength:=LineLength+I-Margin;
            delete(Words,TilPos,2);
            SetMargin:=Margin+SetMargin-OldMargin;
            OldMargin:=Margin;
          end;
      'N':begin               (* Set PageNum *)
            AddChar:='';
            if Words[length(Words)]in ['A'..'Z'] then
              begin
                AddChar:=';'+Words[length(Words)];
                Words[0]:=chr(ord(Words[0])-1);
              end;
            DoPageNum:=true;
            DoRoman:=false;
            Field:=Copy(Words,3,length(Words));
            BPageC:=0;
            val(Field,BPageC,I);
            if BPageC=1 then
              PageSet:=true;
            BPageH:=BPageC;
            delete(Words,3,length(Words)-2);
            delete(Words,TilPos,2);
            if BlineC=0 then
              LineLength:=CurMax-6-Margin-length(AddChar);
          end;
      'O':begin                (* Offset for Wrap *)
            Field:=Copy(Words,3,length(Words));
            WOffset:=0;
            val(Field,WOffset,I);
            delete(Words,3,length(Words)-2);
            delete(Words,TilPos,2);
          end;
      'P':begin                     (* New page *)
            delete(Words,TilPos,2);
            if BLineC>=LineSperPage-1 then
              begin
                BPurge;
              end
            else
              begin
                J:=0;
                for I:=1 to length(BLine) do
                  if (BLine[I]<>' ') then
                    J:=I;
                if J>0 then
                  BPurge;
                if DoBook then
                  begin
                    J:=BLineC;
                    for I:=J to Linesperpage do
                      BPurge;
                  end
                else
                  BTopofForm;
              end;
            if PrintIt then
              delay(B.Delay);
          end;
      'Q':begin                (* clear all tabs *)
            fillchar(TabTable,sizeof(TabTable),#0);
            delete(Words,TilPos,2);
          end;
      'R':begin                (* Roman Numerals *)
            DoRoman:=true;
            DoBook:=false;
            delete(Words,TilPos,2);
          end;
      'S':begin                 (* Skip a line *)
            NewLine:=true;
            delete(Words,TilPos,2);
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            BPurge;
          end;
      'T':begin                  (* Text Format *)
            delete(Words,TilPos,2);
            XFormat:=Text;
            J:=0;
            for I:=1 to length(BLine) do
              if (BLine[I]<>' ') then
                J:=I;
            if J>0 then
              BPurge;
            for I:=1 to WOffset do
              BLine:=BLine+' ';
            BLine6:=BLine;
          end;
      'U':begin                  (* page Numbering Off *)
            AddChar:='';
            DoPageNum:=false;
            delete(Words,TilPos,2);
          end;
      'V':begin                  (* set tab *)
            I:=ord(Words[3])-ord('0');
            if (length(Words)>=4) then
            if Words[4] in ['0','1','2','3','4','5','6','7','8','9']
              then I:=10*I+(ord(Words[4])-ord('0'));
            if I=0 then
              I:=1;
            TabTable[I]:=1;
            delete(Words,3,length(Words)-2);
            delete(Words,TilPos,2);
          end;
      'W':begin                   (* Footing *)
            OldLine:=BLine;
            OldLine6:=Bline6;
            XFooting:=true;
            XPgroup:=PGroup;
            XPjoin:=PJoin;
            XJoin:=Join;
            XGroup:=Group;
            XHyphen:=Hyphen;
            XPHyphen:=PHyphen;
            MakeFoot:=true;
            BLine:='';
            BLine6:='';
            PGroup:=false;
            Group:=false;
            Join:=false;
            PJoin:=false;
            delete(Words,TilPos,2);
          end;
      'X':begin
            Xtab:=true;
            delete(Words,TilPos,2);
          end;
      'Y':begin
            XFormat:=Lists;       (*TABLE Format*)
            delete(Words,TilPos,2);
          end;
      'Z':begin                   (* Terminator *)
            Words[TilPos+1]:='`';
            NewLine:=false;
            delete(Words,TilPos,1);
          end;
      '''':begin           (* Apostrophe *)
            Words[TilPos+1]:='=';
            delete(Words,TilPos,1);
            NewLine:=false;
          end;
      '0':begin          (*Grade 0*)
            NewLine:=false;
            XGrade:=Grade0;
            delete(Words,TilPos,2);
          end;
      '1':begin          (*Grade 1*)
            NewLine:=false;
            XGrade:=Grade1;
            delete(Words,TilPos,2);
          end;
      '2':begin          (*Grade 2*)
            NewLine:=false;
            XGrade:=Grade2;
            delete(Words,TilPos,2);
          end;
      else
        delete(Words,TilPos,1);
    end;
    TilPos:=pos('~',Words);
  until TilPos=0;
  Words[length(Words)+1]:=' ';
end;

(*****************************)
(*** Execute the Operation ***)
(*****************************)
procedure DoLOPOP(OP:byte; FStart,FLen,FapDat: integer);
var I,J:integer;
begin
  if OP<100 then
    case OP of
      1 : LineIn:='';
      2 : XFormat:=Text;
      3 : XFormat:=Lists;
      4 : LineIn:='~S ';
      5 : begin
            while (length(LineIn)>0) and (LineIn[1]=' ') do
              delete(LineIn,1,1);
            LineIn:='~C'+LineIn;
          end;
      6 : SetMargin:=OldMargin+2;
     80 : InPgLen:=FStart;
    end
  else if OP<200 then
    begin
      if (linein='') then
        exit;
      TabMargin:=true;
      if length(LineIn)<FStart then
        for I:=length(LineIn) to length(LineIn)+FLen do
          LineIn:=LineIn+' ';
      Field:=copy(LineIn,FStart,FLen);
      delete(LineIn,FStart,FLen);
      while (length(Field)>0) and (Field[1]=' ') do
        delete(Field,1,1);               (* Strip Left Side Blanks *)
      while Field[length(Field)]=' ' do   (* Strip right side blanks *)
        delete(Field,length(Field),1);

      case OP of
        101 : Field:='';               (* delete field *)
        102 : if Field<>'' then
                begin
                  I:=0;
                  repeat
                    inc(i);
                    J:=pos(StateID[I],Field);
                    if J>0 then
                      begin
                        delete(Field,J,2);
                        insert(StateName[I],Field,J);
                      end;
                  until (I>=StateCount) or (J>0);
                end;
      end;
     if FapDat>0 then
       Field:=Field+AppDat[FapDat]+' ';
     insert(Field,LineIn,FStart);
    end
  else if OP<300 then
    begin
      if linein='' then
        exit;
      if length(LineIn)<FStart then
        for I:=length(LineIn) to length(LineIn)+FLen do
          LineIn:=LineIn+' ';
      Field:=copy(LineIn,FStart,FLen);
      if ((FapDat>0) and (pos(AppDat[FapDat],Field)>0)) then
        begin
          DisableCol:=true;
          case OP of
            201 : LineIn:='';
            202 : Disablecol:=true;
          end;
        end;
   end;
end;

(**************************************************)
(*** Do Line Operation Processing -- outer loop ***)
(**************************************************)
procedure DoLop;
var I,J:integer;
begin
  DisableCol:=false;
  if LOPCount=0 then
    exit;
  for I:=1 to LOPCount do
    if L[I].LFlag then
      if (LineInCT>=L[I].LStart) and (LineInCT<=L[I].LEnd) then
        begin
          J:=L[I].FOPStart;
          DoLopOp(F[J].FOP,F[J].FStart,F[J].FLen,F[J].Fappo);
          if DisableCol then
            for J:=L[I].FOPStart+1 to L[I].FOPStart+L[I].FOPCount-1 do
              DoLopOp(F[J].FOP,F[J].FStart,F[J].FLen,F[J].Fappo);
        end;
  if not DisableCol then
    for I:=1 to LOPCount do
      if not L[I].LFlag then
        if (LineInCT>=L[I].LStart) and (LineInCT<=L[I].LEnd) then
          for J:=L[I].FOPStart to L[I].FOPStart+L[I].FOPCount-1 do
            DoLopOp(F[J].FOP,F[J].FStart,F[J].FLen,F[J].Fappo);

  if DisableCol then
    TabMargin:=false;
end;

(**********************)
(*** Read in a Line ***)
(**********************)
procedure GetLine;
var I:Integer;
begin
  fillchar(LineIn,256,' ');
  LineIn:='';
  if EndFile then
    begin
      Done:=true;
      exit;
    end;
  I:=0;
  repeat
    if eof(InFile) then
      EndFile:=true
    else
      begin
        read(InFile,C);
        I:=I+1;

        if C='^' then
          C:='~';
        if C=#31 then
          C:='|';
        if (C>#127) and (C<#255) then
          C:=chr(ord(C)-128);
        if C=#30 then
          I:=I-1
        else
          LineIn[I]:=C;
      end;
    if (InPgLen>0) and (InPgLen<100) and (C in [#11,#12]) then
      LineInCt:=0;
  until (C in [#10,#26,#138]) or
        EndFile or
        ((C=' ') and (I>200));
  if (LineInCT>InPgLen) and (InPgLen>0) then
    LineInCT:=0;
  inc(LineInCT);
  if (EndLineCt>0) then
    begin
      if (EndLineCt<2) then
        begin
          writeln;
          writeln;
          writeln('Demo Version Finished - ');
          writeln('     Call 1-800-333-7049 to order your ');
          writeln('     your licensed version of NFBTRANS.');
          sound(440);
          delay(150);
          sound(55);
          writeln('     Press a key to stop');
          write(readkey);
          nosound;
          halt;
        end;
      dec(EndLineCt);
    end;
  LineIn[0]:=chr(I);

  for I:=1 to length(LineIn) do
    if LineIn[I]<' ' then
      LineIn[I]:=' ';

  while LineIn[length(LineIn)]=' ' do   (* Strip right side blanks *)
    delete(LineIn,length(LineIn),1);

  if LOPActive then
    DoLOP;

  if DispSource then
    writeln('=>',Linein);
end;

(*************************************)
(*** See if Line should be written ***)
(*************************************)
procedure CheckPurge;
var
    I,J : Integer;
    Purgit:boolean;
begin
  Purgit:=true;
  for I:=1 to LeftMargin do    (* Determine whether to flush *)
    if LineIn[I]<>' ' then     (* when reading a new Line *)
      Purgit:=false;

  if XFormat in [Lists,Block] then
    begin
      if Purgit then
        Purgit:=false
      else
        Purgit:=true;
    end;

  if DisableCol then
    Purgit:=true;

  if Purgit then                    (* Check for Indentation *)
    begin
      NewLine:=true;
      J:=0;
      for I:=1 to length(BLine) do
        if (BLine[I]<>' ') then
          J:=I;
      if J>0 then
        BPurge;
      BLine:='';
      if XFormat=Text then
        for I:=1 to WOffset do
          BLine:=BLine+' ';
      BLine6:=BLine;
      QuoteCount:=0;
      if TabMargin then
        Margin:=SetMargin
      else
        Margin:=OldMargin;
      TabMargin:=false;
    end;
end;

(***********************************)
(***   Extract a Word From the   ***)
(***   Input Text -- check for   ***)
(***          commands           ***)
(***********************************)
procedure GetWord;
var I:Integer;
begin
  Hyphen:=false;
  if XAcronym then
    XAcronym:=false;

  NewLine:=false;
  fillchar(Words,80,#0);
  while (length(LineIn)<1) and not done do
    begin
      if MakeFoot then
        begin
          Makefoot:=false;
          fillchar(FLine[1],80,' ');
          FLine[0]:=chr(LineLength);
          if length(BLine)>0 then
            move(BLine[1],FLine[LineLength-length(BLine)+1],length(BLine));
          BLine:=OldLine;
          BLine6:=OldLine6;
          PGroup:=XPgroup;
          PJoin:=XPJoin;
          Join:=XJoin;
          Group:=XGroup;
        end;
      if MakeHead then
        begin
          Makehead:=false;
          fillchar(HLine[1],80,' ');
          HLine[0]:=chr(CurMax);
          if length(BLine)>0 then
            move(BLine[1],HLine[1+(LineLength-length(BLine)) div 2],
               length(BLine));
          BLine:=OldLine;
          BLine6:=OldLine6;
          PGroup:=XPgroup;
          PJoin:=XPJoin;
          Join:=XJoin;
          Group:=XGroup;
        end;
      GetLine;
(*      NewLine:=true; *)
      CheckPurge;
    end;

  if Done then
    exit;
  while pos(' ',LineIn)=1 do            (* Strip Left Side blanks *)
    delete(LineIn,1,1);
   if pos(' ',LineIn)>1 then             (* Extract the Word *)
    Words:=Copy(LineIn,1,pos(' ',LineIn)-1)
  else
    Words:=LineIn;

  delete(LineIn,1,length(Words));

  if pos('~',Words)>0 then
    DoCommands;
end;

(******************************************************)
(*** Set up the Vector for the characters in a Word ***)
(******************************************************)
procedure SetVect;
var I:integer;
begin
  I:=0;
  repeat
    inc(I);
    CapVec[I]:=0;
    SubVec[I]:=0;
    if (Words[I]='|') then
      begin
        delete(Words,I,1);
        CapVec[I]:=9;
        Words[I]:=chr(ord(Words[I])+128);
      end
    else
      begin
        if (Words[I]>='A') and (Words[I]<='Z') then
          CapVec[I]:=2;
        if (Words[I]>='a') and (Words[I]<='z') then
          begin
            CapVec[I]:=1;
            Words[I]:=chr(ord(Words[I])-32);
          end;
      end;
  until I>=length(Words);
  CapVec[length(Words)+1]:=0;
  SubVec[length(Words)+1]:=0;
end;

(***********************************)
(***   Check the extracted word  ***)
(*** against the table of valid  ***)
(*** types:                      ***)
(***      1-use anywhere         ***)
(***      2-must be exact match  ***)
(***      3-at beginning or all  ***)
(***      4-only in middle       ***)
(***      5-joins with same type ***)
(***      6-joins next-to,into,by***)
(***      7-not at beginning     ***)
(***      8-the word BE          ***)
(***      9-his,was,were,enough  ***)
(***     10-only at end          ***)
(***********************************)
procedure DoLetter;
label 10;
var I,J,K,Matchend,WLength,WStart,CaseType:Integer;
    AtEnd,Matched:boolean;
    MWorks:string[40];
begin
  LastMatch:=Count;
  WLength:=length(Words);
  WStart:=1;
  while Words[WStart]='_' do
    begin
      WLength:=WLength-1;
      WStart:=WStart+1;
    end;
  WStart:=1;             (* for firstletter *)

  Join:=false;
  Group:=false;
  Matched:=false;
  FirstLetter:=FirstLetter+1;
  SubVec[Count]:=Point;
  I:=B.Start2[pos(Words[Count],Letters),pos(Words[Count+1],Letters)];

  if (I>0) and (XGrade=Grade2) and not XAcronym then
    repeat
      MWorks:=B.Match[I];
      MatchEnd:=Count+length(MWorks)-1;
      if MWorks<>Copy(Words,Count,length(MWorks)) then
        goto 10;

      if (FirstLetter>WStart) and (B.TypeX[I] in [2,3,6,8]) then
        goto 10;
      if (FirstLetter=WStart) and (B.TypeX[I] in [4,7]) then
        goto 10;

      J:=ord(Words[MatchEnd+1]);         (* Next Letter *)
      if (B.TypeX[B.Start1[J]]>0) and (B.TypeX[B.Start1[J]]<11) then
        AtEnd:=false
      else               (* Set end of Word if next char not Letter *)
        AtEnd:=true;

      if not AtEnd and (B.TypeX[I] in [2,6,10]) then
        goto 10;

      if AtEnd and ((B.TypeX[I]=4) or
                    ((MWorks='IN') and (B.TypeX[I]=3))) then
                                   (* in [3,4] *)
        goto 10;

      if (B.TypeX[I]=5) and (AtEnd) and (FirstLetter=WStart)
        and not (Words[WStart]='\') then
        Group:=true;

      if PJoin and (B.TypeX[I]=8) and AtEnd then
        goto 10;

      if (B.TypeX[I]=8) and (Matchend=WLength)
        and (WLength<>length(MWorks)) then
        goto 10;

      if (B.TypeX[I]=9)                      and  (* was, his, etc. *)
         ((length(MWorks)<>WLength) or
           PJoin)                            then
        goto 10;

      if (B.TypeX[I]=6) then
        begin
          if (Matchend-WStart+1<>WLength) then
            goto 10;      (* to Into by *)
          Join:=true;
        end;

      CaseType:=CapVec[Count];
      if CaseType=1 then
        for K:=1 to length(MWorks)-1 do
          if (MWorks[K+1] in ['A'..'Z']) then
            if CapVec[Count+K]<>CaseType then
              goto 10;

      SubVec[Count]:=I;
      Count:=MatchEnd;
      Matched:=true;

      10: if not Matched then
            inc(I);
      Work1:=B.Match[I];
    until Matched or (Work1[2]<>MWorks[2]);
  QuoteOpen:=false;
  QuoteClose:=false;
end;

(***********************************)
(***      Convert NumberS        ***)
(***           Type 11           ***)
(***********************************)
procedure DoNumber;
begin
  if XGrade=Grade0 then
    exit;                     (* check for minus - make in (9) sign *)
  FirstLetter:=0;
  SubVec[Count]:=Point;
  CapVec[Count]:=3;
  QuoteOpen:=false;
  QuoteClose:=false;
end;

(***********************************)
(***  Convert THE PUNCTUATION    ***)
(***  Type 21 - Simple Replace   ***)
(***       22 - .                ***)
(***       24 - '                ***)
(***       25 - "                ***)
(***       27 - -                ***)
(***********************************)
procedure DoPunct;
var I,J        : Integer;
    Matched    : boolean;
    Apostrophe : boolean;
begin
  Point:=Point-1;
  repeat
    Point:=Point+1;
  until B.Match[Point]=Copy(Words,Count,length(B.Match[Point]));

  if Count>1 then           (* Check for capital mark requirement *)
    if LastMatch>0 then
      if B.TypeX[abs(SubVec[LastMatch])] in [6,8,9] then
        SubVec[LastMatch]:=-abs(SubVec[LastMatch]);

  Matched:=false;

  Join:=false;
  Group:=false;
  PGroup:=false;
  Apostrophe:=false;

  if B.TypeX[Point]=24 then
    begin
      if (Words[Count-1] in ['A'..'Z','0'..'9']) and
         (Words[Count+1] in ['A'..'Z','0'..'9']) then
         Apostrophe:=true;
      if (Words[Count-1] in ['A'..'Z','0'..'9']) and
         (QuoteCount=0) then
         Apostrophe:=true;
      if (Count=length(Words)) and (Words[Count-1] in ['S','N']) then
         begin end; (* Maybe an apostrophe *)
    end;

  if not Apostrophe and (B.TypeX[Point] in [24,25]) then   (* Handle quotes *)
    begin
      if QuoteOpen or ((Count>1) and
        not (Words[Count-1] in ['(','-','"','''','[']) and
        not QuoteClose) then
        begin      (* Ending quote *)
          if odd(QuoteCount) then
            SubVec[Count]:=B.Start1[ord('>')]
          else
            SubVec[Count]:=B.Start1[ord('}')];
          QuoteCount:=QuoteCount-1;
          QuoteOpen:=true;
        end
      else
        begin      (* Beginning quote *)
          if PJoin then
            begin
              PJoin:=false;
              BLine:=Bline6;    (* reset for to into by *)
            end;
          QuoteCount:=QuoteCount+1;
          if odd(QuoteCount) then
            SubVec[Count]:=B.Start1[ord('<')]
          else
            SubVec[Count]:=B.Start1[ord('{')];
          QuoteClose:=true;
        end;
      exit;
    end;

  repeat                        (* Find replacement *)
    I:=Count+length(B.Match[Point])-1;
    if B.Match[Point]=Copy(Words,Count,length(B.Match[Point])) then
      begin
        Matched:=true;
        SubVec[Count]:=Point;
        Count:=I;
      end
    else
      Point:=Point+1;
  until Matched;

  if B.TypeX[Point]<>27 then
    FirstLetter:=0;
  QuoteOpen:=false;
  QuoteClose:=false;
end;

(***********************************)
(***   Build the Word From the   ***)
(***   Information kept in the   ***)
(***     contraction vector      ***)
(***********************************)
procedure BuildWord;
var NoLow,Num,AllCaps:boolean;
    I,J:Integer;
begin
  BWord:='';
  BWord6:='';
  NUM:=false;
  AllCaps:=false;

  OldWord:=Words;
  for I:=1 to length(Words) do
    if CapVec[I]=9 then
      begin
        BWord:=BWord+chr(ord(Words[I])-128);
      end
    else if SubVec[I]<>0 then
      begin
        if SubVec[I]<0 then
          begin
            NoLow:=true;
            SubVec[I]:=-SubVec[I];
          end
        else
          NoLow:=false;

        if (not Num) and ((B.TypeX[SubVec[I]]=11)
           or ((B.TypeX[SubVec[I]]=22) and (B.TypeX[SubVec[I+1]]=11)))
          then
          begin
            BWord:=BWord+'#';
            Num:=true;
            AllCaps:=false;
            Join:=false;
            Group:=false;
            PGroup:=false;
          end;

        if B.TypeX[SubVec[I]] in [11,21,23,24,25,27] then
          BWord:=BWord+B.Replace[SubVec[I]];

        if (B.TypeX[SubVec[I]]=22) then
          if (B.TypeX[SubVec[I+1]]=11) then
            BWord:=BWord+'.'
          else
            BWord:=BWord+B.Replace[SubVec[I]];

        if Num and (B.TypeX[SubVec[I]]=26) then  (* Percent *)
          begin
              (* note Insert if ( *)
            J:=pos('#',BWord);
            if J=0 then
              J:=1;
            insert(B.Replace[SubVec[I]],BWord,J);
          end;

        if (B.TypeX[SubVec[I]]>0) and (B.TypeX[SubVec[I]]<11) then
          begin
            if NUM and (B.Match[SubVec[I]]<>'-') then
              begin
                NUM:=false;
                if (Words[I]='S') and (Words[I-1]<>'''') then
                  BWord:=BWord+'''';
                if ((CapVec[I]=1) and (Words[I]<'K') and
                    (not (Words[I+1] in ['A'..'Z'])))
(*
                   or
                   (((CapVec[I]=1) and (Word[I]='P')) and
                    ((CapVec[I+1]=1) and (Word[I+1]='M')))
*)
                    then
                  BWord:=BWord+';';
              end;
            if (not AllCaps) and (CapVec[I]=2) then
              begin
                PGroup:=false;
                BWord:=BWord+',';
                if CapVec[I+1]=2 then
                  begin
                    BWord:=BWord+',';
                    AllCaps:=true;
                  end;
              end;
            if (B.TypeX[SubVec[I]]=6) then
              begin
                BWord6:=BWord+B.Match[SubVec[I]];
                if BWord6='INTO' then
                  BWord6:='9TO';
              end;

            if NoLow then
              BWord:=BWord+B.Match[SubVec[I]]
            else
              BWord:=BWord+B.Replace[SubVec[I]];
          end;
      end;
  if (Words='$') then
    begin
      BWord:='4#';
      BWord6:='4#';
    end;
end;

(***********************************)
(***   Determine Letter Type     ***)
(***********************************)
procedure TransWord;
var I,J:Integer;
begin
  QuoteOpen:=false;
  QuoteClose:=false;
  LastMatch:=0;
  FirstLetter:=0;
  Count:=0;
  repeat
    inc(Count);
    if CapVec[Count]<>9 then
      begin
        CharDec:=ord(Words[Count]);
        Point:=B.Start1[CharDec];
        if (B.TypeX[Point]>0) and (B.TypeX[Point]<=10) then
          DoLetter;
        if B.TypeX[Point]=11 then
          DoNumber;
        if B.TypeX[Point]>20 then
          DoPunct;
      end;
  until Count>=length(Words);
end;

(**************************)
(*** Do the Translation ***)
(**************************)
procedure DoTranslate;
var I:integer;
begin
  fillchar(BLine,sizeof(Bline),' ');
  BLine:='';
  fillchar(BLine6,sizeof(BLine6),' ');
  BLine6:='';
  fillchar(Words,sizeof(Word),#0);
  fillchar(BWord,sizeof(BWord),#0);
  fillchar(BWord6,sizeof(BWord6),#0);
  fillchar(OldWord,sizeof(OldWord),#0);
  fillchar(TabVec,sizeof(TabVec),#0);
  fillchar(TabTable,sizeof(TabTable),#0);

  PGroup:=false;
  PJoin:=false;
  Join:=false;
  Group:=false;
  Hyphen:=false;
  PHyphen:=false;
  XGrade:=Grade2;
  XAcronym:=true;
  XCenter:=false;
  XFormat:=Text;
  XTab:=false;
  DoBook:=false;
  XDouble:=false;
  XHeading:=false;
  XFooting:=false;
  MakeFoot:=false;
  MakeHead:=false;
  DoPageNum:=true;
  PageSet:=false;
  DoRoman:=false;
  DisableCol:=false;
  FillIt:=false;
  QuoteCount:=0;
  Margin:=1;
  SetMargin:=1;
  OldMargin:=1;
  TabMargin:=false;
  BPageB:=0;
  BPageC:=0;
  BLineC:=0;
  ActualPage:=0;
  WOffset:=2;
  fillchar(Linein,sizeof(Linein),' ');
  LineIn:='';
  LineInCT:=0;
  InPGLen:=0;
  Field:='';
  AddChar:='';
  CurMax:=MaxLine;
  LineLength:=MaxLine+1-Margin;
  Copies:=Copies+1;

  if FromFile then
    begin
      assign(InFile,FileIn);
      reset(InFile);
    end;

  BTopofForm;
  EndFile:=false;
  Done:=false;
  repeat
    GetWord;
    if (length(Words)>1) and
       (Words[length(Words)]='-') and
       (Words[length(Words)-1]<>'-') then
      begin
        OldWord:=Words;
        GetWord;
        Words:=OldWord+Words;
      end;
    SetVect;
    if length(Words)>0 then
      begin
        if XGrade=Grade0 then
          begin
            BWord:=Words;
            BWord6:=Words;
          end
        else
          begin
            TransWord;
            BuildWord;
          end;
        BuildLine;
      end;
  until Done;
  BPurge;
  close(InFile);

  if XFooting and (BLinec>0) then
    begin
      for I:=BLineC+2 to LinesPerPage do
        if BPageC>PageStart then
          begin
            writeln(Outext,'  ');
            if DispBraille then
              writeln;
          end;
      if BPageC>PageStart then
        begin
          writeln(Outext,FLine);
          if DispBraille then
            writeln(FLine);
        end;
      BLinec:=LinesPerPage;
    end;

  if (BLinec>0) then
    begin
      if LineSkips<99 then
        for I:=BLineC+1 to LinesPerPage+LineSkips do
          writeln(Outext,'  ');
      if LineSkips=99 then
        write(Outext,#12);
      if LineSkips=999 then
        writeln(Outext,#11);
      if LineSkips=9999 then
        begin
          writeln(Outext,#12);
          writeln;
          write('To Continue, Press Return');
          readln;
        end;
      if PrintIt then
        delay(B.Delay);
      inc(actualpage);
    end;

  if not odd(ActualPage) then
    begin
      if LineSkips<99 then
        for I:=BLineC+1 to LinesPerPage+LineSkips do
          writeln(Outext,'  ');
      if LineSkips=99 then
        write(Outext,#12);
      if LineSkips=999 then
        writeln(Outext,#11);
      if LineSkips=9999 then
        begin
          writeln(Outext,#12);
          writeln;
          write('To Continue, Press Return');
          readln;
        end;
      if PrintIt then
        delay(B.Delay);
    end;
  flush(outext);
end;
end.
