program NFBtable;
(***************************************************************)
(*** Copyright (c) 1991 The National Federation of the Blind ***)
(*** This code may be not be distributed in this source code ***)
(*** format.  Any programs derived from or using this code   ***)
(*** may not be sold or released without permission from the ***)
(*** National Federation of the Blind.  Licensed owners of   ***)
(*** NFBTRANS may freely use and modify this program code    ***)
(*** except as stated above.                                 ***)
(***************************************************************)

CONST VERSION='Version July 1, 1991';
      COPYRIGHT='Copyright NFB, 1984...1991';
      MAXTAB=900;

TYPE
  T = record
    DLines   : integer;
    DSkips   : integer;
    Delay    : integer;
    Start1   : array[0..255] of integer;
    Start2   : array[0..26,0..26] of integer;
    TypeX    : array[0..MaxTab] of integer;
    Match    : array[0..MaxTab] of string[10];
    Replace  : array[0..MaxTab] of string[10];
  end;

VAR
  Field    : string[80];
  BTABLE   : TEXT;
  BLINE    : STRING[80];
  RESULT   : BOOLEAN;
  WORK1    : STRING[80];
  WORK2    : STRING[80];

  LETTERS  : STRING[26];
  B        : T;
  BFILE    : FILE OF T;

(***********************************)
(***   THIS SECTION LOADS THE    ***)
(*** TABLES AND INITIALIZES THE  ***)
(***          PROGRAM            ***)
(***********************************)

PROCEDURE LOAD_TABLES;
LABEL 99;
VAR I,J,K,L:INTEGER;
    WORK:STRING[80];
    LENMAT,LENREP:INTEGER;

BEGIN
  I:=0;
  ASSIGN(BFILE,'NFBTRANS.TAB');
  REWRITE(BFILE);
  FILLCHAR(B,SIZEOF(T),CHR(0));
  B.TYPEX[0]:=0;
  B.MATCH[0]:='0000000000';

  writeln;
  write('Default lines per page:');
  readln(B.DLINES);

  writeln;
  write('Default Line Skips (99 will use FF, 999 - VT):');
  readln(B.DSKIPS);

  writeln;
  write('Delay factor (0-Thiel, 3000-Triformation):');
  readln(B.DELAY);

  ASSIGN(BTABLE,'BRAILLE.TAB');
  RESET(BTABLE);
  LETTERS:='ABCDEFGHIJKLMNOPQRSTUVWXYZ';
  WORK2:='        ';

  REPEAT
    READLN(BTABLE,BLINE);
    IF BLINE<>'$DONE$' THEN
      BEGIN
        I:=I+1;

        WORK:=COPY(BLINE,1,POS('|',BLINE)-1);
        B.TYPEX[I]:=ORD(WORK[LENGTH(WORK)])-48;
        IF LENGTH(WORK)>1 THEN
          B.TYPEX[I]:=B.TYPEX[I]+10*(ORD(WORK[1])-48);
        DELETE(BLINE,1,POS('|',BLINE));

        LENMAT:=LENGTH(COPY(BLINE,1,POS('|',BLINE)-1));
        IF LENMAT>10 THEN
          BEGIN
            WRITELN('ERROR-TOO LONG:',BLINE);
            GOTO 99;
          END;
        B.MATCH[I]:=COPY(BLINE,1,POS('|',BLINE)-1);

        DELETE(BLINE,1,POS('|',BLINE));

        LENREP:=LENGTH(BLINE);
        IF LENREP>10 THEN
          BEGIN
            WRITELN('ERROR-TOO LONG:',BLINE);
            GOTO 99;
          END;
        B.REPLACE[I]:=BLINE;


        WORK1:=B.MATCH[I];
        if I>1 then
          WORK2:=B.MATCH[I-1];

        IF WORK1[1]<>WORK2[1] THEN
          BEGIN
            B.START1[ORD(WORK1[1])]:=I;
            B.START2[POS(WORK1[1],LETTERS),0]:=I;
            WRITELN(B.TYPEX[I],WORK1,'|',B.REPLACE[I]);
          END
        ELSE
          IF WORK1[2]<>WORK2[2] THEN
            B.START2[POS(WORK1[1],LETTERS),POS(WORK1[2],LETTERS)]:=I;
      END;
  UNTIL BLINE='$DONE$';
  CLOSE(BTABLE);

  WRITE(BFILE,B);
  CLOSE(BFILE);
99:
END;

begin
  WRITELN('** ',VERSION,' **');
  WRITELN('** ',COPYRIGHT,' **');
  WRITELN('** LOADING TABLES **');
  LOAD_TABLES;
  WRITELN('** TABLES LOADED **');
end.
