program NFBTRANS;
(***************************************************************)
(*** Copyright (c) 1991 The National Federation of the Blind ***)
(*** This code may be not be distributed in this source code ***)
(*** format.  Any programs derived from or using this code   ***)
(*** may not be sold or released without permission from the ***)
(*** National Federation of the Blind.  Licensed owners of   ***)
(*** NFBTRANS may freely use and modify this program code    ***)
(*** except as stated above.                                 ***)
(***************************************************************)
(*$V-*)
uses crt,
     nfbvar,
     nfbcode;
const
      EndLine   = 0;
      Owner     = 'Bulletin Board';
      Version   = 'Version July, 1991';
      Release   = '7.0';
      Copyright =
      'Copyrighted by The National Federation of the Blind, 1983...90';
var
  I : integer;

(******************)
(*** Get Params ***)
(******************)
procedure GetParams;
var I,J,K : integer;
begin
  K:=1;
  field:='      ';
  Field:=paramstr(1);
  if (Field[3]<>'=') then
    begin
      FileIn:=paramstr(1);
      Default:=true;
      writeln('Processing file - ',FileIn);
      K:=2;
      Field:=paramstr(2);
      val(Field,DCopies,Code);
      if DCopies=0 then
        DCopies:=1;
      if Code=0 then
        K:=3;
    end;

  for I:=K to Paramcount do
    begin
      Field:=paramstr(I);
      for J:=1 to length(Field) do
        Field[J]:=upcase(Field[J]);
      if copy(Field,1,3)='CO=' then
        begin
          delete(Field,1,3);
          val(Field,DCopies,Code);
          Field:='';
        end;
      if copy(Field,1,3)='PL=' then
        begin
          delete(Field,1,3);
          val(Field,LinesPerPage,Code);
          Field:='';
        end;
      if copy(Field,1,3)='PW=' then
        begin
          delete(Field,1,3);
          val(Field,MaxLine,Code);
          Field:='';
        end;
      if copy(Field,1,3)='FO=' then
        begin
          delete(Field,1,3);
          FileOut:=Field;
          Field:='';
          PrintIt:=false;
        end;
      if copy(Field,1,3)='PO=' then
        begin
          delete(Field,1,3);
          FileOut:=Field;
          Field:='';
        end;
      if copy(Field,1,3)='PS=' then
        begin
          delete(Field,1,3);
          val(Field,PageStart,Code);
          Field:='';
        end;
      if copy(Field,1,3)='PE=' then
        begin
          delete(Field,1,3);
          val(Field,PageEnd,Code);
          Field:='';
        end;
      if copy(Field,1,3)='FX=' then
        begin
          UseTemplate:=true;
          delete(Field,1,3);
          FileTemp:=Field;
          Field:='';
        end;
      if copy(Field,1,2)='ND' then
        begin
          DispBraille:=false;
          Field:='';
        end;
    end;
end;

(******************)
(*** Initialize ***)
(******************)
procedure Init;
var I,J : integer;
begin
  DirectVideo:=false;
  Default:=false;
  writeln;
  writeln('Grade Two Braille Translator - Release '+Release);
  writeln(Copyright);
  writeln(Version);

  FileIn:='';
  DCopies:=1;
  FileOut:='PRN';
  PrintIt:=true;
  UseTemplate:=false;
  DispBraille:=true;
  DispBraille:=true;
  DispSource:=false;
  MaxLine:=40;
  EndLineCt:=EndLine;
  fillchar(L,sizeof(L),#0);
  LOPActive:=false;
  PageStart:=1;
  PageEnd:=9999;
  TabPath:='';
  for I:=1 to Paramcount do
    begin
      Field:=paramstr(I);
      for J:=1 to length(Field) do
        Field[J]:=upcase(Field[J]);
      if copy(Field,1,3)='TP=' then
        begin
          delete(Field,1,3);
          TabPath:=Field;
          Field:='';
        end;
    end;

  LOADTABLES;

  if paramcount>0 then
    GetParams;

  writeln;
  writeln(Owner,' is the Registered Owner');
end;

(***********************************)
(***      Translate A File       ***)
(***********************************)
procedure TranslateFile;
var I:integer;
begin
  repeat
    if not Default then
      repeat
        write('Source File name?');
        readln(FileIn);
      until FileIn<>'';

    Count:=0;
    if FileIn<>'' then
      begin
        assign(InFile,FileIn);
        (*$I-*)
        reset(InFile);
        (*$I+*)
        Count:=ioresult;
      end;
    if Count<>0 then
      begin
        writeln('*** File not found .... ***'+#7);
        exit;
      end
    else
      close(Infile);;
  until Count=0;

  InPgLen:=66;

  LeftMargin:=1;
  FromFile:=true;
  if FileIn='' then
    FromFile:=false
  else
    if not Default then
      begin
        writeln('Enter Number of spaces before Left Margin');
        write('  of source File (usually 1)? ',LeftMargin,#8);
        readln(Field);
        val(Field,LeftMargin,Code);
        if LeftMargin=0 then
          LeftMargin:=1;
      end;

  LinesPerPage:=B.DLines;
  LineSkips:=B.DSkips;

  if not Default then
    begin
      writeln('Enter Number of braille cells to emboss');
      write('  on a Line (usually 40)? ',MaxLine,#8+#8);
      readln(Field);
      val(Field,MaxLine,Code);
      if MaxLine=0 then
        MaxLine:=40;

      write('Display Source Text (Y/N)? N'+#8);
      readln(Field);
      if (Field='Y') or (Field='y') then
        DispSource:=true;

      write('Display Translated Text (Y/N)? Y'+#8);
      readln(Field);
      if (Field='N') or (Field='n') then
        DispBraille:=false;

      write('Number of Lines per Page? ',LinesPerPage,#8+#8);
      readln(Field);
      val(Field,LinesperPage,Code);
      if LinesPerPage=0 then
        LinesperPage:=B.DLines;

      write('Line Skips between Pages (99-FF, 999-VT)? ',LineSkips,#8);
      readln(Field);
      val(Field,LineSkips,Code);
      if LineSkips=0 then
        LineSkips:=B.DSkips;

      PrintIt:=true;
      writeln('Please select ');
      writeln('  1 to Translate and store in a File or');
      writeln('  2 Translate and emboss immediately.');
      write('  Choice? 2'+#8);
      repeat
        readln(Field);
        if Field='' then
          Field:='2';
      until Field[1] in ['1','2'];

      if Field[1]='1' then
        begin
          PrintIt:=false;
          write('Enter name of File to create? ');
          readln(FileOut);
        end;

      write('Name of External Format File (RETURN for none)?');
      readln(Field);
      if Field<>'' then
        begin
          Filetemp:=Field;
          UseTemplate:=true;
        end;
    end;

  if Printit and not Default then
    begin
      write('Enter First Page to Emboss? ',PageStart,#8);
      readln(Field);
      val(Field,PageStart,Code);
      write(' Enter Last Page to Emboss? ',PageEnd,#8+#8+#8+#8);
      readln(Field);
      if Field<>'' then
        val(Field,PageEnd,Code);
      if Pagestart=0 then
        Pagestart:=1;
    end;

  Copies:=0;
  LastCopy:=1;
  if Default then
    LastCopy:=DCopies;
  if FromFile and not Default then
    begin
      write('Enter Number of Copies? ',LastCopy,#8);
      readln(Field);
      val(Field,LastCopy,Code);
    end;
  if LastCopy=0 then
    LastCopy:=1;
  writeln;

  if UseTemplate then
    DoTemplate;

  if not PrintIt then
    begin
      assign(Outext,FileOut);
      (*$I-*)
      reset(Outext);
      (*$I+*)
      if ioresult=0 then
        begin
          sound(220);
          write('File ',FileOut,' exists - Overwrite (Y/N)? '+#7);
          sound(110);
          for I:= 1 to 5 do
            begin
              sound(220);
              sound(110);
            end;
          readln(Field);
          nosound;
          if (Field='N') or (Field='n') then
            Exit;
          Field:='';
        end;
      writeln('Writing to file - ',Fileout);
    end;

  assign(Outext,FileOut);
  rewrite(Outext);
  repeat
    DoTranslate;
  until Copies>=LastCopy;
  close(Outext);
end;

(********************************)
(*** Emboss a translated File ***)
(********************************)
procedure EmbossFile;
label Finished;
begin
  LastCopy:=DCopies;
  Copies:=0;
  if FileIn='' then
    begin
      write('Please Type the name of the already Translated File? ');
      readln(FileIn);

      LastCopy:=1;
      write('Number of Copies? ',LastCopy,#8);
      readln(Field);
      val(Field,LastCopy,Code);
      if LastCopy=0 then
        LastCopy:=1;
      writeln;

      write('Start at Page? ',PageStart,#8);
      readln(Field);
      val(Field,PageStart,Code);
      if Pagestart=0 then
        Pagestart:=1;
      writeln;

      PageEnd:=0;
      write('Stop at Page (0 for end)? ',PageEnd,#8);
      readln(Field);
      val(Field,PageEnd,Code);
      writeln;
      Default:=false;
    end
  else
    Default:=true;
  if PageEnd<1 then
    PageEnd:=9999;

  FileOut:='PRN';
  PrintIt:=true;
  assign(Outext,FileOut);
  rewrite(Outext);
  BPageC:=1;

  repeat
    Copies:=Copies+1;
    assign(InText,FileIn);
    reset(InText);
    repeat
      readln(InText,Field);
      if (pos(#11,Field)>0) or
         (pos(#12,Field)>0) then
         BPageC:=BPageC+1;
      if BPageC>PageEnd then
        goto Finished;
      if DispBraille and (BPagec>PageStart) then
        begin
          write(Field);
          if length(Field)>20 then
            write('       Copy ',Copies,' of ',LastCopy);
          writeln;
        end;
      if BPageC>=PageStart then
        begin
          if (pos(#11,Field)>0) then
            begin
              writeln(Field);
              delete(Field,pos(#11,Field),1);
              write(Outext,#11);
              delay(B.Delay);
              if length(Field)>0 then
                writeln(Outext,Field);
            end
          else
            if (pos(#12,Field)>0) then
              begin
                writeln(Field);
                delete(Field,pos(#12,Field),1);
                write(Outext,#12);
                delay(B.Delay);
                if length(Field)>0 then
                  writeln(Outext,Field);
              end
            else
              begin
                writeln(Outext,Field);
                writeln(Field);
              end;
        end;
    until eof(InText) or (BPageC>PageEnd);
Finished:
    close(InText);
  until Copies>=LastCopy;
  close(Outext);
end;

(***********************************)
(***      Program Mainline       ***)
(***********************************)
begin
  Init;

  repeat
    Field:=' ';
    if not Default and (PageStart=1) then
      begin
        writeln;
        writeln('Please select');
        writeln('  1 to Translate a Text File or');
        writeln('  2 to emboss a File that has been Translated.');
        write('  Choice? 1'+#8);
        sound(440);
        delay(20);
        sound(1760);
        delay(20);
        nosound;
        repeat
          readln(Field);
          if Field='' then
            Field:='1';
        until Field[1] in ['1','2'];
      end;

    if (Field[1]='1') or Default then
      TranslateFile
    else
      EmbossFile;

    if not Default then
      begin
        for I:=22 to 990 do
          sound(I);
        for I:=22 to 990 do
           sound(I);
        nosound;
        writeln;
        write('Do another Y/N? ');
        readln(Field);
      end;
  until Default or not (Field[1] in ['Y','y']);
  writeln('Returning to Operating System....');
  writeln;
end.
