unit NFBVAR;
(***************************************************************)
(*** Copyright (c) 1991 The National Federation of the Blind ***)
(*** This code may be not be distributed in this source code ***)
(*** format.  Any programs derived from or using this code   ***)
(*** may not be sold or released without permission from the ***)
(*** National Federation of the Blind.  Licensed owners of   ***)
(*** NFBTRANS may freely use and modify this program code    ***)
(*** except as stated above.                                 ***)
(***************************************************************)
interface
uses crt;
const
  MaxTab=900;

type
  T = record
    DLines   : integer;
    DSkips   : integer;
    Delay    : integer;
    Start1   : array[0..255] of integer;
    Start2   : array[0..26,0..26] of integer;
    TypeX    : array[0..MaxTab] of integer;
    Match    : array[0..MaxTab] of string[10];
    Replace  : array[0..MaxTab] of string[10];
  end;

  FOPType = record
    FOP    : byte;             (* Operation    *)
    FStart : integer;          (* Field Start  *)
    Flen   : integer;          (* Field Length *)
    FAppo  : integer;          (* pointer to Data *)
  end;

  LOPType = record
    LStart     : integer;      (* Line Start      *)
    LEnd       : integer;      (* Line End        *)
    LFlag      : boolean;      (* Priority        *)
    FOPStart   : integer;      (* Start of Fops   *)
    FOPCount   : integer;      (* Number of FOPS  *)
  end;

  StateNameType = string[20];
  StateIDType   = string[02];

var
  StateName  : array[1..60] of StateNameType;
  StateID    : array[1..60] of StateIDType;
  StateCount : integer;

  DotTab     : array[0..255] of byte;
  BNumber    : array[0..9] of char;
  Table      : File of T;
  B          : T;

  LineSkips    : integer;
  LinesPerPage : integer;

  InFile     : text;
  InText     : text;
  OuText     : text;
  FromFile   : boolean;
  UseTemplate: boolean;
  FileIn     : string[48];
  FileOut    : string[48];
  FileTemp   : string[48];
  Letters    : string[127];

  MaxLine    : integer;
  EndLineCt  : integer;
  DispBraille: boolean;
  DispSource : boolean;
  Printit    : boolean;
  LeftMargin : integer;

  CapVec     : array[1..255] of integer;
  SubVec     : array[1..255] of integer;

  Default    : boolean;
  DCopies    : integer;
  PageStart  : integer;
  PageEnd    : integer;
  Field      : string[255];
  Code       : integer;
  Count      : integer;
  Copies     : integer;
  LastCopy   : integer;
  BPageC     : integer;

  Token      : array[1..100] of string[40];
  TCount     : integer;
  TCur       : integer;
  LLine      : string;
  Finished   : boolean;
  LOPCount   : integer;
  FOPCount   : integer;
  L          : array[1..40] of LOPType;
  F          : array[1..40] of FOPType;
  AppDat     : array[1..40] of string[40];
  APPCount   : integer;
  LopActive  : boolean;
  LFile      : text;
  LCount     : integer;
  TempError  : integer;
  InPgLen    : integer;
  TabPath    : string[40];

procedure LoadTables;
procedure DoTemplate;

implementation

function GetToken:boolean;
var Delim : char;
    I     : integer;
begin
  GetToken:=false;
  Delim:=' ';
  while (LLine[0]>#0) and (LLine[1]=' ') do
    delete(LLine,1,1);
  if LLine='' then
    exit;
  if LLine[1] in ['"',''''] then
    begin
      Delim:=LLine[1];
      delete(LLine,1,1);
    end;
  if LLine='' then
    exit;

  inc(TCount);
  I:=pos(Delim,LLine);
  if I=0 then
    begin
      Token[TCount]:=LLine;
      LLine:='';
    end
  else
    begin
      Token[TCount]:=copy(LLine,1,I-1);
      delete(LLine,1,I);
      GetToken:=true;
    end;
end;

procedure Getline;
var I : integer;
begin
  inc(LCount);
  readln(LFile,LLine);
end;

function PopTok:string;
begin
  PopTok:='';
  if TCur>=TCount then
    exit;
  inc(TCur);
  PopTok:=Token[TCur];
end;

function CheckToken(Token:string):integer;
var I : integer;
begin
  if Token='' then
    begin
      CheckToken:=999;
      exit;
    end;
  CheckToken:=888;
  val(Token,I,code);
  if code=0 then
    exit;
  for I:=1 to length(Token) do
    Token[I]:=upcase(Token[I]);
  CheckToken:=999;
  if copy(Token,1,1)='D' then            (* delete *)
    CheckToken:=1
  else if copy(Token,1,1)='T' then       (* text   *)
    CheckToken:=2
  else if copy(Token,1,1)='L'  then      (* list   *)
    CheckToken:=3
  else if copy(Token,1,2)='SK' then      (* skip   *)
    CheckToken:=4
  else if copy(Token,1,1)='C' then       (* center *)
    CheckToken:=5
  else if copy(Token,1,3)='IND' then     (* indent *)
    CheckToken:=6
  else if copy(Token,1,3)='PAG' then     (* Page Len *)
    CheckToken:=80
  else if copy(Token,1,3)='FIE' then     (* Field  *)
    CheckToken:=100
  else if copy(Token,1,1)='O' then       (* Omit *)
    CheckToken:=101
  else if copy(Token,1,2)='ST' then      (* State Expand *)
    CheckToken:=102
  else if copy(Token,1,1)='A' then       (* Append *)
    CheckToken:=199
  else if copy(Token,1,3)='MAT' then     (* Match *)
    CheckToken:=202;
end;

procedure DoOps;
var I : integer;
begin
  TCur:=0;
  Field:=PopTok;
  for I:=1 to length(Field) do
    Field[I]:=upcase(Field[I]);
  if Field<>'LINE' then
    begin
      writeln('Invalid first Operation - must be LINE in line ',LCount);
      writeln(LLine);
      Temperror:=100;
      exit;
    end;

  Field:=PopTok;
  if CheckToken(Field)<>888 then
    begin
      writeln('No line numbers specified in line ',LCount);
      writeln(LLine);
      Temperror:=110;
      exit;
   end;

  inc(LOPCount);
  val(Field,L[LOPcount].LStart,code);
  L[LOPCount].LEnd:=L[LOPCount].LStart;
  L[LOPCount].FOPStart:=FOPCount+1;
  L[LOPCount].LFlag:=false;
  Field:=PopTok;
  if CheckToken(Field)=888 then
    begin
      val(Field,L[LOPCount].LEnd,code);
      Field:=PopTok;
    end;

  while CheckToken(Field)<100 do
    begin
      inc(FOPCount);
      inc(L[LOPCount].FOPCount);
      F[FOPCount].FOP:=CheckToken(Field);
      Field:=PopTok;
      if F[FOPCount].FOP=80 then
        begin
          val(Field,F[FOPcount].FStart,code);
          Field:=PopTok;
        end;
    end;

  if CheckToken(Field)=202 then
    begin
      Field:=PopTok;
      if CheckToken(Field)<>888 then
        begin
          writeln('No field numbers specified in line ',LCount);
          writeln(LLine);
          Temperror:=210;
        end;
      inc(FOPCount);
      inc(L[LOPCount].FOPCount);
      val(Field,F[FOPcount].FStart,code);
      F[FOPCount].FLen:=1;
      L[LOPCount].LFlag:=true;
      Field:=PopTok;
      if CheckToken(Field)=888 then
        begin
          val(Field,I,code);
          if I>F[FOPCount].FStart then
            F[FOPCount].FLen:=I-F[FOPCount].FStart+1;
          Field:=PopTok;
        end;

      F[FOPCount].FOP:=202;
      inc(AppCount);
      F[FOPCount].Fappo:=AppCount;
      AppDat[AppCount]:=Field;
      Field:=PopTok;
      if CheckToken(Field)=1 then
        F[FOPCount].FOP:=201;
    end;

  while CheckToken(Field)=100 do
    begin
      Field:=PopTok;
      if CheckToken(Field)<>888 then
        begin
          writeln('No field numbers specified in line ',LCount);
          writeln(LLine);
          Temperror:=210;
        end;
      inc(FOPCount);
      inc(L[LOPCount].FOPCount);
      val(Field,F[FOPcount].FStart,code);
      F[FOPCount].FLen:=1;

      Field:=PopTok;
      if CheckToken(Field)=888 then
        begin
          val(Field,I,code);
          if I>F[FOPCount].FStart then
            F[FOPCount].FLen:=I-F[FOPCount].FStart+1;
          Field:=PopTok;
        end;

      if (CheckToken(Field)>100) and (CheckToken(Field)<199) then
        begin
          F[FOPCount].FOP:=CheckToken(Field);
          Field:=PopTok;
        end;

      if (CheckToken(Field)=199) then
        begin
          if F[FOPCount].FOP=0 then
            F[FOPCount].FOP:=199;
          inc(AppCount);
          F[FOPCount].Fappo:=AppCount;
          AppDat[AppCount]:=PopTok;
          Field:=PopTok;
        end;
    end;
end;

function Posi(F:string; T:string):integer;
var I:integer;
begin
  for I:=1 to length(F) do
    F[I]:=upcase(F[I]);
  for I:=1 to length(T) do
    T[I]:=upcase(T[I]);
  Posi:=pos(F,T);
end;

procedure DoTemplate;
var
    Reply : string[10];
begin
  TempError:=0;
  LCount:=0;
  LOPCount:=0;
  FOPCount:=0;
  AppCount:=0;
  fillchar(F,sizeof(F),#0);
  fillchar(L,sizeof(L),#0);
  fillchar(AppDat,sizeof(AppDat),#0);
  assign(LFile,FileTemp);
  (*$I-*)
  reset(LFile);
  (*$I+*)
  if ioresult<>0 then
    begin
      writeln('*** External Format File not found ... ***'+#7);
      halt;
    end;

  Finished:=false;
  writeln('External Format File '+FileTemp);
  if not eof(LFile) then
    begin
      GetLine;
      repeat
        TCount:=0;
        repeat
          repeat until not GetToken;
          if eof(LFile) then
            Finished:=true
          else
            GetLine;
        until (posi('LINE',LLine)>0) or Finished;
        if TCount>0 then
          DoOps;
      until Finished;
    end;

  writeln('External Format Processing Complete');
  writeln;
  LOPActive:=true;
  close(LFile);
end;

procedure LoadStates;
begin
  StateID[01]:='AK';  StateName[01]:='Alaska';
  StateID[02]:='AL';  StateName[02]:='Alabama';
  StateID[03]:='AR';  StateName[03]:='Arkansas';
  StateID[04]:='AZ';  StateName[04]:='Arizona';
  StateID[05]:='AS';  StateName[05]:='American Samoa';
  StateID[06]:='CA';  StateName[06]:='California';
  StateID[07]:='CO';  StateName[07]:='Colorado';
  StateID[08]:='CT';  StateName[08]:='Connecticut';
  StateID[09]:='CZ';  StateName[09]:='Canal Zone';
  StateID[10]:='DC';  StateName[10]:='District of Columbia';
  StateID[11]:='DE';  StateName[11]:='Delaware';
  StateID[12]:='FL';  StateName[12]:='Florida';
  StateID[13]:='GA';  StateName[13]:='Georgia';
  StateID[14]:='GU';  StateName[14]:='Guam';
  StateID[15]:='HI';  StateName[15]:='Hawaii';
  StateID[16]:='ID';  StateName[16]:='Idaho';
  StateID[17]:='IL';  StateName[17]:='Illinois';
  StateID[18]:='IN';  StateName[18]:='Indiana';
  StateID[19]:='IA';  StateName[19]:='Iowa';
  StateID[20]:='KS';  StateName[20]:='Kansas';
  StateID[21]:='KY';  StateName[21]:='Kentucky';
  StateID[22]:='LA';  StateName[22]:='Louisiana';
  StateID[23]:='ME';  StateName[23]:='Maine';
  StateID[24]:='MD';  StateName[24]:='Maryland';
  StateID[25]:='MA';  StateName[25]:='Massachusetts';
  StateID[26]:='MI';  StateName[26]:='Michigan';
  StateID[27]:='MN';  StateName[27]:='Minnesota';
  StateID[28]:='MS';  StateName[28]:='Mississippi';
  StateID[29]:='MO';  StateName[29]:='Missouri';
  StateID[30]:='MT';  StateName[30]:='Montana';
  StateID[31]:='NE';  StateName[31]:='Nebraska';
  StateID[32]:='NV';  StateName[32]:='Nevada';
  StateID[33]:='NH';  StateName[33]:='New Hampshire';
  StateID[34]:='NJ';  StateName[34]:='New Jersey';
  StateID[35]:='NM';  StateName[35]:='New Mexico';
  StateID[36]:='NY';  StateName[36]:='New York';
  StateID[37]:='NC';  StateName[37]:='North Carolina';
  StateID[38]:='ND';  StateName[38]:='North Dakota';
  StateID[39]:='CM';  StateName[39]:='Northern Mariana IS';
  StateID[40]:='OH';  StateName[40]:='Ohio';
  StateID[41]:='OK';  StateName[41]:='Oklahoma';
  StateID[42]:='OR';  StateName[42]:='Oregon';
  StateID[43]:='PA';  StateName[43]:='Pennsylvania';
  StateID[44]:='PR';  StateName[44]:='Puerto Rico';
  StateID[45]:='RI';  StateName[45]:='Rhode Island';
  StateID[46]:='SC';  StateName[46]:='South Carolina';
  StateID[47]:='SD';  StateName[47]:='South Dakota';
  StateID[48]:='TN';  StateName[48]:='Tennessee';
  StateID[49]:='TT';  StateName[49]:='Trust Territories';
  StateID[50]:='TX';  StateName[50]:='Texas';
  StateID[51]:='UT';  StateName[51]:='Utah';
  StateID[52]:='VT';  StateName[52]:='Vermont';
  StateID[53]:='VA';  StateName[53]:='Virginia';
  StateID[54]:='VI';  StateName[54]:='Virgin Islands';
  StateID[55]:='WA';  StateName[55]:='Washington';
  StateID[56]:='WV';  StateName[56]:='West Virginia';
  StateID[57]:='WI';  StateName[57]:='Wisconsin';
  StateID[58]:='WY';  StateName[58]:='Wyoming';
  StateCount:=58;
end;

procedure LoadTables;
var I,J,K,L:integer;
begin
  BNumber[0]:='J';
  BNumber[1]:='A';
  BNumber[2]:='B';
  BNumber[3]:='C';
  BNumber[4]:='D';
  BNumber[5]:='E';
  BNumber[6]:='F';
  BNumber[7]:='G';
  BNumber[8]:='H';
  BNumber[9]:='I';

  fillchar(DotTab,256,#0);
  DotTab[ord('@')]:=08;
  DotTab[ord('A')]:=01;
  DotTab[ord('B')]:=03;
  DotTab[ord('C')]:=09;
  DotTab[ord('D')]:=25;
  DotTab[ord('E')]:=17;
  DotTab[ord('F')]:=11;
  DotTab[ord('G')]:=27;
  DotTab[ord('H')]:=19;
  DotTab[ord('I')]:=10;
  DotTab[ord('J')]:=26;
  DotTab[ord('K')]:=05;
  DotTab[ord('L')]:=07;
  DotTab[ord('M')]:=13;
  DotTab[ord('N')]:=29;
  DotTab[ord('O')]:=21;
  DotTab[ord('P')]:=15;
  DotTab[ord('Q')]:=31;
  DotTab[ord('R')]:=23;
  DotTab[ord('S')]:=14;
  DotTab[ord('T')]:=30;
  DotTab[ord('U')]:=37;
  DotTab[ord('V')]:=39;
  DotTab[ord('W')]:=58;
  DotTab[ord('X')]:=45;
  DotTab[ord('Y')]:=61;
  DotTab[ord('Z')]:=53;
  DotTab[ord('[')]:=42;
  DotTab[ord('\')]:=51;
  DotTab[ord(']')]:=59;
  DotTab[ord('^')]:=24;
  DotTab[ord('_')]:=56;
  DotTab[ord(' ')]:=00;
  DotTab[ord('!')]:=46;
  DotTab[ord('"')]:=16;
  DotTab[ord('#')]:=60;
  DotTab[ord('$')]:=43;
  DotTab[ord('%')]:=41;
  DotTab[ord('&')]:=47;
  DotTab[ord('''')]:=04;
  DotTab[ord('(')]:=55;
  DotTab[ord(')')]:=62;
  DotTab[ord('*')]:=33;
  DotTab[ord('+')]:=44;
  DotTab[ord(',')]:=32;
  DotTab[ord('-')]:=36;
  DotTab[ord('.')]:=40;
  DotTab[ord('/')]:=12;
  DotTab[ord('0')]:=52;
  DotTab[ord('1')]:=02;
  DotTab[ord('2')]:=06;
  DotTab[ord('3')]:=18;
  DotTab[ord('4')]:=50;
  DotTab[ord('5')]:=34;
  DotTab[ord('6')]:=22;
  DotTab[ord('7')]:=54;
  DotTab[ord('8')]:=38;
  DotTab[ord('9')]:=20;
  DotTab[ord(':')]:=49;
  DotTab[ord(';')]:=48;
  DotTab[ord('<')]:=35;
  DotTab[ord('=')]:=63;
  DotTab[ord('>')]:=28;
  DotTab[ord('?')]:=57;

  assign(Table,TabPath+'NFBTRANS.TAB');
  reset(Table);
  read(Table,B);
  close(Table);

  Letters:='ABCDEFGHIJKLMNOPQRSTUVWXYZ';


  LoadStates;
end;
end.
