/*
 * dttm.c - manage date and time
 *
 * V. Abell
 */

#include "touch2.h"
#include <ctype.h>


struct menu MainDT[] = {
	{  2, 21, "Read and set the meter's date and time." },
	{  9, 21, "R - read date and time" },
	{ 11, 21, "S - set date and time" },
	{ 13, 21, "X - eXit" },
#define	PROMPTLN	15
#define	PROMPTCOL	11
	{  0,  0, NULL },
};

struct menu ReadWt[] = {
	{ 12, 26, "Waiting to read date and time" },
	{  0,  0, NULL },
};

struct menu DateErr[] = {
	{ 12, 33, "Date read/set error" },
	{  0,  0, NULL },
};

short month_days[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };


static char *AsmNum(char *p, int *n);
static void ReadDtTm();
static void SetDtTm();


/*
 * AsmNum() - assemble number
 */

static char *
AsmNum(p, n)
	char *p;			/* pointer to number string */

#if	defined(UNIX)
	int *n;				/* pointer to result */
#else
	short *n;			/* pointer to result */
#endif

{
	for (*n = 0; *p; p++) {
		if ( ! isdigit(*p))
			break;
		*n = (*n * 10) + *p - '0';
	}
	return(p);
}


/*
 * DateTime() - read and set date and time
 */

void
DateTime()
{
	int ch;

	DispMenu(MainDT, NULL);
	for (;;) {
		if ( !kbhit()) {
			reset_buffer();
			continue;
		}
		if ((ch = getch()) == 0)
			ch = getch();
		switch (ch) {

		case ESC:
		case 'x':
		case 'X':
			return;

		case 'r':
		case 'R':
			ReadDtTm();
			break;

		case 's':
		case 'S':
			SetDtTm();
			break;

		default:
			putch(BELL);
		}
		DispMenu(MainDT, NULL);
	}
}


/*
 * ReadDtTm() - read the date and time
 */

static void
ReadDtTm()
{
	char b[64], ch, *cp;
	int err, i;

	for (;;) {
		if (WaitRdy() == 0)
			return;
		DispMenu(ReadWt, NULL);
		if (WaitCmd("DMF", 'F'))
			break;
		DispMenu(DateErr,
			"Press ESC to exit; any other key to retry.");
		if ((char)WaitAnyKey() == ESC)
			return;
	}
	GetDataLn(DumpLine, DUMPLL);
	cp = DumpLine;
	if (*cp == 'F') {
		cp++;
		if (*cp == ' ')
			cp++;
	}
	for (i = 0; i < sizeof(b) - 1; cp++) {
		if (*cp == '"')
			continue;
		b[i++] = *cp;
	}
	b[i] = 0;
	ClearRow(12, 1);
	_settextposition(12, 22);
	_outtext(b);
	PromptMsg("Press any key to exit.");
	(void) WaitAnyKey();
}
 

/*
 * SetDtTm() - set the date and time
 */

static void
SetDtTm()
{
	char buf[19], ch, cmd[32], *cp;
	int err;

#if	defined(UNIX)
	int day, hr, min, mo, sec, yr;
#else
	short day, hr, min, mo, sec, yr;
#endif
	int nc;

	for (buf[0] = '\0', err = 0;;) {
		ClearRow(PROMPTLN, PROMPTCOL);
		if (err) {
			putch(BELL);
			err = 0;
		}
		buf[17] = '\0';
		nc = GetInp(PROMPTLN, PROMPTCOL,
			"Enter date/time (mm/dd/yy hh:mm[:ss) ? ", buf, buf,
			sizeof(buf));
		if (nc == 0)
			return;
		err++;
		cp = AsmNum(buf, &mo);
		if (*cp++ != '/' || mo < 1 || mo > 12)
			continue;
		cp = AsmNum(cp, &day);
		if (*cp++ != '/' || day < 1 || day > 31)
			continue;
		cp = AsmNum(cp, &yr);
		if (*cp++ != ' ' || (yr > 14 && yr < 84))
			continue;
		if (mo == 2) {
			nc = (yr >= 84) ? yr + 1900 : yr + 2000;
			if ((((nc % 4) == 0) && ((nc % 100) != 0))
			|| ((nc % 400) == 0))
				month_days[1] = 29;
			else
				month_days[1] = 28;
		}
		if (day > month_days[mo - 1])
			continue;
		cp = AsmNum(cp, &hr);
		if (*cp++ != ':' || hr < 0 || hr > 23)
			continue;
		cp = AsmNum(cp, &min);
		if (min < 0 || min > 59)
			continue;
		if (*cp == ':') {
			cp = AsmNum(++cp, &sec);
			if (sec < 0 || sec > 59)
				continue;
		} else
			sec = 0;
		if (*cp != '\0')
			continue;
		(void) sprintf(cmd, "DMT%02d/%02d/%02d %02d:%02d:%02d",
			mo, day, yr, hr, min, sec);
		for (;;) {
			if (WaitRdy() == 0)
				return;
			DispMenu(ReadWt, NULL);
			if (WaitCmd(cmd, 'T')) {
				GetDataLn(DumpLine, DUMPLL);
				if (DumpLine[0] == ' ' && DumpLine[1] == '"')
					break;
			}
			DispMenu(DateErr,
				"Press ESC to exit; any other key to retry.");
			_settextposition(14, 1);
			_outtext("Command response:");
			_settextposition(14, 19);
			_outtext(DumpLine);
			if ((char)WaitAnyKey() == ESC)
				return;
			continue;
		}
		return;
	}
}


/*
 * WaitCmd() - issue command and wait for reply
 */

int
WaitCmd(c, e)
	char *c;                        /* command text */

#if	defined(UNIX)
	int e;				/* command echo character */
#else
	char e;				/* command echo character */
#endif

{
	char ch;
	int err;

	(void) reset_buffer();
	(void) writeln_com(c, &err);
	if (err) {
		(void) sprintf(DumpLine, "Meter transmission error %d", err);
		DumpErr[0].col = (short)(((Vc.numtextcols
			       - strlen(DumpLine))/2) + 1);
		DispMenu(DumpErr, "Press any key to continue.");
		(void) WaitAnyKey();
		return(0);
	}
	do {
		if (CheckESC()) {
			err = -1;
			break;
		}
		(void) check_com(&ch, &err);
	} while (err == 6 || (err == 0 && ch != e));
	if ( ! err)
		return(1);
	if (err == -1)
		return(0);
	(void) sprintf(DumpLine, "Error reading command reply: %d", err);
	DumpErr[0].col = (short)(((Vc.numtextcols - strlen(DumpLine))/2) + 1);
	DispMenu(DumpErr, "Press any key to continue.");
	(void) WaitAnyKey();
	return(0);

}
