/*
 * menu.c - menu handling function
 *
 * V. Abell
 */

#include "touch2.h"

short Cursor;
short Mode = -1;
struct videoconfig Vc;
short Vmode = 0;			/* 0 = text; 1 = graphics */


/*
 * ClearRow() - clear a text row
 */

void
ClearRow(r, c)

#if	defined(UNIX)
	int r;				/* row */
	int c;				/* column */
#else
	short r;			/* row */
	short c;			/* column */
#endif

{
	while (c <= ((r == Vc.numtextrows) ? Vc.numtextcols - 1
				           : Vc.numtextcols)) {
		_settextposition(r, c++);
		_outtext(" ");
	}
}


/*
 * DispMenu() - display a menu
 */

void
DispMenu(m, b)
	struct menu *m;			/* menu array */
	char *b;                        /* bottom line contents */
{
	int i;


	_clearscreen(_GCLEARSCREEN);
	for (i = 0; m[i].msg; i++) {
		_settextposition(m[i].row, m[i].col);
		_outtext(m[i].msg);
	}
	PromptMsg((b == NULL) ? "Press ESC to exit." : b);
}


/*
 * GetInp() - get input
 */

int
GetInp(r, c, p, def, ib, ibl)

#if	defined(UNIX)
	int c;				/* column */
	int r;				/* row */
#else
	short c;			/* column */
	short r;			/* row */
#endif
	char *p;			/* prompt */
	char *def;			/* default */
	char *ib;			/* input buffer */
	int ibl;			/* input buffer limit */
{
	short cc, sc;
	int ch[2];
	int eoi, i, j, n;

	PromptMsg("ESC - exit; RETURN - use entry; BKSP, DELETE, arrow keys - edit.");
	ClearRow(r, 1);
	_settextposition(r, c);
	_outtext(p);
	sc = c + (short)strlen(p)  + 1;
	_settextposition(r, sc);
	if (def != NULL && *def != '\0') {
		i = n = strlen(def);
		if (n > (ibl - 1)) {
			(void) fprintf(stderr,
				"GetInp: default (\"%s\") too long", def);
			TouchExit(1);
		}
		if (def != ib)
			(void) strcpy(ib, def);
		cc = sc + n;
		_outtext(ib);
	} else {
		i = n = 0;
		ib[0] = '\0';
		cc = sc;
	}
	_displaycursor(_GCURSORON);
	_settextcursor(Cursor);
/*
 * Get the input.
 */
	for (eoi = 0; !eoi;) {
		ch[1] = 0;
		if ( ! kbhit()) {
			reset_buffer();
			continue;
		}
		if ((ch[0] = getch()) == 0) {
	/*
	 * Get and process function or cursor keystroke.
	 */
			ch[1] = getch();
			switch (ch[1]) {
		/*
		 * Delete the character under the cursor.
		 */
			case CHDEL:
				if (i >= n-1)
					ib[i] = '\0';
				else {
					for (j = i; j < n; j++) {
						ib[j] = ib[j+1];
					}
				}
				n--;
				ClearRow(r, cc);
				_settextposition(r, cc);
				_outtext(&ib[i]);
				_settextposition(r, cc);
				continue;
		/*
		 * Move the cursor left.
		 */
			case LARW:
				if (cc == sc)
					putch(BELL);
				else {
					cc--;
					i--;
					_settextposition(r, cc);
				}
				continue;
		/*
		 * Move the cursor right.
		 */
			case RARW:
				if (i == n)
					putch(BELL);
				else {
					cc++;
					i++;
					_settextposition(r, cc);
				}
				continue;
		/*
		 * Meaningless keystroke.
		 */
			default:
				putch(BELL);
			}
			continue;
		}
		if (isprint(ch[0])) {
	/*
	 * Display and store printable character.
	 */
			if (i >= n) {
				if (i >= ibl - 1) {
					putch(BELL);
					continue;
				}
				ib[i] = (char)ch[0];
				ib[i+1] = '\0';
				n = i+1;
			} else {
				if (n >= ibl - 1) {
					putch(BELL);
					continue;
				}
				for (j = ++n; j > i; j--)
					ib[j] = ib[j-1];
				ib[i] = (char)ch[0];
			}
			_settextposition(r, cc++);
			_outtext(&ib[i++]);
			_settextposition(r, cc);
			continue;
		}
		if (iscntrl(ch[0])) {
	/*
	 * Handle control characters.
	 */
			switch (ch[0]) {
		/*
		 * ESC - exit
		 */
		 	case ESC:
				eoi = 1;
				n = 0;
				continue;
		/*
		 * Backspace -- CTRL-H
		 */
			case BS:
				if (cc == sc)
					continue;
				i--;
				if (i >= n-1)
					ib[i] = '\0';
				else {
					for (j = i; j < n; j++) {
						ib[j] = ib[j+1];
					}
				}
				n--;
				cc--;
				ClearRow(r, cc);
				_settextposition(r, cc);
				_outtext(&ib[i]);
				continue;
		/*
		 * RETURN -- end of input
		 */
			case CR:
				eoi = 1;
				continue;
		/*
		 * Line erase -- CTRL-U
		 */
			case DC4:
				cc = sc;
				i = n = 0;
				ib[0] = '\0';
				ClearRow(r, cc);
				_settextposition(r, cc);
				continue;
			}
		}
	/*
	 * Beep on an unknown.
	 */
		putch(BELL);
	}
	_displaycursor(_GCURSOROFF);
	_settextcursor(NOCURSOR);
	return(n);
}


/*
 * InitMenu() - initialize menu processing
 */

void
InitMenu()
{
	struct videoconfig vc;

	_getvideoconfig(&vc);
	if ((Mode = vc.mode) != _TEXTC80)
		(void) _setvideomode(_TEXTC80);
	Cursor = _gettextcursor();
	_getvideoconfig(&Vc);
	_displaycursor(_GCURSOROFF);
}


/*
 * PromptMsg() - issue prompt message
 */

void
PromptMsg(m)
	char *m;			/* message text */
{
	long pb;
	short ptc;

	ptc = _gettextcolor();
	ClearRow(Vc.numtextrows, 1);
	_settextposition(Vc.numtextrows, 1);
	if ( ! Vmode) {
		pb = _getbkcolor();
		_setbkcolor(PromptBkClrx & 7);
	}
	_settextcolor(PromptTxtClrx);
	_outtext(m);
	if ( ! Vmode)
		_setbkcolor(pb);
	_settextcolor(ptc);
}
