/*
 * touch2.h -- definitions for touch2
 *
 * V. Abell
 */

#include <stdio.h>

#if	!defined(UNIX)
#include <conio.h>
#include <graph.h>
#endif

#if	defined(UNIX)
struct videoconfig {
	short numtextrows;
	short numtextcols;
	short mode;
	short numxpixels;
	short numypixels;
};
#define _GCLEARSCREEN	0
#define	_GCURSOROFF	0
#define	_GCURSORON	0
#define	_TEXTC80	0
#define	_VRES16COLOR	0
#define	strcmpi		strcasecmp
#define strnicmp	strncasecmp
#define	_BLACK		0L
#define	_BLUE		0L
#define	_GREEN		0L
#define	_CYAN		0L
#define	_RED		0L
#define	_MAGENTA	0L
#define	_BROWN		0L
#define	_WHITE		0L
#define	_GRAY		0L
#define	_LIGHTBLUE	0L
#define	_LIGHTGREEN	0L
#define	_LIGHTCYAN	0L
#define	_LIGHTRED	0L
#define	_LIGHTMAGENTA	0L
#define	_YELLOW		0L
#define	_BRIGHTWHITE	0L
#endif

#define	BLACK		0
#define	BLUE		1
#define	GREEN		2
#define	CYAN		3
#define	RED		4
#define	MAGENTA		5
#define	BROWN		6
#define	WHITE		7
#define GRAY            8
#define	LIGHTBLUE	9
#define	LIGHTGREEN	10
#define	LIGHTCYAN	11
#define	LIGHTRED	12
#define	LIGHTMAGENTA	13
#define	YELLOW		14
#define	BRIGHTWHITE	15

#define	AFTEPSON	"\\f\\e@"		/* default after graph printer
						 * control string  for EPSON */
#define	AFTPCL4		"\\f\\eE\\04"		/* default after graph printer
						 * control string  for PCL4 */
#define	AFTPPDS		"\\f\\e[K\\01\\00\\06\\04"
						/* default after graph printer
						 * control string  for PPDS */
#define	BARCH		0xcd			/* bar graph character */
#define	BEFEPSON	"\\e0\\et1\\e7\\ex1"	/* default before graph printer
						 * control string  for EPSON */
#define	BEFPCL4		"\\e&l8D\\e(10U"	/* default before graph printer
						 * control string  for PCL4 */
#define	BEFPPDS		"\\e0"			/* default before graph printer
						 * control string  for PPDS */
#define	BELL		7			/* BELL */
#define	BS		8			/* BACKSPACE */
#define CHDEL           83                      /* delete character at cursor */
#define CR		13			/* RETURN */
#define	DARW		80			/* down arrow */
#define	DC4		21			/* CTRL-U */
#define	DEFBCX		BLUE			/* default background color
						 * index */
#define DEFQDMPF 	"touch2.csv"            /* default QuattroPro dump file
						 * name */
#define DEFRDMPF 	"touch2.dmp"            /* default raw dump file name */
#define DEFMGMAX	110.0			/* default mg/dl maximum */
#define DEFMGMIN        70.0			/* default mg/dl minimum */
#define DEFMMMAX	6.1			/* default mmol/l maximum */
#define DEFMMMIN        3.9			/* default mmol/l minimum */
#define	DEFGRAPHF	"touch2.grf"		/* default graph file name */
#define DEFPBCX		RED			/* default prompt background
						 * color index */
#define	DEFPTCX		BRIGHTWHITE		/* default prompt text color
						 * index */
#define DEFTCX		YELLOW			/* default text color index */
#define	DUMPFNL		64			/* dump file name length */
#define DUMPLL		256			/* dump line length */
#define	ESC		27
#define GTTLLNL		66			/* graph title line limit */
#define	HDRLPP		10			/* header lines per page */
#define	INTCH		0xd8			/* bar and min/max intersection
						 * character */
#define LARW            75                      /* left arrow */
#define LF              10                      /* LINE FEED */
#define	LINECH		0xb3			/* min/max line character */
#define	LPP		81			/* lines per page */
#define	NOCURSOR	0x2000			/* no cursor */
#define	PGDN		81			/* PgDn */
#define PGUP		73			/* PgUp */
#define	PRTRCTLLN	256			/* printer control string
						 * length */
#define RARW            77                      /* right arrow */
#define	RDREG		0			/* regular reading */
#define RDSOL		1			/* check solution reading */
#define	RDSTRIP		2			/* strip reading */
#define RDHIGH		3			/* " HIGH " reading */
#define UARW		72			/* up arrow */

struct clr {
	char *nm;		/* name */
	long v;			/* value */
};

struct menu {
	short	row;
	short	col;
	char	*msg;
};

struct parity {
	short val;
	char *nm;
};

extern char *AftGraph;
extern char BarCh[];
extern short Baud[];
extern short Baudx;
extern char *BefGraph;
extern short BkClrx;
extern int buffer_length;
extern short Ckdump;
extern short Cksum;
extern struct clr Colors[];
extern short Comopen;
extern short Cursor;
extern char Date[];
extern struct menu DumpErr[];
extern char DumpfnQ[];
extern char DumpfnR[];
extern FILE *Dumpfs;
extern int DumpHs;
extern int DumpLc;
extern char DumpLine[];
extern char *DumpLp[];
extern short Frame;
extern double Gmaxl;
extern double Gminl;
extern char Graphfn[];
extern FILE *Graphfs;
extern char Gttl[];
extern char IntCh[];
extern char LineCh[];
extern short Lineval;
extern short Lpp;
extern char Mdate[];
extern char Mmax[];
extern char Mmin[];
extern short Mode;
extern char Mtime[];
extern short Ndump;
extern struct parity Par[];
extern short Parx;
extern short PcDisp;
extern char *Pn;
extern short Port;
extern short PromptBkClrx;
extern short PromptTxtClrx;
extern short Qp;
extern FILE *Rdumpfs;
extern short Rtype;
extern double Rval;
extern short StSt;
extern char Time[];
extern short TxtClrx;
extern struct videoconfig Vc;
extern short Vmode;
extern short Warn;

int Asm1Ch(char *s, char *r);
int CheckESC();

#if	defined(UNIX)
void ClearRow(int r, int c);
#else
void ClearRow(short r, short c);
#endif

int Atof(char *s, double *d, char *m);
void CloseCom();
void CloseDump();
int CvtPrtrStr(char *s, char *r, int n);
void DateTime();
void DefCom();
void DrawGraph(int ty);
void DumpMtr();
void DispMenu(struct menu *m, char *b);
int EntPrtStr(char *a, char *b);
int GetDataLn(char *s, int n);

#if	defined(UNIX)
int GetInp(int r, int c, char *p, char *def, char *ib, int ibl);
#else
int GetInp(short r, short c, char *p, char *def, char *ib, int ibl);
#endif

void InitDump();
void InitMenu();
void InitStatus();
void OpenCom();
char *ParseField(char *p, char *b, int l);
int ParseHdr();

#if	defined(UNIX)
int ParseDumpLn(int i, int s);
#else
int ParseDumpLn(short i, short s);
#endif

void PromptMsg(char *m);
int ReadConf();
int SetAftGraph(char *b, char *v);
int SetBarChar(char *b, char *v);
int SetBefGraph(char *b, char *v);
int SetGmaxLvl(char *b, char *v);
int SetGminLvl(char *b, char *v);
int SetGraphTtl(char *b, char *v);
int SetIntChar(char *b, char *v);
int SetLineChar(char *b, char *v);
int SetLpp(char *b, char *v);
int SetPrinter(char *b, char *v);
void StatusMtr();
int TestGlev();
void TouchExit(int xv);
int WaitAnyKey();

#if	defined(UNIX)
int WaitCmd(char *c, int e);
#else
int WaitCmd(char *c, char e);
#endif

int WaitRdy();

#if	defined(UNIX)
int WarnMsg(int r1, int c1, char *m1, int r2, int c2, char *m2, int f);
#else
int WarnMsg(short r1, short c1, char *m1, short r2, short c2, char *m2, short f);
#endif
