DECLARE SUB UnCmprs (a$, X%, Y%)
DECLARE SUB PRdegmin (B$, a!)
DECLARE SUB PRtxt (S$, a$)
DECLARE SUB CLRtxt (L!, S$, c!)
DECLARE SUB PR (S$, a$)
DECLARE SUB Noise (n!)

Ver$ = "33"  ' See text below for upgrade info
              ' Must use QB/l in order to COMPILE with Mouse stuff
              'From G. Hadley N7SNI suggested new LINEFORMAT
MaxNumMAPS = 170' Maximum number of maps allowed in MAPLIST
MaxNumPoints = 3000  'APRS limit. Six times this many are permitted in MAPFIX
MaxNumLABELS = 199 'was 99 prior to 68c
MaxNumLines = 1900
Maplist$ = "\APRS\MAPLISTS\MAPLIST.USA"
REM $DYNAMIC
   Ycen = 175:  YfacTXT = 350 / 350: SCREEN 9
   COLOR 15, 0
   GBLn = 43: Cfactr = 8: bln = 43
   WIDTH 80, 43
   PALETTE 6, 6
  
   DIM Crsr(16)
   CIRCLE (4, 3), 4, 14
   GET (0, 0)-(8, 6), Crsr
GOTO BEGIN

Info: COLOR 15, 4: CLS : PRINT
   PRINT " ver 3.3 * Better TASK-CLEAR function.."
   PRINT "         * Fixed load error bug when using TASK-BORDER file names"
   PRINT "         * Added CHANGE-ALL-COLORS command"
   PRINT
   PRINT " Ver 3.2 * Found and fixed bug that created extra points whenever you used the"
   PRINT "           TASK-OVERLAY command overlaying a LINEFORMATed map."
   PRINT
   PRINT " Ver 3.1 * NEW LineFormat loads in 75% the time of a compressed file or 64% of "
   PRINT "           the original format!  Its the same COMPRESSED format except that all"
   PRINT "           CR/LFs between all of the points of each feature have been removed."
   PRINT
   PRINT "           This new LineFormat also THROWS away  the original FEATURE names"
   PRINT "           and this saves lots of space.  Unless the map was hand drawn,"
   PRINT "           these feature names are meaningless when generated by any of the"
   PRINT "           automated map making features.  So this loss is insignificant."
   PRINT
   PRINT : BEEP
   PRINT "     ***   ALSO, I removed the direct USGS extract which is no longer used"
   PRINT "           becasuse of the success of KB4XF's MAKEMAP1 and MK100k programs"
   PRINT
   PRINT " Ver 3.0 * Fixed mapfile NAME bug and Feb97 ver has better mouse centering"
   PRINT
   PRINT " Ver 2.9 * Can now edit with COMPRESSED Files. for 66% savings in size and"
   PRINT "           load time.  The format restricts to 3600 in X and 1800 in Y."
   PRINT
   PRINT
   PRINT " **********  Use MAPFIX to build and edit APRS maps  *****"
   PRINT
   PRINT " FREE-HAND:  Good for filling in missing roads, but hard to make roads exact"
   PRINT " CDROM:      Gets points from 2,000,000:1 and 100,000:1 USGS CD ROM.   See"
   PRINT "             MAPS-CD.txt.   It still takes time to fine tune to a good map"
   PRINT " TABLET:     Connect a serial data digitizer tablet and draw!     BEST METHOD!"
   PRINT " GPS DATA:   Replay any APRS GPS track history file and DRAW map lines over it"
   PRINT " CONVERSION: Change origin or scale on-line "
   PRINT " IMPORTING:  Import features from other maps with auto-point conversion!"
   PRINT " OVERLAY:    Overlay any map onto present map to compare and move lines to fit"
   PRINT
   PRINT " SEE THE MAPS, MAPS-CD, MAPMAKIN and MAPFIX.TXT files!"
   PRINT
   Display$ = "UNKnown"
   RETURN

BEGIN: GOSUB Info:
   CALL PR("HIT", a$)
   DIM X%(6 * MaxNumPoints), Y%(6 * MaxNumPoints)
   DIM LN$(MaxNumLines) ' (no limit in APRS)
   nn = 2 * MaxNumLABELS
   DIM ML$(nn), MLa(nn), MLo(nn), MLr(nn) 'Labels & coordinates
   nn = 2 * MaxNumMAPS
   DIM MapName$(nn), LatCen(nn), LonCen(nn), MapMax(nn), Comment$(nn)
   i = 1000
   DIM HLAT(i), HLONG(i)'For GPS hist files
   Mpath$ = "\APRS\MAPS\"
INIT: ON ERROR GOTO ErrorTrap
   RdsOn = -1: LabelsON = -1:  kp = 1: Chgd = 0: MapSize = 256
   Redraw = -1: Acenter = 0: nmp = 0: z = 0: nml = 0: LNi = 0
   Path$ = "C:\MAPS\S01_": Epts = -1
MouseStuff:
   TYPE RegType
     ax AS INTEGER
     bx AS INTEGER
     cx AS INTEGER
     dx AS INTEGER
     BP AS INTEGER
     SI AS INTEGER
     DI AS INTEGER
     FLAGS AS INTEGER
     DS AS INTEGER
     es AS INTEGER
   END TYPE
   DIM RegsIN AS RegType, RegsOUT AS RegType
   RegsIN.ax = &H0
   REM Must invoke QB/L
   CALL Interrupt(&H33, RegsIN, RegsOUT)
   IF RegsOUT.ax = &HFFFF THEN MouseD = -1
  
SCREEN , , 0, 0: Display$ = "HELP": GOSUB HELP: GOSUB LoadMap
REM ON ERROR GOTO 0

Main: GOSUB DrwMPaCur
  DO
GoAgain: Fault = 0
    a$ = ""
    IF Digitizer THEN
       IF LOC(1) > 9 THEN
          GOSUB GetXY
          REM digitizer ADDS a point EXCEPT if it was Btn 3
          REM If btn 3, then just cursor moves.
          REM Search for GetXY.
          REM If you have no, or just 1 button, then F1 will simulate a button
          REM 3 so you can use the digitizer to only move the cursor
          IF JustCur OR Btn = 3 THEN
             GOSUB Cursor: GOSUB DrwMpPt' move cursor and clear JustCur
          ELSEIF Btn = 1 THEN a$ = CHR$(0) + CHR$(62) 'same as F4
          ELSEIF Btn = 2 THEN a$ = CHR$(0) + CHR$(65) 'same as F7
          ELSE GOSUB Cursor: GOSUB AddPoint'
          END IF
       END IF
    END IF
    IF MouseD THEN
       RegsIN.ax = &H3: CALL Interrupt(&H33, RegsIN, RegsOUT)
       bx% = RegsOUT.bx: cx% = RegsOUT.cx: dx% = RegsOUT.dx
       'LOCATE 15, 40: PRINT cx%; dx%;
       IF cx% <> CUMx% OR dx% <> CUMy% THEN
          X = cx% - CUMx%
          Y = dx% - CUMy%
          CUMx% = cx%
          CUMy% = dx%
          IF mouse THEN
             REM here, XY is the amount moved?
             CPX = CPX - X * degpmh: REM THIS IS UNTESTED AND NOT DEBUGGED
             CPY = CPY - Y * degpmv
          ELSE
             CPX = CDX - (CUMx% - 320) / Sfac * Hfac
             CPY = CDY - (CUMy% - Ycen) / Sfac
          END IF
          GOSUB Cursor
       END IF
       IF bx% AND 1 THEN a$ = CHR$(13) ' Left Mouse button
       IF bx% AND 2 THEN               ' Right mouse button
          SELECT CASE MsInit
          CASE 0: IF ABS(TIMER - Lck) > .4 THEN Lck = TIMER: GOSUB AddPoint
          CASE 4: LAb = CPY: FOR zz = 1 TO 100000: NEXT zz
          CASE 3
                CALL Noise(1)
                CALL PRtxt("Enter total LAT moved in Degrees", z$)
                degpmv = VAL(z$) / (Sfac * (CPY - LAb))
          CASE 2: LOb = CPX: FOR zz = 1 TO 100000: NEXT zz
          CASE 1
                CALL Noise(1)
                CALL PRtxt("Enter total LONG moved in Degrees", z$)
                degpmh = VAL(z$) / (Sfac * Hfac * (CPX - LOb))
                
          END SELECT
          IF MsInit THEN MsInit = MsInit - 1
       END IF
       oldbx = bx%
    END IF

    IF a$ = "" THEN a$ = INKEY$
    IF a$ <> "" THEN
       Xinc = 0: Yinc = 0
       IF LEN(a$) = 1 THEN a$ = UCASE$(a$)
       Key$ = a$
       IF ELock THEN
          CALL CLRtxt(43, "*** EDIT IS LOCKED ON ***  |  COMMANDS ARE:  ADD,  DELETE,  LOCKoff,  MOVE", 14)
          IF a$ = "A" THEN GOSUB AddPoint: a$ = ""
          IF a$ = "D" THEN nd = 1: GOSUB DelPT: a$ = ""
          IF a$ = "L" THEN GOSUB Elockdo: a$ = ""
          IF a$ = "M" THEN GOSUB MakePT: a$ = "": IF Redraw THEN GOSUB DrawMap
       END IF
       IF LabMov AND a$ = CHR$(13) THEN
          MLa(HkLab) = CPY: MLo(HkLab) = CPX: LabMov = 0: GOSUB DrawMap
       END IF
       SELECT CASE a$
       CASE CHR$(13): LnStrt = 0: StrtSrch = 1: GOSUB FindPoint
       CASE CHR$(10): LnStrt = LnPtr: StrtSrch = z + 1: GOSUB FindPoint
       CASE "C": GOSUB MenuCHANGE
       CASE "E": GOSUB MenuEdit
       CASE "F": GOSUB MenuFILES
       CASE "L": GOSUB MenuLABELS
       CASE "T": GOSUB MenuTasks
       CASE "S": GOSUB MenuSETUP
       CASE "G": GOSUB CurToPoint: GOSUB CurDrwMap
       CASE "H"
          IF Display$ <> "HELP" THEN
             SCREEN , , 0, 0: COLOR 15, 1: GOSUB HELP
          ELSE GOSUB Info
             LOCATE bln, 1: PRINT " H for HELP or SPACE BAR for map..."; : a$ = ""
          END IF
       CASE "N": GOSUB NextLine: GOSUB Cursor
       CASE "P": GOSUB Previous: GOSUB Cursor
       CASE "Q": GOSUB Quit
       CASE "R": z = 2: LnPtr = 1        'HOME key
       CASE "T": GOSUB Scrunch
       CASE "U": GOSUB GetUSGS
       CASE " "
                 Display$ = "MAP": Redraw = -1: USGS = 0:
                 IF Scrn = 0 THEN SCREEN , , 1, 1: COLOR 15, 0
                 IF Scrn = 1 THEN GOSUB DrwMPaCur
                 Scrn = 1
       CASE "+": z = z + 1: GOSUB MapPoint  ' moves to next map point
       CASE "-": z = z - 1: GOSUB MapPoint  ' moves backwards
       CASE "7": CDX = LONo: CDY = LATo: GOSUB DrwMPaCur 'ShiftHOME
       CASE "6": Xinc = -20: GOSUB DoCursor 'SHIFT Cursor by 4
       CASE "4": Xinc = 20: GOSUB DoCursor
       CASE "8": Yinc = 20: GOSUB DoCursor
       CASE "2": Yinc = -20: GOSUB DoCursor

       END SELECT
      
       B$ = "": IF LEN(a$) = 2 THEN IF ASC(a$) = 0 THEN B$ = RIGHT$(a$, 1)
       SELECT CASE B$
       CASE "I": RS = RS * 2: GOSUB CurDrwMap
       CASE "Q": RS = RS / 2: GOSUB CurDrwMap
       CASE CHR$(132): RS = RS * 8: GOSUB CurDrwMap
       CASE CHR$(118): RS = RS / 8: GOSUB CurDrwMap
       CASE "G": GOSUB CurDrwMap 'Home key
       
       CASE "O": CDX = LonCen: CDY = LatCen: Acenter = 0: GOSUB DrwMPaCur'End Key
       CASE "M": Xinc = -4: GOSUB DoCursor
       CASE "K": Xinc = 4: GOSUB DoCursor
       CASE "H": Yinc = 4: GOSUB DoCursor
       CASE "P": Yinc = -4: GOSUB DoCursor
       
       CASE CHR$(22): GOSUB GetUSGS                     'alt-U
       CASE CHR$(59): JustCur = -1: GOSUB DrwMpPt       'F1
       CASE CHR$(61)                                    'F3 for smaller Maps
          IF MpLstLdd THEN
             MapSize = MapSize / 2: IF MapSize < 1 THEN MapSize = 1
             GOSUB ShowMaps
          ELSE SavClr = 3: a$ = "Stream": GOSUB HotKey
          END IF
       CASE CHR$(62)                                    'F4 for larger Maps
          IF MpLstLdd THEN
             MapSize = MapSize * 2: IF MapSize > 1000 THEN MapSize = 1000
             GOSUB DrwAndShow
          ELSE SavClr = 4: a$ = "Red Rd": GOSUB HotKey
          END IF
       CASE CHR$(63): Slower = NOT Slower                           'F5
       CASE CHR$(64): SavClr = 6: a$ = "Brder": GOSUB HotKey       'F6
       CASE CHR$(65): SavClr = 7: a$ = "St": GOSUB HotKey   'F7
       CASE CHR$(66): SavClr = 8: a$ = "RR": GOSUB HotKey     'F8
       CASE CHR$(68): SavClr = 10: a$ = "Interstate": GOSUB HotKey  'F10
       CASE CHR$(84): SavClr = 11: a$ = "Water": GOSUB HotKey       'F11
       CASE CHR$(85): SavClr = 12: a$ = "Big Rd": GOSUB HotKey  'F12
       'CASE CHR$(86): Comp = -1: GOSUB CkEdges:abort=0             'F3 shift
       'CASE CHR$(87): Comp = 0: GOSUB Redraw                       'F4 shift
       'CASE CHR$(88): Comp = 9: GOSUB CkEdges:abort=0              'F5 shift
       CASE CHR$(91): GOSUB AddMark                                'F8 shift
       END SELECT
    END IF
  LOOP
  SYSTEM 'you should never get here

CkEdges: abort = 0: IF Comp = 0 THEN RETURN
         FOR i = 1 TO nmp
             IF X%(i) < 0 OR X%(i) > 3599 - 1 THEN abort = -1: PRINT "Pt"; i
             IF Y%(i) < 0 OR Y%(i) > 1799 - 1 THEN abort = -1: PRINT "Pt"; i
         NEXT i
         IF abort THEN
            LOCATE 20, 10: Comp = 0
            PRINT "POINTS OUT OF RANGE.  CANNOT SAVE AS COMPRESSED"
            PRINT
            PRINT "All points must be inside the yellow box showing the limits"
            PRINT "for point values in the Compressed and LineFormats."
            CALL PR("HIT", a$)
         ELSE Chgd = Chgd + 1
         END IF
         GOSUB Redraw
         RETURN


DoCursor:  CPX = CPX + Xinc / (Sfac)
           CPY = CPY + Yinc / (Sfac)
           GOTO Cursor

MenuEdit:  CALL PR("EDIT CMDS:  Add, Begin, Color, Delete, Killall, Lock, Move, New, Split", a$)
           SELECT CASE a$
           CASE "A": GOSUB AddPoint
           CASE "B":
              IF Digitizer THEN
                 Key$ = "B": GOSUB NewFeature
              ELSE CALL CLRtxt(41, "This command ONLY used in DIGITIZER mode", 12)
              END IF
           CASE "C": GOSUB ChgColr
           CASE "D": nd = 1: GOSUB DelPT
           CASE "L": GOSUB Elockdo
           CASE "K": GOSUB KillFeature
           CASE "M": GOSUB MakePT: IF Redraw THEN GOSUB DrawMap
           CASE "N": Key$ = "N": GOSUB NewFeature
           CASE "S": GOSUB Split
           END SELECT
           RETURN
Elockdo: ELock = NOT ELock
         IF ELock THEN Bclr = 15 ELSE Bclr = 0
         GOSUB LockBox
         IF NOT ELock THEN GOSUB Post43
         RETURN

MenuFILES: CALL PR("FILES CMDS:  Directory, Load, OpenDgtzrCom, Quit, Save, ViewMaplst", a$)
           SELECT CASE a$
           CASE "D": GOSUB MapDIR
           CASE "L": GOSUB Chg: GOTO INIT
           CASE "O": GOSUB WhichDgtzr
           CASE "Q": GOTO Quit
           CASE "S": GOSUB SaveMap: GOSUB DrwMPaCur
           CASE "V": GOSUB ListMAPlist
           END SELECT
           RETURN
MenuLABELS: d = 0: GOSUB LabelHook
           CALL PR("LABEL CMDS:  Add, Import, Kill, Move, NewRange, On/Off, Show-all, UCASE", a$)
           SELECT CASE a$
           CASE "A": GOSUB LabelADD
           CASE "I": overlay = -1: LImp = -1: GOSUB Import
           CASE "K": GOSUB LabelKILL: d = 1
           CASE "M": GOSUB LabelMove
           CASE "N": GOSUB LabelNwRng
           CASE "S": Key$ = "S"
           CASE "U": ML$(HkLab) = UCASE$(ML$(HkLab))
           CASE "O": LabelsON = NOT LabelsON: IF NOT LabelsON THEN d = 1
           END SELECT
           IF d THEN GOSUB DrawMap ELSE GOSUB Labels
           RETURN
MenuTasks: CALL PR("TASKS:  Bordrs ClearSnglePts GPStrack Import Join Overlay Scrunch Trim", a$)
           SELECT CASE a$
           CASE "B": GOSUB DrwAndShow
           CASE "C": GOSUB Clr1Pts
           CASE "G": GOSUB LoadHST
           CASE "I": GOSUB Import
           CASE "J": GOSUB Join
           CASE "O": overlay = -1: LImp = 0: Redraw = 0: GOSUB Import
           CASE "T": GOSUB TRIM
           CASE "S": Key$ = "S": GOSUB Scrunch
           END SELECT
           RETURN
MenuSETUP: CALL PR("SETUP:  AutoCntr, BOXppd, Endpoints, Points, Redraw, WhiteRR", a$)
           SELECT CASE a$
           CASE "A": Acenter = NOT Acenter
           CASE "B": GOSUB BOXppd
           CASE "P": points = NOT points: GOSUB DrawMap
           CASE "E": Epts = NOT Epts: GOSUB DrawMap
           CASE "W": Wrr = NOT Wrr: GOSUB DrawMap
           CASE "R": Redraw = NOT Redraw: GOSUB Redraw
           END SELECT
           RETURN
MenuCHANGE: CALL PR("CHANGE:  All-colors,  Beeps,  Center,  Origin,  Range", a$)
           SELECT CASE a$
           CASE "A": GOSUB ChangeColors
           CASE "B": Quiet = NOT Quiet
           CASE "C": GOSUB NewCenter
           CASE "R": GOSUB MapRange
           CASE "O": GOSUB MapCnvrt
           END SELECT
           RETURN

LabelHook: HkLab = 0: k = RS / 1000
           FOR i = 1 TO nml
               IF ABS(CPX - MLo(i)) < k AND ABS(CPY - MLa(i)) < k THEN
                  CPX = MLo(i): CPY = MLa(i): GOSUB Cursor
                  HkLab = i: i = nml: CIRCLE (CUX, CUY), 10, 13
                  IF MLr(HkLab) < RS THEN Key$ = "S": GOSUB Labels
               END IF
           NEXT i
           RETURN
               
LabelKILL: IF HkLab THEN
              FOR i = HkLab TO nml
                    ML$(i) = ML$(i + 1): MLa(i) = MLa(i + 1)
                    MLo(i) = MLo(i + 1): MLr(i) = MLr(i + 1)
              NEXT: HkLab = 0: d = 1
              nml = nml - 1
           ELSE CALL Noise(1)
           END IF
           RETURN

LabelMove: IF HkLab THEN LabMov = 1: CALL CLRtxt(43, "Move cursor and then press ENTER...", 13)
           RETURN
LabelNwRng: IF HkLab THEN
               CALL PRtxt("Enter new range scale for Label to begin showing", a$)
               IF a$ <> "" THEN MLr(HkLab) = VAL(a$)
            END IF
            RETURN


AddMark: a$ = "Ref Point": SavClr = 14
   GOSUB BeginF: GOSUB MakePT
   CUY = CUY - 6: GOSUB AddPoint
   CUX = CUX + 10: GOSUB AddPoint
   CUY = CUY + 6: GOSUB AddPoint
   CUX = CUX - 10: GOSUB AddPoint
   CUY = CUY - 6: GOSUB AddPoint
   CUX = CUX + 5: CUY = CUY + 3: GOSUB Cursor
   RETURN

WhichDgtzr: CALL PRtxt("Select (P)oor-Man's-Mouse-Mode or (D)igitizer [D]", a$)
   IF a$ <> "P" THEN GOSUB DigiInit: GOTO DrawMap
   PRINT "Mouse digitizer is NOT working.  Dont use it": RETURN
   mouse = -1
   PRINT "LEFT button is FIND, RIGHT button is EDIT-ADD."
   degpmh = 1 / Sfac: degpmv = 1 / Sfac
   CLS : LOCATE 6, 1
   PRINT "POOR-MANS-MOUSE-MODE  (Digitizer)"
   PRINT
   PRINT "You must first calibrate the mouse to actual LAT/LONG movements."
   PRINT "Perform the following steps in sequence.  If you mess up, START PROGRAM OVER!"
   PRINT
   PRINT "During this process, ignore the cursor on the screen."
   PRINT
   PRINT "Lift and move mouse to a low LATITUDE mark.  Hit left button."
   PRINT "     move mouse carefully up to an UPPER LATTITUDE mark.  Hit left button."
   PRINT
   PRINT "Lift and move mouse to a right LONGITUDE mark.  Hit left button."
   PRINT "     move mouse carefully to a LEFT LONGITUDE mark.  Hit left button."
   MsInit = 4
   RETURN



Redraw: LOCATE 1, 20: PRINT "LOADtime"; LEFT$(STR$(LdTime), 4); " ";
    LOCATE 1, 44: IF Redraw THEN PRINT "REDRAW-ON" ELSE PRINT "redrw-off"
    LOCATE 1, 55: IF LabelsON THEN PRINT RIGHT$(MapFile$, 15) ELSE PRINT "LABELS-OFF!"
    LOCATE 1, 33:
    IF Comp = -1 THEN PRINT "COMPRSSED";
    IF Comp = 9 THEN PRINT "LineFormt";
    IF Comp = 0 THEN PRINT SPACE$(9);
    LINE (146, 0)-(552, 9), 12, B'Box around it
    RETURN

Quit: CLS : CALL Noise(1): CALL PR("Really quit MAPFIX (Y/N) [Y]", a$)
      IF a$ = "N" THEN GOSUB DrawMap: RETURN
      GOSUB Chg
      SYSTEM

Chg:  IF Chgd THEN
         CALL PR("**** MAP HAS BEEN MODIFIED" + STR$(Chgd) + "TIMES BUT NOT SAVED!!!  SAVE NOW? (Y)", a$)
         IF a$ <> "N" THEN GOSUB SaveMap
      END IF
      RETURN

TRIM: CLS : PRINT "TRIM ALL POINTS AND LABELS OUTSIDE OF MAPRANGE"
    PRINT
    PRINT "This command removes all points and labels outside of the white map border"
    PRINT "defined with the CHANGE-CENTER and CHANGE-RANGE commands."
    PRINT : PRINT
    PRINT "To avoid errors near the edge, make the CENTER/RANGE box about 10% larger"
    PRINT
    PRINT "You might consider stopping now and doing a FILES-SAVE before proceeding."
    PRINT
    PRINT : PRINT
    INPUT "Are you ready to proceed? (Y/N) (N)"; ans$
    CDX = LonCen: CDY = LatCen: GOSUB DrwMPaCur
    IF UCASE$(ans$) <> "Y" THEN RETURN
    LOCATE bln - 2, 1: PRINT "Processing...";
    REM dx and dy are num pix of center of map
    REM bx and by are borders of map based on MapRng
    by = ppdv * MapRng / 60
    bx = by * 1.8
    z = 0: nd = 0: DoItnow = 0
    DO
      z = z + 1: LOCATE 15, 40: PRINT z
      IF X%(z) = 0 THEN z = z + 2
      IF X%(z) > dx + bx OR Y%(z) > dy + by THEN bad = 1 ELSE bad = 0
      IF X%(z) < dx - bx OR Y%(z) < dy - by THEN bad = 1
      IF bad THEN
         IF nd = 0 THEN fp = z
         nd = nd + 1
      ELSE IF nd THEN DoItnow = -1
      END IF
      IF DoItnow OR (nd AND X%(z + 1) = 0) THEN
         z = fp
         GOSUB DelPT
         z = z - 1
         nd = 0: DoItnow = 0
      END IF
      IF z >= nmp - 4 THEN EXIT DO
    LOOP
    LOCATE bln - 2, 1: PRINT "Now removing labels...";
    i = 0
    DO UNTIL i > nml
       i = i + 1
       bad = 0: Xm = MapRng / (60 * Lfac): Ym = MapRng / 60
       IF MLo(i) > LonCen + Xm OR MLa(i) > LatCen + Ym THEN bad = 1
       IF MLo(i) < LonCen - Xm OR MLa(i) < LatCen - Ym THEN bad = 1
       IF bad = 1 THEN
          FOR j = i TO nml
              ML$(j) = ML$(j + 1): MLa(j) = MLa(j + 1)
              MLo(j) = MLo(j + 1): MLr(j) = MLr(j + 1)
          NEXT j: nml = nml - 1: i = i - 1: PRINT ".";
       END IF
    LOOP
    GOSUB DrawMap
    LOCATE 10, 10: PRINT "Use TASK-CLEAR a few times"
    LOCATE 12, 10: PRINT "to clear remaining single pts."
    RETURN

FindPoint: CurX = INT(.5 + dx + (CUX - 320) / HfacK)
           CurY = INT(.5 + dy + (CUY - Ycen) / kp)
    dmin = 32000
    LnCtr = LnStrt
    FOR i = StrtSrch TO nmp
        IF X%(i) = 0 THEN LnCtr = LnCtr + 1
        IF LnCtr >= LNi THEN i = nmp
        d = ABS(X%(i) - CurX) + ABS(Y%(i) - CurY)
        IF d < dmin THEN dmin = d: z = i: LnPtr = LnCtr
    NEXT
    GOSUB CurToPoint
    GOSUB MapPoint: SavClr = 0
    GOSUB Find1st: LineColor = 15: dots = &HCCCC: GOSUB DP
    RETURN
                 
HotKey: IF NOT Digitizer THEN RETURN
        GOSUB BeginF: GOSUB GetXY: GOSUB Cursor: GOSUB MakePT
        RETURN

NewFeature: LOCATE bln - 1, 1: PRINT SPACE$(27);
    CALL PRtxt("Enter reference name for new feature", a$)
    IF a$ = "" THEN RETURN
    GOSUB Rainbow: IF abort THEN RETURN
    GOSUB BeginF
    IF Key$ = "B" THEN
       CALL CLRtxt(43, "NOW USE DIGITIZER TO ADD NEW POINTS TO THIS FEATURE...", 10)
       GOSUB GetXY: GOSUB Cursor
    ELSE
       CALL CLRtxt(43, "NOW MOVE CURSOR AND USE EDIT-ADD TO ADD POINTS TO THIS NEW FEATURE...", 10)
    END IF
    GOSUB MakePT
    RETURN

Rainbow: LOCATE bln, 1
    FOR i = 0 TO 14
        PRINT RIGHT$(" " + MID$(STR$(i + 1), 2), 2); "   ";
        LINE (16 + i * 40, 335 * YfacTXT)-(40 + i * 40, 349 * YfacTXT), i + 1, BF
    NEXT i
    CALL PRtxt("Select color (4,7,10-Hwys 11-Water 12-Hwy 13-Spcl 14-City)", B$)
    SavClr = VAL(B$): IF SavClr > 15 OR SavClr < 1 THEN abort = -1 ELSE abort = 0
    RETURN

           
BeginF: X%(nmp) = 0: Y%(nmp) = SavClr   'Store feature color 0,c
    LN$(LNi + 1) = LN$(LNi): LnPtr = LNi'Bump up present LN$ comment
    LN$(LNi) = a$: LNi = LNi + 1'Store feature name
    nmp = nmp + 1: z = nmp
    nmp = nmp + 1: X%(nmp) = 0: Y%(nmp) = 0'nmp points to ending 0,0
    RETURN

NewCenter: LatCen = CPY: LonCen = CPX: Chgd = Chgd + 1: GOTO CurDrwMap

MapRange: CALL PRtxt("Enter map range", a$)
    IF VAL(a$) <> 0 THEN MapRng = VAL(a$)
    Chgd = Chgd + 1: GOTO DrwMPaCur

AddPoint: X% = dx + (CUX - 320) / HfacK
    IF X% = 0 THEN CALL Noise(1): PRINT "X=0!!!": RETURN
    nmp = nmp + 1: z = z + 1
    FOR i = nmp TO z STEP -1
        X%(i) = X%(i - 1): Y%(i) = Y%(i - 1)
    NEXT
    GOSUB MakePT
    IF SavClr = 0 AND Redraw THEN GOTO DrawMap
    LineColor = SavClr
    S = z - 1: GOTO DP

MakePT: X%(z) = dx + (CUX - 320) / HfacK
    Y%(z) = dy + (CUY - Ycen) / kp
    Chgd = Chgd + 1
    GOTO MapPoint

CurToPoint:
    CPX = CDX - (X%(z) - dx) / ppdv
    CPY = CDY - (Y%(z) - dy) / ppdv
    GOTO Cursor

Clr1Pts:
    FOR j = 1 TO 50
        Didit = 0
        FOR i = 1 TO nmp
            nd = 1
            IF X%(i) = 0 THEN
               IF X%(i + 1) = 0 THEN
                  z = i + 1: GOSUB DelZ
               ELSEIF X%(i + 2) = 0 THEN z = i + 1: nd = 2: GOSUB DelZ
               ELSEIF Y%(i) = 0 THEN Y%(i) = 15
               END IF
            END IF
        NEXT i
    IF Didit THEN LOCATE 10, 10: PRINT "Cleared "; j; "Points" ELSE j = 50
    NEXT j
    X%(nmp + 1) = 0: Y%(nmp + 1) = -1
    X%(1) = 0
    FOR i = 1 TO nmp
        IF X%(i) = X%(i + 1) THEN
           IF Y%(i) = Y%(i + 1) THEN z = i: nd = 1: GOSUB DelZ
        END IF
    NEXT i
    GOSUB DrawMap
   
    RETURN

DelPT: GOSUB DelZ
    REM if 1st pt, it stays as 1st pt
    IF X%(z) = 0 THEN z = z - 1: REM if end pt, it stays as end
    IF z > 0 THEN
    IF X%(z + 1) = 0 AND X%(z - 1) = 0 THEN 'It is just one point
       z = z - 1                            'So point to 0,color
       GOSUB Kline: LnPtr = LnPtr - 1       'So Kill Line name
       nd = 2: GOSUB DelZ                   'Kiil point and line
       z = z - nd
    END IF                                  'and -1 to end point
    END IF
    IF B$ = CHR$(32) AND Redraw THEN GOSUB DrawMap ELSE GOSUB MapPoint
    RETURN

DelZ: nmp = nmp - nd
      FOR i = z TO nmp: X%(i) = X%(i + nd): Y%(i) = Y%(i + nd): NEXT
      Chgd = Chgd + 1: Didit = -1
      RETURN

Split: nmp = nmp + 2: z = z + 1
       FOR i = nmp TO z STEP -1: X%(i) = X%(i - 2): Y%(i) = Y%(i - 2): NEXT
       Chgd = Chgd + 1
       X%(z) = 0: Y%(z) = 14
       LNi = LNi + 1
       FOR i = LNi TO LnPtr + 1 STEP -1: LN$(i) = LN$(i - 1): NEXT
       oz = z
       GOSUB Clr1Pts
       z = oz
       RETURN

NextLine: IF z >= nmp - 1 THEN z = nmp - 1: CALL Noise(1): RETURN
    DO UNTIL X%(z) = 0: z = z + 1: LOOP
    IF z < nmp - 1 THEN z = z + 1: LnPtr = LnPtr + 1
    SavClr = 0: GOTO MapPoint

Previous: DO UNTIL z = 1 OR X%(z) = 0: z = z - 1: LOOP
    IF z > 3 THEN z = z - 1: LnPtr = LnPtr - 1
    SavClr = 0: GOTO MapPoint

KillFeature: GOSUB Find1st: REM Stop at Beginning (0) point of the feature to kill
    ni = S' Now scan for next feature
    DO UNTIL X%(ni) = 0: ni = ni + 1: LOOP
    REM now move down rest of array to fill
    DO UNTIL ni >= nmp + 1
       X%(S - 1) = X%(ni): Y%(S - 1) = Y%(ni)
       S = S + 1: ni = ni + 1
    LOOP
    nmp = nmp - (ni - (S - 1)): Y%(nmp) = 0
    GOSUB Kline
    GOTO DrawMap
    
Find1st: S = z: DO UNTIL X%(S - 1) = 0: S = S - 1: LOOP
         RETURN

ChgColr: GOSUB Find1st: GOSUB Rainbow: IF abort THEN RETURN
         Y%(S - 1) = SavClr: Chgd = Chgd + 1
         LineColor = SavClr
         GOSUB DP
         RETURN


Kline: FOR i = LnPtr TO LNi
           LN$(i) = LN$(i + 1)
       NEXT i
       LNi = LNi - 1
       RETURN

MapPoint:
     IF z < 2 THEN z = 2: LnPtr = 1: CALL Noise(1): SavClr = 0
     IF z > nmp - 1 THEN z = z - 1: CALL Noise(1): SavClr = 0
     IF X%(z) = 0 THEN
        IF a$ = "-" THEN
             LnPtr = LnPtr - 1: z = z - 1
        ELSE LnPtr = LnPtr + 1: z = z + 1
        END IF: SavClr = 0
     END IF
     IF LnPtr < 0 THEN LnPtr = 0
     IF Display$ = "MAP" THEN
          LOCATE bln - 3, 1
          PRINT "Fture#"; LnPtr; TAB(12); LEFT$(LN$(LnPtr) + "            ", 12);
     END IF
DrwMpPt: IF Display$ <> "MAP" THEN RETURN
     IF JustCur THEN pc = 12 ELSE pc = 15
     CIRCLE (Xtest, Ytest), 10, 0 'Erase old circle
     Xtest = 320 + (X%(z) - dx) * HfacK
     Ytest = Ycen + kp * (Y%(z) - dy)
     IF Acenter AND (Xtest > 600 OR Xtest < 40 OR Ytest > 300 OR Ytest < 40) THEN
        GOSUB CurToPoint: GOSUB CurDrwMap
        Xtest = 320 + (X%(z) - dx) * HfacK
        Ytest = Ycen + kp * (Y%(z) - dy)
     END IF
     CIRCLE (Xtest, Ytest), 10, pc
     
     LOCATE bln - 2, 1: PRINT "MapPt#"; z;
     IF z > 999 THEN PRINT TAB(13); "val:";  ELSE PRINT TAB(12); "vals:";
     PRINT TAB(17); X%(z); TAB(23); Y%(z);
     RETURN

LabelADD: nml = nml + 1
     MLa(nml) = CPY: MLo(nml) = CPX
     CALL CLRtxt(41, "Enter Label Name", 14)
     INPUT ML$(nml)
     CALL PRtxt("Begin displaying label at what range?", a$)
     IF a$ <> "" THEN a = VAL(a$) ELSE a = RS
     MLr(nml) = a
     Chgd = Chgd + 1
     RETURN

ErrorTrap: Fault = ERR: 'Error handling routine
     Ert = Ert + 1: LOCATE 40, 1: PRINT Ert;
     IF ERR = 57 THEN PRINT " I/O-error-User-logoff"; : RESUME
     IF ERR = 69 THEN PRINT " Comm-buffer-overflow"; : RESUME
     IF ERR = 53 THEN PRINT " file-"; F$; "-not-found": CLOSE : RESUME NEXT
     IF ERR = 62 THEN PRINT " Inpt past end": RESUME NEXT
     IF ERR = 64 THEN PRINT " BadFile name": RESUME NEXT
     IF ERR = 52 THEN PRINT " BadFIle name/#": RESUME NEXT
     IF ERR = 55 THEN PRINT " File already Open": RESUME NEXT
     IF ERR = 2 THEN PRINT " SYNTAX-error"
     IF ERR = 70 THEN PRINT " WRITE PROTECTED!...": RESUME NEXT
     IF ERR = 76 THEN PRINT " Wrong Path!": RESUME NEXT
     IF ERR = 71 THEN PRINT " no disk!": RESUME NEXT
     'CLOSE #2: CLOSE #3: CLOSE #4
     CLOSE #2: CLOSE #3: CLOSE #4
     LOCATE 40, 1: INPUT "Hit ENTER to resume"; a$
     RESUME Main

MapDIR: CLS : PRINT "MAP FILES DIRECTORY": PRINT
     PRINT "To display your MAP file directory, enter the path to your xxxxxxx.MAP files."
     PRINT "For example, the default '\APRS\MAPS\*.MAP' will show all maps in the APRS"
     PRINT "directory.  Similarly '*.map' will search your present directory."
     PRINT ""
     F$ = "\aprs\MAPS\*.map"
     PRINT "Enter Filespec for searching the DIRECTORY ("; F$; ")";
     INPUT a$: IF a$ <> "" THEN F$ = a$
     PRINT : PRINT : FILES F$
     RETURN


LoadMap: CALL PRtxt(" MAP FILENAME, or NEW, ? for list, or Q to quit)" + Mpath$, a$)
    IF a$ = "" THEN GOTO LoadMap
    IF a$ = "Q" THEN IF Y%(1) = 0 THEN GOTO Quit ELSE RETURN
    IF a$ = "?" THEN GOSUB MapDIR: GOTO LoadMap
    IF a$ = "NEW" THEN Key$ = "NEW": GOSUB NewMap: RETURN
    a = INSTR(3, a$, "."): IF a = 0 THEN a$ = a$ + ".MAP"
    Strtime = TIMER
    IF INSTR(a$, "\") = 0 AND INSTR(a$, ":") = 0 THEN F$ = Mpath$ + a$ ELSE F$ = a$
    OPEN F$ FOR INPUT AS #3
    IF Fault > 52 AND Fault < 77 THEN Fault = 0: PRINT : CLOSE #3: GOTO LoadMap
    a = 1
    DO UNTIL a = 0: wa = a: a = INSTR(wa + 1, F$, "\"): LOOP
    IF wa > 1 THEN Mpath$ = LEFT$(F$, wa)
    MapFile$ = F$
    CALL CLRtxt(43, " Loading " + F$ + "...", 10)
    INPUT #3, LATo: LINE INPUT #3, LATtext$
    INPUT #3, LONo: LINE INPUT #3, LONtext$
    INPUT #3, ppdv: LINE INPUT #3, VS$'Pixels per degree horiz
    INPUT #3, LatCen: LINE INPUT #3, LatCen$
    INPUT #3, LonCen: LINE INPUT #3, LonCen$
    INPUT #3, MapRng: LINE INPUT #3, MapRng$
    INPUT #3, MinRng: LINE INPUT #3, MR$
    LINE INPUT #3, MapType$ ' Line of comments or instrutcitons
    IF MapType$ = "Compressed" THEN Comp = -1 ELSE Comp = 0
    IF MapType$ = "LineFormat" THEN Comp = 9
    IF LEFT$(MapType$, 14) = "Map generated " THEN Redraw = 0
    RS = 2 ^ INT(LOG(MapRng) / LOG(2))'Rng is intgr of VERTrng
    i = 0: LNi = 0: Tcomp = 0: IF Comp = -1 THEN Tcomp = -1
    IF Comp = 9 THEN GOSUB LoadLine ELSE GOSUB LoadNorm
    CDY = LatCen: CDX = LonCen
    CPX = CDX: CPY = CDY
    z = 2: LnPtr = 1
    CLOSE #3:     REM first X% value is map color.  2nd val is 1st pt
    LdTime = TIMER - Strtime
    RETURN

LoadNorm:
    DO WHILE NOT EOF(3)
       i = i + 1
       GOSUB LoadPT: X%(i) = X%: Y%(i) = Y%
       IF X%(i) = 0 AND NOT EOF(3) THEN ' Get line color & store with x=0
          INPUT #3, Y%(i): LNi = LNi + 1: LINE INPUT #3, LN$(LNi)' Feature name
          IF Y = -1 THEN GOSUB LoadLabels
       END IF
    LOOP: nmp = i  'nmp points to 0,-1 that ends all data (but the value
    RETURN         'of X% and y% are 0,0 until file is saved.

LoadLine: DO WHILE NOT EOF(3)
            i = i + 1: LNi = LNi + 1:  LN$(LNi) = STR$(LNi)'Feature name
            X%(i) = 0
            INPUT #3, Y%: LINE INPUT #3, L$
            IF Y% = -1 THEN GOSUB LoadLabels: EXIT DO
            Y%(i) = Y%
            FOR j = 1 TO LEN(L$) STEP 3
                i = i + 1
                CALL UnCmprs(MID$(L$, j, 3), X%(i), Y%(i))
            NEXT j
         LOOP: nmp = i
         RETURN

LoadPT:  IF Tcomp THEN
            LINE INPUT #3, a$
            IF a$ = " 0,0" THEN
                 X% = 0: Y = 0: Y% = Y
            ELSEIF a$ = " 0,-1" THEN X% = 0: Y = -1: Y% = Y
            ELSE CALL UnCmprs(a$, X%, Y%)
            END IF
         ELSE INPUT #3, X%, Y: Y% = Y
         END IF
         RETURN

LoadLabels: nml = 0
     DO WHILE NOT EOF(3)
        nml = nml + 1: INPUT #3, ML$(nml), MLa(nml), MLo(nml), MLr(nml)
        IF MLa(nml) = 0 OR MLo(nml) = 0 THEN nml = nml - 1
     LOOP
     RETURN
       
SaveMap: CALL PR("Save in Normal, LineFormat, or Compressed [C]", a$)
   Comp = -1
   IF a$ = "N" THEN Comp = 0
   IF a$ = "L" THEN Comp = 9
   IF a$ = "C" THEN Comp = -1
   GOSUB CkEdges: IF abort THEN abort = 0: RETURN
   CALL PRtxt("Enter file name to save (" + MapFile$ + ")", a$)
   IF a$ <> "" THEN
      IF INSTR(a$, ".") = 0 THEN a$ = a$ + ".map"
      IF INSTR(a$, "\") = 0 AND INSTR(a$, ":") = 0 THEN
         MapFile$ = Mpath$ + a$
      ELSE MapFile$ = a$
      END IF
   END IF
   F$ = MapFile$
   CALL CLRtxt(43, "Saving map to file named " + F$ + " ...", 10)
   OPEN F$ FOR OUTPUT AS #4
   IF Fault = 70 OR Fault = 71 THEN Fault = 0: CLOSE #4: GOTO SaveMap
   PRINT #4, LATo; ","; LATtext$
   PRINT #4, LONo; ","; LONtext$
   PRINT #4, ppdv; ","; VS$
   PRINT #4, LatCen; ",", LatCen$
   PRINT #4, LonCen; ","; LonCen$
   PRINT #4, MapRng; ","; MapRng$
   PRINT #4, MinRng; ","; MR$
   j = 1: abort = 0
   IF Comp THEN
      IF Comp = 9 THEN PRINT #4, "LineFormat";  ELSE PRINT #4, "Compressed"
      'abc where c = .xxxxyyy
      '          x = 16*a + xxxx  and  y = 8*b +yyy
      IF X%(1) <> 0 THEN X%(1) = 0: Y%(1) = 15
      FOR i = 1 TO nmp
          IF X%(i) <> 0 THEN
             a% = INT(X%(i) / 16): cx% = X%(i) - a% * 16
             B% = INT(Y%(i) / 8): cy% = Y%(i) - B% * 8
             c% = 8 * cx% + cy%
             PRINT #4, CHR$(a% + 27); CHR$(B% + 27); CHR$(c% + 27);
             IF Comp = -1 THEN PRINT #4,
          END IF
          IF i = nmp AND Comp <> 9 THEN PRINT #4, " 0,-1"
          IF X%(i) = 0 AND i <> nmp THEN
             IF Comp = -1 THEN
                PRINT #4, " 0,0"
                PRINT #4, Y%(i); ","; LN$(j): j = j + 1
             ELSE PRINT #4, : PRINT #4, MID$(STR$(Y%(i)), 2); ",";
             END IF
          END IF
      NEXT i
   ELSE
      IF MapType$ <> "Compressed" AND MapType$ <> "LineFormat" THEN
         PRINT #4, MapType$
      ELSE PRINT #4, "ASCII"
      END IF
      FOR i = 1 TO nmp
          IF X%(i) <> 0 THEN WRITE #4, X%(i), Y%(i)
          IF i = nmp THEN PRINT #4, " 0,-1"  'Used to be AND X%(i)=0
          IF X%(i) = 0 AND i <> nmp THEN
             PRINT #4, "0,0"
             PRINT #4, Y%(i); ","; LN$(j): j = j + 1
          END IF
      NEXT i
   END IF
   IF Comp = 9 THEN
      PRINT #4, : PRINT #4, "-1,Labels"
   ELSE PRINT #4, "0,"; LN$(j)
   END IF
   a = 5
   IF ppdv > 30 THEN a = 6
   IF ppdv > 300 THEN a = 7
   IF ppdv > 3000 THEN a = 8
   FOR k = 1 TO nml
       PRINT #4, ML$(k); ",";
       PRINT #4, LEFT$(LTRIM$(STR$(MLa(k))), a); ",";
       PRINT #4, LEFT$(LTRIM$(STR$(MLo(k))), a); ",";
       PRINT #4, LTRIM$(STR$(MLr(k)))
   NEXT k: CLOSE #4: LOCATE bln - 1, 1:
   Chgd = 0
   IF nmp > MaxNumPoints OR nml > MaxNumLABELS THEN
      CLS : LOCATE 9, 29: PRINT "CAUTION!": PRINT : PRINT
      IF nmp > MaxNumPoints THEN
         PRINT "            The number of points,"; nmp; "is greater than"; MaxNumPoints
      END IF
      IF nml > MaxNumLABELS THEN
         PRINT "            The number of LABELS,"; nml; "is greater than"; MaxNumLABELS
      END IF
      LOCATE 18, 12
      PRINT " Therefore this map will not work with APRS (yet) "
      CALL PR("HIT", a$)
   END IF
   RETURN

CurDrwMap: CDX = CPX: CDY = CPY: GOTO DrawMap

DrwMPaCur: CPX = CDX: CPY = CDY: GOSUB DrawMap
           REM After drawing map, Put cursor at center
           RETURN

ChangeColors: CALL PRtxt("Enter color to change", a$): IF a$ = "" THEN RETURN
              ctc = VAL(a$)
              CALL PRtxt("Enter new color", a$): : IF a$ = "" THEN RETURN
              NewC = VAL(a$)
              FOR i = 1 TO nmp
                  IF X%(i) = 0 AND Y%(i) = ctc THEN Y%(i) = NewC
              NEXT i

DrawMap: IF USGS THEN RETURN
    SCREEN , , 1, 1: Scrn = 1: CLS : CUX = 0
    Display$ = "MAP"
    COLOR 15, 0
    WIDTH 80, GBLn: bln = GBLn
   'Draw to range scale RS and center display CDX and CDY
  
   DO WHILE RS < 400 / ppdv: RS = RS * 2: LOOP
   IF RS > 8192 THEN RS = 8192
   kp = 100 * 100 / (RS * ppdv)' this is kinda arbitrary..??
   Sfac = 50 * 200 / RS

   Lfac = COS(CDY / 57.296)
   Hfac = (640 / 350) * (3 / 4) * Lfac
   HfacK = kp * Hfac
   dx = ppdv * (LONo - CDX)
   dy = ppdv * (LATo - CDY)
        
   LOCATE 1, 1: PRINT "Redrawing Map"
   REM draw ORG, CNTR, & 1800x3600 BOX
   x0 = 320 - (dx * HfacK): y0 = Ycen - dy * kp
   Xm = 320 + (3600 - dx) * HfacK: Ym = Ycen + (1800 - dy) * kp
   LINE (x0, y0)-(Xm, Ym), 14, B
   CMX = 320 + Sfac * (CDX - LonCen) * Hfac'new
   CMY = Ycen + Sfac * (CDY - LatCen)
   LINE (CMX - 27, CMY)-(CMX + 27, CMY), 15
   LINE (CMX, CMY - 20)-(CMX, CMY + 20), 15
   CIRCLE (CMX, CMY), 10, 15
   CIRCLE (320 - dx * HfacK, Ycen - kp * dy), 12, 14
   S = 0: GOSUB MapPoint
   StrtPt = 0
   RegsIN.ax = &H4: RegsIN.cx = 320: RegsIN.dx = Ycen
   CALL Interrupt(&H33, RegsIN, RegsOUT)

   
DP: HfacK = kp * Hfac
    YfactrK = kp
    FOR i = S TO nmp - 1
       X = 320 + (X%(i) - dx) * HfacK
       Y = Ycen + (Y%(i) - dy) * YfactrK
       X1 = 320 + (X%(i + 1) - dx) * HfacK
       Y1 = Ycen + (Y%(i + 1) - dy) * YfactrK
       IF StrtPt THEN
          'x = 320 + (x%(i) - dx) * HfacK
          'y = Ycen + (y%(i) - dy) * YfactrK
          PSET (X, Y), LineColor
          IF Epts THEN CIRCLE (X, Y), 2, 9
          StrtPt = 0
          LINE -(X1, Y1), LineColor, , dots
       ELSE
          IF X%(i + 1) <> 0 THEN
             LINE -(X1, Y1), LineColor, , dots
             IF points THEN CIRCLE (X1, Y1), 1, 15
          ELSE
             IF Epts THEN CIRCLE (X, Y), 3, 10
             StrtPt = -1
             LineColor = Y%(i + 1): i = i + 1
             dots = &HFFFF
             IF LineColor = 8 THEN dots = &HF0F0: IF Wrr THEN LineColor = 15
             IF LineColor = 0 OR LineColor = 15 THEN dots = &HCCCC: LineColor = 15
             X = 320 + (X%(i + 1) - dx) * HfacK
             Y = Ycen + (Y%(i + 1) - dy) * YfactrK
             IF Display$ = "SHOW" AND LineColor > 8 THEN LineColor = LineColor - 8
          END IF
       END IF
       IF i = z THEN SavClr = LineColor
   NEXT i
   GOSUB Cursor
   GOSUB Redraw
   GOSUB DrawHist
   IF Key$ <> CHR$(0) + CHR$(30) THEN GOSUB ShowBox
   IF Display$ = "SHOW" THEN
      GOSUB ShowMaps
   ELSE GOSUB Post43
   END IF

Labels:
   IF LabelsON THEN
      FOR i = 1 TO nml ' Now plot labels on map
      IF RS <= MLr(i) OR Key$ = "S" THEN
         X = 320 + Sfac * (CDX - MLo(i)) * Hfac'new
         Y = Ycen + Sfac * (CDY - MLa(i))
         CIRCLE (X, Y), 1, 14
         IF Y > Cfactr AND Y < bln * Cfactr AND X > 8 * (LEN(ML$(i)) + 1) AND X < 632 THEN
            LOCATE Y / Cfactr, (X / 8) - LEN(ML$(i)): PRINT ML$(i);
         END IF
      END IF
      NEXT i
   END IF
   GOSUB ShowMap
   Bclr = 15
   IF ELock THEN GOSUB LockBox
     LINE (0, 0)-(138, 3 * Cfactr), 12, B
     LINE (0, 0)-(76, 3 * Cfactr), 12, B
   LOCATE bln - 1, 1: PRINT "Cursor coordnts:";
   RETURN

LockBox: LINE (0, 0)-(639, 349), Bclr, B
         LINE (3, 2)-(636, 347), Bclr, B
         CALL CLRtxt(43, "*** EDIT IS LOCKED ON ***|    COMMANDS ARE:  ADD,  DELETE,  LOCKoff,  MOVE", 14)
         RETURN
        
Post43: CALL CLRtxt(43, "Use +/- to move MAPpoint.   N/P for Next/Previous Feature.   H for HELP!. ", 0)
        LOCATE 1, 71 ' was 61
        PRINT "PTS"; nmp ' ; "= "; INT((nmp / MaxNumPoints) * 100); "%";
        LOCATE 2, 71 ' was 61
        PRINT "LBLS "; nml '; "= "; INT((nml / MaxNumLABELS) * 100); "%";
        LOCATE 3, 71: PRINT "PPD"; ppdv
        LOCATE 4, 71: PRINT "Rng"; LEFT$(STR$(MapRng), 5)
        RETURN
ShowMap: REM this shows the map boarder of the loaded map
    X = 320 + (CDX - LonCen) * ppdv * HfacK'new
    Y = Ycen + kp * (CDY - LatCen) * ppdv
      by = MapRng * Sfac / 60
      bx = 1.8 * by
      c = 15
    LINE (X - bx, Y - by)-(X + bx, Y + by), c, B
    RETURN

Cursor: JustCur = 0: IF pc = 12 THEN GOSUB DrwMpPt
     IF CUX > 4 AND CUY > 3 AND CUX < 635 AND CUY < 343 THEN PUT (CUX - 4, CUY - 3), Crsr, XOR
     CUX = 320 + Sfac * (CDX - CPX) * Hfac'new
     CUY = Ycen + Sfac * (CDY - CPY)
     IF CUX > 4 AND CUY > 3 AND CUX < 635 AND CUY < 343 THEN PUT (CUX - 4, CUY - 3), Crsr, XOR
     IF CPX > 0 THEN
          X = INT(CPX): Xm = (CPX - X) * 60
     ELSE X = INT(-CPX): Xm = -(CPX + X) * 60
     END IF
     IF CPY > 0 THEN
          Y = INT(CPY): Ym = (CPY - Y) * 60
     ELSE Y = INT(-CPY): Ym = -(CPY + Y) * 60
     END IF
     X$ = RIGHT$(STR$(X), 3) + " "
     LOCATE 1, 1: PRINT "Rng"; RIGHT$("   " + STR$(RS), 4) + "   Decimal"
                  PRINT Y; : PRINT USING "##.##"; Ym;
                  PRINT LEFT$(STR$(CPY) + " ", 8)
                  PRINT X$; : PRINT USING "##.##"; Xm;
                  PRINT LEFT$(STR$(CPX) + "   ", 8);
     LOCATE bln - 1, 17
     PRINT INT(.5 + dx + (CUX - 320) / (HfacK)); TAB(23); INT(.5 + dy + (CUY - Ycen) / kp);
'     LINE (0, 0)-(138, 3 * Cfactr), 12, B
 '    LINE (0, 0)-(76, 3 * Cfactr), 12, B
     a$ = "": B$ = ""
     RETURN


HELP: SCREEN , , 0, 0: Scrn = 0: CLS
      COLOR 15, 1
      LINE (0, 0)-(639, 18), 4, BF
      LOCATE 1, 20: PRINT " MAPFIX.bas HELP SCREEN Ver "; Ver$
      LOCATE 3, 1
      PRINT
      PRINT " The ORIGIN, CENTER and BORDER are shown, but only the CENTER and RANGE in the"
      PRINT " MAPLIST.xxx are used by APRS.  Labels are right justified. Callsigns are left"
      PRINT " justified.  Use the first letter of any command."
      PRINT ""
      PRINT
      PRINT " F- FILES      C- CHANGE  S- SETUP       E- EDIT        L- LABELS  T- TASKS "
      PRINT "    MENU          MENU       MENU           MENU           MENU       MENU     "
      PRINT " ------------  ---------  ------------   -------------  ---------  ------------"
      PRINT " D- Directory  B- BEEPS   A- AutoCentr   A- Add point   A- Add     C- Clear Pts"
      PRINT " L- Load       C- Center  B- ppdBOX on/f C- Chnge Color K- Kill    G- GPStrack "
      PRINT " O- Opn Dgtzr  O- Origin  E- END pts     D- Delete Pt   I- Import  I- Import "
      PRINT " Q- Quit       R- Range   P- Points      L- LockEDIT    M- Move    J- Join"
      PRINT " S- Save                  R- Redraw      K- Killfeature N- New Rng O- Overlay"
      PRINT " V- ViewMpLst             W- White RR    M- Move Pt     O- On/Off  T- Trim"
      PRINT "                                         N- New Feature S- Show    S- Scrunch"
      PRINT "                                         S- Split featr            B- Borders'                 "
      PRINT
      PRINT " DISPLAY COMMANDS     POINTER MOVEMENTS  DIGITIZER/MOUSE     USGS CD ROM CMDS"
      PRINT " -------------------  -----------------  ------------------  ----------------"
      PRINT " SPACE to draw map    N- Next Feature    F1- Move cursor      U- USGS overlay"
      PRINT " ARROWS cursr (shft)  P- Prev Feature    F3, F4, F6, F7, F8  @U- USGS Load"
      PRINT " PgUP/DN (ctrl)       G- Go to Pointer   F10,shifted F1, F2"
      PRINT " HOME map to Cursor   +  Move to next    are all hotkeys to"
      PRINT " HOME(shft) to Orign  -  Previous pt     begin that color"
      PRINT " END to map center    R- RESET to 1stPt  line"
      PRINT
      PRINT " CR or ENTER will search the MAP for the closest point to the cursor.  There"
      PRINT " may be many points at a junction.  Hit CTRL-ENTER to continue the search."
      PRINT ""
      PRINT " F1 Temporarily re-defines Digitizer click to move cursor vice ADD point"
      'PRINT " F3 (SHFT) Mark mapfile to be saved in COMPRESSED format (3-to-1 compression)"
      'PRINT " F4 (SHFT) Mark mapfile to be saved in ASCII format"
      'PRINT " F5 (SHFT) Mark mapfile to be saved in LineFormat  (6-to-1 compression)"
      PRINT " F5        Slow GPS overlay so U can see chronologically"
      PRINT " F8 (shft) Adds MARKER to map.  Useful for re-calibrating MOUSE"
      REM PRINT " F9        Init Mouse (Microsoft serial mouse only)"
      PRINT
      PRINT
              
      IF Display$ <> "HELP" THEN CALL CLRtxt(43, " HIT H AGAIN FOR MORE HELP SCREENS, OR SPACE BAR FOR MAP...", 14)
      Display$ = "HELP"
      LINE (0, 0)-(639, 348), 15, B
      RETURN

LdMapLst: CALL PRtxt("Enter FileSpec for MAPLIST (" + Maplist$ + ")", a$)
    IF a$ <> "" THEN
       IF INSTR(a$, "\") = 0 AND INSTR(a$, ":") = 0 THEN
          Maplist$ = Mpath$ + a$
       ELSE Maplist$ = a$
       END IF
    END IF
    F$ = Maplist$
    OPEN F$ FOR INPUT AS #3: IF Fault <> 0 THEN RETURN
    i = 1: NumGood = 0
    INPUT #3, DfltY: LINE INPUT #3, a$
    INPUT #3, DfltX: LINE INPUT #3, a$
    INPUT #3, BestRng: LINE INPUT #3, a$: DfltR = BestRng
    INPUT #3, GMToffset: LINE INPUT #3, a$
    WHILE a$ <> "* BEGIN *" AND NOT EOF(3)
          LINE INPUT #3, a$
    WEND ' Skip comment block
    WHILE NOT EOF(3) AND i <= UBOUND(MapName$)
       INPUT #3, MapName$(i), LatCen(i), LonCen(i), MapMax(i)
       LINE INPUT #3, Comment$(i)
       IF LEFT$(MapName$(i), 1) <> "*" THEN NumGood = NumGood + 1
       NumMaps = i: i = i + 1
    WEND: CLOSE #3
    MpLstLdd = -1
    IF NumGood >= MaxNumMAPS - 1 THEN
       CLS : LOCATE 2, 5
       PRINT "WARNING: Too many ACTIVE MAPS (more than"; MaxNumMAPS; ") in MAPLIST.map file for APRS"
       LOCATE 4, 10: PRINT "Use EDITOR to suppress mapnames with an (*) that you don't need."
       CALL PR("HIT", a$)
    END IF
    RETURN

ListMAPlist: IF NOT MpLstLdd THEN GOSUB LdMapLst
   GOSUB ListHeader
   FOR i = 1 TO NumMaps
       IF i / 36 = INT(i / 36) THEN
          CALL PR("HIT", a$)
          GOSUB ListHeader
       END IF
       PRINT MapName$(i); TAB(14);
       PRINT INT(LatCen(i) * 100) / 100; TAB(21); INT(LonCen(i) * 100) / 100;
       PRINT TAB(29); MapMax(i); TAB(36); LEFT$(LTRIM$(Comment$(i)), 43)
   NEXT i
   
   CALL CLRtxt(43, "LIST COMPLETE. CONTINUE WITH NEXT MAPFIX COMMAND...", 10)
   RETURN

ListHeader: CLS
   PRINT "MAPS in MAPLIST.map  (*MAPS are not used)"
   PRINT
   PRINT "MAP NAME      LATcen LONcen  RANGE COmments..."
   PRINT "------------  ------ ------- ----- -----------"
   RETURN

DrwAndShow: IF NOT MpLstLdd THEN GOSUB LdMapLst
            Display$ = "SHOW": REM GOSUB DrwMPaCur

ShowMaps: IF MapSize > RS / 2 THEN MapSize = RS / 2
    CALL CLRtxt(43, " Displaying map borders >" + STR$(MapSize) + "mi.  ZOOM and re-do to see smaller.", 10)
    FOR i = 1 TO NumMaps
    X = 320 + Sfac * (CDX - LonCen(i)) * Hfac
    Y = Ycen + Sfac * (CDY - LatCen(i))
      dy = MapMax(i) * Sfac / 60
      dx = dy * 1.8
      c = 15
      IF MapMax(i) > 32 THEN c = 14
      IF MapMax(i) > 64 THEN c = 12
      IF MapMax(i) > 128 THEN c = 11
      IF MapMax(i) > 256 THEN c = 13
          
    IF MapMax(i) > MapSize THEN
       LINE (X - dx, Y - dy)-(X + dx, Y + dy), c, B
       IF Y + dy > Cfactr AND Y + dy < bln * Cfactr THEN
          IF X + dx > 8 * (LEN(MapName$(i)) + 1) AND X + dx < 632 THEN
             LOCATE (Y + dy) / (Cfactr), (X + dx) / 8 - LEN(MapName$(i))
             IF MapMax(i) > RS / 4 THEN PRINT MapName$(i);
          END IF
       END IF
    END IF
    NEXT i: RETURN
        
Hstdir: CLS : PRINT "HISTORY FILES ": PRINT
    PRINT "Enter the path to your xxxxx.HST files.  ie: \APRS\HSTS"
    PRINT ""
    INPUT F$: IF F$ = "" THEN F$ = "\APRS\HSTS"
    PRINT : PRINT : FILES F$ + "\*.*"
    RETURN

LoadHST: CALL PRtxt("Which history file to load (ENTER for list, Q to quit)", F$)
    IF F$ = "Q" THEN RETURN
    IF F$ = "" THEN GOSUB Hstdir: GOTO LoadHST
    a = INSTR(3, F$, "."): IF a = 0 THEN F$ = F$ + ".hst"
    Fault = 0: F$ = UCASE$(F$): OPEN F$ FOR INPUT AS #3
   
    IF Fault = 53 OR Fault = 62 THEN Fault = 0: RETURN
    CALL CLRtxt(41, "Loading track history from " + F$, 10)
      
    DO WHILE NOT EOF(3)
       i = i + 1
       LINE INPUT #3, a$
       o = 0: IF MID$(a$, 23, 1) = "." THEN o = -7
       HLAT(i) = VAL(MID$(a$, 26 + o, 2)) + (VAL(MID$(a$, 28 + o, 5)) / 60)
       HLONG(i) = VAL(MID$(a$, 35 + o, 3)) + (VAL(MID$(a$, 38 + o, 5)) / 60)
       IF MID$(a$, 33 + o, 1) = "S" THEN HLAT(i) = -HLAT(i)
       IF MID$(a$, 43 + o, 1) = "E" THEN HLONG(i) = -HLONG(i)
       maxhist = i
     LOOP
     CLOSE #3: Histloaded = -1
     CALL CLRtxt(41, "File loading complete.  GPS data is plotted.", 0)
     '...

DrawHist:
     IF Histloaded THEN
        size = 3: IF RS < 2 THEN size = size * 2 / RS
        FOR i = 1 TO maxhist
            HMX = 320 + (CDX - HLONG(i)) * ppdv * HfacK'new
            HMY = Ycen + kp * (CDY - HLAT(i)) * ppdv
            CIRCLE (HMX, HMY), size, 13
            IF Slower THEN FOR zz = 1 TO 1500: NEXT zz
        NEXT i
     END IF
     RETURN

NewMap: CLS
   PRINT "Points are measured to the right and down from the map origin."
   CALL PRdegmin("Enter the LATITUDE  of the ORIGIN ", LATo)
   CALL PRdegmin("Enter the LONGITUDE of the ORIGIN ", LONo)
   LOCATE 6, 1
   PRINT "Choose the number of dots per degree to set the map scale:"
   PRINT
   PRINT "Approximate size     Range fm center Resolution Dots/Deg"
   PRINT "----------------     --------------- ---------- -------"
   PRINT "Typical state                 128 mi  400 yds    240"
   PRINT "Several County region          64 mi  200 yds    450"
   PRINT "Typical VHF range              32 mi  100 yds    900"
   PRINT "Big metro area     1:100,000   16 mi  160 ft    1800"
   PRINT "Four 7.5 min maps               8 mi   80 ft    3600"
   PRINT "One 7.5 min map    1: 24,000    4 mi   40 ft    7200"
   PRINT ""
   INPUT "Enter desired Dots/Deg"; ppdB
   IF ppdB = 0 THEN GOTO NewMap
   REM 500 is half of 999 (maximum nominal value for pts)
   LatCen = LATo - (500 / ppdB)
   LonCen = LONo - (756 / ppdB) 'had been 500. Now .75 of 3600 % 2
   GOSUB StartMap: ppdv = ppdB
   CLS : PRINT "YOU MAY NOW DRAW A NEW MAP...": PRINT : PRINT
   PRINT
   PRINT "The YELLOW box shows the maximum values for this ORIGIN and SCALE."
   PRINT
   PRINT "The PURPLE box shows the same limits, but moves with the current map center."
   PRINT
   PRINT "The WHITE  box shows the current map range to be entered into MAPLIST.xxx."
   PRINT
   PRINT
   PRINT "USING CURSOR WITHOUT DIGITIZER:  Move coursor to starting point for a NEW"
   PRINT "feature and hit EDIT-NEW. Then enter new feature name (not used except for"
   PRINT "your own reference) and continue moving cursor and hitting EDIT-ADD."
   PRINT
   PRINT
   PRINT "USING A DIGITIZER:  First, use FILES-OPEN to OPEN the digitizer COM port. Then"
   PRINT "use EDIT-BEGIN to BEGIN each new map feature.  Enter the name and color of the"
   PRINT "new feature.  Then use the digitizer mouse to add more points."
   PRINT : PRINT : PRINT
   PRINT "Add LABELS on the map at the current cursor location by using LABELS-ADD. "
   PRINT
   PRINT
   PRINT "When you are finished, be sure to do a FILES-SAVE..."
   PRINT : PRINT : PRINT
   PRINT "FOR HELP, REMEMBER THE  H  KEY!"
   CALL PR("HIT", a$)
   RETURN

StartMap: REM called by NEW and inside USGS build
   LatCen$ = "LAT of CENTER": LonCen$ = "LON of CENTER"
   MapRng = 60 * 500 / ppdB: REM 500 is half of full map size
   MapRng$ = "Map range from center"
   VS$ = "Pixels per degree"
   MinRng = 1: MR$ = "Reserved"
   MapType$ = "NEW Map made by MAPFIX.bas..."
   IF Key$ = "NEW" THEN RS = 2 ^ INT(LOG(MapRng) / LOG(2))'Rng is intgr of VERTrng
   CDX = LonCen: CDY = LatCen: CPX = CDX: CPY = CDY
   nmp = 1: nml = 0
   LNi = 1: LN$(1) = "Labels follow"
   RETURN


DigiInit:
   CLS : PRINT : Digitizer = -1: MpLstLdd = 0
   PRINT "DIGITIZER INITIALIZATION:"
   PRINT
   PRINT "Only Mercator projection charts will give absolutely accurate results."
   PRINT
   PRINT : PRINT
   PRINT "The digitizr should operate at 9600,N,8,1 in POINT mode with 200 LPI resolution."
   PRINT "The FORMAT outputs X,Y,C values separated by commas (C is for button pressed."
   PRINT
   PRINT "Set up the digitizer according to your model's instructions.  For the model"
   PRINT "23360, use the drawing board menu by pressing the mouse button 0 on the SETUP"
   PRINT "label so that the LED is ON.  Then move the mouse to each other label and"
   PRINT "use the 0 button to toggle the value ON or off as follows:"
   PRINT
   PRINT "POINT is ON                             PARITY 7/8 and 1 are ON "
   PRINT "BAUDRATE 3 is ON                        FORMAT is ON ON off ON"
   PRINT "DATA RATE doesn't matter                RESOLUTION off off ON"
   PRINT : PRINT
   INPUT "DIGITIZER connected to COM1 or COM2 (1)"; a$
   IF a$ <> "2" THEN a$ = "COM1" ELSE a$ = "COM2"
   INPUT "9600 baud.  Is digitizer 7 or 8 bits (8)"; B$
   IF B$ = "7" THEN B$ = "E,7" ELSE B$ = "N,8"
   Port$ = a$ + ":9600," + B$ + ",1,cs0,ds0,cd0"
   OPEN Port$ FOR RANDOM AS #1
   

   CLS : PRINT "FIRST, TEST THE DIGITIZER, AND GET THE MAP ON STRAIGHT.": PRINT
   PRINT "Move mouse/pen and hit the 0 button (or touch tablet) to see if the ouput"
   PRINT "is in the desired format.  While doing this, verify that your map is on"
   PRINT "straight.  The Y values should be the same for any LATITUDE line on both the"
   PRINT "right and left edges of the map.  If not, move your map to get it horizontal."
   PRINT "Play with this until you get the map on straight & the right format."
   PRINT
   PRINT "OUTPUT FORMAT:"
   PRINT
   PRINT "XXXXX,YYYYY,APn (Only the X and Y values are important (4 or 5 digits are OK)"
   PRINT "                (APn usually represents the buttons.  A four button mouse will"
   PRINT "                (output a 0,1,2, or 3.  The 0 ADDS a point, the 1 begins a RED"
   PRINT "                (road, a 2 begins a GRAY road and the 3 only moves the cursor."
   PRINT ""
   PRINT "                If your mouse is not putting out these numbers (Especially 0),"
   PRINT "                then select ONE BUTTON mode when asked."
   PRINT
   LOCATE bln, 1: PRINT "Hit ENTER and press 0 button on mouse to continue...";
   LOCATE 12, 1
   DO UNTIL INKEY$ <> "": LINE INPUT #1, a$: PRINT a$: LOOP
   CALL PR("Is your digitizer FOUR (4) or more buttons, OR a PEN (1). [1]", a$)
   IF a$ = CHR$(13) OR a$ = "1" THEN Buttons = 1
   CLS : PRINT
   PRINT "NEXT YOU MUST ESTABLISH THE SCALE OF YOUR DIGITIZER."
   PRINT
   PRINT "Both the HORZ and VERT scale are established by two points, the first near the"
   PRINT "top, the second near the bottom.  THese points must also be WIDELY separated"
   PRINT "both Vertically AND Horizontally."
   PRINT
   PRINT "If the map is not exactly MERCATOR, use points within the area where you are"
   PRINT "working, not on the extreme corners.  IE:  choose points in the center of the"
   PRINT "upper left quadrant and the lower right quadrant. (or the opposite diagonal)"
   PRINT
   PRINT "To establish the upper reference point:"
   CALL PRdegmin("Enter lat ", LATref1)
   CALL PRdegmin("Enter long ", LONref1)
   LOCATE 12, 1
   PRINT "Place mouse/pen on the upper point and press the 0 button."
   GOSUB GetPoint: digix1 = X: digiy1 = Y
   LOCATE 12, 1
   PRINT "Digitizer reads "; digix1, digiy1; " for this point."
  
   PRINT
   PRINT "NOW Establish the lower reference point:"
   CALL PRdegmin("Enter LAT ", LATref2)
   CALL PRdegmin("Enter LONG ", LONref2)
   LOCATE 14, 1
   PRINT "Place mouse/pen on lower point and press the 0 button."
   GOSUB GetPoint: digix2 = X: digiy2 = Y
   LOCATE 14, 1
   PRINT "Digitizer reads "; digix2, digiy2; " for this point."
   PRINT

   REM Find delta lat/long between reference points
   REM Calculate degrees per x/y unit
        degx# = (LONref1 - LONref2) / (digix1 - digix2)
        degy# = (LATref1 - LATref2) / (digiy1 - digiy2)
   PRINT
   PRINT "***** YOU ARE NOW READY TO USE THE DIGITIZER  *****"
   PRINT
   PRINT "The digitizer works like the cursor and EDIT-ADD command.  Each point click"
   PRINT "adds a point to the current feature just as if you had hit EDIT-ADD.  The"
   PRINT "new point is added after the current MapPoint identified by the white circle. "
   PRINT
   PRINT "With the digitizer, do NOT use the EDIT-NEW command which always begins at the"
   PRINT "current cursor location.  For the digitizer, use EDIT-BEGIN to BEGIN a new"
   PRINT "feature.  You will be asked to identify the name and color of the new feature."
   PRINT "From then on, just move the digitizer mouse (or pen) to ADD new points.  "
   PRINT
   PRINT "If your digitizer mouse has 4 buttons, use the first (left) button for ADDing "
   PRINT "points, use the 4th (right) button to just move the cursor with no action."
   PRINT "With point-pens or single button mice, press F1 and the next use of the Pen "
   PRINT "will just move the cursor, NOT add a point."
   PRINT
   PRINT "On a four button mouse, the 2nd will BEGIN a RED #4 line, and the 3rd will"
   PRINT "begin a gray color #7 line."
   CALL PR("HIT", a$)
   RETURN

GetPoint: LINE INPUT #1, a$: CALL Noise(2)
   a = INSTR(a$, ","): IF a = 0 THEN RETURN
       X = 5000 - VAL(LEFT$(a$, a - 1))
   B = INSTR(a + 1, a$, ",")
   c = B: IF B = 0 THEN c = LEN(a$)
       Y = VAL(MID$(a$, a + 1, c - (a)))
   RETURN

GetXY: GOSUB GetPoint
   IF B THEN Btn = VAL(RIGHT$(a$, 1))' Get the BUTTON value from 3rd field
   IF Buttons = 1 THEN Btn = 0
   CPY = ((Y - digiy2) * degy#) + LATref2
   CPX = ((X - digix2) * degx#) + LONref2
   IF LOC(1) <> 0 THEN a$ = INPUT$(LOC(1), #1)'Clear input buffer
   RETURN

BOXppd:  CALL PRtxt("Enter the desired PPD (enter 0 to eliminate purple box)", a$)
         IF a$ <> "" THEN ppdB = VAL(a$): gotthem = 0' To force re-evaluation
ShowBox: IF ppdB > 1 THEN
             Y = (30000 / ppdB) * Sfac / 60  'had been 30000 thn 36000
             X = Y * 820 / (400) * Lfac  'had been 640 then 560
             LINE (CUX - X, CUY - Y)-(CUX + X, CUY + Y), 13, B
            CALL CLRtxt(41, "Purple box shows the largest APRS map that can be made with that scale.", 10)
         END IF
         RETURN
        
GetUSGS: REM used for both U=OVERLAY and ALT-U = USGS BUILD!
         CLS : PRINT "The USGS routines have been removed since KB4XF's MAKEMAP1 program"
         PRINT "does it all in one step.  If you want to use this feature, then get an"
         PRINT "old copy of MAPFIX30 or earlier..."
         RETURN


KeepLine: X%(z) = X%: Y%(z) = Y%: nmp = nmp + 1: z = z + 1: ni = ni + 1: RETURN


Scrunch: i = 0: Pt = 0: nt = 0: ni = 0
    CALL PRtxt("Enter slope filter ratio 1.1 to 1.5 (typically 1.2)", a$)
    IF a$ = "" THEN Slope = 1.2 ELSE Slope = VAL(a$)
    DO UNTIL i >= nmp - 1
      i = i + 1
      X1 = 320 + (X%(i) - dx) * HfacK
      Y1 = Ycen + kp * (Y%(i) - dy)
      IF X%(i) <> 0 THEN
        Pt = Pt + 1
        IF Pt > 2 THEN
          REM LINE (x, y)-(x1, y1), 6
          dd = X - X1
          dn = Y - Y1
          IF dd = 0 AND dn = 0 THEN
            sd = Slope: S = Lsp  'Here the points are identical
            CIRCLE (X, Y), 9, 13
          ELSE
            IF dd = 0 THEN dd = .01
            dst = ((dd * dd) + (dn * dn)) ^ .5
            S = dn / dd' Note that 1>s>.01 for Xdelta of 1 to 100
            IF S = 0 THEN S = .05
            IF ABS(S) < .2 THEN S = .2 * SGN(S)
            IF ABS(S) > 5 THEN S = 5 * SGN(S)
            IF ABS(S) <= .2 AND ABS(Lsp) <= .2 THEN
               sd = 1
            ELSEIF ABS(S) >= 5 AND ABS(Lsp) >= 5 THEN sd = 1
            ELSE sd = Lsp / S
            END IF
            IF ABS(dd) > 50 * kp OR ABS(dn) > 30 * kp THEN sd = 0
            REM IF ABS(dd) < 5 OR ABS(dn) < 4 THEN sd = 1
          END IF
          IF sd > Slope OR sd < 1 / Slope OR X%(i + 1) = 0 OR NumRej > 4 THEN
            ni = ni + 1: CIRCLE (X, Y), 1, 15: NumRej = 0
          ELSE PSET (X, Y), 4: NumRej = NumRej + 1: Chgd = Chgd + 1
            IF Key$ <> "T" THEN
               i = i - 1: nmp = nmp - 1
               FOR ii = i TO nmp
                   X%(ii) = X%(ii + 1): Y%(ii) = Y%(ii + 1)
               NEXT ii
            END IF
          END IF
          Lsp = S: nt = nt + 1
        ELSE Lsp = 0: nt = nt + 1: ni = ni + 1: CIRCLE (X1, Y1), 4, 9
        END IF
      ELSE Pt = 0: nt = nt + 1: ni = ni + 1
        LOCATE 1, 71: PRINT "PTS "; nt
        LOCATE 2, 71: PRINT "SAVD"; ni
      END IF
      X = X1: Y = Y1
    LOOP
    CALL Noise(3)
    RETURN

Join: LnPtr = 0: i = 0: k = 0: CALL CLRtxt(41, "Lines joined: ", 0)
   DO UNTIL i >= nmp
      i = i + 1
       IF X%(i) = X%(i + 2) AND Y%(i) = Y%(i + 2) AND Y%(i + 1) = LColor THEN
          nmp = nmp - 2: LNi = LNi - 1: k = k + 1: LOCATE bln - 2, 15: PRINT k
          FOR j = i + 1 TO nmp: X%(j) = X%(j + 2): Y%(j) = Y%(j + 2): NEXT j
          FOR j = LnPtr TO LNi: LN$(j) = LN$(j + 1): NEXT j
       ELSEIF X%(i) = 0 THEN LColor = Y%(i): LnPtr = LnPtr + 1
       END IF
   LOOP: GOSUB DrawMap
   CALL Noise(3)
   RETURN

MapCnvrt: CALL PRtxt("Enter SCALE in dots-per-deg (" + STR$(ppdv) + ")", a$)
   PPDD = ppdv: IF a$ <> "" THEN PPDD = VAL(a$)
   Chgd = Chgd + nmp
   Nlat = LATo: Nlon = LONo
   CALL PRdegmin("Enter New Lat  of origin ", Nlat)
   CALL PRdegmin("Enter New Long of origin ", Nlon)
     ChgFac = PPDD / ppdv
     LOfset = LONo - Nlon
     LAfset = LATo - Nlat
     CALL PRtxt("This will convert all points...  Are you sure (Y/N) [Y]", a$)
     IF a$ <> "" AND a$ <> "Y" THEN RETURN
     CALL CLRtxt(41, "Now processing map points.", 15)

     FOR i = 1 TO nmp'DO WHILE NOT EOF(3)
         IF X%(i) <> 0 THEN
            X%(i) = ChgFac * (X%(i) - ppdv * LOfset)
            Y%(i) = ChgFac * (Y%(i) - ppdv * LAfset)
            IF X%(i) = 0 THEN X%(i) = 1: PRINT "ZERO value of X!  Converted to 1,"; Y%
        ELSEIF Y%(i) = -1 THEN i = nmp 'shuldnt occur since -1 is NOT in array
        END IF                         'but is only writen at end of file
     NEXT i
     CALL CLRtxt(41, "CONVERSION SUCCESSFUL.", 0)
     LATo = Nlat
     LONo = Nlon
     ppdv = PPDD
     Display$ = "MAP": Redraw = -1: USGS = 0: GOSUB DrwMPaCur
     RETURN

Import: 'Also does TASK-OVERLAY and LABELS-IMPORT
   LoopCNTR = 0
   IF (CDX <> LonCen OR CDY <> LatCen) AND (NOT overlay OR LImp) THEN
      CDX = LonCen: CDY = LatCen: GOSUB DrwMPaCur
      'Cuz TRIM calcs are based on range from CDX,CDY vice alt-CENTER
   END IF: IF Import$ = "" THEN Ipath$ = Mpath$: Import$ = Ipath$
   IF overlay THEN a$ = "OVERLAYING " ELSE a$ = "IMPORTING "
   CALL CLRtxt(43, a$ + "ALL (or one) FEATURES FROM ANOTHER MAP THAT FIT WITHIN WHITE BOX", 10)
   CALL PRtxt("Enter filename (& path if diffrnt) [" + Import$ + "]", a$)
   IF a$ <> "" THEN
      IF INSTR(a$, ".") = 0 THEN a$ = a$ + ".MAP"
      IF INSTR(a$, "\") = 0 AND INSTR(a$, ":") = 0 THEN Import$ = Ipath$ + a$ ELSE Import$ = a$
   END IF
   F$ = Import$
   Fault = 0: OPEN F$ FOR INPUT AS #3
   IF Fault <> 0 THEN RETURN
    a = 1
    DO UNTIL a = 0: wa = a: a = INSTR(wa + 1, F$, "\"): LOOP
    IF wa > 1 THEN Ipath$ = LEFT$(F$, wa)
   a$ = ""
   IF NOT LImp THEN CALL PRtxt("Color of feature to get (1 to 15) or ALL", a$)
   IF a$ = "ALL" OR a$ = "" THEN all = -1 ELSE all = 0
   IF a$ <> "" THEN Fcolr = VAL(a$)
   INPUT #3, LATa: LINE INPUT #3, a$:
   INPUT #3, LONa: LINE INPUT #3, a$: IF Nlon = 0 THEN Nlon = LONa
   INPUT #3, OppdV: LINE INPUT #3, a$'PPDv
   INPUT #3, oLatCen: LINE INPUT #3, a$
   INPUT #3, oLonCen: LINE INPUT #3, a$
   INPUT #3, oMapRng: LINE INPUT #3, a$
   INPUT #3, oMinRnga: LINE INPUT #3, a$
   LINE INPUT #3, a$
   IF a$ = "Compressed" THEN Tcomp = -1 ELSE Tcomp = 0
   IF a$ = "LineFormat" THEN Tcomp = 9
   i = 0
   REM make offset/scale calcs
   Nfac = ppdv / OppdV
   LOfset = LONa - LONo
   LAfset = LATa - LATo
    by = ppdv * MapRng / 60 'same as TRIM borders
    bx = by * 1.8
    S = nmp 'start for RE-DRAW at end of this routine
    X% = 1: Y% = 1' skip 1st test
'    ON ERROR GOTO 0
    DO WHILE NOT EOF(3)
      IF (X% = 0 AND Y% = 0) OR Tcomp = 9 THEN
         StrtPt = -1
         INPUT #3, LColor: LINE INPUT #3, a$ 'get color/name
         IF Tcomp = 9 AND LColor = -1 THEN EXIT DO
         IF LColor = Fcolr OR all THEN
            IF NOT overlay THEN
               X%(nmp) = 0: Y%(nmp) = LColor ' over previous 0,0 at nmp
               LN$(LNi + 1) = LN$(LNi)
               IF Tcomp <> 9 THEN LN$(LNi) = a$ ELSE LN$(LNi) = STR$(LNi)
               LNi = LNi + 1
            END IF
            NofPts = 0' helps not delete pts until line has at least 2 pts
            IF Tcomp = 9 THEN
               FOR u = 1 TO LEN(a$) STEP 3
                   IF NOT overlay THEN nmp = nmp + 1: Chgd = Chgd + 1
                   CALL UnCmprs(MID$(a$, u, 3), X%, Y%)
                   GOSUB OverlayPT
               NEXT u
               'nmp = nmp + 1 this caused bug in Mapfix31
            ELSE
               DO
                  GOSUB LoadPT: 'INPUT #3, x%, y%
                  IF NOT overlay THEN nmp = nmp + 1: Chgd = Chgd + 1
                  IF X% = 0 THEN EXIT DO
                  GOSUB OverlayPT
               LOOP
            END IF
            IF NofPts = 2 AND bad AND NOT overlay THEN
               LNi = LNi - 1
               LN$(LNi) = LN$(LNi + 1)
               nmp = nmp - 3
            END IF
            IF NOT overlay THEN
               X%(nmp) = 0: Y%(nmp) = 0
            ELSE CIRCLE (Xc, Yc), 3, 10
            END IF
         ELSE IF Tcomp <> 9 THEN GOSUB LoadPT
         END IF
      ELSE IF Tcomp <> 9 THEN GOSUB LoadPT'ELSE INPUT #3, x%, y%
      END IF
      LoopCNTR = LoopCNTR + 1
      IF X% = 0 AND Y% = -1 THEN EXIT DO
   LOOP
   LOCATE 42, 1: PRINT SPACE$(80);
   CALL CLRtxt(43, "All map points converted...", 10)
      LINE INPUT #3, a$
      Yp = CDY + MapRng / 60: Xp = CDX + (MapRng / 60) / Lfac
      Ym = CDY - MapRng / 60: Xm = CDX - (MapRng / 60) / Lfac
      DO WHILE NOT EOF(3)
         INPUT #3, ML$, MLa, MLo, MLr
         IF MLa < Yp AND MLa > Ym AND MLo < Xp AND MLo > Xm THEN
            IF NOT overlay OR LImp THEN
               nml = nml + 1
               ML$(nml) = ML$: MLa(nml) = MLa
               MLo(nml) = MLo: MLr(nml) = MLr
            END IF
         END IF
      LOOP: CLOSE #3
      IF NOT overlay THEN GOSUB DP
      overlay = 0: LImp = 0
      CALL Noise(3)
      Tcomp = 0
      RETURN

OverlayPT: X = Nfac * (X% - OppdV * LOfset)
           Y = Nfac * (Y% - OppdV * LAfset)
           IF X = 0 THEN
              X = 1
              IF NOT overlay THEN PRINT "ZERO value of X!  Converted to 1,"; Y%
           END IF
           IF NOT overlay THEN X%(nmp) = X: Y%(nmp) = Y
           IF X > dx + bx OR Y > dy + by THEN bad = 1 ELSE bad = 0
           IF X < dx - bx OR Y < dy - by THEN bad = 1
           IF bad AND NofPts > 1 THEN
              IF NOT overlay THEN nmp = nmp - 1
           ELSE REM IF NOT LImp THEN
                NofPts = NofPts + 1
                Xc = 320 + (X - dx) * HfacK
                Yc = Ycen + (Y - dy) * YfactrK
                IF StrtPt THEN
                   StrtPt = 0
                   PSET (Xc, Yc), LColor
                   CIRCLE (Xc, Yc), 2, 9
                ELSE
                   LINE -(Xc, Yc), LColor
                END IF
           END IF
           RETURN
END

REM $STATIC
SUB CLRtxt (L, S$, c)

 LOCATE L, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE L, LEN(S$) + 2
 IF L = 41 THEN
    LINE (0, 318)-(639, 329), c, B
 ELSE
    LINE (0, 334)-(639, 345), c, B
 END IF

END SUB

SUB Noise (n)
 SHARED Quiet
 IF NOT Quiet THEN
    IF n = 1 THEN SOUND 1200, 1.5
    IF n = 2 THEN SOUND 150, 3
    IF n = 3 THEN SOUND 800, 4: SOUND 1500, 3: SOUND 500, 2
 END IF

END SUB

SUB PR (S$, a$)

 IF S$ = "HIT" THEN S$ = "HIT any key to continue..."
 LOCATE 43, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE 43, LEN(S$) + 2: PRINT "? _";
 LINE (0, 334)-(639, 345), 14, B
 a$ = ""
 DO UNTIL a$ <> "": a$ = INKEY$: LOOP
 a$ = UCASE$(a$)
 CALL CLRtxt(43, "", 0)
 
END SUB

SUB PRdegmin (B$, a)
  
 CALL PRtxt(B$ + "(decimal or deg,min) [" + MID$(STR$(a), 2) + "]", a$)
 IF a$ <> "" THEN
    B = INSTR(a$, ",")
    IF B > 1 THEN
         a = VAL(LEFT$(a$, B - 1))
         M = VAL(MID$(a$, B + 1))
    ELSE a = VAL(a$): M = 0
    END IF
    a = a + SGN(a) * M / 60
 END IF

END SUB

SUB PRtxt (S$, a$)

 LOCATE 41, 1: PRINT LEFT$(S$ + SPACE$(80), 80);
 LOCATE 41, LEN(S$) + 2
 LINE (0, 318)-(639, 329), 14, B
 LINE INPUT a$
 a$ = UCASE$(a$)
 LOCATE 41, 1: PRINT SPACE$(80);
 LINE (0, 318)-(639, 329), 0, B

END SUB

SUB UnCmprs (a$, X%, Y%)

 IF LEN(a$) = 3 THEN
 'a$=abc where c = .xxxxyyy
 'x = 16*a + xxxx  and  y = 8*b +yyy
 c$ = RIGHT$(a$, 1): B$ = MID$(a$, 2, 1): d$ = LEFT$(a$, 1)
  cx% = INT((ASC(c$) - 27) / 8): cy% = (ASC(c$) - 27) - cx% * 8
  X% = 16 * (ASC(d$) - 27) + cx%
  Y% = 8 * (ASC(B$) - 27) + cy%
 END IF
END SUB

