PRINT "This program takes a RAW PROCOMM download file from a GPS receiver"
PRINT "in NMEA-0183 format and formats it to look like an APRS packet beacon"
PRINT "It looks for the GGA and VTG sentences."
PRINT
PRINT "For LORAN or other sentences GLL or RMC, you will have to rewrite"
PRINT "Several lines in the program..."
PRINT
INPUT "Enter file name of raw GPS data"; FI$
INPUT "Select NMEA sentence to use RMC or GGA"; NMEA$
INPUT "Enter name of OUTPUT file for APRS compatible TRACK HISTORY"; FO$
INPUT "Enter callsign to be used with the raw data"; CALL$
INPUT "Enter two digit DAY of data"; Day
INPUT "Enter symbol for character (Car >, Air ', Boat ~)"; Sym$
IF LEN(Sym$) <> 1 THEN Sym$ = ">"
LET CALL$ = LEFT$(CALL$ + "         ", 10)
OPEN FI$ FOR INPUT AS #1
OPEN FO$ FOR OUTPUT AS #2
IF UCASE$(NMEA$) = "GGA" THEN
  DTG$ = MID$(DATE$, 4, 2) + LEFT$(TIME$, 2) + MID$(TIME$, 4, 2)
  DO WHILE NOT EOF(1)
     LINE INPUT #1, A$
     IF LEFT$(A$, 6) = "$GPGGA" AND MID$(A$, 36, 1) = "1" THEN
        LAT$ = MID$(A$, 15, 7)
        LON$ = MID$(A$, 25, 8)
        EST = VAL(MID$(A$, 8, 4)) - 500
        IF EST < 0 THEN Tim = EST + 2400: Standby = 1 ELSE Tim = EST
        IF EST > 0 AND Standby = 1 THEN Standby = 0: Day = Day + 1
        UTC$ = RIGHT$("0" + MID$(STR$(Day), 2), 2) + RIGHT$("000" + MID$(STR$(Tim), 2), 4)
        Pos$ = "/" + LAT$ + "N/" + LON$ + "W"
     END IF
     IF LEFT$(A$, 6) = "$GPVTG" THEN
        CSE$ = Sym$ + MID$(A$, 8, 3)
        SPD$ = "/" + MID$(A$, 26, 3)
     END IF
     Pkt$ = CALL$ + UTC$ + " @" + UTC$ + Pos$ + CSE$ + SPD$ + "/comments"
     PRINT #2, Pkt$
  LOOP
  CLOSE

ELSE 'Or do the RMC here by N4WZR
  DO WHILE NOT EOF(1)
     LINE INPUT #1, A$
     REM $GPRMC has 12 comma-separated fields.  This portion evaluates the input
     REM string character by character and generates F$(1) thru F$(12).
     REM F is field number and C is character number in A$ we're looking at.
     DIM F$(12)
     FOR A = 1 TO 12: F$(A) = "": NEXT A: F = 1: C = 1
        DO UNTIL F = 12
           IF MID$(A$, C, 1) = "," THEN F = F + 1 ELSE F$(F) = F$(F) + MID$(A$, C, 1)
           C = C + 1
        LOOP
     REM
     REM Now that we have 12 fields, we'll scrutinize them individually and
     REM build our final variables.
     REM
     CALL$ = LEFT$(CALL$ + "         ", 10)
     UTC$ = MID$(F$(10), 1, 2) + MID$(F$(2), 1, 4)
     LAT$ = MID$(F$(4), 1, 7) + F$(5)
     LON$ = MID$(F$(6), 1, 8) + F$(7)
     CSE$ = F$(9)
     SPD$ = F$(8)
     Pos$ = " @" + UTC$ + "z" + LAT$ + "/" + LON$ + Sym$
     Pkt$ = CALL$ + UTC$ + Pos$ + CSE$ + "/" + SPD$ + "/raw*/RMC Fix"
     PRINT #2, Pkt$
  LOOP
  CLOSE

END IF
END

