Public Law 102-194

-------------------------------------------------------------------

 A bill to provide for a coordinated Federal program to
 ensure continued United States leadership in
 high-performance computing
 
 
 SECTION 1. SHORT TITLE.
 This Act may be cited as the "High-Performance
 Computing Act of 1991".
 SEC. 2. FINDINGS
 The Congress finds the following:
 (1) Advances in computer science and technology are vital
 to the Nation's prosperity, national and economic security,
 industrial production, engineering, and scientific advancement
 (2) The United States currently leads the world in the
 development and use of high-performance computing for
 national security, industrial productivity, science and
 engineering, but that lead is being challenged by foreign
 competitors.
 (3) Further research and development, expanded
 educational programs, improved computer research
 networks, and more effective technology transfer from
 government to industry are necessary for the United
 States to reap fully the benefits of high-performance
 computing.
 (4) A high-capacity and high speed national research
 and education computer network would provide
 researchers and educators with access to computer
 and information resources and act as a test bed for
 further research and development of high-capacity
 and high-speed computer networks.
 (5)Several Federal agencies have ongoing high
 performance computing programs, but improved
 long-term interagency coordination, cooperation, and
 planning would enhance the effectiveness of these
 programs.
 (6) A 1991 report entitled "Grand Challenges:  High-
 Performance Computing and Communications" by the
 Office of Science and Technology Policy, outlining a
 research and development strategy for high-performance
 computing, provides a framework for a multiagency
  high-performance computing program.  Such a program would
 provide American researchers and educators with the computer
 and information resources they need, and demonstrate how
 advanced computers, high-capacity and high-speed networks,
 and electronic data bases can improve the national information
 infrastructure for use by all Americans.
 
 SEC 3. PURPOSE.
 The purpose of this Act is to help ensure the continued leadership
 of the United States in high-performance computing and its
 applications by--
 (1)  expanding Federal support for research,
 development, and application of high-performance
 computing in order to--
 (A) establish a high-capacity and high-speed National Research
  and Education Network;
 (B) expand the number of researchers, educators, and
 students with training in high-performance computing and
 access to high-performance computing resources;
 (C) promote the further development of an information
 infrastructure of data bases, services, access mechanisms,
 and research facilities available for use through the Network;
 (D) stimulate research on software technology;
 (E) promote the more rapid development and wider
 distribution of computer software tools and applications
 software;
 (F) accelerate the development of computing systems and
 subsystems;
 (G) provide for the application of high-performance
 computing to Grand Challenges;
 (H) invest in basic research and education, and promote
 the inclusion of high-performance computing into
 educational institutions at all levels; and
 (I) promote greater collaboration among government,
 Federal laboratories, industry, high-performance
 computing centers, and universities; and
 (2) improving the interagency planning and coordination of
 Federal research and development on high- performance
 computing and maximizing the effectiveness of the Federal
 Government's high-performance computing efforts.
 
 SEC. 4. DEFINITIONS.
 As used in this Act, the term--
 (1) "Director" means the Director of the Office of Science
 and Technology Policy;
 (2) "Grand Challenge" means a fundamental problem in
 science or engineering, with broad economic and scientific
 impact, whose solution will require the application of
 high-performance computing resources;
 (3) "high-performance computing" means advanced
 computing, communications, and information technologies,
 including scientific workstations, supercomputer systems
 (including vector supercomputers and large scale parallel
 systems), high-capacity and high-speed networks, special
 purpose and experimental systems, and applications and
 systems software;
 (4) "Network" means a computer network referred to as
 the National Research and Education Network established
 under section 102; and
 (5) "Program" means the National High-Performance
 Computing Program described in section 101
 TITLE I--HIGH_PERFORMANCE COMPUTING AND THE
 NATIONAL RESEARCH AND EDUCATION NETWORK
 SEC. 101. NATIONAL HIGH-PERFORMANCE COMPUTING
 PROGRAM.
 (a) NATIONAL HIGH-PERFORMANCE COMPUTING
 PROGRAM.--(1) The President shall implement a National
 High-Performance Computing Program, which shall.
 
 (A) establish the goals and priorities for Federal
 high-performance computing research, development,
 networking, and other activities; and
 (B) provide for interagency coordination of Federal
 high-performance computing research, development,
 networking, and other activities undertaken pursuant
 to the Program
 (2) The Program shall--
 (A) provide for the establishment of policies for
 management and access to the Network;
 (B) provide for oversight of the operation and
 evolution of the Network;
 (C) promote connectivity among computer networks
 of Federal agencies and departments;
 (D) provide for efforts to increase software availability,
 productivity, capability, portability, and reliability;
 (E) Provide for improved dissemination of Federal agency
 data and electronic information;
 (F) provide for acceleration of the development of high-
 performance computing systems, subsystems, and
 associated software;
 (G) provide for the technical support and research and
 development for high-performance computing software
 and hardware needed to address Grand Challenges;
 (H) provide for educating and training additional
 undergraduate and graduate students in software engineering,
 computer science, library and information science, and
 computational science; and
 (I) provide
 (i) for the security requirements, policies, and standards
 necessary to protect Federal research computer networks
 and information resources accessible through Federal
 research computer networks, including research required
 to establish security standards for high-performance
 computing systems and networks; and
 (ii) that agencies and departments identified in the
 annual report submitted under paragraph (3)(A) shall
 define and implement a security plan consistent with the
 Program and with applicable law.
 (3) The Director shall--
 (A) submit to the Congress an annual report, along with
 the President's annual budget request, describing the
 implementation of the Program;
 (B) provide for interagency coordination of the Program;
 and
 (C) consult with academic, State, industry, and other
 appropriate groups conducting research on and using
 high-performance computing.
 (4) The annual report submitted under paragraph (3)(A)
 shall--
 (A) include a detailed description of the goals and priorities
 established by the President for the Program;
 (B) set forth the relevant programs and activities, for the
 fiscal year with respect to which the budget submission
 applies, of each Federal agency and department, including--
 
 (i) the Department of Agriculture
 (ii) the Department of Commerce;
 (iii) the Department of Defense;
 (iv) the Department of Education;
 (v) the Department of Energy;
 (vi) the Department of Health and Human Services;
 (vii) the Department of the Interior;
 (viii) the Environmental Protection Agency;
 (ix) the National Aeronautics and Space
 Administration;
 (x) the National Science Foundation;
 (xi) such other agencies and departments as the
 President or the Director considers appropriate;
 (C) describe the levels of Federal funding for
 the fiscal year during which such report is submitted,
 and the levels proposed for the fiscal year with
 respect to which the budget submission applies, for
 specific activities, including education, research,
 hardware and software development, and
 support for the establishment of the Network;
 (D) describe the levels of Federal funding for
 each agency and department participating in the
 Program for the fiscal year during which such report
 is submitted, and the levels proposed for the fiscal
 year with respect to which the budget submission
 applies; and
  (E) include an analysis of the progress made
  toward achieving the goals and priorities established
  for the Program.
 
 (b) HIGH-PERFORMANCE COMPUTING ADVISORY
 COMMITTEE.--The President shall establish an
  advisory Committee on high-performance computing
 consisting of non-Federal members, including
 representatives of the research, education and library
 communities, network providers, and industry, who
 are specially qualified to provide the Director with
 advice and information on high-performance
 computing.  The recommendations of the advisory
 committee shall be considered in reviewing and
 revising the Program.  The advisory committee
 shall provide the Director with an independent
 assessment of--
 
 (1) progress made in implementing the Program;
 (2) the need to revise the Program;
 (3) the balance between the components of the
 Program;
 (4) whether the research and development undertaken
 pursuant to the Program is helping to maintain United
 States leadership in computing technology; and
 (5) other issues identified by the Director.
 (c) OFFICE OF MANAGEMENT AND BUDGET.--
 (1) Each Federal agency and department participating
 in the Program shall, as part of its annual request for
 appropriations to the Office of Management and
  Budget, submit a report to the Office of Management
 and Budget, identifying which--
 (A) identifies each element of its high-performance
 computing activities which contributes directly to the
 Program or benefits from the Program; and
 (B) states the portion of its request for appropriations
 that is allocated to each such element.
 (2) The Office of Management and Budget shall review
 each such report in light of the goals, priorities, and
 agency and departmental responsibilities set forth in the
 annual report submitted under subsection (a) (3) (A), and
 shall include, in the President's annual budget estimate,
 a statement of the portion of each appropriate agency's or
 department's annual budget estimate relating to its
 activities undertaken pursuant to the Program.
 SEC. 102. NATIONAL RESEARCH AND EDUCATION NETWORK.
 (a) ESTABLISHMENT.--As part of the Program, the
 National Science Foundation, the Department of the
 Defense, the Department of Energy, the Department
 of Commerce, the National Aeronautics and Space
 Administration, and other agencies participating in
 the Program shall support the establishment of the
 National Research and Education Network, portions of
 (b) ACCESS.--Federal agencies shall work with private
  network service providers, State and local agencies,
 libraries, educational institutions and organizations,
 and others, as appropriate in order to ensure that the
 researchers, educators, and students have access, as
 appropriate, to the Network.  The Network is provide
 users with appropriate access to high-performance
 computing systems, electronic information resources,
 other research facilities, and libraries. The Network
 shall provide access, to the extent practicable, to electronic
 information resources maintained by libraries, research
 facilities, publishers, and affiliated organizations.
 (c) NETWORK CHARACTERISTICS.--The Network shall--
 (1) be developed and deployed with the computer,
 telecommunications, and information industries;
 (2) be designed, developed, and operated in collaboration
 with potential users in government, industry, and
 research institutions and educational institutions;
 (3) be designed, developed, and operated in a
 manner which fosters and maintains competition and
 private sector investment in high-speed data
 networking within the telecommunications industry;
 (4) be designed, developed, and operated in a
 manner which promotes research and development
 leading to development of commercial data
 communications and telecommunications standards,
 whose development will encourage the establishment of
 privately operated high-speed commercial networks;
 (5) be designed and operated so as to ensure the
 continued application of laws that provide network
 and information resources security measures, including
 those that protect copyright and other intellectual
 property rights, and those that control access to data
 bases and protect national security;
 (6) have accounting mechanisms which allow
 users or groups of users to be charged for their
 usage of copyrighted materials available over the
 Network and, where appropriate and technically feasible,
 for their usage of the Network;
 (7) ensure the interoperability of Federal and non-Federal
 computer networks, to the extent appropriate, in a way
 that allows autonomy for each component network;
 (8) be developed by purchasing standard commercial
 transmission and network services from vendors
 whenever feasible, and by contracting for customized
 services when not feasible, in order to minimize
 Federal investment in network hardware;
 (9) support research and development of networking
 software and hardware; and
 (10) serve as a test bed for further research and
 development of high-capacity and high-speed computing
 networks and demonstrate how advanced computers, high-
 capacity and high-speed computing networks, and data
 bases can improve the national information infrastructure.
 (d) DEFENSE ADVANCED RESEARCH PROJECTS AGENCY
 RESPONSIBILITY.--As part of the Program, the Department
 of Defense, through the Defense Advanced Research Projects
 Agency, shall support research and development of advanced
 fiber optics technology, switches, and protocols needed to
 develop the Network.
 (e) INFORMATION SERVICES.--The Director shall assist the
 President in coordinating the activities of appropriate agencies
 and departments to promote the development of information
 services that could be provided over the Network. These
 services may include the provision of directories of users
 and services on computer networks, data bases of
 unclassified Federal scientific data, training of users of
 data bases and computer networks, access to commercial
 information services for users of the Network, and
 technology to support computer-based collaboration that
 allows researchers and educators around the Nation to
 share information and instrumentation.
 (f) USE OF GRANT FUNDS--All Federal agencies and
 departments are authorized to allow recipients of Federal
 research grants to use grant moneys to pay for computer
 networking expenses.
 (g) REPORT TO CONGRESS.--Within one year after the date
 of enactment of this Act, the Director shall report to the
 Congress on--
 (1) effective mechanisms for providing operating
 funds for the maintenance and use of the Network,
 including user fees, industry support, and continued
 Federal investment;
 (2) the future operation and evolution of the Network;
 (3) how commercial information services providers could
 be charged for access to the Network, and how Network
 users could be charged for such commercial information
 services;
 (4) the technological feasibility of allowing commercial
 information service providers to use the Network and
 other federally funded research networks;
 (5) how to protect the copyrights of material distributed
 over the Network; and
 (6) appropriate policies to ensure the security of resources
 available on the Network and to protect the privacy of users
 of networks.
 TITLE II--AGENCY ACTIVITIES
 SEC. 201. NATIONAL SCIENCE FOUNDATION ACTIVITIES
 (a) GENERAL RESPONSIBILITIES.--As part of the
 Program described in TITLE I--
 (1) the National Science Foundation shall provide computing
 and networking infrastructure support for all science and
 engineering disciplines, and support basic research and human
 resource development in all aspects of high-performance
 computing and advanced high-speed computer networking.
 (2) to the extent that colleges, universities, and libraries
 cannot connect to the Network with the assistance of the
 private sector, the National Science Foundation shall have
 primary responsibility for assisting colleges, universities,
 and libraries to connect to the Network;
 (3) the National Science Foundation shall serve as the
 primary source of information on access to and use of the
 Network; and
 (4) the National Science Foundation shall upgrade the National
 Science Foundation funded network, assist regional networks
 to upgrade their capabilities, and provide other Federal
 departments and agencies the opportunity to connect to the
 National Science Foundation funded network.
 (b) AUTHORIZATION OF APPROPRIATIONS.-- From
 sums otherwise authorized to be appropriated, there are
 authorized to be appropriated to the National Science
 Foundation for the purposes of the Program $213,000,000 for
 fiscal year 1992; $262,000,000 for fiscal year 1993;
 $305,000,000 for fiscal year 1994; $354,000,000 for fiscal
 year 1995; and $413,000,000 for fiscal year 1996
 SEC. 202. NATIONAL AERONAUTICS AND SPACE
 ADMINISTRATION.ACTIVITIES.
 (a) GENERAL RESPONSIBILITIES.--As part of the
 Program described in title I the National Aeronautics
 and Space Administration shall conduct basic and applied
 research in high-performance computing, particularly in
 the field of computational science, with emphasis on aero-
 space sciences, earth and space sciences, and remote
 exploration and experimentation.
 (b) AUTHORIZATION OF APPROPRIATIONS.--From
 sums otherwise authorized to be appropriated, there are
 authorized to be appropriated to the National Aeronautics
 and Space Administration for the purposes of the Program
 $72,000,000 for fiscal year 1992; $107,000,000 for fiscal
 year  1993;  $134,000,000 for fiscal year 1994;
 $151,000,000 for fiscal year 1995; and $145,000,000 for
 fiscal year 1996.
 SEC. 203.  DEPARTMENT OF ENERGY.ACTIVITIES
 (a) GENERAL RESPONSIBILITIES.--As part of the Program
 described in Title I, the Secretary of Energy shall--
 (1) perform research and development on, and systems
 evaluations of, high-performance computing and
 communications systems;
 (2) conduct computational research with emphasis
 on energy applications;
 (3) support basic research, education, and human
 resources in computational science; and
 (4) provide for networking infrastructure support for
 energy-related mission activities.
 (b) COLLABORATIVE CONSORTIA.--In accordance with the
 Program, the Secretary of Energy shall establish High-
 Performance Computing Research and Development Collaborative
 Consortia by soliciting and selecting proposals.  Each
 Collaborative Consortium shall--
 (1) conduct research directed at scientific and technical
 problems whose solutions require the application of
 high-performance computing and communications resources;
 (2) promote the testing and uses of new types of high-
 performance computing and related software and equipment;
 (3) serve as a vehicle for participating vendors of high-
 performance computing systems to test new ideas and
 technology in a sophisticated computing environment; and
 (4) be led by a Department of Energy national laboratory,
 and include participants from Federal agencies and
 departments, researchers, private industry, educational
 institutions, and others as the Secretary of Energy may deem
 appropriate.
 (c) TECHNOLOGY TRANSFER.--The results of research and
 development carried out under this section shall be
 transferred to the private sector and others in accordance
 with applicable law.
 (d) ANNUAL REPORTS TO CONGRESS.--Within one year after
 the date of enactment of this Act and every year thereafter,
 the Secretary of Energy shall transmit to the Congress a
 report on activities taken to carry out this Act.
 (e) AUTHORIZATION OF APPROPRIATIONS.--(1) There are
 authorized to be appropriated to the Secretary of Energy for
 for the purposes of this the Program $93,000,000 for fiscal
 year 1992; $110,000,000 for fiscal year 1993;
 $138,000,000 for fiscal year 1994; $157,000,000 for fiscal
 year 1995; and $168,000,000 for fiscal year 1996.
 (2) There are authorized to be appropriated to the Secretary
 of Energy for fiscal years 1992, 1993, 1994, 1995, and 1996,
 such funds as may be necessary to carry out the activities that
 are not part of the Program but are authorized by this section.
 SEC. 204.  DEPARTMENT OF COMMERCE ACTIVITIES.
 (a) GENERAL RESPONSIBILITIES.--As part of the
 Program described in Title I--
 (1) the National Institute of Standards and
 Technology shall
 (A) conduct basic and applied measurement
 research needed to support various high-performance
 computing systems and networks;
 (B) develop and propose standards and guidelines,
 and develop measurement techniques and test methods,
 for the interoperability of high-performance computing
 systems in networks and for common user interfaces to
 systems; and
 (C) be responsible for developing benchmark tests and
 standards for high performance computing systems and
 software; and
 (2) the National Oceanic and Atmospheric Administration
 shall conduct basic and applied research in weather
 prediction and ocean sciences, particularly in development
 of new forecast models, in computational fluid dynamics,
 and in the incorporation of evolving computer
 architectures and networks into the systems that carry
 out agency missions.
 (b) HIGH-PERFORMANCE COMPUTING AND NETWORK
 SECURITY.--Pursuant to the Computer Security Act of 1987
 (Public Law 100-235; 101 Stat. 1724), The National Institute of
 Standards and Technology shall be responsible for developing
 and proposing standards and guidelines needed to
 assure the cost-effective security and privacy of sensitive
 information in Federal computer systems.
 (c) STUDY OF IMPACT OF FEDERAL PROCUREMENT
 REGULATIONS.--(l) The Secretary of Commerce shall
 conduct a study to--
 (A) evaluate the impact of Federal procurement regulations
 that require that contractors providing software to the
 Federal Government share the rights to proprietary software
 development tools that the contractors use to develop the
 software; and
 (B) determine whether such regulations discourage
 development of improved software development tools and
 techniques.
 (2) The Secretary of Commerce shall, within one year
 after the date of enactment of this Act, report to the
 Congress regarding the results of the study conducted
 under paragraph (1).
 (d) AUTHORIZATION OF APPROPRIATIONS.--From
 sums otherwise authorized to be appropriated, there are
 authorized to be appropriated--
 (1) to the National Institute of Standards and
 Technology for the purposes of the Program $3,000,000
 for fiscal year 1992; $4,000,000 for fiscal year 1993;
 $5,000,000 for fiscal year 1994; $6,000,000 for
 fiscal year 1995; and $7,000,000 for fiscal year1996.
 (2) to the National Oceanic and Atmospheric
 Administration for the purposes of the Program
 $2,500,000 for fiscal year 1992; $3,000,000 for fiscal
 year 1993; $3,500,000 for fiscal year 1994;
 $4,000,000 for fiscal year 1995; and $4,500,000 for
 fiscal year 1996.
 SEC. 205. ENVIRONMENTAL PROTECTION AGENCY.ACTIVITIES
 (a) GENERAL RESPONSIBILITIES.--As part of the
 Program described in title I, the Environmental
 Protection Agency shall conduct basic and applied
 research directed toward the advancement and
 dissemination of computational techniques and software
 tools which form the core of ecosystem, atmospheric
 chemistry, and atmospheric dynamics models.
 (b) AUTHORIZATION OF APPROPRIATIONS.--From
 sums otherwise authorized to be appropriated, there are
 authorized to be appropriated to the Environmental
 Protection Agency for the purposes of the Program
 $5,000,000 for fiscal year 1992; $5,500,000 for fiscal
 year 1993; $6,000,000 for fiscal year 1994; $6,500,000
 for fiscal year 1995; and $7,000,000 for fiscal year 1996
 SEC. 206. ROLE OF THE DEPARTMENT OF EDUCATION.
 (a) GENERAL RESPONSIBILITIES.--As part of the Program
 described in title I, the Secretary of Education is authorized
 to conduct basic and applied research in computational
 research with an emphasis on the coordination of activities
 with libraries, school facilities, and education research
 groups with respect to the advancement and dissemination
 of computational science and the development, evaluation and
 application of software capabilities.
 (b) AUTHORIZATION OF APPROPRIATIONS.--From
 sums otherwise authorized to be appropriated, there are
 authorized to be appropriated to the Department of
 Education for the purposes of this section $1,500,000 for
 fiscal year 1992; $1,700,000 for fiscal year 1993;
 $1,900,000 for fiscal year 1994; $2,100,000 for fiscal year
 1995; and $2,300,000 for fiscal year 1996.
 SEC. 207. MISCELLANEOUS PROVISIONS.
 (A) NONAPPLICABILITY.--Except to the extent the
 appropriate Federal Agency or department head
 determines, the provisions of this Act shall not apply to--
 (1) programs or activities regarding computer systems
 that process classified information; or
 (2) computer systems the function, operation, or use
 of which are those delineated in paragraphs (1) through
 (5) of section 2315(a) of title 10, United States Code.
 (b) ACQUISITION OF PROTOTYPE AND EARLY PRODUCTION
 MODELS.--In accordance with Federal contracting law,
 Federal agencies and departments participating in the
 Program may acquire prototype or early production
 models of new high-performance computing systems
 and subsystems to stimulate hardware and software
 development.  Items of computing equipment acquired
 under this subsection shall be considered research computers
 for purposes of applicable acquisition regulations.
 SEC. 208.  FOSTERING UNITED STATES COMPETITIVENESS IN
 HIGH-PERFORMANCE COMPUTING AND RELATED ACTIVITIES.
 (a) FINDINGS.--The Congress finds the following:
 (1) High-performance computing and associated technologies
 are critical to the United States economy.
 (2) While the United States has led the development of high-
 performance computing, United States industry is facing
 increasing global competition.
 (3) Despite existing international agreements on fair
 competition and nondiscrimination in government
 procurements, there is increasing concern that such
 agreements are not being honored, that more aggressive
 enforcement of such agreements is needed, and that
 additional steps may be required to ensure fair global
 competition, particularly in high-technology fields such
 as high-performance computing and associated technologies.
 (4) It is appropriate for Federal agencies and departments to
 use the funds authorized for the Program in a manner which
 most effectively fosters the maintenance and development of
 United States leadership in high-performance computers
 and associated technologies in and for the benefit of the
 United States.
 (5) It is appropriate for Federal agencies and departments
 to use the funds authorized for the Program in a manner,
 consistent with the Trade Agreements Act of 1979
 (19 U.S.C. 2501 et seq.), which most effectively fosters
 reciprocal competitive procurement treatment by foreign
 governments for United States high-performance computing
 and associated technology products and suppliers.
 (b) ANNUAL REPORT.--
 (1) REPORT.--The Director shall submit an annual report
 to Congress that identifies--
 (A) any grant, contract, cooperative agreement, or
 cooperative research and development agreement (as
 defined under section 12(d)(1) of the Stevenson-Wydler
 Technology Innovation Act of 1980 (15 U.S.C. 3710a(d)(1))
 made or entered into by any Federal agency or department
 for research and development under the Program with--
 (i)any company other than a company that is either
 incorporated or located in the United States, and that has
 majority ownership by individuals who are citizens of the
 United States; or
 (ii) any educational institution or nonprofit institution
 located outside the United States; and
 (B) any procurement exceeding $1,000,000 by any Federal
 agency or department under the Program for--
 (i) unmanufactured articles, materials, or supplies mined
 outside the United States; or
 (ii) manufactured articles, materials, or supplies other
 than those manufactured in the United States substantially
 all from articles, materials, or supplies mined, produced, or
 manufactured in the United States, under the meaning of
 title III of the Act of March 3, 1933 (41 U.S.C. 10a-10d;
 popularly known as the Buy American Act) as amended by
 the Buy American Act of 1988.
 (2) CONSOLIDATION OF REPORTS.--The report required by
 this subsection may be included with the report required
 by section 101(a)(3)(A).
 (c) REVIEW OF SUPERCOMPUTER AGREEMENT.--
 (1) REPORT.--The Under Secretary for Technology
 Administration of the Department of Commerce (in this
 subsection referred to as the "Under Secretary") shall
 conduct a comprehensive study of the revised "Procedures
 to Introduce Supercomputers" and the accompanying
 exchange of letters between the United States and Japan
 dated June 15, 1990 (commonly referred to as the
 "Supercomputer Agreement") to determine whether the
 goals and objectives of such Agreement have been met and
 to analyze the effects of such Agreement on United States
 and Japanese supercomputer manufacturers.  Within 180
 days after the date of enactment of this Act, the Under
 Secretary shall submit a report to Congress containing the
 results of such study.
 (2) CONSULTATION.--In conducting the comprehensive
 study under this subsection, the Under Secretary shall
 consult with appropriate Federal agencies and departments
 and with United States manufacturers of supercomputers
 and other appropriate private sector entities.
 (d) APPLICATION OF BUY AMERICAN ACT.--This Act does
 not affect the applicability of title III of the Act of March 3,
 1933 (41 U.S.C. 10a-10d; popularly known as the Buy
 American Act), as amended by the Buy American Act of 1988,
 to procurements by Federal agencies and departments
 undertaken as a part of the Program.
 
 
